/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSchemaUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSchemaUDB.class);

    public SHCreateSchemaUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSchemaUDB.clearCR(string);
        if (Token.startsWithString(string2, "create schema")) {
            try {
                this.parseSchema(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateSchemaUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSchema(String string) {
        this.statement = string;
        String string2 = Token.getTokenAfter(this.statement, "SCHEMA").trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        SchemaUDB schemaUDB = storageDesignUDB.getSchemaSet().createSchema();
        if (schemaUDB != null) {
            schemaUDB.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(schemaUDB);
            if (Token.hasToken(this.statement, "AUTHORIZATION")) {
                String string3 = Token.getTokenAfter(this.statement, "AUTHORIZATION").trim();
                OwnerUDB ownerUDB = (OwnerUDB)storageDesignUDB.getOwnerSet().getByName(string3);
                if (ownerUDB == null) {
                    ownerUDB = (OwnerUDB)storageDesignUDB.getOwnerSet().createElement(null);
                    ownerUDB.setName(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL(ownerUDB);
                }
                schemaUDB.setOwner(ownerUDB);
            }
        }
    }
}

