/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateMethodUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateMethodUDB.class);

    public SHCreateMethodUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateMethodUDB.clearCR(string);
        if (Token.startsWithString(string2, "create method") || Token.startsWithString(string2, "create specific method")) {
            try {
                this.parseCreateMethod(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateMethodUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseCreateMethod(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null) {
            String string2 = Token.getNameAfterToken(this.statement, "METHOD", '\"', '\"').trim();
            if (!"SPECIFIC".equalsIgnoreCase(Token.getTokenAfter(string, "CREATE").trim())) {
                StructuredType structuredType;
                String string3 = Token.getNameAfterToken(this.statement, "FOR", '\"', '\"').trim();
                int n = string3.indexOf(46);
                if (n > 0) {
                    string3 = Token.getValAfterCharacter(string3, '.');
                }
                if ((structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string3)) != null) {
                    Method method = structuredType.getMethodByName(string2);
                    if (method != null) {
                        MethodProxyUDB methodProxyUDB = (MethodProxyUDB)storageDesignUDB.getMethodProxySet().getByName(string2);
                        this.initExternalName(methodProxyUDB);
                        this.initTransformGroup(methodProxyUDB);
                        this.initReturn(methodProxyUDB);
                    } else {
                        LOGGER.error("Unable to find required Method: " + string2);
                    }
                } else {
                    LOGGER.error("Unable to find required Structured Type: " + string3);
                }
            }
        }
    }

    private void initExternalName(MethodProxyUDB methodProxyUDB) {
        String string;
        if (Token.hasToken(this.statement, "EXTERNAL") && "NAME".equalsIgnoreCase(Token.getFirstToken(string = Token.getStringAfterToken(this.statement, "EXTERNAL").trim()).trim())) {
            String string2 = Token.getToken(string, 2).trim();
            methodProxyUDB.setExt_R_Name(string2);
        }
    }

    private void initTransformGroup(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "TRANSFORM GROUP")) {
            String string = Token.getStringAfter(this.statement, "TRANSFORM GROUP").trim();
            String string2 = Token.getFirstToken(string).trim();
            methodProxyUDB.setExt_R_TransformGroup(string2);
        }
    }

    private void initReturn(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "RETURN")) {
            String string = Token.getStringAfterToken(this.statement, "RETURN").trim();
            methodProxyUDB.setSqlMethodBody(string);
        }
    }
}

