/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexUDB
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private StorageDesignUDB stoDesign;
    private String schemaName = null;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndexUDB.class);

    public SHCreateIndexUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndexUDB.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index")) {
            try {
                this.index = null;
                this.createIndex(string2);
                if (this.failed) {
                    this.importLog.addFailedStatement(SHCreateIndexUDB.FormatCR(string, "\n"));
                } else {
                    this.importLog.incrementImportedStatements();
                }
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateIndexUDB.FormatCR(string, "\n"));
            }
            this.index = null;
            this.table = null;
            this.indexName = "";
            this.stoDesign = null;
            this.schemaName = null;
            this.failed = false;
        } else {
            this.nextHandler(string);
        }
    }

    private void createIndex(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            if (this.index != null) {
                IndexProxyUDB indexProxyUDB;
                this.initUnique();
                this.setColumnForIndex();
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
                if (this.stoDesign != null && (indexProxyUDB = (IndexProxyUDB)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initSchema(indexProxyUDB, this.stoDesign);
                    this.initInclude(indexProxyUDB);
                    this.initCluster(indexProxyUDB);
                    this.initPctFree(indexProxyUDB);
                    this.initMinPctUsed(indexProxyUDB);
                    this.initReverseScans(indexProxyUDB);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            StringBuffer stringBuffer = new StringBuffer(objectDoesNotExistException.getMessage());
            stringBuffer.append(" in SHCreateIndex.createIndex");
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError("Creating index for statement " + string + " for UDB failed");
            this.failed = true;
        }
    }

    private void constructIndex() throws ObjectDoesNotExistException {
        String string = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        if (this.table != null) {
            Index[] indexArray = (Index[])this.table.getKeys();
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = index;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else {
            this.importLog.addError("Specified table " + string + " for index " + this.indexName + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
    }

    private void initUnique() {
        boolean bl;
        if (!this.index.isPK() && (bl = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Plain Index");
        }
    }

    private String initIndexName() {
        String string = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.schemaName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        Map map = this.getColumnsForTable();
        if (map.size() > 0) {
            String string = Token.getValBetweenBrackets(this.statement, 1).trim();
            boolean bl = Token.hasCloseAndOpenBrackets(string);
            if (bl) {
                this.index.setIndexExpression(string);
                return;
            }
            string = Token.getNamesOnly(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                Column column;
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = "ASC";
                if (Token.getLastToken(string2).equalsIgnoreCase("ASC") || Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                    if (Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                        string3 = "DESC";
                    }
                    string2 = string2.substring(0, string2.lastIndexOf(32));
                }
                if ((column = (Column)map.get(string2)) != null) {
                    this.index.add(column);
                    this.index.setColumnSortOrder(column, string3);
                    continue;
                }
                this.importLog.addError("Setting column " + string2 + " for index failed");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columnArray = (Column[])this.table.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private String getTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "ON", '\"', '\"').trim();
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        if ((n = string.indexOf(46)) > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        string = Token.removeQuotes(string);
        return string;
    }

    private void initCluster(IndexProxyUDB indexProxyUDB) {
        if (Token.hasToken(this.statement, "CLUSTER")) {
            indexProxyUDB.setCluster(true);
        }
    }

    private void initInclude(IndexProxyUDB indexProxyUDB) {
        if (Token.hasToken(this.statement, "INCLUDE")) {
            String string = this.statement.substring(this.statement.indexOf("INCLUDE") + "INCLUDE".length()).trim();
            String string2 = Token.getValBetweenBrackets(string);
            indexProxyUDB.setColumnList(string2);
        }
    }

    private void initPctFree(IndexProxyUDB indexProxyUDB) {
        if (Token.hasToken(this.statement, "PCTFREE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "PCTFREE"));
                indexProxyUDB.setPercentageFree(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initPctFree : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMinPctUsed(IndexProxyUDB indexProxyUDB) {
        if (Token.hasToken(this.statement, "MINPCTUSED")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MINPCTUSED"));
                indexProxyUDB.setMinimumPercentageUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINPCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initMinPctUsed : " + numberFormatException.getMessage());
            }
        }
    }

    private void initReverseScans(IndexProxyUDB indexProxyUDB) {
        if (Token.hasToken(this.statement, "ALLOW")) {
            indexProxyUDB.setReverseScanSupport(true);
        }
    }

    private void initSchema(IndexProxyUDB indexProxyUDB, StorageDesignUDB storageDesignUDB) {
        if (this.schemaName != null) {
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(this.schemaName);
            if (schemaUDB != null) {
                indexProxyUDB.setSchema(schemaUDB);
            } else {
                OwnerUDB ownerUDB = (OwnerUDB)((StorageDesignUDB)indexProxyUDB.getStorageDesign()).getOwnerSet().getByName(this.schemaName);
                if (ownerUDB == null) {
                    ownerUDB = (OwnerUDB)((StorageDesignUDB)indexProxyUDB.getStorageDesign()).getOwnerSet().createElement(null);
                    ownerUDB.setName(this.schemaName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ownerUDB);
                }
                indexProxyUDB.setOwner(ownerUDB);
            }
        } else if (this.getOwner() != null) {
            indexProxyUDB.setOwner((OwnerUDB)this.getOwner());
        }
    }
}

