/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDistinctTypeUDB
extends DDLStatementHandler {
    private DistinctTypeUDB type;
    private static final String TYPE = "TYPE";
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHCreateDistinctTypeUDB.class);

    public SHCreateDistinctTypeUDB(Design design) {
        super(design);
    }

    public SHCreateDistinctTypeUDB(Design design, LogicalDatatypeFactory logicalDatatypeFactory) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDistinctTypeUDB.clearCR(string);
        if (Token.startsWithString(string2, "create distinct type")) {
            try {
                this.parseDistinctType(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateDistinctTypeUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDistinctType(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null) {
            this.type = storageDesignUDB.getDistinctTypeSet().createDistinctType();
            if (this.type != null) {
                String string2 = Token.getTokenAfter(string, TYPE).trim();
                this.type.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String string3 = Token.getStringAfter(string, "AS").trim();
                DomainSet domainSet = storageDesignUDB.getDesign().getDomainSet();
                Domain domain = (Domain)domainSet.getByName(string2);
                if (domain != null) {
                    if (domain.getDataType().toString().equalsIgnoreCase(string3)) {
                        this.type.setDomain(string2);
                    } else {
                        LOGGER.error("Type of domain " + string2 + " is not " + string3);
                        this.importLog.addError("Type of domain " + string2 + " is not " + string3);
                    }
                } else {
                    this.createOneDomain(string2, string3);
                    this.type.setDomain(string2);
                }
                NotStandartDataTypeNames.addNotStandartDataType(string2);
                NotStandartDataTypeNames.addNotStandartSynonym(string2, string3);
            }
        }
    }

    private void createOneDomain(String string, String string2) {
        String string3 = string2;
        int n = string3.indexOf(40);
        if (n > -1) {
            string3 = string3.substring(0, n).trim();
        }
        if (this.checkBuildinDatatype(string3)) {
            Map map = this.parseBuildinDatatype(string2);
            String string4 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("scale"), (String)map.get("precision"), (String)map.get("size")};
            if (string4 != null) {
                String string5 = StandardDatatypeNames.getUsedDatatypeName(string4);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string5);
                DomainSet domainSet = this.design.getDesign().getDomainSet();
                Domain domain = domainSet.createDomain();
                domain.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(domain);
                if (logicalDatatype != null) {
                    domain.setLogicalDatatype(logicalDatatype);
                } else {
                    LogicalDatatype logicalDatatype2 = this.design.getDesign().getLogicalDatatypeSet().createLogicalDatatype(null);
                    this.design.getRelationalDesign().stampModelObjectDDL(logicalDatatype2);
                    domain.setLogicalDatatype(logicalDatatype2);
                }
                domain.setFileName(this.design.getDesign().getFileName());
                domain.setDataTypeParameter("size", stringArray[2]);
                domain.setDataTypeParameter("scale", stringArray[1]);
                domain.setDataTypeParameter("precision", stringArray[0]);
            }
        }
    }

    private boolean checkBuildinDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("DB2/UDB 7.1");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String string) {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string;
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
        }
        if ((string2 = StandardDatatypeNames.getUsedDatatypeName(string3)) != null) {
            String string4 = Token.cutTokenFromFront(string, string3);
            hashMap.put("datatype", string2);
            if (!string4.equalsIgnoreCase("")) {
                boolean bl = Token.hasCloseAndOpenBrackets(string4);
                if (bl) {
                    bl = Token.getValBeforeBrackets(string4).trim().equalsIgnoreCase("");
                }
                if (bl) {
                    String string5 = Token.getValBetweenBrackets(string4, 1);
                    int n2 = string5.indexOf(",");
                    if (n2 != -1) {
                        hashMap.put("size", ZERO);
                        hashMap.put("precision", string5.substring(0, n2).trim());
                        hashMap.put("scale", string5.substring(n2 + 1).trim());
                    } else if (string2.equals("DECIMAL")) {
                        hashMap.put("size", ZERO);
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", string5.trim());
                    } else {
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", ZERO);
                        hashMap.put("size", string5.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + string + " is unknown!");
            this.importLog.addError("Datatype " + string + " is unknown");
        }
        return hashMap;
    }
}

