/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseUDB
extends DDLStatementHandler {
    private DataBaseUDB database;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseUDB.class);

    public SHCreateDatabaseUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseUDB.clearCR(string);
        if ((Token.startsWithString(string2, "create database") || Token.startsWithString(string2, "create db")) && string2.toLowerCase().indexOf("create database partition group") == -1) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateDatabaseUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null) {
            this.database = storageDesignUDB.getDataBaseSet().createDataBase();
            String string2 = this.initDatabaseName();
            this.database.setName(string2);
            this.initOnPath();
            this.initAlias();
            this.initCodeSet();
            this.initTerritory();
            this.initCollate();
            this.initNumSegs();
            this.initDFTExtentSize();
            this.initCatalogTableSpace();
            this.initUserTableSpace();
            this.initTempTableSpace();
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    public DataBaseUDB getDatabase() {
        return this.database;
    }

    private void initOnPath() {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            this.database.setOnPath(string);
        }
    }

    private void initAlias() {
        if (Token.hasToken(this.statement, "ALIAS")) {
            String string = Token.getTokenAfter(this.statement, "ALIAS");
            this.database.setAlias(string);
        }
    }

    private void initCodeSet() {
        if (Token.hasToken(this.statement, "CODESET")) {
            String string = Token.getTokenAfter(this.statement, "CODESET");
            this.database.setCodeSet(string);
        }
    }

    private void initTerritory() {
        if (Token.hasToken(this.statement, "TERRITORY")) {
            String string = Token.getTokenAfter(this.statement, "TERRITORY");
            this.database.setTerritory(string);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String string = Token.getStringAfterToken(this.statement, "COLLATE");
            string = Token.getTokenAfter(string, "USING");
            String[] stringArray = DataBaseUDB.getAvailableCollatingSequences();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                this.database.setCollatingSequence(stringArray[i]);
                break;
            }
        }
    }

    private void initNumSegs() {
        if (Token.hasToken(this.statement, "NUMSEGS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "NUMSEGS"));
                this.database.setSegmentNumber(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NUMSEGS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initNumSegs : " + numberFormatException.getMessage());
            }
        }
    }

    private void initDFTExtentSize() {
        if (Token.hasToken(this.statement, "DFT_EXTENT_SZ")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "DFT_EXTENT_SZ"));
                this.database.setDefaultExtentSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong DFT_EXTENT_SZ format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initDFTExtentSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initCatalogTableSpace() {
        if (Token.hasToken(this.statement, "CATALOG")) {
            String string = this.statement.substring(this.statement.indexOf("CATALOG") + "CATALOG".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpaceUDB.setName("CatalogTS_For_" + this.database.getName());
            this.database.setCatalogTableSpace(tableSpaceUDB);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            if (Token.hasToken(string, "USER")) {
                string = string.substring(0, string.indexOf("USER")).trim();
            } else if (Token.hasToken(string, "TEMPORARY")) {
                string = string.substring(0, string.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initUserTableSpace() {
        if (Token.hasToken(this.statement, "USER")) {
            String string = this.statement.substring(this.statement.indexOf("USER") + "USER".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpaceUDB.setName("UserTS_For_" + this.database.getName());
            this.database.setUserTableSpace(tableSpaceUDB);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            if (Token.hasToken(string, "TEMPORARY")) {
                string = string.substring(0, string.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initTempTableSpace() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            String string = this.statement.substring(this.statement.indexOf("TEMPORARY") + "TEMPORARY".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpaceUDB.setName("TempTS_For_" + this.database.getName());
            this.database.setTemporaryTableSpace(tableSpaceUDB);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initTableSpaceOptions(String string, TableSpaceUDB tableSpaceUDB) {
        String string2;
        String string3;
        tableSpaceUDB.setDBDefOnly(true);
        if (Token.hasToken(string, "BY")) {
            string3 = Token.getTokenAfter(string, "BY").trim();
            tableSpaceUDB.setManagedBy(string3);
        }
        if (Token.hasToken(string, "USING") && Token.getTokenAfter(string, "USING").trim().startsWith("(")) {
            string3 = string;
            while (string3.indexOf("USING") > -1 && Token.getTokenAfter(string, "USING").trim().startsWith("(")) {
                String string4 = Token.getValBetweenBrackets(string3, 1);
                string3 = Token.getValAfterBrackets(string3, 1);
                ContainerUDB containerUDB = ((StorageDesignUDB)tableSpaceUDB.getStorageDesign()).getContainerSet().createContainer();
                if (containerUDB == null) continue;
                containerUDB.setTableSpace(tableSpaceUDB);
                containerUDB.setContainers(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(containerUDB);
            }
        }
        if (Token.hasToken(string, "EXTENTSIZE")) {
            tableSpaceUDB.setExtentSize(Token.getTokenAfter(string, "EXTENTSIZE"));
        }
        if (Token.hasToken(string, "PREFETCHSIZE")) {
            tableSpaceUDB.setPrefetchSize(Token.getTokenAfter(string, "PREFETCHSIZE"));
        }
        if (Token.hasToken(string, "OVERHEAD")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(string, "OVERHEAD"));
                tableSpaceUDB.setOverhead(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + numberFormatException.getMessage());
            }
        }
        if (Token.hasToken(string, "TRANSFERRATE")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(string, "TRANSFERRATE"));
                tableSpaceUDB.setTransferRate(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions: " + numberFormatException.getMessage());
            }
        }
        if (Token.hasToken(string, "RECOVERY") && "ON".equalsIgnoreCase(string2 = Token.getTokenAfter(string, "RECOVERY").trim())) {
            tableSpaceUDB.setDroppedTableRecovery(true);
        }
    }
}

