/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateBufferPoolUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateBufferPoolUDB.class);

    public SHCreateBufferPoolUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateBufferPoolUDB.clearCR(string);
        if (Token.startsWithString(string2, "create bufferpool")) {
            try {
                this.parseBufferPool(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateBufferPoolUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseBufferPool(String string) {
        this.statement = string;
        String string2 = Token.getQuotedNameAfterToken(this.statement, "BUFFERPOOL").trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        BufferPoolUDB bufferPoolUDB = storageDesignUDB.getBufferPoolSet().createBufferPool();
        if (bufferPoolUDB != null) {
            bufferPoolUDB.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(bufferPoolUDB);
            String string3 = Token.getTokenAfter(this.statement, string2).trim();
            if (string3.equalsIgnoreCase("NODEGROUP")) {
                String string4 = this.statement;
                while (!Token.getFirstToken(string4).equalsIgnoreCase("NODEGROUP")) {
                    string4 = Token.cutFirstToken(string4);
                }
                string4 = Token.cutFirstToken(string4);
                StringBuffer stringBuffer = new StringBuffer();
                while (!Token.getFirstToken(string4).equalsIgnoreCase("SIZE")) {
                    stringBuffer.append(Token.getFirstToken(string4));
                    string4 = Token.cutFirstToken(string4);
                }
                String string5 = stringBuffer.toString().trim();
                bufferPoolUDB.setScope(string5);
            }
            this.initSize(bufferPoolUDB);
            this.initPageSize(bufferPoolUDB);
            this.initExtendedStorage(bufferPoolUDB);
        }
    }

    private void initSize(BufferPoolUDB bufferPoolUDB) {
        if (Token.hasToken(this.statement, "SIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "SIZE"));
                bufferPoolUDB.setSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDB.initSize: " + numberFormatException.getMessage());
            }
            if (Token.hasToken(this.statement, "EXCEPT") && Token.hasCloseAndOpenBrackets(this.statement)) {
                String string = Token.getValBetweenBrackets(this.statement).trim();
                bufferPoolUDB.setNodesWithDiffSize(string);
            }
        }
    }

    private void initPageSize(BufferPoolUDB bufferPoolUDB) {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                if (!Token.getTokenAfter(this.statement, "" + n).equalsIgnoreCase("K")) {
                    n /= 1024;
                }
                bufferPoolUDB.setPageSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDB.initPageSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initExtendedStorage(BufferPoolUDB bufferPoolUDB) {
        if (this.statement.toUpperCase().indexOf("EXTENDED STORAGE") > -1 && this.statement.toUpperCase().indexOf("NOT EXTENDED STORAGE") == -1) {
            bufferPoolUDB.setExtendedStorage(true);
        }
    }
}

