/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;

public class SHAlterTableUDB
extends DDLStatementHandler
implements AlterTableHandler {
    protected Table table;
    protected List statemensList = new ArrayList();
    protected static final Logger LOGGER = new Logger(SHAlterTableUDB.class);
    protected String name = "";

    public SHAlterTableUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterTableUDB.clearCR(string);
        if (Token.startsWithString(string2, "alter table") && (this.isUK(string2) || this.isPK(string2) || this.isFK(string2) || this.isCheck(string2))) {
            if (this.isPK(string2) || this.isUK(string2) || this.isCheck(string2) || this.isFK(string2)) {
                try {
                    this.parseAlterTable(string2);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error("Parsing " + string2 + " for UDB failed!", exception);
                    this.importLog.addFailedStatement(SHAlterTableUDB.FormatCR(string, "\n"));
                }
            } else {
                this.statemensList.add(string2);
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseAlterTable(String string) {
        this.statement = string;
        this.initTable();
        if (this.table != null) {
            String[] stringArray = string.split(" ADD ");
            if (stringArray.length == 1) {
                stringArray = string.split(" add ");
            }
            for (String string2 : Arrays.asList(stringArray)) {
                if (this.isPK(string2)) {
                    this.initPK(string2);
                    continue;
                }
                if (this.isFK(string2)) {
                    this.parseFK(string2);
                    continue;
                }
                if (this.isUK(string2)) {
                    this.initUnique(string2);
                    continue;
                }
                if (!this.isCheck(string2)) continue;
                this.initCheck(string2);
            }
        }
    }

    public void parseFK(String string) {
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        if (this.table != null) {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            if (this.isFK()) {
                FKProxyUDB fKProxyUDB;
                this.initForeignKey();
                if (storageDesignUDB != null && (fKProxyUDB = (FKProxyUDB)storageDesignUDB.getFKProxySet().getByName(this.name)) != null) {
                    String string2;
                    if (Token.hasToken(this.statement, "DELETE")) {
                        string2 = Token.getTokenAfter(this.statement, "DELETE").trim();
                        if (string2.equalsIgnoreCase("NO")) {
                            if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                string2 = "NO ACTION";
                            }
                        } else if (string2.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                            string2 = "SET NULL";
                        }
                        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyUDB.getObject()).getFKAssociation();
                        fKIndexAssociation.setDeleteRule(string2);
                    }
                    if (Token.hasToken(this.statement, "UPDATE")) {
                        string2 = Token.getTokenAfter(this.statement, "UPDATE").trim();
                        if (string2.equalsIgnoreCase("NO") && Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                            string2 = "NO ACTION";
                        }
                        fKProxyUDB.setOnUpdate(string2);
                    }
                }
            }
        }
    }

    private boolean isFK() {
        return Token.hasString(this.statement.toUpperCase(), "FOREIGN");
    }

    protected void initTable() {
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String string2 = this.getNameFor(string);
        this.table = this.getTableFor(string2);
    }

    protected void initForeignKey() {
        boolean bl = false;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String string = this.statement;
        bl = Token.hasToken(string, "FOREIGN");
        while (bl) {
            String string2;
            int n = string.toUpperCase().indexOf("FOREIGN");
            String string3 = string.substring(n);
            String string4 = "FK_ASS";
            if (Token.hasToken(string, "CONSTRAINT")) {
                string4 = Token.getQuotedNameAfterToken(string, "CONSTRAINT");
            } else {
                String string5 = this.table.getName();
                if (string5.length() > 13) {
                    string5 = string5.substring(0, 13);
                }
                string4 = string5 + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = string4;
            int n2 = string3.indexOf(41);
            String string6 = string3.substring(0, n2 + 1).trim();
            String string7 = Token.getValBetweenBrackets(string6);
            List list = this.getColumnNames(string7);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column[] columnArray = (Column[])this.table.getElements();
            for (String string8 : list) {
                string8 = Token.getName(string8);
                for (int i = 0; i < columnArray.length; ++i) {
                    string2 = columnArray[i].getName().trim();
                    if (!string8.equalsIgnoreCase(string2)) continue;
                    arrayList.add(columnArray[i]);
                }
            }
            int n3 = string3.toUpperCase().indexOf("REFERENCES");
            String string9 = Token.getValBeforeBrackets(string3 = string3.substring(n3));
            string2 = Token.getQuotedNameAfterToken(string9, "REFERENCES");
            String string10 = this.getNameFor(string2);
            Table table = this.getTableFor(string10);
            if (table != null) {
                Object object;
                PropertyMap propertyMap;
                Object object2;
                Object object3;
                boolean bl2 = Token.hasString(string3, "(");
                if (bl2) {
                    object3 = Token.getValBetweenBrackets(string3);
                    object2 = this.getColumnNames((String)object3);
                    propertyMap = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = this.getUniqueIndexForColumnNames(table, (List)object2);
                    if (index != null) {
                        object = this.table.addFK(index, null, (FKIndexAssociationReference)propertyMap);
                        ((FKIndexAssociation)object).setName(string4);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                        ((FKIndexAssociation)object).getLocalFKIndex().setName(string4);
                        if (this.design.getDesign().isPropagatePKChahges()) {
                            this.replaceAllColumns((FKIndexAssociation)object, arrayList, index);
                        } else {
                            this.fixFKColumns((FKIndexAssociation)object, arrayList, index);
                        }
                        boolean bl3 = Token.hasToken(string3, "DELETE");
                        if (bl3) {
                            String string11 = Token.getTokenAfter(string3, "DELETE").trim();
                            if (string11.equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                    string11 = "NO ACTION";
                                }
                            } else if (string11.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                                string11 = "SET NULL";
                            }
                            String[] stringArray = ((FKIndexAssociation)object).getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!string11.equalsIgnoreCase(stringArray[i])) continue;
                                ((FKIndexAssociation)object).setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                } else {
                    object3 = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object2 = (Index)table.getPK();
                    if (object2 != null) {
                        propertyMap = this.table.addFK((KeyObject)object2, null, (FKIndexAssociationReference)object3);
                        ((FKIndexAssociation)propertyMap).setName(string4);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)((Object)propertyMap));
                        ((FKIndexAssociation)propertyMap).getLocalFKIndex().setName(string4);
                        if (this.design.getDesign().isPropagatePKChahges()) {
                            this.replaceAllColumns((FKIndexAssociation)propertyMap, arrayList, (Index)object2);
                        } else {
                            this.fixFKColumns((FKIndexAssociation)propertyMap, arrayList, (Index)object2);
                        }
                        boolean bl4 = Token.hasToken(string3, "DELETE");
                        if (bl4) {
                            object = Token.getTokenAfter(string3, "DELETE").trim();
                            if (((String)object).equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                    object = "NO ACTION";
                                }
                            } else if (((String)object).equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                                object = "SET NULL";
                            }
                            String[] stringArray = ((FKIndexAssociation)propertyMap).getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!((String)object).equalsIgnoreCase(stringArray[i])) continue;
                                ((FKIndexAssociation)propertyMap).setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                }
            }
            string = string3;
            bl = Token.hasToken(string, "FOREIGN");
        }
    }

    protected List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(Token.removeQuotes(string2.trim()));
        }
        return arrayList;
    }

    protected String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return Token.getName(string2);
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return Token.getName(string);
    }

    protected Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String string) {
        Column column = null;
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column2 = columnArray[i];
            if (!column2.getName().equalsIgnoreCase(string)) continue;
            column = column2;
            break;
        }
        return column;
    }

    protected void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        Column[] columnArray2 = (Column[])index2.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = columnArray2[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    protected boolean isPK(String string) {
        return string.toUpperCase().indexOf("PRIMARY KEY") > -1;
    }

    protected boolean isUK(String string) {
        return Token.hasToken(string, "UNIQUE");
    }

    protected boolean isFK(String string) {
        return Token.hasToken(string, "ADD") || Token.hasToken(string, "FOREIGN");
    }

    protected void initPK(String string) {
        Object object;
        String string2 = null;
        String string3 = Token.getValBetweenBrackets(Token.getStringAfter(string, "PRIMARY KEY"), 1).trim();
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string2 = Token.getQuotedNameAfterToken(string, "CONSTRAINT").trim();
        } else {
            object = this.table.getName();
            if (((String)object).length() > 15) {
                object = ((String)object).substring(0, 15);
            }
            string2 = (String)object + "_PK";
        }
        object = this.getColumnNames(string3);
        if (object.size() > 0) {
            Index index = this.table.createIndex();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Column column = this.getColumnFor(this.table, string4 = Token.getName(string4));
                if (column == null) continue;
                index.add(column);
            }
            index.makePK();
            index.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(index);
        }
    }

    protected void initUnique(String string) {
        String string2;
        String string3 = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string3 = Token.getQuotedNameAfterToken(string, "CONSTRAINT").trim();
        } else {
            string2 = this.table.getName();
            if (string2.length() > 13) {
                string2 = string2.substring(0, 13);
            }
            string3 = string2 + "_UK" + this.table.getUKeys().size();
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(string, "UNIQUE"), 1).trim();
        List list = this.getColumnNames(string2);
        if (list.size() > 0) {
            Index index = this.table.createIndex();
            for (String string4 : list) {
                Column column = this.getColumnFor(this.table, string4 = Token.getName(string4));
                if (column == null) continue;
                index.add(column);
            }
            index.setUnique(true);
            index.setName(string3);
            this.design.getRelationalDesign().stampModelObjectDDL(index);
        }
    }

    private boolean isCheck(String string) {
        return string.toUpperCase().indexOf("CHECK") > -1;
    }

    private void initCheck(String string) {
        String string2;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        String string3 = null;
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            string3 = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT").trim();
        } else {
            string2 = this.table.getName();
            if (string2.length() > 13) {
                string2 = string2.substring(0, 13);
            }
            string3 = string2 + "_CK" + this.table.getCheckConstraints().size();
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        TableLevelConstraint tableLevelConstraint = this.table.createCheckConstraint(string3, string2);
        this.table.addCheckConstraint(tableLevelConstraint);
        this.design.getRelationalDesign().stampModelObjectDDL(tableLevelConstraint);
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase(Token.getName((String)list.get(i)))) continue;
            return false;
        }
        return true;
    }

    protected Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String string : this.statemensList) {
            this.parseAlterTable(string);
        }
    }
}

