/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTriggerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerSqlServerv2k5
extends SHCreateTriggerSqlServer {
    private static final String TRIGGERNAME = "@triggername";
    private static final String ORDER = "@order";
    private static final String STMTTYPE = "@stmttype";
    private static final Logger LOGGER = new Logger(SHCreateTriggerSqlServerv2k5.class);
    private TriggerSqlServerv2k5 trigger;
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreateTriggerSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTriggerSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create trigger")) {
            try {
                this.parseTrigger(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateTriggerSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (string2.toUpperCase().indexOf("sp_settriggerorder") > -1) {
            try {
                this.setTriggerOrder(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQLServer failed!", exception);
                this.importLog.addFailedStatement(SHCreateTriggerSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void setTriggerOrder(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_settriggerorder").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 3) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(TRIGGERNAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(ORDER)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                if (string5.startsWith(STMTTYPE)) {
                    string5 = Token.getStringAfter(string5, "=").trim();
                }
                if (string5.toUpperCase().startsWith("N'")) {
                    string5 = string5.substring(1);
                }
                if (string5.startsWith("'")) {
                    string5 = Token.getValBetweenQuotationMarks(string5);
                }
                string5 = Token.getValBetweenSquareBrackets(string5);
                this.trigger = (TriggerSqlServerv2k5)this.storageDesign.getTriggerSet().getByName(string3.toUpperCase());
                if (this.trigger != null) {
                    this.trigger.setExecutionOrder(string4);
                }
            } else {
                LOGGER.error(string + " SHCreateTriggerSqlServer.sp_settriggerorder: wrong number of arguments!");
                this.importLog.addError("sp_settriggerorder: wrong number of arguments");
            }
        }
    }

    private void parseTrigger(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.trigger = (TriggerSqlServerv2k5)this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initOnTable();
                    this.initWithEncription();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initNotForReplication();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                }
                catch (Exception exception) {
                    LOGGER.error(" Parsing " + string + " for SQLServer failed!", exception);
                }
            }
        }
    }

    private void initTriggerName() {
        String string = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        if (string.indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = Token.getValBetweenSquareBrackets(string2);
            SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(string2);
            if (schemaSqlServerv2k5 != null) {
                this.trigger.setSchema(schemaSqlServerv2k5);
            }
            string = string.substring(string.indexOf(46) + 1);
        }
        this.trigger.setName(string);
    }

    private void initOnTable() throws ParseException {
        String string = this.statement.substring(this.statement.toUpperCase().indexOf(" ON ") + 3).trim();
        String string2 = Token.getLastToken(string = Token.getFirstToken(string));
        int n = string2.lastIndexOf(".");
        if (n > -1) {
            string2 = string2.substring(n + 1);
        }
        string2 = Token.getValBetweenSquareBrackets(string2);
        if (((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(string2) != null) {
            this.trigger.setTable(((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(string2));
        } else if (((TableViewProxySetSqlServerv2k5)this.storageDesign.getTableViewProxySet()).getByName(string2) != null) {
            this.trigger.setView(((TableViewProxySetSqlServerv2k5)this.storageDesign.getTableViewProxySet()).getByName(string2));
        } else {
            throw new ParseException(this.statement + " Specified table or view on trigger " + this.trigger.getName() + "does not exist ");
        }
    }

    private void initWithEncription() {
        if (Token.hasString(this.statement, "WITH ENCRYPTION")) {
            this.trigger.setEncription("YES");
        } else {
            this.trigger.setEncription("NO");
        }
    }

    private void initTriggeringTime() {
        if (Token.hasString(this.statement, "INSTEAD OF")) {
            this.trigger.setTriggerTime(TriggerSqlServer.TRIGGER_TIMES[1]);
        } else if (Token.hasString(this.statement, "AFTER")) {
            this.trigger.setTriggerTime(TriggerSqlServer.TRIGGER_TIMES[0]);
        } else {
            this.trigger.setTriggerTime("FOR");
        }
    }

    private void initAction() {
        String string = Token.getStringAfterToken(this.statement, "ON");
        if (Token.hasString(string = string.substring(0, string.toUpperCase().indexOf(" AS ")), "INSERT")) {
            this.trigger.setActions("INSERT");
        }
        if (Token.hasString(string, "DELETE")) {
            this.trigger.setActions("DELETE");
        }
        if (Token.hasString(string, "UPDATE")) {
            this.trigger.setActions("UPDATE");
        }
    }

    private void initNotForReplication() {
        if (Token.hasString(this.statement, "NOT FOR REPLICATION")) {
            this.trigger.setForReplication("YES");
        } else {
            this.trigger.setForReplication("NO");
        }
    }

    private void initBody() {
        this.trigger.setBody(Token.getStringAfterToken(this.statement, "AS"));
    }
}

