/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSynonymSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateSynonymSqlServerv2k5.class);

    public SHCreateSynonymSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSynonymSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create synonym")) {
            try {
                this.parseSynonym(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateSynonymSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseSynonym(String string) {
        this.statement = string;
        String string2 = Token.getTokenAfter(string, "SYNONYM").trim();
        String string3 = Token.getTokenAfter(string, "FOR").trim();
        String string4 = Token.getValBeforeCharacter(string2, '.').trim();
        String string5 = Token.getValAfterCharacter(string3, '.').trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(string5);
        TableView tableView = null;
        StoredProcedureSqlServerv2k5 storedProcedureSqlServerv2k5 = null;
        SchemaSqlServerv2k5 schemaSqlServerv2k5 = null;
        if (!string4.equalsIgnoreCase("")) {
            string2 = Token.getValAfterCharacter(string2, '.');
        }
        if (!string2.equalsIgnoreCase("") && !string5.equalsIgnoreCase("")) {
            SynonymSqlServer synonymSqlServer = storageDesignSqlServerv2k5.getSynonymSet().createSynonym();
            synonymSqlServer.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(synonymSqlServer);
            if (table == null) {
                tableView = (TableView)storageDesignSqlServerv2k5.getPhysicalDesign().getTableViewSet().getByName(string5);
                if (tableView != null) {
                    TableViewProxySqlServerv2k5 tableViewProxySqlServerv2k5 = (TableViewProxySqlServerv2k5)storageDesignSqlServerv2k5.getTableViewProxySet().getProxy(tableView.getObjectID());
                    schemaSqlServerv2k5 = (SchemaSqlServerv2k5)tableViewProxySqlServerv2k5.getDataBase().getSchemas().getByName(string4);
                    synonymSqlServer.setSchema(schemaSqlServerv2k5);
                    synonymSqlServer.setView(tableViewProxySqlServerv2k5);
                } else {
                    storedProcedureSqlServerv2k5 = (StoredProcedureSqlServerv2k5)storageDesignSqlServerv2k5.getStoredProcedureSet().getByName(string5);
                    if (storedProcedureSqlServerv2k5 != null) {
                        schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storedProcedureSqlServerv2k5.getDatabase().getSchemas().getByName(string4);
                        synonymSqlServer.setSchema(schemaSqlServerv2k5);
                        synonymSqlServer.setProcedure(storedProcedureSqlServerv2k5);
                    }
                }
            } else {
                TableProxySqlServerv2k5 tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)storageDesignSqlServerv2k5.getTableProxySet().getProxy(table.getObjectID());
                schemaSqlServerv2k5 = (SchemaSqlServerv2k5)tableProxySqlServerv2k5.getDatabase().getSchemas().getByName(string4);
                synonymSqlServer.setSchema(schemaSqlServerv2k5);
                synonymSqlServer.setTable(tableProxySqlServerv2k5);
            }
        } else if (!string2.equalsIgnoreCase("") && !string3.equalsIgnoreCase("")) {
            TableViewProxySqlServerv2k5 tableViewProxySqlServerv2k5;
            SynonymSqlServer synonymSqlServer = storageDesignSqlServerv2k5.getSynonymSet().createSynonym();
            synonymSqlServer.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(synonymSqlServer);
            storedProcedureSqlServerv2k5 = (StoredProcedureSqlServerv2k5)storageDesignSqlServerv2k5.getStoredProcedureSet().getByName(string3);
            if (storedProcedureSqlServerv2k5 != null) {
                schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storedProcedureSqlServerv2k5.getDatabase().getSchemas().getByName(string4);
                synonymSqlServer.setSchema(schemaSqlServerv2k5);
                synonymSqlServer.setProcedure(storedProcedureSqlServerv2k5);
            }
            if ((tableViewProxySqlServerv2k5 = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)storageDesignSqlServerv2k5.getTableViewProxySet()).getByName(string3)) != null) {
                schemaSqlServerv2k5 = (SchemaSqlServerv2k5)tableViewProxySqlServerv2k5.getDataBase().getSchemas().getByName(string4);
                synonymSqlServer.setSchema(schemaSqlServerv2k5);
                synonymSqlServer.setView(tableViewProxySqlServerv2k5);
            }
        } else {
            LOGGER.error("SynonymSqlServer.parseSynonym: wrong syntax!");
            this.importLog.addWarning("Synonym without name.");
        }
    }
}

