/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRuleSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRuleSqlServerv2k5
extends SHCreateRuleSqlServer {
    private static final String RULENAME = "@rulename";
    private static final Logger LOGGER = new Logger(SHCreateRuleSqlServer.class);
    private RuleSqlServerv2k5 rule;
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreateRuleSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRuleSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create rule ")) {
            try {
                this.parseRule(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRuleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_bindrule ")) {
            try {
                this.bindRule(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRuleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseRule(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.rule = (RuleSqlServerv2k5)this.storageDesign.getRuleSet().createRule();
            if (this.rule != null) {
                this.initRuleName();
                this.initExpression();
                this.design.getRelationalDesign().stampModelObjectDDL(this.rule);
                if (this.rule.getDatabase() == null) {
                    this.rule.setDatabase(this.getCurrentDB());
                }
            }
        }
    }

    private void initRuleName() {
        String string = Token.getStringAfter(this.statement, "RULE").trim();
        if ((string = Token.getStringBefore(string, "AS").trim()).indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = Token.getValBetweenSquareBrackets(string2);
            SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(string2);
            if (schemaSqlServerv2k5 != null) {
                this.rule.setSchema(schemaSqlServerv2k5);
                this.rule.setDatabase(schemaSqlServerv2k5.getDatabase());
            }
            string = string.substring(string.indexOf(46) + 1);
        }
        this.rule.setName(string);
    }

    private void initExpression() {
        String string = Token.getStringAfter(this.statement, "AS").trim();
        this.rule.setExpression(string);
    }

    private void bindRule(String string) {
        String string2;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null && (string2 = Token.getStringAfter(this.statement, "sp_bindrule").trim()).indexOf(44) > -1) {
            RuleSqlServerv2k5 ruleSqlServerv2k5;
            String string3 = string2.substring(0, string2.indexOf(44)).trim();
            String string4 = string2.substring(string2.indexOf(44) + 1).trim();
            if (string3.startsWith(RULENAME)) {
                string3 = Token.getStringAfter(string3, "=").trim();
            }
            if (string3.toUpperCase().startsWith("N'")) {
                string3 = string3.substring(1);
            }
            if (string3.startsWith("'")) {
                string3 = Token.getValBetweenQuotationMarks(string3);
            }
            if (string4.startsWith("@")) {
                string4 = Token.getStringAfter(string4, "=").trim();
            }
            if (string4.toUpperCase().startsWith("N'")) {
                string4 = string4.substring(1);
            }
            if (string4.startsWith("'")) {
                string4 = Token.getValBetweenQuotationMarks(string4);
            }
            if (string3.indexOf(46) > -1) {
                string3 = string3.substring(string3.indexOf(46) + 1);
            }
            if ((ruleSqlServerv2k5 = (RuleSqlServerv2k5)this.storageDesign.getRuleSet().getByName(string3)) != null) {
                this.bindColumn(ruleSqlServerv2k5, string4);
            }
        }
    }

    private void bindColumn(RuleSqlServerv2k5 ruleSqlServerv2k5, String string) {
        StorageObject storageObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringTokenizer.countTokens() == 2) {
            string4 = string;
            string3 = stringTokenizer.nextToken().trim();
            string5 = stringTokenizer.nextToken().trim();
        } else if (stringTokenizer.countTokens() == 3) {
            string2 = stringTokenizer.nextToken().trim();
            string4 = string.substring(string.indexOf(".")).trim();
            string3 = stringTokenizer.nextToken().trim();
            string5 = stringTokenizer.nextToken().trim();
        } else {
            LOGGER.error("RuleSqlServer " + ruleSqlServerv2k5.getName() + ": wrong column syntax!");
            this.importLog.addWarning("Wrong column syntax for rule " + ruleSqlServerv2k5.getName());
        }
        if (string2 != null) {
            string2 = Token.getValBetweenSquareBrackets(string2);
            storageObject = (UserSqlServerv2k5)this.storageDesign.getUserSet().getByName(string2);
            if (storageObject != null) {
                ruleSqlServerv2k5.setOwner((UserSqlServer)storageObject);
            }
        }
        if (string4 != null) {
            string3 = Token.getValBetweenSquareBrackets(string3);
            storageObject = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(string3);
            if (storageObject != null) {
                ruleSqlServerv2k5.setColumns(string5);
                ruleSqlServerv2k5.setDatabase(((TableProxySqlServer)storageObject).getDatabase());
            }
        }
    }
}

