/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRoleSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleSqlServerv2k5
extends SHCreateRoleSqlServer {
    private static final String ROLENAME = "@rolename";
    private static final String MEMBERNAME = "@membername";
    private static final String PASSWORD = "@password";
    private static final String OWNERNAME = "@ownername";
    private static final Logger LOGGER = new Logger(SHCreateRoleSqlServer.class);

    public SHCreateRoleSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRoleSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "exec sp_addrole")) {
            try {
                this.createDBRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "create role")) {
            try {
                this.createDBRoleNew(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_addapprole")) {
            try {
                this.createApplRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "create application role")) {
            try {
                this.createApplRoleNew(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_addrolemember")) {
            try {
                this.addRoleMember(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createApplRoleNew(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            RoleSqlServerv2k5 roleSqlServerv2k5 = (RoleSqlServerv2k5)storageDesignSqlServerv2k5.getRoleSet().createRole();
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServerv2k5);
            roleSqlServerv2k5.setIsApplicationRole(true);
            String string2 = Token.getStringAfter(this.statement, "ROLE").trim();
            String string3 = Token.getFirstName(string2, '\'', '\'');
            String string4 = string2.substring(string3.length() + 1);
            if (!string4.equalsIgnoreCase("")) {
                String string5 = "";
                String string6 = string4;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                if (stringTokenizer.countTokens() == 2) {
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                string6 = Token.getStringAfter(string6, "=");
                string6 = Token.getValBetweenQuotationMarks(string6);
                if (!string5.equalsIgnoreCase("")) {
                    string5 = Token.getStringAfter(string5, "=");
                }
                roleSqlServerv2k5.setName(string3);
                roleSqlServerv2k5.encodePassword(string6);
                roleSqlServerv2k5.setDefaultSchema(string5);
                roleSqlServerv2k5.setDatabase(this.getCurrentDB());
            } else {
                LOGGER.error("RoleSqlServer.createApplRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in creating appl role " + string2);
            }
        }
    }

    private void createDBRole(String string) {
        RoleSqlServerv2k5 roleSqlServerv2k5;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null && (roleSqlServerv2k5 = (RoleSqlServerv2k5)storageDesignSqlServerv2k5.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServerv2k5);
            roleSqlServerv2k5.setIsApplicationRole(false);
            String string2 = Token.getStringAfter(this.statement, "sp_addrole").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = "";
            if (stringTokenizer.countTokens() == 1) {
                string3 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                roleSqlServerv2k5.setName(string3);
                roleSqlServerv2k5.setDatabase(this.getCurrentDB());
            } else if (stringTokenizer.countTokens() == 2) {
                string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(OWNERNAME)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                roleSqlServerv2k5.setName(string3);
                roleSqlServerv2k5.setDatabase(this.getCurrentDB());
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServerv2k5 userSqlServerv2k5 = (UserSqlServerv2k5)storageObjectCollection.getByName(string4);
                roleSqlServerv2k5.setOwner(userSqlServerv2k5);
            } else {
                LOGGER.error("RoleSqlServer.createDBRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining db role " + string2);
            }
        }
    }

    private void createDBRoleNew(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            RoleSqlServer roleSqlServer = storageDesignSqlServerv2k5.getRoleSet().createRole();
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServer);
            roleSqlServer.setIsApplicationRole(false);
            String string2 = Token.getStringAfter(this.statement, "ROLE").trim();
            String string3 = Token.getFirstToken(string2);
            string3 = Token.getValBetweenQuotationMarks(string3);
            if (!string3.equalsIgnoreCase("")) {
                String string4 = Token.getStringAfter(string2, "AUTHORIZATION");
                roleSqlServer.setName(string3);
                roleSqlServer.setDatabase(this.getCurrentDB());
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServer userSqlServer = (UserSqlServer)storageObjectCollection.getByName(string4);
                roleSqlServer.setOwner(userSqlServer);
            } else {
                LOGGER.error("RoleSqlServer.createDBRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining db role " + string2);
            }
        }
    }

    private void createApplRole(String string) {
        RoleSqlServerv2k5 roleSqlServerv2k5;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null && (roleSqlServerv2k5 = (RoleSqlServerv2k5)storageDesignSqlServerv2k5.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServerv2k5);
            roleSqlServerv2k5.setIsApplicationRole(true);
            String string2 = Token.getStringAfter(this.statement, "sp_addapprole").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(PASSWORD)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                roleSqlServerv2k5.setName(string3);
                roleSqlServerv2k5.encodePassword(string4);
                roleSqlServerv2k5.setDatabase(this.getCurrentDB());
            } else {
                LOGGER.error("RoleSqlServer.createApplRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in creating appl role " + string2);
            }
        }
    }

    private void addRoleMember(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_addrolemember").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(MEMBERNAME)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                RoleSqlServerv2k5 roleSqlServerv2k5 = (RoleSqlServerv2k5)storageDesignSqlServerv2k5.getRoleSet().getByName(string3);
                if (roleSqlServerv2k5 != null && string4 != null && storageDesignSqlServerv2k5.getUserSet().getByName(string4) != null) {
                    roleSqlServerv2k5.setUsers(string4);
                }
            } else {
                LOGGER.error("RoleSqlServer.addRoleMember(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in defining role member " + string2);
            }
        }
    }
}

