/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreatePartitionFunctionSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServer.class);
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreatePartitionFunctionSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreatePartitionFunctionSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create partition function")) {
            try {
                this.parseFunction(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreatePartitionFunctionSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseFunction(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            String string2 = this.initFunctionName(string);
            String string3 = Token.getValBetweenBrackets(string, 1);
            String string4 = Token.getTokenAfter(string, "RANGE");
            PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)this.storageDesign.getPartitionFunctionSet().createPartitionFunction();
            partitionFunctionSqlServerv2k5.setName(string2);
            partitionFunctionSqlServerv2k5.setDatabase(this.getCurrentDB());
            partitionFunctionSqlServerv2k5.setInputType(string3);
            partitionFunctionSqlServerv2k5.setRangeType(string4);
            this.design.getRelationalDesign().stampModelObjectDDL(partitionFunctionSqlServerv2k5);
            this.initBoundaryValues(partitionFunctionSqlServerv2k5, Token.getStringAfter(string, "VALUES"));
        }
    }

    private void initBoundaryValues(PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5, String string) {
        String string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "VALUES"));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = Token.getValBetweenQuotes(string3);
            partitionFunctionSqlServerv2k5.setBoundaryValues(string3);
            partitionFunctionSqlServerv2k5.setBoundaryValues("");
        }
    }

    private String initFunctionName(String string) {
        String string2 = Token.getTokenAfter(string, "FUNCTION");
        return string2;
    }
}

