/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDefaultSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDefaultSqlServerv2k5
extends SHCreateDefaultSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDefaultSqlServer.class);

    public SHCreateDefaultSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDefaultSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create default ")) {
            try {
                this.createDefault(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addError("Parsing " + string2 + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_bindefault ")) {
            try {
                this.bindDefault(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addError("Parsing " + string2 + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createDefault(String string) {
        DefaultSqlServerv2k5 defaultSqlServerv2k5;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null && (defaultSqlServerv2k5 = (DefaultSqlServerv2k5)storageDesignSqlServerv2k5.getDefaultSet().createDefault()) != null) {
            String string2;
            this.design.getRelationalDesign().stampModelObjectDDL(defaultSqlServerv2k5);
            String string3 = Token.getStringAfter(this.statement, "CREATE DEFAULT").trim();
            string3 = Token.getValBetweenSquareBrackets(Token.getStringBefore(string3, "AS").trim());
            if (string3.indexOf(46) > -1) {
                string2 = Token.getValBetweenSquareBrackets(string3.substring(0, string3.indexOf(46)));
                StorageObjectCollection storageObjectCollection = this.getCurrentDB().getSchemas();
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageObjectCollection.getByName(string2);
                if (schemaSqlServerv2k5 != null) {
                    defaultSqlServerv2k5.setSchema(schemaSqlServerv2k5);
                }
                string3 = string3.substring(string3.indexOf(46) + 1);
            }
            defaultSqlServerv2k5.setName(string3);
            string2 = Token.getStringAfterToken(this.statement, " AS ").trim();
            if (string2.toUpperCase().startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            defaultSqlServerv2k5.setConstant(string2);
            defaultSqlServerv2k5.setDataBase(this.getCurrentDB());
        }
    }

    private void bindDefault(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            String string2 = Token.getStringAfter(this.statement.toLowerCase(), "sp_bindefault ").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if ((string3 = Token.getValBetweenSquareBrackets(string3).trim()).startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                if (string4.indexOf(46) > -1) {
                    string4 = string4.substring(string4.indexOf(46) + 1);
                }
                string4 = Token.getValBetweenSquareBrackets(string4).trim();
                if (string3.indexOf(46) > -1) {
                    string3 = string3.substring(string3.indexOf(46) + 1);
                }
                DefaultSqlServerv2k5 defaultSqlServerv2k5 = (DefaultSqlServerv2k5)storageDesignSqlServerv2k5.getDefaultSet().getByName(string3);
                ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)storageDesignSqlServerv2k5.getColumnProxySet()).getByName(string4);
                if (defaultSqlServerv2k5 != null && columnProxySqlServerv2k5 != null) {
                    columnProxySqlServerv2k5.setDefaultObject(defaultSqlServerv2k5);
                    columnProxySqlServerv2k5.setDefineDefault(true);
                } else if (defaultSqlServerv2k5 != null && columnProxySqlServerv2k5 == null) {
                    UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)storageDesignSqlServerv2k5.getUsedUserDefinedDataSet().getByName(string4);
                    usedUserDefinedDatav2k5.setDefaultObject(defaultSqlServerv2k5);
                }
            } else {
                LOGGER.error("DefaultSqlServer.bindDefault(): wrong syntax!");
                this.importLog.addError("Wrong syntax near " + string);
            }
        }
    }
}

