/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHColumnElementsSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableSqlServer
extends DDLStatementHandlerSqlServer
implements SectionConstants,
CreateTableHandler {
    private RDBMSSite site = null;
    private Table table = null;
    private String tableName;
    private String dataBase;
    private String ownerName;
    private String inSideBrackets;
    private ArrayList columns;
    private StorageDesignSqlServer storageDesign = null;
    private TableProxySqlServer tableProxy = null;
    private boolean createDomainsDuringImport;
    private String fileGroup;
    private String textImageOn;
    private List fkList;
    private List refAtColumnList;
    private List tableNodeList = new ArrayList();
    private String outSideBrackets;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableSqlServer.class);

    public SHCreateTableSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block5: {
            String string2 = SHCreateTableSqlServer.clearCR(string);
            if (Token.startsWithString(string2, "create table")) {
                try {
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(string2);
                    FKRefNode fKRefNode = new FKRefNode();
                    fKRefNode.processedTable = this.table;
                    fKRefNode.fkStatements = this.fkList;
                    fKRefNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fKRefNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableSqlServer.FormatCR(string, "\n"));
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error(exception);
                    this.importLog.addFailedStatement(SHCreateTableSqlServer.FormatCR(string, "\n"));
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    public void parseTable(String string) {
        this.setStatement(string);
        this.outSideBrackets = Token.getValOutsideBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.table = this.design.getDesign().getRelationalDesign().createTable();
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServer)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxySqlServer)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.storageDesign.getDesign().getAppView().getSettings().isCreateDomainsDuringImport();
        this.statement = string;
        this.columns = this.initColumns();
        this.fileGroup = this.initFileGroup();
        this.textImageOn = this.initTextImageOn();
        this.tableProxy.setDatabase((DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.dataBase));
        this.tableProxy.setUser((UserSqlServer)this.storageDesign.getUserSet().getByName(this.ownerName));
        this.tableProxy.setFilegroup((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(this.fileGroup));
        this.tableProxy.setTextImageFG((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(this.textImageOn));
        for (int i = 0; i < this.columns.size(); ++i) {
            ModelIDObject modelIDObject;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Map map = (Map)this.columns.get(i);
            boolean bl = (Boolean)map.get("IS_CONSTRAINT");
            if (!bl) {
                Object object6;
                int n;
                boolean bl2;
                int n2;
                Object object7;
                String string2;
                boolean bl3;
                Object object8;
                Object object9;
                Object object10;
                object5 = this.table.createColumn((String)map.get("columnname"));
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                String string3 = (String)map.get("datatype");
                object4 = (String)map.get("scale");
                object3 = (String)map.get("size");
                object2 = (String)map.get("precision");
                object = new String[]{object2, object4, object3};
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                modelIDObject = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string4);
                if (this.createDomainsDuringImport) {
                    object10 = null;
                    object9 = (String)map.get("typename");
                    if (object9 != null) {
                        object8 = this.design.getDesign().getDomainSet();
                        object10 = (Domain)((DesignObjectSet)object8).getByName((String)object9);
                    }
                    object8 = "";
                    if (object10 == null) {
                        object8 = DomainFactory.createDomainName(modelIDObject, (String[])object);
                        object10 = this.getCorrespondingDomain((String)object8);
                    }
                    if (object10 != null) {
                        ((Column)object5).setDomain((Domain)object10);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer("domain is null in SHCreateTableSqlServer.parseTable, TABLE=" + this.tableName + ": ");
                        stringBuffer.append((String)object8);
                        LOGGER.error(stringBuffer.toString());
                        this.importLog.addError("Null domain occurred while creating " + this.tableName);
                    }
                } else {
                    ((ContainedObjectWithDomain)object5).setLogicalDatatype((LogicalDatatype)modelIDObject);
                    ((ContainedObjectWithDomain)object5).setUse((short)1);
                    ((ContainedObjectWithDomain)object5).setDataTypeParameter("scale", (String)object4);
                    ((ContainedObjectWithDomain)object5).setDataTypeParameter("precision", (String)object2);
                    ((ContainedObjectWithDomain)object5).setDataTypeParameter("size", (String)object3);
                }
                object10 = (Boolean)map.get("nulls");
                if (object10 != null) {
                    boolean bl4 = (Boolean)object10;
                    ((ContainedObject)object5).setNullsAllowed(bl4);
                }
                object9 = (ColumnProxySqlServer)this.storageDesign.getColumnProxySet().getProxy(((ModelIDObject)object5).getObjectID());
                if (map.containsKey("collate")) {
                    object8 = (String)map.get("collate");
                    ((ColumnProxySqlServer)object9).setCollation((String)object8);
                }
                if (map.containsKey(NameElements.COL_DEFAULT)) {
                    object8 = (String)map.get(NameElements.COL_DEFAULT);
                    ((ContainedObjectWithDomain)object5).setUsesDefaultValue(true);
                    ((ContainedObjectWithDomain)object5).setDefaultValue((String)object8);
                }
                if (bl3 = ((Boolean)(object8 = (Boolean)map.get("IDENTITY"))).booleanValue()) {
                    ((Column)object5).setIdentityColumn(true);
                    string2 = (String)map.get("SEED");
                    if (string2 != null) {
                        ((ColumnProxySqlServer)object9).setIdentitySeed(string2);
                    }
                    if ((object7 = map.get("INCREMENT")) != null) {
                        try {
                            n2 = Integer.parseInt((String)object7);
                            ((ColumnProxySqlServer)object9).setIdentityIncrement(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (map.containsKey("NOT FOR REPLICATION")) {
                        n2 = ((Boolean)map.get("NOT FOR REPLICATION")).booleanValue() ? 1 : 0;
                        if (n2 != 0) {
                            ((ColumnProxySqlServer)object9).setIdentityForReplication("NO");
                        } else {
                            ((ColumnProxySqlServer)object9).setIdentityForReplication("YES");
                        }
                    }
                }
                if (map.containsKey("COMPUTED")) {
                    ((Column)object5).setComputed((boolean)((Boolean)map.get("COMPUTED")));
                }
                if (map.containsKey("FORMULA")) {
                    string2 = (String)map.get("FORMULA");
                    ((ContainedObject)object5).setFormulaDesc(string2);
                }
                if (map.containsKey("ROWGUIDCOL")) {
                    boolean bl5 = (Boolean)map.get("ROWGUIDCOL");
                    if (bl5) {
                        ((ColumnProxySqlServer)object9).setRowGuidCol("YES");
                    } else {
                        ((ColumnProxySqlServer)object9).setRowGuidCol("NO");
                    }
                }
                if (bl2 = ((Boolean)map.get("PRIMARY KEY")).booleanValue()) {
                    String string5;
                    object7 = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object7);
                    ((Index)object7).add((ContainedObject)object5);
                    ((KeyObject)object7).makePK();
                    PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)this.storageDesign.getPKProxySet().getProxy(((ModelIDObject)object7).getObjectID());
                    if (map.containsKey("CLUSTERED")) {
                        pKProxySqlServer.setClustered(true);
                    } else if (map.containsKey("NONCLUSTERED")) {
                        pKProxySqlServer.setClustered(false);
                    }
                    if (map.containsKey("FILLFACTOR")) {
                        try {
                            n = Integer.parseInt((String)map.get("FILLFACTOR"));
                            pKProxySqlServer.setFillFactor(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (map.containsKey("FILEGROUP") && !(string5 = (String)map.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) {
                        FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string5);
                        pKProxySqlServer.setFilegroup(fileGroupSqlServer);
                    }
                } else {
                    boolean bl6 = (Boolean)map.get("UNIQUE");
                    if (bl6) {
                        String string6;
                        Index index = this.table.createIndex();
                        this.design.getRelationalDesign().stampModelObjectDDL(index);
                        index.add((ContainedObject)object5);
                        index.setIndexState("Unique Constraint");
                        object6 = (UniqueProxySqlServer)this.storageDesign.getUniqueProxySet().getProxy(index.getObjectID());
                        if (map.containsKey("CLUSTERED")) {
                            ((IndexProxy)object6).setClustered(true);
                        } else if (map.containsKey("NONCLUSTERED")) {
                            ((IndexProxy)object6).setClustered(false);
                        }
                        if (map.containsKey("FILLFACTOR")) {
                            try {
                                int n3 = Integer.parseInt((String)map.get("FILLFACTOR"));
                                ((UniqueProxySqlServer)object6).setFillFactor(n3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (map.containsKey("FILEGROUP") && !(string6 = (String)map.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) {
                            FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string6);
                            ((UniqueProxySqlServer)object6).setFilegroup(fileGroupSqlServer);
                        }
                    } else {
                        n2 = ((Boolean)map.get("FOREIGN")).booleanValue() ? 1 : 0;
                        if (n2 != 0) {
                            object6 = this.getColumnLine((String)map.get("columnname"));
                            this.addForeignKey((String)object6, this.table);
                        }
                    }
                }
                object7 = (String)map.get("REFERENCES");
                if (object7 != null) {
                    RefAtColNode refAtColNode = new RefAtColNode();
                    n = ((String)object7).indexOf(46);
                    if (n > 0) {
                        object7 = Token.getValAfterCharacter((String)object7, '.');
                    }
                    refAtColNode.onDelete = (String)map.get("ON DELETE");
                    refAtColNode.columnName = (String)map.get("columnname");
                    refAtColNode.refColumn = (String)map.get("REFERENCED_COLUMN");
                    refAtColNode.referencedTable = object7;
                    this.refAtColumnList.add(refAtColNode);
                }
                String string7 = (String)map.get("CONSTRAINT");
                object6 = (String)map.get("CHECK");
                if (object6 == null) continue;
                this.initCheckConstraint((String)object6, string7, (Column)object5);
                continue;
            }
            object5 = (String)map.get("CONSTRAINT_NAME");
            boolean bl7 = (Boolean)map.get("PRIMARY KEY");
            if (bl7) {
                object4 = this.table.createIndex();
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                if (!"".equalsIgnoreCase((String)object5)) {
                    ((DesignObject)object4).setName((String)object5);
                } else {
                    if (this.tableName.length() > 125) {
                        this.tableName = this.tableName.substring(0, 125);
                    }
                    ((DesignObject)object4).setName(this.tableName + "_PK");
                }
                object3 = (String)map.get("CONSTRAINT_VALUE");
                try {
                    String string8;
                    this.setColumnsForIndexPK((Index)object4, (String)object3);
                    ((KeyObject)object4).makePK();
                    object2 = (PKProxySqlServer)this.storageDesign.getPKProxySet().getProxy(((ModelIDObject)object4).getObjectID());
                    if (map.containsKey("CLUSTERED")) {
                        ((IndexProxy)object2).setClustered(true);
                    } else if (map.containsKey("NONCLUSTERED")) {
                        ((IndexProxy)object2).setClustered(false);
                    }
                    if (map.containsKey("FILLFACTOR")) {
                        try {
                            int n = Integer.parseInt((String)map.get("FILLFACTOR"));
                            ((PKProxySqlServer)object2).setFillFactor(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!map.containsKey("FILEGROUP") || (string8 = (String)map.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) continue;
                    FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string8);
                    ((PKProxySqlServer)object2).setFilegroup(fileGroupSqlServer);
                }
                catch (ObjectDoesNotExistException objectDoesNotExistException) {
                    LOGGER.error("", objectDoesNotExistException);
                    this.importLog.addError("Columns for primary key " + ((DesignObject)object4).getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean bl8 = (Boolean)map.get("UNIQUE");
            if (bl8) {
                object3 = this.table.createIndex();
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                if (!"".equalsIgnoreCase((String)object5)) {
                    ((DesignObject)object3).setName((String)object5);
                } else {
                    if (this.tableName.length() > 123) {
                        this.tableName = this.tableName.substring(0, 123);
                    }
                    ((DesignObject)object3).setName(this.tableName + "_UK" + this.table.getUKeys().size());
                }
                object2 = (String)map.get("CONSTRAINT_VALUE");
                try {
                    String string9;
                    this.setColumnsForIndexPK((Index)object3, (String)object2);
                    ((Index)object3).setIndexState("Unique Constraint");
                    object = (UniqueProxySqlServer)this.storageDesign.getUniqueProxySet().getProxy(((ModelIDObject)object3).getObjectID());
                    if (map.containsKey("CLUSTERED")) {
                        ((IndexProxy)object).setClustered(true);
                    } else if (map.containsKey("NONCLUSTERED")) {
                        ((IndexProxy)object).setClustered(false);
                    }
                    if (map.containsKey("FILLFACTOR")) {
                        try {
                            int n = Integer.parseInt((String)map.get("FILLFACTOR"));
                            ((UniqueProxySqlServer)object).setFillFactor(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!map.containsKey("FILEGROUP") || (string9 = (String)map.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) continue;
                    modelIDObject = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string9);
                    ((UniqueProxySqlServer)object).setFilegroup((FileGroupSqlServer)modelIDObject);
                }
                catch (ObjectDoesNotExistException objectDoesNotExistException) {
                    LOGGER.error("", objectDoesNotExistException);
                    this.importLog.addError("Columns for unique key " + ((DesignObject)object3).getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean bl9 = (Boolean)map.get("CHECK");
            if (!bl9) continue;
            object2 = (String)map.get("CONSTRAINT_VALUE");
            if (this.tableName.length() > 123) {
                this.tableName = this.tableName.substring(0, 123);
            }
            object = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), (String)object2);
            if (!"".equalsIgnoreCase((String)object5)) {
                ((DesignObject)object).setName((String)object5);
            }
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            this.table.addCheckConstraint((TableLevelConstraint)object);
        }
    }

    private String getColumnLine(String string) {
        String string2 = this.inSideBrackets;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracketNoClose(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString().trim();
                }
            }
            if (!Token.isTokenEqualTo(string3, 1, string)) continue;
            return string3;
        }
        return string3;
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        Object object;
        CheckConstraint checkConstraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(checkConstraint);
        RDBMSTypeSet rDBMSTypeSet = this.design.getRDBMSTypeSet();
        Iterator iterator = rDBMSTypeSet.iterator();
        while (iterator.hasNext()) {
            object = (RDBMSType)iterator.next();
            if (object != StorageDesignSqlServerv2k.RDBMS_TYPE) continue;
            checkConstraint.add((ConstraintType)object, string);
        }
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            object = column.getName();
            if (((String)object).length() > 123) {
                object = ((String)object).substring(0, 123);
            }
            string2 = (String)object + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        }
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    private String initTableName() {
        String string = Token.getTokenAfter(this.statement, "TABLE", " ").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "TABLE", '[', ']').trim() : (string.startsWith("\"") ? Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim() : string);
        int n = string2.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken().toString();
                ++n2;
            }
            if (stringArray.length == 3) {
                this.dataBase = stringArray[0];
                this.ownerName = stringArray[1];
                string2 = stringArray[2];
                string2 = Token.getValBetweenSquareBrackets(string2);
                string2 = Token.removeQuotes(string2);
                return string2;
            }
            if (stringArray.length == 2) {
                this.ownerName = stringArray[0];
                string2 = stringArray[1];
                string2 = Token.getValBetweenSquareBrackets(string2);
                string2 = Token.removeQuotes(string2);
                this.dataBase = this.getCurrentDB().getName();
                return string2;
            }
        }
        if (this.getCurrentDB() != null) {
            this.dataBase = this.getCurrentDB().getName();
        }
        this.ownerName = "";
        return string2;
    }

    private ArrayList initColumns() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.inSideBrackets;
        SHColumnElementsSqlServer sHColumnElementsSqlServer = new SHColumnElementsSqlServer(this.design);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            if (Boolean.TRUE.equals((object = sHColumnElementsSqlServer.getElementsColumn(string2.trim())).get("IS_CONSTRAINT")) && string2.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string2);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDesign().getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    public void setColumnsForIndexPK(Index index, String string) throws ObjectDoesNotExistException {
        if (index != null) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = Token.getFirstName(string2, '[', ']').trim();
                object = "ASC";
                if (string2.toUpperCase().indexOf("DESC", string3.length()) > -1) {
                    object = "DESC";
                }
                arrayList.add(string3);
                hashMap.put(string3, object);
            }
            for (String string3 : arrayList) {
                object = (Column)index.getTable().getElementByName(string3);
                if (object != null) {
                    index.add((ContainedObject)object);
                    String string4 = (String)hashMap.get(string3);
                    index.setColumnSortOrder(object, string4);
                    continue;
                }
                this.importLog.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private String initFileGroup() {
        String string = Token.getTokenAfter(this.outSideBrackets, "ON").trim();
        string = Token.getValBetweenQuotationMarks(string).trim();
        string = Token.getValBetweenSquareBrackets(string).trim();
        return string;
    }

    private String initTextImageOn() {
        String string = Token.getTokenAfter(this.outSideBrackets, "TEXTIMAGE_ON").trim();
        string = Token.getValBetweenQuotationMarks(string).trim();
        string = Token.getValBetweenSquareBrackets(string).trim();
        return string;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasString(string2, "[") && Token.hasString(string2, "]")) {
                string2 = Token.getValBetweenSquareBrackets(string2);
            }
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    private void addForeignKey(String string, Table table) {
        block17: {
            String[] stringArray;
            DesignObject designObject;
            Table table2;
            List list;
            String string2;
            block18: {
                String[] stringArray2;
                DesignObject designObject2;
                string2 = null;
                if (Token.hasToken(string, "CONSTRAINT")) {
                    string2 = Token.getTokenAfter(string, "CONSTRAINT");
                } else {
                    if (this.tableName.length() > 123) {
                        this.tableName = this.tableName.substring(0, 123);
                    }
                    string2 = this.tableName + "_FK" + this.table.getFKAssociationsCount();
                }
                int n = string.indexOf(41);
                String string3 = string.substring(0, n + 1).trim();
                String string4 = Token.getValBetweenBrackets(string3);
                list = this.getColumnNames(string4);
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string5 = Token.getTokenAfter(string, "REFERENCES");
                String string6 = this.getNameFor(string5);
                string6 = Token.removeQuotes(string6);
                table2 = this.getTableFor(string6);
                if (table2 == null) break block17;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block18;
                String string7 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string7);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
                Column[] columnArray = (Column[])table.getElements();
                for (int i = 0; i < columnArray.length; ++i) {
                    designObject2 = columnArray[i];
                    String string8 = ((ContainedObject)designObject2).getName().trim();
                    for (int j = 0; j < list.size(); ++j) {
                        stringArray2 = (String[])list.get(j);
                        if (!string8.equals(stringArray2)) continue;
                        arrayList.add(designObject2);
                    }
                }
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index == null) break block17;
                designObject2 = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(designObject2);
                if (string2 != null) {
                    ((FKIndexAssociation)designObject2).setName(string2);
                    ((FKIndexAssociation)designObject2).getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns((FKIndexAssociation)designObject2, arrayList, index);
                } else {
                    this.fixFKColumns((FKIndexAssociation)designObject2, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (!bl2) break block17;
                String string9 = Token.getTokenAfter(string, "DELETE").trim();
                stringArray2 = ((FKIndexAssociation)designObject2).getDeleteRuleChoices();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string9.equalsIgnoreCase(stringArray2[i])) continue;
                    ((FKIndexAssociation)designObject2).setDeleteRule(stringArray2[i]);
                    break block17;
                }
                break block17;
            }
            Column[] columnArray = (Column[])table.getElements();
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            for (int i = 0; i < columnArray.length; ++i) {
                designObject = columnArray[i];
                String string10 = ((ContainedObject)designObject).getName().trim();
                for (int j = 0; j < list.size(); ++j) {
                    stringArray = (String[])list.get(j);
                    if (!string10.equals(stringArray)) continue;
                    arrayList.add(designObject);
                }
            }
            Index index = (Index)table2.getPK();
            if (index != null) {
                designObject = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(designObject);
                if (string2 != null) {
                    ((FKIndexAssociation)designObject).setName(string2);
                    ((FKIndexAssociation)designObject).getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns((FKIndexAssociation)designObject, arrayList, index);
                } else {
                    this.fixFKColumns((FKIndexAssociation)designObject, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string11 = Token.getTokenAfter(string, "DELETE").trim();
                    stringArray = ((FKIndexAssociation)designObject).getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string11.equalsIgnoreCase(stringArray[i])) continue;
                        ((FKIndexAssociation)designObject).setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private void processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = refAtColNode.referencedTable;
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error(objectDoesNotExistException);
            this.importLog.addError("Referenced table " + string + " of fereign key does not exist.");
            this.failed = true;
        }
        if (table2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(refAtColNode.refColumn);
            Index index = this.getUniqueIndexForColumnNames(table2, arrayList);
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.getDesign().isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
        }
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        this.importLog.addError("Table with name " + string + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    private Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

