/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTriggerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateTriggerSqlServer.class);

    public SHCreateStoredProcedureSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateStoredProcedureSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create proc") || Token.startsWithString(string2, "create procedure")) {
            this.parseStoredProcedure(string2, string);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseStoredProcedure(String string, String string2) {
        StoredProcedureSqlServer storedProcedureSqlServer;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null && (storedProcedureSqlServer = storageDesignSqlServerv2k.getStoredProcedureSet().createStoredProcedure()) != null) {
            try {
                this.initStoredProcedureName(storageDesignSqlServerv2k, storedProcedureSqlServer, string);
                this.initBody(storedProcedureSqlServer, string2, string);
                this.design.getRelationalDesign().stampModelObjectDDL(storedProcedureSqlServer);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(string + " Error parsing stored procedure for SqlServer!");
                this.importLog.addFailedStatement(SHCreateStoredProcedureSqlServer.FormatCR(string2, "\n"));
            }
        }
    }

    private void initStoredProcedureName(StorageDesignSqlServerv2k storageDesignSqlServerv2k, StoredProcedureSqlServer storedProcedureSqlServer, String string) throws ParseException {
        try {
            String string2;
            int n = 1;
            String string3 = Token.getToken(string, n);
            while (!("".equalsIgnoreCase(string3) || string3.equalsIgnoreCase("PROCEDURE") || string3.equalsIgnoreCase("PROC"))) {
                string3 = Token.getToken(string, ++n);
            }
            if ((string2 = Token.getToken(string, ++n)).indexOf(46) > -1) {
                String string4 = string2.substring(0, string2.indexOf(46));
                string4 = Token.getValBetweenSquareBrackets(string4);
                UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServerv2k.getUserSet().getByName(string4);
                if (userSqlServer != null) {
                    storedProcedureSqlServer.setOwner(userSqlServer);
                }
                string2 = string2.substring(string2.indexOf(46) + 1);
            }
            storedProcedureSqlServer.setName(string2);
            storedProcedureSqlServer.setDatabase(this.getCurrentDB());
        }
        catch (Exception exception) {
            LOGGER.error(string + " Error parsing stored procedure name (SqlServer)! ");
            this.importLog.addError("Error parsing stored procedure name for SqlServer " + string);
            throw new ParseException();
        }
    }

    private void initBody(StoredProcedureSqlServer storedProcedureSqlServer, String string, String string2) {
        int n = 1;
        String string3 = Token.getToken(string2, n);
        while (!("".equalsIgnoreCase(string3) || string3.equalsIgnoreCase("PROCEDURE") || string3.equalsIgnoreCase("PROC"))) {
            string3 = Token.getToken(string2, ++n);
        }
        String string4 = Token.getToken(string2, ++n);
        storedProcedureSqlServer.setBody(Token.getStringAfter(string, string4));
    }
}

