/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRuleSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String RULENAME = "@rulename";
    private static final Logger LOGGER = new Logger(SHCreateRuleSqlServer.class);
    private RuleSqlServer rule;
    private StorageDesignSqlServerv2k storageDesign;

    public SHCreateRuleSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRuleSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create rule ")) {
            try {
                this.parseRule(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRuleSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_bindrule ")) {
            try {
                this.bindRule(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRuleSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseRule(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.rule = this.storageDesign.getRuleSet().createRule();
            if (this.rule != null) {
                this.initRuleName();
                this.initExpression();
                this.design.getRelationalDesign().stampModelObjectDDL(this.rule);
                if (this.rule.getDatabase() == null) {
                    this.rule.setDatabase(this.getCurrentDB());
                }
            }
        }
    }

    private void initRuleName() {
        String string = Token.getStringAfter(this.statement, "RULE").trim();
        if ((string = Token.getStringBefore(string, "AS").trim()).indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = Token.getValBetweenSquareBrackets(string2);
            UserSqlServer userSqlServer = (UserSqlServer)this.storageDesign.getUserSet().getByName(string2);
            if (userSqlServer != null) {
                this.rule.setOwner(userSqlServer);
                this.rule.setDatabase(userSqlServer.getDatabase());
            }
            string = string.substring(string.indexOf(46) + 1);
        }
        this.rule.setName(string);
    }

    private void initExpression() {
        String string = Token.getStringAfter(this.statement, "AS").trim();
        this.rule.setExpression(string);
    }

    private void bindRule(String string) {
        String string2;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null && (string2 = Token.getStringAfter(this.statement, "sp_bindrule").trim()).indexOf(44) > -1) {
            RuleSqlServerv2k ruleSqlServerv2k;
            String string3 = string2.substring(0, string2.indexOf(44)).trim();
            String string4 = string2.substring(string2.indexOf(44) + 1).trim();
            if (string3.startsWith(RULENAME)) {
                string3 = Token.getStringAfter(string3, "=").trim();
            }
            if (string3.toUpperCase().startsWith("N'")) {
                string3 = string3.substring(1);
            }
            if (string3.startsWith("'")) {
                string3 = Token.getValBetweenQuotationMarks(string3);
            }
            if (string4.startsWith("@")) {
                string4 = Token.getStringAfter(string4, "=").trim();
            }
            if (string4.toUpperCase().startsWith("N'")) {
                string4 = string4.substring(1);
            }
            if (string4.startsWith("'")) {
                string4 = Token.getValBetweenQuotationMarks(string4);
            }
            if (string3.indexOf(46) > -1) {
                string3 = string3.substring(string3.indexOf(46) + 1);
            }
            if ((ruleSqlServerv2k = (RuleSqlServerv2k)this.storageDesign.getRuleSet().getByName(string3)) != null) {
                this.bindColumn(ruleSqlServerv2k, string4);
            }
        }
    }

    private void bindColumn(RuleSqlServer ruleSqlServer, String string) {
        StorageObject storageObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringTokenizer.countTokens() == 2) {
            string4 = string;
            string3 = stringTokenizer.nextToken().trim();
            string5 = stringTokenizer.nextToken().trim();
        } else if (stringTokenizer.countTokens() == 3) {
            string2 = stringTokenizer.nextToken().trim();
            string4 = string.substring(string.indexOf(".")).trim();
            string3 = stringTokenizer.nextToken().trim();
            string5 = stringTokenizer.nextToken().trim();
        } else {
            LOGGER.error("RuleSqlServer " + ruleSqlServer.getName() + ": wrong column syntax!");
            this.importLog.addWarning("Wrong column syntax for rule " + ruleSqlServer.getName());
        }
        if (string2 != null) {
            string2 = Token.getValBetweenSquareBrackets(string2);
            storageObject = (UserSqlServer)this.storageDesign.getUserSet().getByName(string2);
            if (storageObject != null) {
                ruleSqlServer.setOwner((UserSqlServer)storageObject);
            }
        }
        if (string4 != null) {
            string3 = Token.getValBetweenSquareBrackets(string3);
            storageObject = ((TableProxySetSqlServer)this.storageDesign.getTableProxySet()).getByName(string3);
            if (storageObject != null) {
                ruleSqlServer.setColumns(string5);
                ruleSqlServer.setDatabase(((TableProxySqlServer)storageObject).getDatabase());
            }
        }
    }
}

