/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FileGroupSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.PKProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UniqueProxySqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexSqlServer
extends DDLStatementHandlerSqlServer
implements Constants {
    private Index index;
    private Table table;
    private TableViewProxySqlServer viewProxy;
    private String indexName = "";
    private StorageDesignSqlServerv2k stoDesign;
    private TableView view;
    private IndexOnViewSqlServer iov;
    private RDBMSSite site;
    private static final Logger LOGGER = new Logger(SHCreateIndexSqlServer.class);

    public SHCreateIndexSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndexSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index") || Token.startsWithString(string2, "create unique clustered index") || Token.startsWithString(string2, "create unique nonclustered index") || Token.startsWithString(string2, "create clustered index") || Token.startsWithString(string2, "create nonclustered index")) {
            this.index = null;
            this.indexName = "";
            try {
                this.parseIndex(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateIndexSqlServer.FormatCR(string, "\n"));
            }
            this.index = null;
            this.table = null;
            this.viewProxy = null;
            this.indexName = "";
            this.stoDesign = null;
            this.view = null;
            this.iov = null;
        } else {
            this.nextHandler(string);
        }
    }

    private void parseIndex(String string) {
        this.statement = string;
        if (this.isPK()) {
            this.parsePK(string);
        } else if (this.isUK()) {
            this.parseUK(string);
        } else if (this.isIOV()) {
            this.parseIOV(string);
        } else {
            this.parseInd();
        }
    }

    public void parseInd() {
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.index != null && this.index.getName().equals(this.indexName)) {
                IndexProxySqlServerv2k indexProxySqlServerv2k;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (indexProxySqlServerv2k = (IndexProxySqlServerv2k)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClustered(indexProxySqlServerv2k);
                    this.initPadIndex(indexProxySqlServerv2k);
                    this.initFillFactor(indexProxySqlServerv2k);
                    this.initIgnoreDupKey(indexProxySqlServerv2k);
                    this.initStatisticNoRecompute(indexProxySqlServerv2k);
                    this.initSortInTempDB(indexProxySqlServerv2k);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private void initClustered(IndexProxy indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            indexProxy.setClustered(true);
        } else {
            indexProxy.setClustered(false);
        }
    }

    public void parseIOV(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.view != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && this.iov != null) {
                    this.initPadIndex((IndexOnViewSqlServerv2k)this.iov);
                    this.initFillFactor((IndexOnViewSqlServerv2k)this.iov);
                    this.initIgnoreDupKey((IndexOnViewSqlServerv2k)this.iov);
                    this.initSortInTempDB((IndexOnViewSqlServerv2k)this.iov);
                    this.initStatisticNoRecompute((IndexOnViewSqlServerv2k)this.iov);
                    this.initFileGroup((IndexOnViewSqlServerv2k)this.iov);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    public void parsePK(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.table != null) {
                PKProxySqlServerv2k pKProxySqlServerv2k;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (pKProxySqlServerv2k = new PKProxySqlServerv2k(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(pKProxySqlServerv2k);
                    this.initFillFactorPK(pKProxySqlServerv2k);
                    this.initFileGroupPK(pKProxySqlServerv2k);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private boolean isIOV() {
        String string = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        return this.table == null;
    }

    private boolean isPK() {
        return Token.hasToken(this.statement, "ADD") && Token.hasToken(this.statement, "PRIMARY");
    }

    private String getIndexOption(String string) {
        String string2 = Token.getStringAfter(this.statement, string);
        if (string2.startsWith("=")) {
            String string3 = Token.getFirstToken(string2.substring(1).trim());
            int n = string3.indexOf(44);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            return string3;
        }
        return "";
    }

    private void initSortInTempDB(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setRecomputeStatistics("NO");
        }
    }

    private void initIgnoreDupKey(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                indexOnViewSqlServerv2k.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Fill factor is unknown on index on view " + indexOnViewSqlServerv2k.getName());
            }
        }
    }

    private void initPadIndex(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setPadIndex("YES");
        }
    }

    private void initSortInTempDB(IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k.setRecomputeStatistics("NO");
        }
    }

    private void initIgnoreDupKey(IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexProxySqlServerv2k indexProxySqlServerv2k) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                indexProxySqlServerv2k.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Fill factor is unknown on index " + indexProxySqlServerv2k.getName());
            }
        }
    }

    private void initPadIndex(IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k.setPadIndex("YES");
        }
    }

    private void initFileGroup(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        while (Token.hasToken(this.statement, "ON")) {
            String string = Token.getStringAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            FileGroupSqlServerv2k fileGroupSqlServerv2k = (FileGroupSqlServerv2k)this.stoDesign.getFileGroupSet().getByName(string);
            if (fileGroupSqlServerv2k != null) {
                indexOnViewSqlServerv2k.setFilegroup(fileGroupSqlServerv2k);
            }
            this.statement = Token.getStringAfter(this.statement, "ON");
        }
    }

    private String initIndexName() {
        String string = Token.getTokenAfter(this.statement, "INDEX").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "INDEX", '[', ']').trim() : Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "INDEX"), '.');
        }
        return string2;
    }

    private void constructIndex() {
        String string = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        if (this.table == null) {
            this.view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string);
            this.viewProxy = ((TableViewProxySetSqlServer)this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).getTableViewProxySet()).getByName(string);
        }
        if (this.table != null) {
            Index[] indexArray = (Index[])this.table.getKeys();
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = index;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else if (this.viewProxy != null) {
            this.iov = ((StorageDesignSqlServerv2k)this.design.getStorageDesign(this.design.getSelectedRDBMSSite())).getIndexOnViewSet().createIndexOnView();
            this.iov.setName(this.indexName);
            this.iov.setView(this.viewProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(this.iov);
        }
    }

    private void initUnique() {
        boolean bl;
        if (!this.index.isPK() && (bl = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Constraint");
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        block13: {
            Map map;
            block12: {
                map = null;
                if (this.table == null) break block12;
                map = this.getColumnsForTable();
                if (map.size() <= 0) break block13;
                String string = Token.getValBetweenBrackets(this.statement, 1);
                if ("".equalsIgnoreCase(string.trim())) {
                    return;
                }
                boolean bl = Token.hasCloseAndOpenBrackets(string);
                if (bl) {
                    this.index.setIndexExpression(string);
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    Column column;
                    String string2 = stringTokenizer.nextToken().trim();
                    string2 = Token.getValBetweenSquareBrackets(string2);
                    string2 = Token.getNamesOnly(string2);
                    String string3 = "ASC";
                    int n = string2.indexOf(" ");
                    if (n > 0) {
                        try {
                            if (string2.substring(n + 1).trim().equalsIgnoreCase("DESC")) {
                                string3 = "DESC";
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        string2 = string2.substring(0, n);
                    }
                    if ((column = (Column)map.get(string2 = Token.getValBetweenSquareBrackets(string2))) != null) {
                        try {
                            this.index.add(column);
                            this.index.setColumnSortOrder(column, string3);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Exception occured while adding column to index!" + this.statement);
                            this.importLog.addError("Error in adding column " + column + " to index " + this.indexName);
                        }
                        continue;
                    }
                    throw new ObjectDoesNotExistException("Column");
                }
                break block13;
            }
            if (this.viewProxy != null && (map = this.getColumnsForView()).size() > 0) {
                String string = Token.getValBetweenBrackets(this.statement, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    int n = string4.indexOf(" ");
                    if (n <= 0) continue;
                    string4 = string4.substring(0, n);
                }
            }
        }
    }

    private String getName() {
        String string = Token.getQuotedNameAfterToken(this.statement, "ON");
        int n = string.indexOf(46);
        if (n > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        return Token.getValBetweenSquareBrackets(string);
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columnArray = (Column[])this.table.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private Map getColumnsForView() {
        HashMap<String, ColumnView> hashMap = new HashMap<String, ColumnView>();
        if (this.viewProxy != null) {
            ColumnView[] columnViewArray = (ColumnView[])this.view.getElements();
            for (int i = 0; i < columnViewArray.length; ++i) {
                hashMap.put(columnViewArray[i].getName(), columnViewArray[i]);
            }
        }
        return hashMap;
    }

    public void parseUK(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.initUnique();
            this.setColumnForIndex();
            if (this.table != null) {
                UniqueProxySqlServerv2k uniqueProxySqlServerv2k;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (uniqueProxySqlServerv2k = new UniqueProxySqlServerv2k(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(uniqueProxySqlServerv2k);
                    this.initFillFactorUK(uniqueProxySqlServerv2k);
                    this.initFileGroupUK(uniqueProxySqlServerv2k);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Error in creating unique key " + this.indexName);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServerv2k uniqueProxySqlServerv2k) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            uniqueProxySqlServerv2k.setFilegroup((FileGroupSqlServer)this.stoDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServerv2k uniqueProxySqlServerv2k) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                uniqueProxySqlServerv2k.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Unknown fill factor of unique key " + uniqueProxySqlServerv2k.getName());
            }
        }
    }

    private boolean isUK() {
        return Token.hasToken(this.statement, "UNIQUE") && !this.isIOV();
    }

    private void initFileGroupPK(PKProxySqlServerv2k pKProxySqlServerv2k) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            pKProxySqlServerv2k.setFilegroup((FileGroupSqlServer)this.stoDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorPK(PKProxySqlServerv2k pKProxySqlServerv2k) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                pKProxySqlServerv2k.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Unknown fill factor of primary key " + pKProxySqlServerv2k.getName());
            }
        }
    }
}

