/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDefaultSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDefaultSqlServer.class);

    public SHCreateDefaultSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDefaultSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create default ")) {
            try {
                this.createDefault(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addError("Parsing " + string2 + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "sp_bindefault ")) {
            try {
                this.bindDefault(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addError("Parsing " + string2 + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createDefault(String string) {
        DefaultSqlServer defaultSqlServer;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null && (defaultSqlServer = storageDesignSqlServerv2k.getDefaultSet().createDefault()) != null) {
            String string2;
            this.design.getRelationalDesign().stampModelObjectDDL(defaultSqlServer);
            String string3 = Token.getStringAfter(this.statement, "CREATE DEFAULT").trim();
            string3 = Token.getValBetweenSquareBrackets(Token.getStringBefore(string3, "AS").trim());
            if (string3.indexOf(46) > -1) {
                string2 = Token.getValBetweenSquareBrackets(string3.substring(0, string3.indexOf(46)));
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServer userSqlServer = (UserSqlServer)storageObjectCollection.getByName(string2);
                if (userSqlServer != null) {
                    defaultSqlServer.setOwner(userSqlServer);
                }
                string3 = string3.substring(string3.indexOf(46) + 1);
            }
            defaultSqlServer.setName(string3);
            string2 = Token.getStringAfterToken(this.statement, " AS ").trim();
            if (string2.toUpperCase().startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            defaultSqlServer.setConstant(string2);
            defaultSqlServer.setDataBase(this.getCurrentDB());
        }
    }

    private void bindDefault(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null) {
            String string2 = Token.getStringAfter(this.statement.toLowerCase(), "sp_bindefault ").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if ((string3 = Token.getValBetweenSquareBrackets(string3).trim()).startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                if (string4.indexOf(46) > -1) {
                    string4 = string4.substring(string4.indexOf(46) + 1);
                }
                string4 = Token.getValBetweenSquareBrackets(string4).trim();
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)storageDesignSqlServerv2k.getDefaultSet().getByName(string3);
                ColumnProxySqlServer columnProxySqlServer = ((ColumnProxySetSqlServer)storageDesignSqlServerv2k.getColumnProxySet()).getByName(string4);
                if (defaultSqlServer != null || columnProxySqlServer != null) {
                    columnProxySqlServer.setDefaultObject(defaultSqlServer);
                    columnProxySqlServer.setDefineDefault(true);
                }
            } else {
                LOGGER.error("DefaultSqlServer.bindDefault(): wrong syntax!");
                this.importLog.addError("Wrong syntax near " + string);
            }
        }
    }
}

