/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsSqlServer
extends DDLStatementHandlerSqlServer
implements SectionConstants {
    private static final String ZERO = "0";
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElementsSqlServer.class);

    public SHColumnElementsSqlServer(Design design) {
        super(design);
    }

    public void parseColumns(String string) {
        this.statement = string;
        this.mapElementsColumn = new HashMap();
        try {
            if (this.initColumnName()) {
                this.initDatatype();
                this.initCollate();
                this.initDefault();
                this.initIdentity();
                this.initRowguidcol();
                this.initNotNull();
                this.initPrimaryKeyOrUnique();
                this.initReferences();
                this.initConstraintCheck();
            } else {
                this.initAnyConstraint();
            }
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + this.statement + " for SQL Server failed!", exception);
        }
    }

    private void initRowguidcol() {
        boolean bl = Token.hasToken(this.statement, "ROWGUIDCOL");
        if (bl) {
            this.mapElementsColumn.put("ROWGUIDCOL", bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private void initIdentity() {
        String string;
        boolean bl = Token.hasToken(this.statement, "IDENTITY");
        if (bl && Token.hasCloseAndOpenBrackets(string = Token.getStringAfterToken(this.statement, "IDENTITY"))) {
            string = Token.getValBetweenBrackets(string);
            String string2 = Token.getValBeforeCharacter(string, ',').trim();
            String string3 = Token.getValAfterCharacter(string, ',').trim();
            this.mapElementsColumn.put("SEED", string2);
            this.mapElementsColumn.put("INCREMENT", string3);
            boolean bl2 = Token.hasString(this.statement, "NOT FOR REPLICATION");
            this.mapElementsColumn.put("NOT FOR REPLICATION", bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
        this.mapElementsColumn.put("IDENTITY", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private void initDefault() {
        if (Token.hasToken(this.statement, "DEFAULT")) {
            String string = Token.getStringAfter(this.statement, "DEFAULT");
            if (string.startsWith("'")) {
                string = Token.getFirstTextLiteral(string);
            } else {
                if (Token.hasToken(string, "PRIMARY")) {
                    string = Token.getStringBefore(string, "PRIMARY");
                }
                if (Token.hasToken(string, "UNIQUE")) {
                    string = Token.getStringBefore(string, "UNIQUE");
                }
                if (Token.hasToken(string, "FOREIGN")) {
                    string = Token.getStringBefore(string, "FOREIGN");
                }
                if (Token.hasToken(string, "REFERENCES")) {
                    string = Token.getStringBefore(string, "REFERENCES");
                }
                if (Token.hasToken(string, "COLLATE")) {
                    string = Token.getStringBefore(string, "COLLATE");
                }
                if (Token.hasToken(string, "ROWGUIDCOL")) {
                    string = Token.getStringBefore(string, "ROWGUIDCOL");
                }
                if (Token.hasToken(string, "NULL")) {
                    string = Token.getStringBefore(string, "NULL");
                }
                string = Token.hasToken(string, "NOT") ? Token.getStringBefore(string, "NOT") : Token.getFirstToken(string);
            }
            this.mapElementsColumn.put(NameElements.COL_DEFAULT, string);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String string = Token.getTokenAfter(this.statement, "COLLATE");
            this.mapElementsColumn.put("collate", string);
        }
    }

    private void initNotNull() {
        if (Token.hasString(this.statement, "NOT NULL")) {
            this.mapElementsColumn.put("nulls", Boolean.FALSE);
        } else if (Token.hasToken(this.statement, "NULL") && !Token.hasString(this.statement.toUpperCase(), "NOT NULL")) {
            this.mapElementsColumn.put("nulls", Boolean.TRUE);
        }
    }

    private boolean initColumnName() {
        String string = Token.getFirstName(this.statement, '[', ']');
        if (this.constraints.contains(string.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", string);
        this.statement = Token.getStringAfter(this.statement, string);
        if (this.statement.trim().startsWith("]")) {
            this.statement = this.statement.substring(1).trim();
        }
        return true;
    }

    protected String searchWhichDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2000");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.toUpperCase().startsWith(string2);
            if (!bl) continue;
            try {
                char c = string.charAt(string2.length());
                bl = c == '(' || c == ' ' || c == '\n' || c == '\t';
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = true;
            }
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    private void initDatatype() {
        String string = Token.getFirstToken(this.statement);
        if (!string.equalsIgnoreCase("AS")) {
            String string2;
            int n;
            if (this.statement.indexOf(32) > -1) {
                String string3 = this.statement.substring(this.statement.indexOf(32)).trim();
                if (string3.startsWith("(")) {
                    string = string + Token.getFirstToken(string3);
                } else {
                    string3 = this.statement.substring(string.length()).trim();
                    if (string3.startsWith("(")) {
                        string = string + Token.getFirstToken(string3);
                    }
                }
            }
            if (Token.hasOpenBracketNoClose(string)) {
                string = this.statement.substring(0, this.statement.indexOf(")") + 1);
            }
            if (Token.hasCloseAndOpenBrackets(string) && (n = string.indexOf(")")) > -1) {
                string = string.substring(0, n + 1);
            }
            if (Token.hasString(string, "[") && Token.hasString(string, "]")) {
                if (Token.hasCloseAndOpenBrackets(string)) {
                    String string4 = string.substring(0, string.indexOf("(")).trim();
                    string4 = this.getValBetween(string4);
                    string = string4 = string4.concat(string.substring(string.indexOf("(")));
                } else {
                    String string5;
                    string = string5 = this.getValBetween(string);
                }
            }
            if ((string2 = this.searchWhichDatatype(string)) == null) {
                string2 = this.searchNotStandartDatatypes(string);
                this.mapElementsColumn.put("typename", string);
            }
            if (string2 != null) {
                String string6 = StandardDatatypeNames.getUsedDatatypeName(string2);
                if (Token.hasCloseAndOpenBrackets(string6)) {
                    string = string6;
                    string2 = string6 = Token.getValBeforeBrackets(string6).trim();
                }
                if (string6 != null) {
                    boolean bl;
                    string = Token.cutTokenFromFront(string, string2);
                    this.mapElementsColumn.put("datatype", string6);
                    if (!string.equalsIgnoreCase("") && (bl = Token.hasCloseAndOpenBrackets(string))) {
                        String string7 = Token.getValBetweenBrackets(string, 1);
                        int n2 = string7.indexOf(",");
                        if (n2 != -1) {
                            this.mapElementsColumn.put("size", ZERO);
                            this.mapElementsColumn.put("precision", string7.substring(0, n2).trim());
                            this.mapElementsColumn.put("scale", string7.substring(n2 + 1).trim());
                        } else if (string6.equals("DECIMAL")) {
                            this.mapElementsColumn.put("size", ZERO);
                            this.mapElementsColumn.put("scale", ZERO);
                            this.mapElementsColumn.put("precision", string7.trim());
                        } else if (string6.equalsIgnoreCase("NUMERIC")) {
                            if (n2 != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", string7.substring(0, n2).trim());
                                this.mapElementsColumn.put("scale", string7.substring(n2 + 1).trim());
                            } else {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", string7.trim());
                                this.mapElementsColumn.put("scale", ZERO);
                            }
                        } else {
                            this.mapElementsColumn.put("scale", ZERO);
                            this.mapElementsColumn.put("precision", ZERO);
                            this.mapElementsColumn.put("size", string7.trim());
                        }
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    LOGGER.error("datatype is unknown in SHColumnElements.initDatatype: ");
                    this.importLog.addError("Unknown dataype " + string2);
                }
            }
        } else {
            this.mapElementsColumn.put("COMPUTED", Boolean.TRUE);
            String string8 = Token.cutTokenFromFront(this.statement, "AS");
            if (Token.hasToken(string8, "PERSISTED")) {
                this.mapElementsColumn.put("PERSISTED", Boolean.TRUE);
                string8 = Token.getStringBefore(string8, "PERSISTED");
            }
            this.mapElementsColumn.put("FORMULA", string8);
        }
    }

    private String searchNotStandartDatatypes(String string) {
        String[] stringArray = NotStandartDataTypeNames.getAllNewTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.equalsIgnoreCase(string2);
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    public String getValBetween(String string) {
        if (string != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    public Map getElementsColumn(String string) {
        this.parseColumns(string.replaceAll("\"", ""));
        return this.mapElementsColumn;
    }

    private void initConstraintCheck() {
        boolean bl;
        boolean bl2 = Token.hasToken(this.statement, "CONSTRAINT");
        if (bl2) {
            this.statement = Token.getStringAfter(this.statement, "CONSTRAINT");
            String string = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("CONSTRAINT", string);
            this.statement = Token.cutTokenFromFront(this.statement, string);
        }
        if (bl = Token.hasToken(this.statement, "CHECK")) {
            this.statement = Token.getStringAfter(this.statement, "CHECK");
            String string = this.statement;
            if (Token.hasOpenBracketNoClose(string)) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer(string);
                while (!Token.hasCloseBracket(Token.getFirstToken(this.statement)) && !(string2 = Token.getFirstToken(this.statement)).equals("")) {
                    stringBuffer.append(" ").append(string2);
                    this.statement = Token.cutTokenFromFront(this.statement, string2);
                }
                stringBuffer.append(" )");
                stringBuffer.append(" )");
                string = stringBuffer.toString();
                this.statement = Token.cutTokenFromFront(this.statement, ")");
            }
            string = Token.getValBetweenBrackets(string);
            this.mapElementsColumn.put("CHECK", string);
        }
    }

    private void initAnyConstraint() {
        String string = Token.getFirstToken(this.statement);
        if (string.equalsIgnoreCase("CONSTRAINT")) {
            String string2 = Token.getNameAfterToken(this.statement, "CONSTRAINT", '[', ']').trim();
            this.statement = Token.getStringAfter(this.statement, string2);
            if (this.statement.startsWith("]")) {
                this.statement = this.statement.substring(1).trim();
            }
            this.mapElementsColumn.put("CONSTRAINT_NAME", string2);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else if (string.equalsIgnoreCase("FOREIGN")) {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.mapElementsColumn.put("FOREIGN", Boolean.TRUE);
            if (Token.hasToken(this.statement, "DELETE")) {
                if (Token.hasToken(this.statement, "CASCADE")) {
                    this.mapElementsColumn.put("ON DELETE", "CASCADE");
                } else {
                    this.mapElementsColumn.put("ON DELETE", "NO ACTION");
                }
            }
            if (Token.hasToken(this.statement, "UPDATE")) {
                if (Token.hasToken(this.statement, "CASCADE")) {
                    this.mapElementsColumn.put("ON UPDATE", "CASCADE");
                } else {
                    this.mapElementsColumn.put("ON UPDATE", "NO ACTION");
                }
            }
            if (Token.hasString(this.statement, "NOT FOR REPLICATION")) {
                this.mapElementsColumn.put("NOT FOR REPLICATION", Boolean.TRUE);
            }
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean bl = Token.hasToken(this.statement, "PRIMARY");
        boolean bl2 = Token.hasToken(this.statement, "KEY");
        boolean bl3 = Token.hasToken(this.statement, "FOREIGN");
        if (bl && bl2) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.FALSE);
            if (Token.hasToken(this.statement, "CLUSTERED")) {
                this.mapElementsColumn.put("CLUSTERED", Boolean.TRUE);
            } else if (Token.hasToken(this.statement, "NONCLUSTERED")) {
                this.mapElementsColumn.put("NONCLUSTERED", Boolean.TRUE);
            }
            this.initIndexOption("FILLFACTOR");
            if (Token.hasToken(this.statement, "ON")) {
                String string = Token.getTokenAfter(this.statement, "ON");
                this.mapElementsColumn.put("FILEGROUP", string);
            }
        } else if (bl3 && bl2) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.FALSE);
            boolean bl4 = Token.hasToken(this.statement, "UNIQUE");
            if (bl4) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
                if (Token.hasToken(this.statement, "CLUSTERED")) {
                    this.mapElementsColumn.put("CLUSTERED", Boolean.TRUE);
                } else if (Token.hasToken(this.statement, "NONCLUSTERED")) {
                    this.mapElementsColumn.put("NONCLUSTERED", Boolean.TRUE);
                }
                this.initIndexOption("FILLFACTOR");
                if (Token.hasToken(this.statement, "ON")) {
                    String string = Token.getTokenAfter(this.statement, "ON");
                    this.mapElementsColumn.put("FILEGROUP", string);
                }
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initIndexOption(String string) {
        String string2 = Token.getStringAfter(this.statement, string);
        if (string2.startsWith("=")) {
            String string3 = Token.getFirstToken(string2.substring(1).trim());
            int n = string3.indexOf(44);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            this.mapElementsColumn.put(string, string3);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String string = Token.getValBetweenBrackets(this.statement, 1);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", string);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }

    private void initTableConstraints() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (bl) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initReferences() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "REFERENCES");
        if (bl) {
            boolean bl2;
            this.statement = Token.cutTokenFromFront(this.statement, "REFERENCES");
            String string = Token.getFirstToken(this.statement);
            this.mapElementsColumn.put("REFERENCES", string);
            this.statement = Token.cutTokenFromFront(this.statement, string);
            boolean bl3 = Token.hasString(this.statement, "(");
            if (bl3) {
                String string2 = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", string2);
            }
            if (bl2 = Token.isTokenEqualTo(this.statement, 1, "ON")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ON DELETE");
                String string3 = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("ON DELETE", string3);
                this.statement = Token.cutTokenFromFront(this.statement, string3);
            }
        }
    }
}

