/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FKProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableSqlServer
extends DDLStatementHandlerSqlServer
implements AlterTableHandler {
    private Index index = null;
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignSqlServerv2k storageDesign = null;
    private String name = "";
    private TableViewProxySqlServer viewProxy;
    private TableView view;
    private Design design;
    private List statemensList = new ArrayList();
    private static final Logger LOGGER = new Logger(SHAlterTableSqlServer.class);
    int count = 0;

    public SHAlterTableSqlServer(Design design) {
        super(design);
        this.design = design;
    }

    @Override
    public void handle(String string) {
        this.count = 0;
        String string22 = SHAlterTableSqlServer.clearCR(string);
        if (Token.startsWithString(string22, "alter table")) {
            this.index = null;
            this.name = "";
            this.initTable(string22);
            String[] stringArray = string22.split("ADD");
            if (stringArray.length == 1) {
                stringArray = string22.split("add");
            }
            for (String string22 : Arrays.asList(stringArray)) {
                try {
                    if (this.isPK(string22)) {
                        this.parsePK(string22);
                        continue;
                    }
                    if (this.isUK(string22)) {
                        this.parseUK(string22);
                        continue;
                    }
                    if (this.isFK(string22)) {
                        this.parseFK(string22);
                        continue;
                    }
                    this.processTableLevelConstraints(string22);
                }
                catch (Exception exception) {
                    this.importLog.addFailedStatement(SHAlterTableSqlServer.FormatCR(string, "\n"));
                }
            }
            this.importLog.incrementImportedStatements();
        } else {
            this.nextHandler(string);
        }
    }

    private void initTable(String string) {
        Object object;
        String string2 = Token.getTokenAfter(string, "TABLE", " ").trim();
        String string3 = string2.startsWith("[") ? Token.getNameAfterToken(string, "TABLE", '[', ']').trim() : (string2.startsWith("\"") ? Token.getNameAfterToken(string, "TABLE", '\"', '\"').trim() : string2);
        if (Token.hasString(string3, ".")) {
            object = new StringTokenizer(string3, ".");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
            }
        }
        object = this.getNameFor(string3);
        this.table = this.getTableFor((String)object);
    }

    private String getNameFor(String string) {
        StringTokenizer stringTokenizer;
        if (string.indexOf(46) > -1 && (stringTokenizer = new StringTokenizer(string, ".")).countTokens() > 0) {
            for (int i = 0; i < stringTokenizer.countTokens() - 1; ++i) {
                stringTokenizer.nextToken();
            }
            string = stringTokenizer.nextToken();
        }
        string = Token.getValBetweenSquareBrackets(string);
        string = Token.removeQuotes(string);
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private boolean isUK(String string) {
        return Token.hasToken(string, "UNIQUE");
    }

    private boolean isFK(String string) {
        return Token.hasToken(string, "FOREIGN");
    }

    private boolean isPK(String string) {
        return Token.hasToken(string, "PRIMARY");
    }

    private void parseUK(String string) {
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        try {
            this.initUKName();
            this.constructIndex();
            String string2 = Token.getStringAfter(string, "UNIQUE");
            if (string2.endsWith(",")) {
                string2 = Token.getStringBefore(string2, ",");
            }
            this.setColumnForIndex(string2);
            if (this.table != null) {
                UniqueProxySqlServer uniqueProxySqlServer;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                this.index.setUnique(true);
                if (this.storageDesign != null && (uniqueProxySqlServer = (UniqueProxySqlServer)this.storageDesign.getUniqueProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClusteredUK(uniqueProxySqlServer);
                    this.initFillFactorUK(uniqueProxySqlServer);
                    this.initFileGroupUK(uniqueProxySqlServer);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.importLog.addError("Error parsing unique key statement " + string);
            LOGGER.error("", objectDoesNotExistException);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServer uniqueProxySqlServer) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            uniqueProxySqlServer.setFilegroup((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServer uniqueProxySqlServer) {
        if (Token.hasToken(this.statement, "FILLFACTOR")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(Token.getStringAfter(this.statement, "FILLFACTOR").trim(), "=").trim());
                uniqueProxySqlServer.setFillFactor(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format:", numberFormatException);
                this.importLog.addWarning("Unknown fill factor for unique key " + uniqueProxySqlServer.getName());
            }
        }
    }

    private void initClusteredUK(UniqueProxySqlServer uniqueProxySqlServer) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            uniqueProxySqlServer.setClustered(true);
        } else {
            uniqueProxySqlServer.setClustered(false);
        }
    }

    public void parsePK(String string) {
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        try {
            this.initPKName();
            this.constructIndex();
            String string2 = Token.getStringAfter(string, "PRIMARY KEY");
            if (string2.endsWith(",")) {
                string2 = Token.getStringBefore(string2, ",");
            }
            this.setColumnForIndex(string2);
            if (this.table != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.storageDesign != null) {
                    this.index.makePK();
                    PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)this.storageDesign.getPKProxySet().getProxy(this.index.getObjectID());
                    if (pKProxySqlServer != null) {
                        this.initClusteredPK(pKProxySqlServer);
                        this.initFillFactorPK(pKProxySqlServer);
                        this.initFileGroupPK(pKProxySqlServer);
                    }
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Error parsing primary key statement " + string);
        }
    }

    private void initFileGroupPK(PKProxySqlServer pKProxySqlServer) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            pKProxySqlServer.setFilegroup((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorPK(PKProxySqlServer pKProxySqlServer) {
        if (Token.hasToken(this.statement, "FILLFACTOR")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(Token.getStringAfter(this.statement, "FILLFACTOR").trim(), "=").trim());
                pKProxySqlServer.setFillFactor(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format: ", numberFormatException);
                this.importLog.addWarning("Unknown fill factor for primary key " + pKProxySqlServer.getName());
            }
        }
    }

    private void initClusteredPK(PKProxySqlServer pKProxySqlServer) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            pKProxySqlServer.setClustered(true);
        } else {
            pKProxySqlServer.setClustered(false);
        }
    }

    private void initOnDeleteFK(FKProxySqlServerv2k fKProxySqlServerv2k, String string) {
        if (Token.hasString(string, "ON DELETE")) {
            String string2 = Token.getTokenAfter(string, "DELETE");
            if (string2.endsWith(",")) {
                string2 = Token.getStringBefore(string2, ",");
            }
            FKIndexAssociation fKIndexAssociation = ((Index)fKProxySqlServerv2k.getObject()).getFKAssociation();
            fKIndexAssociation.setDeleteRule(string2);
        }
    }

    private void initOnUpdateFK(FKProxySqlServerv2k fKProxySqlServerv2k, String string) {
        if (Token.hasString(string, "ON UPDATE")) {
            String string2 = Token.getTokenAfter(string, "UPDATE");
            if (string2.endsWith(",")) {
                string2 = Token.getStringBefore(string2, ",");
            }
            fKProxySqlServerv2k.setOnUpdate(string2);
        }
    }

    private void initReplicationFK(FKProxySqlServerv2k fKProxySqlServerv2k, String string) {
        if (!Token.hasString(string, "NOT FOR REPLICATION")) {
            fKProxySqlServerv2k.setForReplication("YES");
        } else {
            fKProxySqlServerv2k.setForReplication("NO");
        }
    }

    private void initPKName() {
        Object object;
        if (Token.hasToken(this.statement, "PRIMARY")) {
            this.name = Token.getTokenBefore(this.statement, "PRIMARY");
            if (this.name.equalsIgnoreCase(",") || this.name.equalsIgnoreCase("ADD")) {
                this.name = "";
            } else {
                if (Token.hasString(this.name, ".")) {
                    object = new StringTokenizer(this.name, ".");
                    this.name = ((StringTokenizer)object).nextToken().trim();
                    this.name = ((StringTokenizer)object).nextToken().trim();
                }
                this.name = Token.getValBetweenSquareBrackets(this.name);
                this.name = Token.getNamesOnly(this.name);
            }
        }
        if (this.name.equalsIgnoreCase("")) {
            object = this.table.getName();
            if (((String)object).length() > 125) {
                object = ((String)object).substring(0, 125);
            }
            this.name = (String)object + "_PK";
        }
    }

    private void initUKName() {
        Object object;
        if (Token.hasToken(this.statement, "UNIQUE")) {
            this.name = Token.getTokenBefore(this.statement, "UNIQUE");
            if (this.name.equalsIgnoreCase(",") || this.name.equalsIgnoreCase("ADD")) {
                this.name = "";
            } else {
                if (Token.hasString(this.name, ".")) {
                    object = new StringTokenizer(this.name, ".");
                    this.name = ((StringTokenizer)object).nextToken().trim();
                    this.name = ((StringTokenizer)object).nextToken().trim();
                }
                this.name = Token.getValBetweenSquareBrackets(this.name);
                this.name = Token.getNamesOnly(this.name);
            }
        }
        if (this.name.equalsIgnoreCase("")) {
            object = this.table.getName();
            if (((String)object).length() > 123) {
                object = ((String)object).substring(0, 123);
            }
            this.name = (String)object + "_UK" + this.table.getUKeys().size();
        }
    }

    private void setColumnForIndex(String string) throws ObjectDoesNotExistException {
        block10: {
            Map map;
            block9: {
                map = null;
                if (this.table == null) break block9;
                map = this.getColumnsForTable();
                if (map.size() <= 0) break block10;
                String string2 = Token.getValBetweenBrackets(string, 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    Column column;
                    int n;
                    String string3 = stringTokenizer.nextToken().trim();
                    if (Token.hasString(string3 = Token.getNamesOnly(string3), "[") && Token.hasString(string3, "]")) {
                        string3 = this.getValBetween(string3);
                    }
                    if ((n = string3.indexOf(" ")) > 0) {
                        string3 = string3.substring(0, n);
                    }
                    if ((column = (Column)map.get(string3)) != null) {
                        try {
                            this.index.add(column);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Exception occured while adding column to index!" + string);
                            this.importLog.addError("Exception occured while adding column  " + string3 + " to index");
                        }
                        continue;
                    }
                    this.importLog.addError("Column " + string3 + " does not exist");
                    throw new ObjectDoesNotExistException("Column");
                }
                break block10;
            }
            if (this.viewProxy != null && (map = this.getColumnsForView()).size() > 0) {
                String string4 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    Column column;
                    String string5 = stringTokenizer.nextToken().trim();
                    int n = string5.indexOf(" ");
                    if (n > 0) {
                        string5 = string5.substring(0, n);
                    }
                    if ((column = (Column)map.get(string5)) != null) continue;
                    this.importLog.addError("View Column " + string5 + " does not exist");
                    throw new ObjectDoesNotExistException("Column");
                }
            }
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columnArray = (Column[])this.table.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private Map getColumnsForView() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.viewProxy != null) {
            Column[] columnArray = (Column[])this.view.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private void constructIndex() {
        if (this.table != null) {
            Index[] indexArray = (Index[])this.table.getKeys();
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getName().equalsIgnoreCase(this.name)) continue;
                this.index = index;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.name)) {
                this.index = this.table.createIndex();
                if (!"".equalsIgnoreCase(this.name)) {
                    this.index.setName(this.name);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        }
    }

    public String getValBetween(String string) {
        if ((string = string.trim()) != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    private void initForeignKey(String string) {
        block11: {
            Table table;
            ArrayList<Column> arrayList;
            block12: {
                String string2;
                int n = string.indexOf(41);
                String string3 = string.substring(0, n + 1).trim();
                String string4 = Token.getValBetweenBrackets(string3);
                List list = this.getColumnNames(string4);
                arrayList = new ArrayList<Column>();
                Column[] columnArray = (Column[])this.table.getElements();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string5 = Token.getValBetweenSquareBrackets(((String)iterator.next()).trim());
                    string5 = Token.removeQuotes(string5);
                    for (int i = 0; i < columnArray.length; ++i) {
                        string2 = columnArray[i].getName().trim();
                        if (!string5.equalsIgnoreCase(string2)) continue;
                        arrayList.add(columnArray[i]);
                    }
                }
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string6 = Token.getNameAfterToken(string, "REFERENCES", '[', ']');
                string2 = this.getNameFor(string6);
                int n3 = (string2 = Token.removeQuotes(string2)).indexOf(40);
                if (n3 > -1) {
                    string2 = string2.substring(0, n3);
                }
                if ((table = this.getTableFor(string2)) == null) break block11;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block12;
                String string7 = Token.getValBetweenBrackets(string, 1);
                List list2 = this.getColumnNames(string7);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getDesign().getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table, list2);
                if (index == null) break block11;
                FKIndexAssociation fKIndexAssociation = this.table.addFK(index, null, fKIndexAssociationReference);
                fKIndexAssociation.setName(this.name);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().setName(this.name);
                if (this.design.getDesign().isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (!bl2) break block11;
                String string8 = Token.getTokenAfter(string, "DELETE").trim();
                String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string8.equalsIgnoreCase(stringArray[i])) continue;
                    fKIndexAssociation.setDeleteRule(stringArray[i]);
                    break block11;
                }
                break block11;
            }
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getDesign().getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)table.getPK();
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = this.table.addFK(index, null, fKIndexAssociationReference);
                fKIndexAssociation.setName(this.name);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().setName(this.name);
                if (this.design.getDesign().isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string9 = Token.getTokenAfter(string, "DELETE").trim();
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string9.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private void parseFK(String string) {
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        if (this.table != null) {
            this.site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
            boolean bl = false;
            String string2 = string;
            bl = Token.hasToken(string2, "FOREIGN");
            while (bl) {
                Object object;
                int n = string2.toUpperCase().indexOf("FOREIGN");
                String string3 = string2.substring(n);
                String string4 = "FK_ASS";
                if (Token.hasToken(string2, "FOREIGN")) {
                    string4 = Token.getTokenBefore(string2, "FOREIGN");
                    if (this.name.equalsIgnoreCase(",") || this.name.equalsIgnoreCase("ADD")) {
                        this.name = "";
                    }
                }
                if (this.name.equalsIgnoreCase("")) {
                    object = this.table.getName();
                    if (((String)object).length() > 123) {
                        object = ((String)object).substring(0, 123);
                    }
                    string4 = (String)object + "_FK" + this.table.getFKAssociationsCount();
                }
                this.name = Token.getValBetweenSquareBrackets(string4.trim());
                this.initForeignKey(string3);
                string3 = string3.substring(12);
                if (this.storageDesign != null && (object = (FKProxySqlServerv2k)this.storageDesign.getFKProxySet().getByName(this.name)) != null) {
                    this.initOnDeleteFK((FKProxySqlServerv2k)object, string3);
                    this.initOnUpdateFK((FKProxySqlServerv2k)object, string3);
                    this.initReplicationFK((FKProxySqlServerv2k)object, string3);
                }
                string2 = string3;
                bl = Token.hasToken(string2, "FOREIGN");
            }
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = Token.getValBetweenSquareBrackets(stringTokenizer.nextToken().trim());
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            System.out.println("Foreign key columns don't match Primary key columns\ntab_ch " + index2.getContainerWithKeyObject().getName() + " index " + index2.getName() + "  parent_tab " + index.getContainerWithKeyObject().getName());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            LOGGER.error("Foreign key columns don't match Primary key columns\ntab_ch " + index2.getContainerWithKeyObject().getName() + " index " + index2.getName() + "  parent_tab " + index.getContainerWithKeyObject().getName());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String string : this.statemensList) {
            this.parseFK(string);
        }
    }

    private void processTableLevelConstraints(String string) {
        this.statement = string;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String string2 = string.toUpperCase();
        String string3 = string;
        int n = string2.indexOf("WITH");
        if (n > -1 && string2.indexOf("ADD", n) > -1) {
            int n2 = string2.indexOf("ADD", n);
            string3 = string.substring(n2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            StringBuffer stringBuffer = new StringBuffer(string4);
            while (Token.tokenNumber(string4, "(") > Token.tokenNumber(string4, ")") && stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                string4 = stringBuffer.toString().trim();
            }
            if (Token.hasToken(string4, "PRIMARY") || Token.hasToken(string4, "UNIQUE") || Token.hasToken(string4, "FOREIGN")) continue;
            ++this.count;
            if (Token.hasToken(string4, "check")) {
                this.processCheck(string4);
                continue;
            }
            this.processColumnConstraint(string4);
        }
    }

    private void processCheck(String string) {
        int n = string.toUpperCase().indexOf("REPLICATION");
        String string2 = Token.getTokenBefore(string, "CHECK");
        if (string2.equalsIgnoreCase(",") || string2.equalsIgnoreCase("ADD")) {
            string2 = "";
        }
        String string3 = "";
        string3 = n > -1 ? Token.getStringAfter(string, "REPLICATION").trim() : Token.getStringAfter(string, "CHECK").trim();
        if (string3.indexOf(40) > -1) {
            string3 = Token.getValBetweenBrackets(string3);
        }
        TableLevelConstraint tableLevelConstraint = null;
        if (!"".equalsIgnoreCase(string2)) {
            tableLevelConstraint = this.table.createCheckConstraint(string2, string3);
            this.design.getRelationalDesign().stampModelObjectDDL(tableLevelConstraint);
        } else {
            String string4 = this.table.getName();
            if (string4.length() > 123) {
                string4 = string4.substring(0, 123);
            }
            tableLevelConstraint = this.table.createCheckConstraint(string4 + "_CK" + this.table.getCheckConstraints().size(), string3);
            this.design.getRelationalDesign().stampModelObjectDDL(tableLevelConstraint);
        }
        this.table.addCheckConstraint(tableLevelConstraint);
    }

    private void processColumnConstraint(String string) {
        String string2 = Token.getStringAfter(string, "DEFAULT");
        if (!string2.equalsIgnoreCase("")) {
            Column column;
            String string3;
            String string4 = "";
            if (string2.startsWith("'")) {
                string4 = Token.getFirstTextLiteral(string2);
            } else if (string2.startsWith("(")) {
                string4 = "(" + Token.getValBetweenBrackets(string2, 1) + ")";
            } else {
                string4 = string2.startsWith("[") ? "[" + Token.getFirstName(string2, '[', ']') + "]" : (string2.startsWith("\"") ? "\"" + Token.getFirstName(string2, '\"', '\"') + "\"" : Token.getFirstToken(string2));
                string3 = Token.getStringAfter(string2, string4);
                if (string3.startsWith("(")) {
                    string4 = string4 + "(" + Token.getValBetweenBrackets(string3, 1) + ")";
                }
            }
            string3 = Token.getStringAfter(string, "FOR");
            if (!string3.equalsIgnoreCase("") && (column = (Column)this.table.getElementByName(string3 = string3.startsWith("[") ? Token.getValBetweenSquareBrackets(string3) : (string3.startsWith("\"") ? Token.getValBetweenDoubleQuotes(string3) : Token.getFirstToken(string3)))) != null) {
                column.setUsesDefaultValue(true);
                column.setDefaultValue(string4);
            }
        }
    }
}

