/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAddDataTypeSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String SP_ADDTYPE = "sp_addtype";
    private static final String TYPENAME = "@typename";
    private static final String PHYSTYPE = "@phystype";
    private static final String NULLTYPE = "@nulltype";
    private static final String OWNER = "@owner";
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHAddDataTypeSqlServer.class);
    private UserDefinedTypeSqlServer type;
    private LogicalDatatypeFactory factoryLogical;
    private String name = "";
    private String systype = "";
    private String nulltype = "";
    private String owner = "";

    public SHAddDataTypeSqlServer(Design design, LogicalDatatypeFactory logicalDatatypeFactory) {
        super(design);
        this.factoryLogical = logicalDatatypeFactory;
    }

    public SHAddDataTypeSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAddDataTypeSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "exec sp_addtype ")) {
            try {
                this.addDataType(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHAddDataTypeSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void addDataType(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServer != null) {
            this.type = storageDesignSqlServer.getUserDefinedTypeSet().createType();
            if (this.type != null) {
                Object object;
                Object object2;
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String string2 = Token.getStringAfter(string, SP_ADDTYPE).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                ArrayList<String> arrayList = new ArrayList<String>(4);
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken().trim();
                    object = new StringBuffer((String)object2);
                    while (Token.tokenNumber((String)object2, "(") > Token.tokenNumber((String)object2, ")") && stringTokenizer.hasMoreTokens()) {
                        ((StringBuffer)object).append(",").append(stringTokenizer.nextToken().trim());
                        object2 = ((StringBuffer)object).toString().trim();
                    }
                    arrayList.add((String)object2);
                }
                if (arrayList.size() == 2) {
                    this.name = ((String)arrayList.get(0)).trim();
                    this.systype = ((String)arrayList.get(1)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.type.setName(this.name);
                    object2 = storageDesignSqlServer.getDesign().getDomainSet().iterator();
                    object = null;
                    while (object2.hasNext() && !((Domain)(object = (Domain)object2.next())).getDataType().toString().equalsIgnoreCase(this.systype)) {
                    }
                    if (object != null) {
                        this.type.setDomain(((DesignObject)object).getName());
                    } else {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                } else if (arrayList.size() == 3) {
                    this.name = ((String)arrayList.get(0)).trim();
                    this.systype = ((String)arrayList.get(1)).trim();
                    this.nulltype = ((String)arrayList.get(2)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.nulltype = this.formatValue(this.nulltype, NULLTYPE);
                    this.type.setName(this.name);
                    object2 = storageDesignSqlServer.getDesign().getDomainSet().iterator();
                    object = null;
                    while (object2.hasNext()) {
                        Domain domain = (Domain)object2.next();
                        if (!domain.getName().equalsIgnoreCase(this.name) || !this.compareDataTypes(domain, this.systype)) continue;
                        object = domain;
                        break;
                    }
                    if (object != null) {
                        this.type.setDomain(((DesignObject)object).getName());
                    } else if (this.factoryLogical != null) {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    } else {
                        LOGGER.error("Could not create new domain " + this.name + "! Domain with this name already exists!");
                        this.importLog.addError("Could not create new domain " + this.name + ". Domain with this name already exists");
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                    this.type.setNullType(this.nulltype);
                } else if (arrayList.size() == 4) {
                    this.name = ((String)arrayList.get(0)).trim();
                    this.systype = ((String)arrayList.get(1)).trim();
                    this.nulltype = ((String)arrayList.get(2)).trim();
                    this.owner = ((String)arrayList.get(3)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.nulltype = this.formatValue(this.nulltype, NULLTYPE);
                    this.owner = this.formatValue(this.owner, OWNER);
                    this.type.setName(this.name);
                    object2 = storageDesignSqlServer.getDesign().getDomainSet().iterator();
                    object = null;
                    while (object2.hasNext()) {
                        Domain domain = (Domain)object2.next();
                        if (!domain.getDataType().toString().equalsIgnoreCase(this.systype)) continue;
                        object = domain;
                        break;
                    }
                    if (object != null) {
                        this.type.setDomain(((DesignObject)object).getName());
                    } else {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                    this.type.setNullType(this.nulltype);
                    this.type.setOwner((UserSqlServer)storageDesignSqlServer.getUserSet().getByName(this.owner));
                } else {
                    LOGGER.error("Wrong syntax occured near " + string);
                    this.importLog.addError("Wrong syntax occured near " + string);
                }
            }
        }
    }

    private void createOneDomain(String string, String string2) {
        String string3 = string2;
        int n = string3.indexOf(40);
        if (n > -1) {
            string3 = string3.substring(0, n).trim();
        }
        if (this.checkBuildinDatatype(string3)) {
            Map map = this.parseBuildinDatatype(string2);
            String string4 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("scale"), (String)map.get("precision"), (String)map.get("size")};
            if (string4 != null) {
                String string5 = StandardDatatypeNames.getUsedDatatypeName(string4);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string5);
                DomainSet domainSet = this.design.getDesign().getDomainSet();
                Domain domain = domainSet.createDomain();
                domain.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(domain);
                if (logicalDatatype != null) {
                    domain.setLogicalDatatype(logicalDatatype);
                } else {
                    LogicalDatatype logicalDatatype2 = this.design.getDesign().getLogicalDatatypeSet().createLogicalDatatype(null);
                    this.design.getRelationalDesign().stampModelObjectDDL(logicalDatatype2);
                    domain.setLogicalDatatype(logicalDatatype2);
                }
                domain.setFileName(this.design.getDesign().getFileName());
                domain.setDataTypeParameter("size", stringArray[2]);
                domain.setDataTypeParameter("scale", stringArray[1]);
                domain.setDataTypeParameter("precision", stringArray[0]);
            }
        }
    }

    private boolean checkBuildinDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2000");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String string) {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string;
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
        }
        if ((string2 = StandardDatatypeNames.getUsedDatatypeName(string3)) != null) {
            String string4 = Token.cutTokenFromFront(string, string3);
            hashMap.put("datatype", string2);
            if (!string4.equalsIgnoreCase("")) {
                boolean bl = Token.hasCloseAndOpenBrackets(string4);
                if (bl) {
                    bl = Token.getValBeforeBrackets(string4).trim().equalsIgnoreCase("");
                }
                if (bl) {
                    String string5 = Token.getValBetweenBrackets(string4, 1);
                    int n2 = string5.indexOf(",");
                    if (n2 != -1) {
                        hashMap.put("size", ZERO);
                        hashMap.put("precision", string5.substring(0, n2).trim());
                        hashMap.put("scale", string5.substring(n2 + 1).trim());
                    } else if (string2.equals("DECIMAL")) {
                        hashMap.put("size", ZERO);
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", string5.trim());
                    } else if (string2.equalsIgnoreCase("NUMERIC")) {
                        if (n2 != -1) {
                            hashMap.put("size", ZERO);
                            hashMap.put("precision", string5.substring(0, n2).trim());
                            hashMap.put("scale", string5.substring(n2 + 1).trim());
                        } else {
                            hashMap.put("size", ZERO);
                            hashMap.put("precision", string5.trim());
                            hashMap.put("scale", ZERO);
                        }
                    } else {
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", ZERO);
                        hashMap.put("size", string5.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + string + " is unknown!");
            this.importLog.addError("Datatype " + string + " is unknown");
        }
        return hashMap;
    }

    private String formatValue(String string, String string2) {
        if (string.startsWith(string2)) {
            string = Token.getStringAfter(string, "=").trim();
        }
        if (string.toUpperCase().startsWith("N'")) {
            string = string.substring(1);
        }
        if (string.startsWith("'")) {
            string = Token.getValBetweenQuotationMarks(string);
        }
        string = this.getValBetweenQuotationMarks2(string);
        string = Token.getValBetweenSquareBrackets(string);
        return string;
    }

    private String getValBetweenQuotationMarks2(String string) {
        if (string != null && string.indexOf(34) == 0 && string.indexOf(34, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean compareDataTypes(Domain domain, String string) {
        String string2;
        if (string.equalsIgnoreCase("INT")) {
            string = "INTEGER";
        }
        if (Token.hasCloseAndOpenBrackets(string2 = domain.getDataType().toString()) && Token.hasCloseAndOpenBrackets(string)) {
            String string3 = string2.substring(string2.indexOf(40)).trim();
            String string4 = string2.substring(0, string2.indexOf(40)).trim();
            String string5 = string2.substring(string.indexOf(40)).trim();
            String string6 = string2.substring(0, string.indexOf(40)).trim();
            return string3.equalsIgnoreCase(string5) && string4.equalsIgnoreCase(string6);
        }
        return string2.equalsIgnoreCase(string);
    }
}

