/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsOraclev9i
extends DDLStatementHandler {
    private PermissionsOraclev9i permissions;
    private StorageDesignOraclev9i storageDesign;
    private TableProxyOraclev9i table = null;
    private TableViewProxyOraclev9i view = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsOraclev9i.class);

    public SHGrantPermissionsOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHGrantPermissionsOraclev9i.clearCR(string);
        if (string2.toUpperCase().startsWith("GRANT") && Token.hasToken(string2, "TO")) {
            try {
                this.statement = string2.replaceAll("\"", "");
                this.grantPermissions();
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHGrantPermissionsOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void grantPermissions() throws ObjectDoesNotExistException {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            ArrayList arrayList = this.initUsersOrRoles();
            Object object = this.initOn();
            if (object != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)arrayList.get(i), object);
                    if (this.permissions == null) {
                        this.permissions = (PermissionsOraclev9i)this.storageDesign.getPermissionsSet().createPermissions();
                    }
                    if (this.permissions == null) continue;
                    this.initPrivileges(null);
                    this.initOnObject(object);
                    this.initTo(arrayList.get(i));
                    this.initHierarchyOption();
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.initPrivileges(arrayList.get(i));
                }
            }
        }
        this.permissions = null;
        this.table = null;
        this.view = null;
    }

    private void initOnObject(Object object) {
        if (object instanceof TableProxyOracle) {
            this.permissions.setTable((TableProxyOracle)object);
        } else if (object instanceof TableViewProxyOracle) {
            this.permissions.setView((TableViewProxyOracle)object);
        } else if (object instanceof SnapshotOracle) {
            this.permissions.setSnapshot((SnapshotOracle)object);
        } else if (object instanceof SequenceOracle) {
            this.permissions.setSequence((SequenceOracle)object);
        } else if (object instanceof StoredProcedureOracle) {
            this.permissions.setProc((StoredProcedureOracle)object);
        } else if (object instanceof FunctionOracle) {
            this.permissions.setFunctionOracle((FunctionOracle)object);
        } else if (object instanceof PackageOracle) {
            this.permissions.setPackage((PackageOracle)object);
        } else if (object instanceof DirectoryOracle) {
            this.permissions.setDirectoryOracle((DirectoryOracle)object);
        } else if (object instanceof StructuredTypeProxyOracle) {
            this.permissions.setStructuredTypeOracle((StructuredTypeProxyOracle)object);
        } else if (object instanceof CollectionTypeProxyOracle) {
            this.permissions.setCollectionTypeOracle((CollectionTypeProxyOracle)object);
        } else if (object instanceof ExternalTableOracle) {
            this.permissions.setExternalTableOracle((ExternalTableOracle)object);
        } else if (object instanceof ColumnProxyOracle) {
            this.permissions.setColumnsTable(((ColumnProxyOracle)object).getTableProxy());
        }
    }

    private PermissionsOraclev9i getPermissionForUser(StorageObject storageObject, Object object) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        ColumnProxyOracle columnProxyOracle = null;
        if (object instanceof ColumnProxyOracle) {
            columnProxyOracle = (ColumnProxyOracle)object;
        }
        PermissionsOraclev9i permissionsOraclev9i = null;
        while (iterator.hasNext()) {
            permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getUser() != storageObject && permissionsOraclev9i.getRole() != storageObject || permissionsOraclev9i.getTable() != object && permissionsOraclev9i.getView() != object && permissionsOraclev9i.getSnapshot() != object && permissionsOraclev9i.getSequence() != object && permissionsOraclev9i.getProc() != object && permissionsOraclev9i.getFunctionOracle() != object && permissionsOraclev9i.getPackage() != object && permissionsOraclev9i.getDirectoryOracle() != object && permissionsOraclev9i.getStructuredTypeOracle() != object && permissionsOraclev9i.getCollectionTypeOracle() != object && permissionsOraclev9i.getExternalTableOracle() != object && (columnProxyOracle == null || permissionsOraclev9i.getColumnsTable() == null || !permissionsOraclev9i.getColumnsTable().getObjectID().equals(columnProxyOracle.getTableProxy().getObjectID()) || !permissionsOraclev9i.getColumns().contains(columnProxyOracle.getName()) && !permissionsOraclev9i.getColumnsWithGrantOption().contains(columnProxyOracle.getName()))) continue;
            return permissionsOraclev9i;
        }
        return null;
    }

    private Object initOn() throws ObjectDoesNotExistException {
        String string = Token.getStringAfterToken(this.statement, "ON");
        if (string.toUpperCase().startsWith("COMMIT REFRESH")) {
            string = Token.getStringAfterToken(string, "ON");
        }
        if (string.toUpperCase().startsWith("DIRECTORY ")) {
            String string2 = Token.getQuotedNameAfterToken(string, "DIRECTORY");
            DirectoryOracle directoryOracle = (DirectoryOracle)this.storageDesign.getDirectorySet().getByName(string2);
            if (directoryOracle != null) {
                return directoryOracle;
            }
            throw new ObjectDoesNotExistException(string2);
        }
        if (!(string = Token.getFirstName(string, '\"', '\"')).equalsIgnoreCase("")) {
            RelationalDesign relationalDesign = this.storageDesign.getPhysicalDesign();
            Table table = (Table)relationalDesign.getTableSet().getByName(string);
            if (table != null) {
                this.table = (TableProxyOraclev9i)this.storageDesign.getProxy(table);
                if (this.table != null) {
                    String string3 = Token.getValBetweenBrackets(Token.getStringBefore(this.statement, "ON"));
                    if (!string3.equals("")) {
                        return this.table.getColumnProxyByName(string3);
                    }
                    if (this.table.getSnapshot() != null) {
                        return this.table.getSnapshot();
                    }
                    return this.table;
                }
            } else {
                SequenceOracle sequenceOracle;
                TableView tableView = (TableView)relationalDesign.getTableViewSet().getByName(string);
                if (tableView != null) {
                    this.view = (TableViewProxyOraclev9i)this.storageDesign.getProxy(tableView);
                    return this.view;
                }
                String string4 = "";
                String string5 = string;
                int n = string.indexOf(46);
                if (n > -1) {
                    string4 = string.substring(0, n);
                    string5 = string.substring(n + 1);
                }
                if ((sequenceOracle = string4.equals("") ? (SequenceOracle)this.storageDesign.getSequenceSet().getByName(string5) : (SequenceOracle)this.storageDesign.getSequenceSet().getByUserSchemaAndName(string4, string5)) != null) {
                    return sequenceOracle;
                }
                StoredProcedureOracle storedProcedureOracle = string4.equals("") ? (StoredProcedureOracle)this.storageDesign.getStoredProcedureSet().getByName(string5) : this.storageDesign.getStoredProcedureSet().getByOwnerAndName(string4, string5);
                if (storedProcedureOracle != null) {
                    return storedProcedureOracle;
                }
                FunctionOracle functionOracle = string4.equals("") ? (FunctionOracle)this.storageDesign.getFunctionSet().getByName(string5) : this.storageDesign.getFunctionSet().getByOwnerAndName(string4, string5);
                if (functionOracle != null) {
                    return functionOracle;
                }
                PackageOracle packageOracle = string4.equals("") ? (PackageOracle)this.storageDesign.getPackageSet().getByName(string5) : this.storageDesign.getPackageSet().getByOwnerAndName(string4, string5);
                if (packageOracle != null) {
                    return packageOracle;
                }
                ExternalTableOracle externalTableOracle = string4.equals("") ? (ExternalTableOracle)this.storageDesign.getExternalTableSet().getByName(string5) : this.storageDesign.getExternalTableSet().getByOwnerAndName(string4, string5);
                if (externalTableOracle != null) {
                    return externalTableOracle;
                }
                CollectionTypeProxy collectionTypeProxy = string4.equals("") ? this.storageDesign.getCollectionTypeProxySet().getByName(string5) : this.storageDesign.getCollectionTypeProxySet().getByOwnerAndName(string4, string5);
                if (collectionTypeProxy != null) {
                    return collectionTypeProxy;
                }
                StructuredTypeProxy structuredTypeProxy = string4.equals("") ? this.storageDesign.getStructuredTypeProxySet().getByName(string5) : this.storageDesign.getStructuredTypeProxySet().getBySchemaAndName(string4, string5);
                if (structuredTypeProxy != null) {
                    return structuredTypeProxy;
                }
            }
        }
        return null;
    }

    private void initTo(Object object) {
        String string = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            if (object instanceof UserOracle) {
                this.permissions.setUser((UserOracle)object);
            } else if (object instanceof RoleOracle) {
                this.permissions.setRole((RoleOracle)object);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initTo(): wrong syntax!");
            this.importLog.addError("Wrong syntax near TO in statement " + this.statement);
        }
    }

    private ArrayList initUsersOrRoles() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        String string = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            UserSetOracle userSetOracle = this.storageDesign.getUserSet();
            RoleSetOracle roleSetOracle = this.storageDesign.getRoleSet();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                ModelObject modelObject = userSetOracle.getByName(string2 = Token.getValBetweenSquareBrackets(string2));
                if (modelObject != null) {
                    arrayList.add(modelObject);
                    continue;
                }
                ModelObject modelObject2 = roleSetOracle.getByName(string2);
                if (modelObject2 != null) {
                    arrayList.add(modelObject2);
                    continue;
                }
                modelObject = userSetOracle.createUser();
                modelObject.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(modelObject);
                arrayList.add(modelObject);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initUsersOrRoles(): wrong syntax!");
            this.importLog.addError("Wrong syntax near INIT USER in statement " + this.statement);
        }
        return arrayList;
    }

    private void initPrivileges(Object object) {
        Object object2;
        boolean bl;
        String string = Token.getStringAfterToken(this.statement, "GRANT");
        boolean bl2 = bl = this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1;
        if (object != null) {
            string = Token.getStringBeforeToken(string, "TO");
        } else {
            int n;
            object2 = string.toUpperCase();
            int n2 = ((String)object2).indexOf(" ON ", (n = ((String)object2).indexOf("ON COMMIT REFRESH")) + 1);
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            if (Token.hasCloseAndOpenBrackets(string)) {
                String string2 = Token.getValBetweenBrackets(string).trim();
                string = Token.getStringBefore(string, "(");
                this.initColumns(string2, string, bl);
            }
        }
        string = string.trim().toUpperCase();
        object2 = new StringTokenizer(string, ",");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            String string3 = ((StringTokenizer)object2).nextToken().trim();
            if (object != null) {
                this.addPrivileges(object, string3);
                continue;
            }
            if (bl) {
                this.permissions.setPrivilegesWithGrantOption(string3);
                continue;
            }
            this.permissions.setPrivileges(string3);
        }
    }

    private void addPrivileges(Object object, String string) {
        boolean bl = this.statement.toUpperCase().indexOf("WITH ADMIN OPTION") > -1;
        RoleOracle roleOracle = (RoleOracle)this.storageDesign.getRoleSet().getByName(string);
        if (object instanceof UserOracle) {
            if (roleOracle != null) {
                if (bl) {
                    ((UserOracle)object).setRolesWithAdminOption(string);
                } else {
                    ((UserOracle)object).setRoles(string);
                }
            } else if (bl) {
                ((UserOracle)object).setPrivilegesWithAdminOption(string);
            } else {
                ((UserOracle)object).setPrivileges(string);
            }
        } else if (object instanceof RoleOracle) {
            if (roleOracle != null) {
                if (bl) {
                    ((RoleOracle)object).setRolesWithAdminOption(string);
                } else {
                    ((RoleOracle)object).setRoles(string);
                }
            } else if (bl) {
                ((RoleOracle)object).setPrivilegesWithAdminOption(string);
            } else {
                ((RoleOracle)object).setPrivileges(string);
            }
        }
    }

    private void initColumns(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if ((string3.equalsIgnoreCase("") || this.table == null || this.table.getColumnProxyByName(string3) == null) && (this.view == null || this.view.getColumnProxyByName(string3) == null)) continue;
            string3 = string3 + ", " + string2;
            if (bl) {
                this.permissions.setColumnListWithGrantOption(string3);
                continue;
            }
            this.permissions.setColumnList(string3);
        }
    }

    private void initHierarchyOption() {
        if (this.statement.toUpperCase().indexOf("WITH_HIERARCHY_OPTION") > -1) {
            this.permissions.setHierarchyOption("YES");
        } else {
            this.permissions.setHierarchyOption("NO");
        }
    }
}

