/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleOraclev9i
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateRoleOraclev9i.class);

    public SHCreateRoleOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRoleOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create role")) {
            try {
                this.parseRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseRole(String string) {
        RoleOraclev9i roleOraclev9i;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOraclev9i != null && (roleOraclev9i = (RoleOraclev9i)storageDesignOraclev9i.getRoleSet().createRole()) != null) {
            this.initName(roleOraclev9i);
            this.initIdentified(roleOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(roleOraclev9i);
        }
    }

    private void initName(RoleOraclev9i roleOraclev9i) {
        String string = Token.getQuotedNameAfterToken(this.statement, "ROLE").trim();
        roleOraclev9i.setName(string);
    }

    private void initIdentified(RoleOraclev9i roleOraclev9i) {
        if (Token.hasToken(this.statement, "NOT")) {
            roleOraclev9i.setIdentified("NO");
        } else {
            roleOraclev9i.setIdentified("YES");
            String string = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(string)) {
                String string2 = Token.getTokenAfter(this.statement, "BY").trim();
                roleOraclev9i.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                roleOraclev9i.encodePassword(string2);
            } else if ("USING".equalsIgnoreCase(string)) {
                roleOraclev9i.setAuthType(RoleOraclev9i.getAuthTypes()[3]);
                String string3 = Token.getTokenAfter(this.statement, "USING").trim();
                int n = string3.indexOf(".");
                if (n != -1) {
                    roleOraclev9i.setSchema(Token.getName(string3.substring(0, n)));
                    roleOraclev9i.setPack(Token.getName(string3.substring(n + 1)));
                } else {
                    roleOraclev9i.setPack(Token.getName(string3));
                }
            } else {
                roleOraclev9i.setAuthType(string);
            }
        }
    }
}

