/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexOraclev9i
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private ClusterIndexOracle clusterIndex;
    private BitmapJoinIndexOracle bitmapIndex;
    private String indexName = "";
    private StorageDesignOracle stoDesign;
    private String userName;
    private IndexProxyOracle indexProxy = null;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndexOraclev9i.class);

    public SHCreateIndexOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndexOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index") || Token.startsWithString(string2, "create bitmap index")) {
            try {
                this.failed = false;
                this.index = null;
                this.createIndex(string2);
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.index != null) {
                    DesignObject designObject2;
                    for (DesignObject designObject2 : this.index.getElementsCollection()) {
                        arrayList.add(designObject2.getName());
                    }
                    designObject2 = this.getUniqueIndexForColumnNames(this.table, arrayList);
                    if (designObject2 != null) {
                        PKProxyOracle pKProxyOracle = (PKProxyOracle)this.stoDesign.getPKProxySet().getObjectGeneratedBy(designObject2);
                        if (pKProxyOracle != null) {
                            pKProxyOracle.setUsingIndex("BY INDEX NAME");
                            pKProxyOracle.setExistingIndex(this.indexProxy);
                        } else {
                            UniqueOracle uniqueOracle = (UniqueOracle)this.stoDesign.getUniqueSet().getObjectGeneratedBy(designObject2);
                            if (uniqueOracle != null) {
                                uniqueOracle.setUsingIndex("BY INDEX NAME");
                                uniqueOracle.setExistingIndex(this.indexProxy);
                            }
                        }
                    }
                }
                if (this.failed) {
                    this.importLog.addFailedStatement(SHCreateIndexOraclev9i.FormatCR(string, "\n"));
                } else {
                    this.importLog.incrementImportedStatements();
                }
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateIndexOraclev9i.FormatCR(string, "\n"));
            }
            this.index = null;
            this.table = null;
            this.clusterIndex = null;
            this.bitmapIndex = null;
            this.indexName = "";
            this.stoDesign = null;
            this.userName = null;
            this.indexProxy = null;
        } else {
            this.nextHandler(string);
        }
    }

    private void createIndex(String string) {
        this.statement = string;
        this.indexName = this.initIndexName();
        if (this.isClusterIndex()) {
            this.createClusterIndex();
        } else if (this.isBitmapJoinIndex()) {
            this.createBitmapJoinIndex();
        } else {
            this.createTableIndex();
        }
    }

    private boolean isClusterIndex() {
        return "CLUSTER".equalsIgnoreCase(Token.getTokenAfter(this.statement, "ON").trim());
    }

    private boolean isBitmapJoinIndex() {
        return this.statement.toLowerCase().indexOf("create bitmap index") > -1 && Token.hasToken(this.statement, "WHERE") && Token.hasToken(this.statement, "FROM");
    }

    private void createClusterIndex() {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.clusterIndex = this.stoDesign.getClusterIndexSet().createClusterIndex();
            this.clusterIndex.setName(this.initIndexName());
            this.design.getRelationalDesign().stampModelObjectDDL(this.clusterIndex);
            UserOracle userOracle = this.initUser();
            this.clusterIndex.setUser(userOracle);
            this.clusterIndex.setCluster(this.getCluster());
            this.initAttributes(null, this.clusterIndex, this.statement);
        }
    }

    private void createBitmapJoinIndex() {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.bitmapIndex = this.stoDesign.getBitmapJoinIndexSet().createBitmapJoinIndex();
            this.bitmapIndex.setName(this.initIndexName());
            this.design.getRelationalDesign().stampModelObjectDDL(this.bitmapIndex);
            UserOracle userOracle = this.initUser();
            this.bitmapIndex.setUser(userOracle);
            this.initBaseTable(this.bitmapIndex);
            this.initDimensionTables(this.bitmapIndex);
            this.initIndexColumns(this.bitmapIndex);
            this.initJoinColumns(this.bitmapIndex);
            String string = this.initBitmapPartitioning();
            this.initAttributesBitmap(this.bitmapIndex, string);
        }
    }

    private void createTableIndex() {
        try {
            this.constructIndex();
            if (this.index != null) {
                this.initUnique();
                this.setColumnForIndex();
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
                if (this.stoDesign != null) {
                    this.indexProxy = (IndexProxyOracle)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID());
                    if (this.indexProxy != null) {
                        String string;
                        UserOracle userOracle = this.initUser();
                        if (userOracle != null) {
                            string = userOracle.getName();
                            SchemaObjectSet schemaObjectSet = ((RelationalDesign)this.index.getDesignPart()).getSchemaObjectSet();
                            SchemaObject schemaObject = (SchemaObject)schemaObjectSet.getByName(string);
                            if (schemaObject == null && !string.trim().equalsIgnoreCase("")) {
                                schemaObject = schemaObjectSet.createSchemaObject(null);
                                schemaObject.setName(string);
                                this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
                            }
                            if (userOracle.getSchemaObject() == null) {
                                userOracle.setSchemaObject(schemaObject);
                            }
                            if (userOracle.getSchemaObject() != schemaObject) {
                                this.indexProxy.setUser(userOracle);
                            }
                            this.index.setSchemaObject(schemaObject);
                        }
                        this.initBitmapIndex();
                        this.initIndextype();
                        string = this.initPartitioned();
                        this.initAttributes(this.indexProxy, null, string);
                    }
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            StringBuffer stringBuffer = new StringBuffer(objectDoesNotExistException.getMessage());
            stringBuffer.append(" in SHCreateIndex.createIndex");
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError("Creating index for statement " + this.statement + " for Oracle failed");
            this.failed = true;
        }
    }

    private String initIndexName() {
        String string = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private UserOracle initUser() {
        if (this.userName != null) {
            UserOracle userOracle = (UserOracle)this.stoDesign.getUserSet().getByName(this.userName);
            if (userOracle == null) {
                userOracle = this.stoDesign.getUserSet().createUser();
                userOracle.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            return userOracle;
        }
        return null;
    }

    private void initBaseTable(BitmapJoinIndexOracle bitmapJoinIndexOracle) {
        TableProxyOracle tableProxyOracle;
        String string = Token.getQuotedNameAfterToken(this.statement, "ON");
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
        }
        if ((tableProxyOracle = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(string, string2)) != null) {
            bitmapJoinIndexOracle.setTable(tableProxyOracle);
        }
    }

    private void initIndexColumns(BitmapJoinIndexOracle bitmapJoinIndexOracle) {
        String string = Token.getStringAfterToken(this.statement, "ON");
        string = Token.getStringBefore(string, "FROM");
        string = Token.getValBetweenBrackets(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            ColumnProxyOracle columnProxyOracle;
            String string2 = stringTokenizer.nextToken();
            String string3 = "ASC";
            String string4 = Token.getLastToken(string2);
            if (string4.equalsIgnoreCase("ASC")) {
                string2 = Token.getStringBefore(string2, " ASC");
            } else if (string4.equalsIgnoreCase("DESC")) {
                string2 = Token.getStringBefore(string2, " DESC");
                string3 = "DESC";
            }
            if ((columnProxyOracle = this.getColumnProxy(string2, bitmapJoinIndexOracle)) == null) continue;
            bitmapJoinIndexOracle.setIndexColumns(columnProxyOracle.getObjectID());
            bitmapJoinIndexOracle.setIndexColumns(string3);
        }
    }

    private ColumnProxyOracle getColumnProxy(String string, BitmapJoinIndexOracle bitmapJoinIndexOracle) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            ColumnProxyOracle columnProxyOracle;
            TableProxyOracle tableProxyOracle;
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            String string4 = null;
            n = string3.lastIndexOf(46);
            if (n > -1) {
                string4 = string3.substring(0, n).trim();
                string3 = string3.substring(n + 1);
            }
            if ((tableProxyOracle = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(string3.trim(), string4)) != null && (columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(string2.trim())) != null) {
                return columnProxyOracle;
            }
        } else {
            Object object;
            String string5 = string.trim();
            BitmapJoinIndexOracle.InlineList inlineList = bitmapJoinIndexOracle.getDimensionKeySet();
            for (int i = 0; i < inlineList.size(); i += 2) {
                ColumnProxyOracle columnProxyOracle;
                object = (String)inlineList.get(i);
                TableProxyOracle tableProxyOracle = (TableProxyOracle)this.stoDesign.getTableProxySet().getProxy((String)object);
                if (tableProxyOracle == null || (columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(string5)) == null) continue;
                return columnProxyOracle;
            }
            TableProxyOracle tableProxyOracle = bitmapJoinIndexOracle.getTable();
            if (tableProxyOracle != null && (object = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(string5)) != null) {
                return object;
            }
        }
        return null;
    }

    private void initDimensionTables(BitmapJoinIndexOracle bitmapJoinIndexOracle) {
        String string = Token.getStringAfterToken(this.statement, "FROM");
        string = Token.getStringBefore(string, "WHERE");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            int n = string2.lastIndexOf(46);
            if (n > -1) {
                string3 = string2.substring(0, n).trim();
                string2 = string2.substring(n + 1);
            }
            string2 = string2.trim();
            TableProxyOracle tableProxyOracle = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(string2, string3);
            if (tableProxyOracle == null || tableProxyOracle.equals(bitmapJoinIndexOracle.getTable())) continue;
            bitmapJoinIndexOracle.setDimensionKeys(tableProxyOracle.getObjectID());
            bitmapJoinIndexOracle.setDimensionKeys("");
        }
    }

    private void initJoinColumns(BitmapJoinIndexOracle bitmapJoinIndexOracle) {
        String string = Token.getStringAfterToken(this.statement, "WHERE");
        int n = string.lastIndexOf(61);
        String string2 = string.substring(n + 1).trim();
        string2 = Token.getFirstToken(string2);
        string = string.substring(0, n + 1).trim() + ' ' + string2;
        String[] stringArray = string.split(" AND ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n2 = string3.indexOf(61);
            if (n2 <= -1) continue;
            String string4 = string3.substring(0, n2).trim();
            String string5 = string3.substring(n2 + 1).trim();
            ColumnProxyOracle columnProxyOracle = this.getColumnProxy(string4, bitmapJoinIndexOracle);
            ColumnProxyOracle columnProxyOracle2 = this.getColumnProxy(string5, bitmapJoinIndexOracle);
            if (columnProxyOracle == null || columnProxyOracle2 == null) continue;
            if (columnProxyOracle.getTableProxy().getObjectID().equals(bitmapJoinIndexOracle.getTable().getObjectID())) {
                bitmapJoinIndexOracle.setJoinColumns(columnProxyOracle2.getObjectID());
                bitmapJoinIndexOracle.setJoinColumns(columnProxyOracle.getObjectID());
                continue;
            }
            bitmapJoinIndexOracle.setJoinColumns(columnProxyOracle.getObjectID());
            bitmapJoinIndexOracle.setJoinColumns(columnProxyOracle2.getObjectID());
        }
    }

    private void constructIndex() throws ObjectDoesNotExistException {
        Index[] indexArray;
        int n;
        String string = Token.getQuotedNameAfterToken(this.statement, "ON");
        int n2 = string.indexOf(40);
        if (n2 > -1) {
            string = string.substring(0, n2).trim();
        }
        if ((n = string.indexOf(46)) > -1) {
            indexArray = string.substring(0, n);
            string = string.substring(n + 1);
            this.table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName((String)indexArray, string);
        }
        if (this.table == null) {
            this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        }
        if (this.table != null) {
            indexArray = (Index[])this.table.getKeys();
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = index;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else {
            this.importLog.addError("Reference table " + string + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
    }

    private void initUnique() {
        String string;
        if (!this.index.isPK() && (string = Token.getTokenAfter(this.statement, "CREATE").trim()).equalsIgnoreCase("UNIQUE")) {
            this.index.setIndexState("Unique Plain Index");
        }
    }

    private void initBitmapIndex() {
        String string = Token.getTokenAfter(this.statement, "CREATE").trim();
        if (string.equalsIgnoreCase("BITMAP")) {
            this.indexProxy.setBitmapIndex(true);
        }
    }

    private void initIndextype() {
        int n = this.statement.toUpperCase().indexOf(" INDEXTYPE IS ");
        if (n > -1) {
            String string = this.statement.substring(n + 14);
            this.indexProxy.setIndexType(Token.getFirstName(string, '\"', '\"'));
            String string2 = Token.getStringAfterToken(string, "PARAMETERS");
            this.indexProxy.setIndexDomainParameters(Token.getValBetweenQuotes(string2));
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        String string = Token.getValBetweenBrackets(this.statement, 1).trim();
        boolean bl = Token.hasCloseAndOpenBrackets(string);
        if (bl) {
            this.index.setIndexExpression(string);
            return;
        }
        Map map = this.getColumnsForTable();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Column column;
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = "ASC";
            if (Token.getLastToken(string2).equalsIgnoreCase("ASC") || Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                if (Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                    string3 = "DESC";
                }
                string2 = string2.substring(0, string2.lastIndexOf(32));
            }
            if (string2.trim().startsWith("\"")) {
                string2 = Token.removeQuotes(string2);
            }
            if ((column = (Column)map.get(string2)) == null) {
                column = (Column)map.get(string2.toUpperCase());
            }
            if (column != null) {
                this.index.add(column);
                this.index.setColumnSortOrder(column, string3);
                continue;
            }
            Iterator iterator = this.index.getElementsCollection().iterator();
            while (iterator.hasNext()) {
                this.index.remove((ContainedObject)iterator.next());
            }
            this.index.setIndexExpression(string);
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columnArray = (Column[])this.table.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
                hashMap.put(columnArray[i].getName().toUpperCase(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private ClusterOracle getCluster() {
        String string = Token.getQuotedNameAfterToken(this.statement, "CLUSTER");
        int n = string.indexOf(46);
        if (n > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        if (!"".equalsIgnoreCase(string)) {
            return (ClusterOracle)this.stoDesign.getClusterSet().getByName(string);
        }
        return null;
    }

    private String initPartitioned() {
        String string = this.statement;
        if (Token.hasToken(this.statement, "GLOBAL")) {
            String string2 = Token.getStringAfter(this.statement, "PARTITION BY");
            String string3 = Token.getFirstToken(string2);
            String string4 = Token.getValBetweenBrackets(string2, 1).trim();
            string2 = Token.getValAfterBrackets(string2, 1);
            if (string3.equalsIgnoreCase("RANGE")) {
                if (this.indexProxy instanceof IndexProxyOraclev9i) {
                    this.indexProxy.setIndexPartitioned("GLOBAL");
                } else {
                    this.indexProxy.setIndexPartitioned("GLOBAL BY RANGE");
                }
            } else if (string3.equalsIgnoreCase("HASH") && this.indexProxy instanceof IndexProxyOraclev10g) {
                if (Token.getFirstToken(string2).equalsIgnoreCase("PARTITIONS")) {
                    this.indexProxy.setIndexPartitioned("GLOBAL HASH PARTITIONED BY QUANTITY");
                } else {
                    this.indexProxy.setIndexPartitioned("GLOBAL HASH PARTITIONED BY LIST");
                }
            }
            IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = this.stoDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
            this.design.getRelationalDesign().stampModelObjectDDL(indexGlobalPartitionsListOracle);
            this.indexProxy.setIndexGlobalPartitionsList(indexGlobalPartitionsListOracle);
            indexGlobalPartitionsListOracle.setIndex(this.indexProxy);
            indexGlobalPartitionsListOracle.setGlobalPartColumns(indexGlobalPartitionsListOracle.columnNamesToColumnIDs(string4));
            if (this.indexProxy.getIndexPartitioned().equals("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                TableSpaceOracle tableSpaceOracle;
                String string5;
                StringTokenizer stringTokenizer;
                IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)indexGlobalPartitionsListOracle;
                string2 = Token.cutTokenFromFront(string2, "PARTITIONS");
                String string6 = Token.getFirstToken(string2);
                string2 = Token.cutTokenFromFront(string2, string6);
                try {
                    int n = Integer.parseInt(string6);
                    indexGlobalPartitionsListOraclev10g.setHashPQuantity(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateIndexOraclev9i.initPartitioned : " + numberFormatException.getMessage());
                    this.importLog.addWarning("Wrong PARTITIONS format in statement " + this.statement);
                }
                if (Token.startsWithString(string2, "STORE IN")) {
                    String string7 = Token.getValBetweenBrackets(string2, 1);
                    string2 = Token.getValAfterBrackets(string2, 1);
                    stringTokenizer = new StringTokenizer(string7, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = Token.getName(stringTokenizer.nextToken().trim());
                        tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string5);
                        if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                            tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string5);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                        }
                        if (tableSpaceOracle == null) continue;
                        indexGlobalPartitionsListOraclev10g.setHashPTableSpaces(tableSpaceOracle.getObjectID());
                    }
                }
                if (Token.hasToken(string2, "OVERFLOW") && Token.startsWithString(string2 = Token.getStringAfterToken(string2, "OVERFLOW"), "STORE IN")) {
                    String string8 = Token.getValBetweenBrackets(string2, 1);
                    string2 = Token.getValAfterBrackets(string2, 1);
                    stringTokenizer = new StringTokenizer(string8, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = Token.getName(stringTokenizer.nextToken().trim());
                        tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string5);
                        if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                            tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string5);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                        }
                        if (tableSpaceOracle == null) continue;
                        indexGlobalPartitionsListOraclev10g.setIOTOverflowHashPTSSet(tableSpaceOracle.getObjectID());
                    }
                }
                string = string2;
            } else {
                String string9 = Token.getValBetweenBrackets(string2, 1).trim();
                string = Token.getValAfterBrackets(string2, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    TableSpaceOracle tableSpaceOracle;
                    String string10;
                    String string11;
                    AbstractStorageObjectOracle abstractStorageObjectOracle;
                    ++n;
                    String string12 = stringTokenizer.nextToken();
                    while (Token.hasOpenBracket(string12) && stringTokenizer.hasMoreTokens()) {
                        string12 = string12 + ", " + stringTokenizer.nextToken();
                    }
                    String string13 = Token.getQuotedNameAfterToken(string12, "PARTITION");
                    if (this.indexProxy.getIndexPartitioned().equals("GLOBAL HASH PARTITIONED BY LIST")) {
                        abstractStorageObjectOracle = ((StorageDesignOraclev10g)this.stoDesign).getIndexHashPartitionSet().createIndexHashPartition();
                        if (!(string13.equalsIgnoreCase("TABLESPACE") || string13.equalsIgnoreCase("OVERFLOW") || string13.equalsIgnoreCase("COMPRESS") || string13.equalsIgnoreCase("NOCOMPRESS") || string13.equalsIgnoreCase("LOB") || string13.equalsIgnoreCase("VARRAY"))) {
                            abstractStorageObjectOracle.setName(string13);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                        ((IndexHashPartitionOracle)abstractStorageObjectOracle).setIndexGlobalPartList(indexGlobalPartitionsListOracle);
                        string11 = string12;
                        while (Token.hasToken(string11, "TABLESPACE")) {
                            if (Token.hasOpenBracketNoClose(Token.getStringBeforeToken(string11, "TABLESPACE"))) {
                                string11 = Token.getValAfterBrackets(string11, 1);
                                continue;
                            }
                            string10 = Token.getQuotedNameAfterToken(string11, "TABLESPACE");
                            if (!string10.equals("")) {
                                tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string10);
                                if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string10)) {
                                    tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                                    tableSpaceOracle.setName(string10);
                                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                                }
                                if (tableSpaceOracle != null) {
                                    if (Token.getTokenBefore(string11, "TABLESPACE").equalsIgnoreCase("OVERFLOW")) {
                                        ((IndexHashPartitionOracle)abstractStorageObjectOracle).setOverflowTableSpace(tableSpaceOracle);
                                    } else {
                                        ((IndexHashPartitionOracle)abstractStorageObjectOracle).setTableSpace(tableSpaceOracle);
                                    }
                                }
                            }
                            string11 = Token.getStringAfterToken(string11, "TABLESPACE");
                        }
                        continue;
                    }
                    abstractStorageObjectOracle = this.stoDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                    if (!string13.equalsIgnoreCase("VALUES")) {
                        abstractStorageObjectOracle.setName(string13);
                    }
                    this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                    ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setIndexGlobalPartList(indexGlobalPartitionsListOracle);
                    ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setPosition(n);
                    string12 = Token.getStringAfter(string12, "LESS THAN").trim();
                    string11 = Token.getValBetweenBrackets(string12, 1).trim();
                    ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setValueList(string11);
                    this.initPartSegment(string12, (IndexGlobalPartitionOracle)abstractStorageObjectOracle);
                    if (Token.hasToken(string12, "TABLESPACE")) {
                        string10 = Token.getQuotedNameAfterToken(string12, "TABLESPACE");
                        tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string10);
                        if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string10)) {
                            tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string10);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                        }
                        if (tableSpaceOracle != null) {
                            ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setTableSpace(tableSpaceOracle);
                        }
                    }
                    if (Token.hasToken(string12, "LOGGING")) {
                        ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setLogging("YES");
                        continue;
                    }
                    if (Token.hasToken(string12, "NOLOGGING")) {
                        ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setLogging("NO");
                        continue;
                    }
                    ((IndexGlobalPartitionOracle)abstractStorageObjectOracle).setLogging("");
                }
            }
        } else if (Token.hasToken(this.statement, "LOCAL")) {
            this.indexProxy.setIndexPartitioned("LOCAL");
            return this.initLocalPartitioning(Token.getStringAfterToken(this.statement, "LOCAL"));
        }
        return string;
    }

    private String initLocalPartitioning(String string) {
        String string2;
        block11: {
            Object object;
            String string3;
            Object object2;
            String string4;
            TableProxyOracle tableProxyOracle;
            block12: {
                string2 = string;
                tableProxyOracle = (TableProxyOracle)this.stoDesign.getTableProxySet().getProxy(this.table.getObjectID());
                if (tableProxyOracle == null || !tableProxyOracle.getPartitioned().equalsIgnoreCase("YES")) break block11;
                string4 = tableProxyOracle.getPartitionList().getPartitionType();
                String string5 = tableProxyOracle.getPartitionList().getSubpartitionType();
                if (Token.startsWithString(string, "STORE IN")) {
                    if (string4.equalsIgnoreCase("HASH BY QUANTITY") || string4.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || string5.equalsIgnoreCase("HASH")) {
                        object2 = Token.getValBetweenBrackets(string, 1);
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = Token.getName(stringTokenizer.nextToken());
                            object = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string3);
                            if (object == null) continue;
                            this.indexProxy.setHashSubPartitionsTableSpaces(((ModelIDObject)object).getObjectID());
                        }
                    }
                    string2 = string = Token.getValAfterBrackets(string, 1);
                }
                if (!string4.equalsIgnoreCase("RANGE") && !string4.equalsIgnoreCase("LIST") && !string4.equalsIgnoreCase("COMPOSITE BY HASH") && !string4.equalsIgnoreCase("COMPOSITE BY LIST")) break block12;
                if (!Token.hasToken(string, "PARTITION")) break block11;
                string2 = Token.getValAfterBrackets(string, 1);
                string = Token.getValBetweenBrackets(string, 1);
                object2 = new StringTokenizer(string, ",");
                int n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    StorageObjectCollection storageObjectCollection;
                    ++n;
                    string3 = ((StringTokenizer)object2).nextToken();
                    while (Token.hasOpenBracket(string3) && ((StringTokenizer)object2).hasMoreTokens()) {
                        string3 = string3 + ", " + ((StringTokenizer)object2).nextToken();
                    }
                    object = Token.getQuotedNameAfterToken(string3, "PARTITION").trim();
                    if ("".equalsIgnoreCase((String)object) || n > (storageObjectCollection = tableProxyOracle.getPartitions()).size()) continue;
                    AbstractStorageObjectOracle abstractStorageObjectOracle = (AbstractStorageObjectOracle)storageObjectCollection.getElement(n - 1);
                    this.initPartitionAttr(string3, this.indexProxy, abstractStorageObjectOracle, (String)object, string5);
                }
                break block11;
            }
            if (string4.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") && Token.hasToken(string, "PARTITION")) {
                string2 = Token.getValAfterBrackets(string, 1);
                string = Token.getValBetweenBrackets(string, 1);
                object2 = new StringTokenizer(string, ",");
                int n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    Object object3;
                    StorageObjectCollection storageObjectCollection;
                    ++n;
                    string3 = ((StringTokenizer)object2).nextToken();
                    while (Token.hasOpenBracket(string3) && ((StringTokenizer)object2).hasMoreTokens()) {
                        string3 = string3 + ", " + ((StringTokenizer)object2).nextToken();
                    }
                    object = Token.getQuotedNameAfterToken(string3, "PARTITION").trim();
                    if ("".equalsIgnoreCase((String)object) || n > (storageObjectCollection = tableProxyOracle.getPartitions()).size()) continue;
                    HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)storageObjectCollection.getElement(n - 1);
                    TableSpaceOracle tableSpaceOracle = null;
                    if (Token.hasToken(string3, "TABLESPACE")) {
                        object3 = Token.getQuotedNameAfterToken(string3, "TABLESPACE");
                        tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName((String)object3);
                        if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase((String)object3)) {
                            tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName((String)object3);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                        }
                    }
                    if (tableSpaceOracle == null && ((String)object).equals(hashPartitionOracle.getName()) || (object3 = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(hashPartitionOracle, this.indexProxy)) == null) continue;
                    ((LocalIndexProperties)object3).setIndex(this.indexProxy);
                    if (!((String)object).equals("TABLESPACE")) {
                        ((LocalIndexProperties)object3).setPartitionName((String)object);
                    }
                    if (tableSpaceOracle == null) continue;
                    ((LocalIndexProperties)object3).setTableSpace(tableSpaceOracle);
                }
            }
        }
        return string2;
    }

    private void setLocalIndexProperties(StorageObject storageObject, AbstractStorageObjectOracle abstractStorageObjectOracle, TableSpaceOracle tableSpaceOracle, String string, SegmentOracle segmentOracle, String string2, String string3) {
        LocalIndexProperties localIndexProperties = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(abstractStorageObjectOracle, storageObject);
        if (localIndexProperties != null) {
            localIndexProperties.setIndex(storageObject);
            localIndexProperties.setPartitionName(string3);
            if (tableSpaceOracle != null) {
                localIndexProperties.setTableSpace(tableSpaceOracle);
            }
            localIndexProperties.setLogging(string);
            localIndexProperties.setSegment(segmentOracle);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = Token.getName(stringTokenizer.nextToken());
                TableSpaceOracle tableSpaceOracle2 = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOracle2 == null) continue;
                localIndexProperties.setHashSubPartitionsTableSpaces(tableSpaceOracle2.getObjectID());
            }
        }
    }

    public static String getFirstToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = " ";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2.trim();
    }

    private void initPartitionAttr(String string, StorageObject storageObject, AbstractStorageObjectOracle abstractStorageObjectOracle, String string2, String string3) {
        String string4 = string;
        String string5 = " ";
        if (Token.hasToken(string4, "SUBPARTITION")) {
            string4 = Token.getStringBefore(string4, "SUBPARTITION");
            int n = string.toUpperCase().indexOf("SUBPARTITION");
            string = string.substring(n - 2);
            this.initIndexSubpartitionClause(string, storageObject, abstractStorageObjectOracle, string3);
        } else if (Token.hasToken(string4, "STORE")) {
            string4 = Token.getStringBefore(string4, "STORE");
            string = Token.getStringAfter(string, "STORE");
            if (!(string = Token.getValBetweenBrackets(string)).equalsIgnoreCase("DEFAULT")) {
                string5 = string;
            }
        }
        SegmentOracle segmentOracle = null;
        TableSpaceOracle tableSpaceOracle = null;
        String string6 = "";
        if ((Token.hasToken(string4, "PCTFREE") || Token.hasToken(string4, "PCTUSED") || Token.hasToken(string4, "INITRANS") || Token.hasToken(string4, "MAXTRANS") || Token.hasToken(string4, "STORAGE")) && (segmentOracle = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string4, segmentOracle);
            this.initInitrans(string4, segmentOracle);
            this.initMaxtrans(string4, segmentOracle);
            this.initStorage(string4, segmentOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
            segmentOracle = this.stoDesign.getSegmentSet().findEqual(segmentOracle);
        }
        if (Token.hasToken(string4, "TABLESPACE")) {
            String string7 = Token.getQuotedNameAfterToken(string4, "TABLESPACE");
            tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string7);
            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string7);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
            }
        }
        if (Token.hasToken(string4, "NOLOGGING")) {
            string6 = "NO";
        } else if (Token.hasToken(string4, "LOGGING")) {
            string6 = "YES";
        }
        this.setLocalIndexProperties(storageObject, abstractStorageObjectOracle, tableSpaceOracle, string6, segmentOracle, string5, string2);
    }

    private void initIndexSubpartitionClause(String string, StorageObject storageObject, AbstractStorageObjectOracle abstractStorageObjectOracle, String string2) {
        string = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            ++n;
            String string3 = stringTokenizer.nextToken();
            String string4 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION").trim();
            if ("".equalsIgnoreCase(string4)) continue;
            StorageObjectCollection storageObjectCollection = null;
            if (abstractStorageObjectOracle instanceof PartitionOracle) {
                if (string2.equalsIgnoreCase("HASH")) {
                    storageObjectCollection = ((PartitionOracle)abstractStorageObjectOracle).getPartitions();
                } else if (string2.equalsIgnoreCase("LIST")) {
                    storageObjectCollection = ((PartitionOracle)abstractStorageObjectOracle).getListPartitions();
                } else if (string2.equalsIgnoreCase("RANGE") && abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                    storageObjectCollection = ((PartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions();
                }
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                if (string2.equalsIgnoreCase("HASH")) {
                    storageObjectCollection = ((ListPartitionOraclev11g)abstractStorageObjectOracle).getHashSubpartitions();
                } else if (string2.equalsIgnoreCase("LIST")) {
                    storageObjectCollection = ((ListPartitionOraclev11g)abstractStorageObjectOracle).getListSubpartitions();
                } else if (string2.equalsIgnoreCase("RANGE")) {
                    storageObjectCollection = ((ListPartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions();
                }
            }
            if (storageObjectCollection == null || n > storageObjectCollection.size()) continue;
            AbstractStorageObjectOracle abstractStorageObjectOracle2 = (AbstractStorageObjectOracle)storageObjectCollection.getElement(n - 1);
            TableSpaceOracle tableSpaceOracle = null;
            if (Token.hasToken(string3, "TABLESPACE")) {
                object = Token.getQuotedNameAfterToken(string3, "TABLESPACE");
                tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName((String)object);
                if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase((String)object)) {
                    tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOracle.setName((String)object);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                }
            }
            if (tableSpaceOracle == null && string4.equals(abstractStorageObjectOracle2.getName()) || (object = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(abstractStorageObjectOracle2, storageObject)) == null) continue;
            ((LocalIndexProperties)object).setIndex(storageObject);
            if (!string4.equals("TABLESPACE")) {
                ((LocalIndexProperties)object).setPartitionName(string4);
            }
            if (tableSpaceOracle == null) continue;
            ((LocalIndexProperties)object).setTableSpace(tableSpaceOracle);
        }
    }

    private void initPartSegment(String string, IndexGlobalPartitionOracle indexGlobalPartitionOracle) {
        SegmentOracle segmentOracle = null;
        if (Token.hasToken(string, "PCTFREE") && (segmentOracle = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOracle);
            this.initInitrans(string, segmentOracle);
            this.initMaxtrans(string, segmentOracle);
            this.initStorage(string, segmentOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
            SegmentOracle segmentOracle2 = this.stoDesign.getSegmentSet().findEqual(segmentOracle);
            indexGlobalPartitionOracle.setSegment(segmentOracle2);
        }
    }

    private void initAttributes(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasToken(string, "TABLESPACE")) {
            String string2 = Token.getQuotedNameAfterToken(string, "TABLESPACE");
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
            }
            if (tableSpaceOracle != null) {
                if (indexProxyOracle != null) {
                    indexProxyOracle.setTableSpace(tableSpaceOracle);
                } else {
                    clusterIndexOracle.setTableSpace(tableSpaceOracle);
                }
            }
        }
        this.initSegment(indexProxyOracle, clusterIndexOracle, string);
        this.initLogging(indexProxyOracle, clusterIndexOracle, string);
        this.initOnline(indexProxyOracle, clusterIndexOracle, string);
        this.initComputeStatistics(indexProxyOracle, clusterIndexOracle, string);
        this.initCompress(indexProxyOracle, clusterIndexOracle, string);
        this.initSortedRows(indexProxyOracle, clusterIndexOracle, string);
        this.initParallel(indexProxyOracle, clusterIndexOracle, string);
    }

    private void initAttributesBitmap(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "TABLESPACE")) {
            String string2 = Token.getQuotedNameAfterToken(string, "TABLESPACE");
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
            }
            if (tableSpaceOracle != null && bitmapJoinIndexOracle != null) {
                bitmapJoinIndexOracle.setTablespace(tableSpaceOracle.getName());
            }
        }
        this.initSegment(bitmapJoinIndexOracle, string);
        this.initLogging(bitmapJoinIndexOracle, string);
        this.initOnline(bitmapJoinIndexOracle, string);
        this.initComputeStatistics(bitmapJoinIndexOracle, string);
        this.initCompress(bitmapJoinIndexOracle, string);
        this.initSortedRows(bitmapJoinIndexOracle, string);
        this.initParallel(bitmapJoinIndexOracle, string);
    }

    private void initSegment(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        SegmentOracle segmentOracle = null;
        if (Token.hasToken(string, "PCTFREE") && (segmentOracle = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOracle);
            this.initInitrans(string, segmentOracle);
            this.initMaxtrans(string, segmentOracle);
            this.initStorage(string, segmentOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
            SegmentOracle segmentOracle2 = this.stoDesign.getSegmentSet().findEqual(segmentOracle);
            if (indexProxyOracle != null) {
                indexProxyOracle.setSegment(segmentOracle2);
            } else {
                clusterIndexOracle.setSegment(segmentOracle2);
            }
        }
    }

    private void initSegment(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        SegmentOracle segmentOracle = null;
        if (Token.hasToken(string, "PCTFREE") && (segmentOracle = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOracle);
            this.initInitrans(string, segmentOracle);
            this.initMaxtrans(string, segmentOracle);
            this.initStorage(string, segmentOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
            SegmentOracle segmentOracle2 = this.stoDesign.getSegmentSet().findEqual(segmentOracle);
            bitmapJoinIndexOracle.setSegment(segmentOracle2);
        }
    }

    private void initPctFree(String string, SegmentOracle segmentOracle) {
        String string2 = Token.getTokenAfter(string, "PCTFREE").trim();
        try {
            int n = Integer.parseInt(string2);
            segmentOracle.setPCTFree(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
            LOGGER.error("wrong format in SHCreateIndexOracle.initPctFree : " + numberFormatException.getMessage());
        }
    }

    private void initInitrans(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "INITRANS")) {
            String string2 = Token.getTokenAfter(string, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initInitrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxtrans(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "MAXTRANS")) {
            String string2 = Token.getTokenAfter(string, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initMaxtrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initStorage(String string, SegmentOracle segmentOracle) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, segmentOracle, null);
            this.initNext(string2, segmentOracle, null);
            this.initPCtIncrease(string2, segmentOracle, null);
            this.initMinExtents(string2, segmentOracle, null);
            this.initMaxExtents(string2, segmentOracle, null);
            this.initFreeLists(string2, segmentOracle, null);
            this.initFreeListGroups(string2, segmentOracle, null);
            this.initSegBufferPool(string2, segmentOracle, null);
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateIndexOracle.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initInitial(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCInitialExtent(l);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCInitialExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initInitial : " + numberFormatException.getMessage());
            }
        }
    }

    private void initNext(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCNextExtent(l);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCNextExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initNext : " + numberFormatException.getMessage());
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCPctIncrease(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCPctIncrease(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initPCtIncrease : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMinExtents(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCMinExtents(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCMinExtents(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initMinExtents : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxExtents(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            if (segmentOracle != null) {
                segmentOracle.setSCMaxExtents(string2);
            } else {
                lobStorageOracle.setSCMaxExtents(string2);
            }
        }
    }

    private void initFreeLists(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCFreeLists(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCFreeLists(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initFreeLists : " + numberFormatException.getMessage());
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCFreelistGroups(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCFreelistGroups(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initFreeListGroups : " + numberFormatException.getMessage());
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL").trim();
            if (segmentOracle != null) {
                segmentOracle.setSCBufferPool(string2);
            } else if (lobStorageOracle != null) {
                lobStorageOracle.setSCBufferPool(string2);
            }
        }
    }

    private void initLogging(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        String string2 = Token.hasToken(string, "NOLOGGING") ? "NO" : (Token.hasToken(string, "LOGGING") ? "YES" : "");
        if (indexProxyOracle != null) {
            indexProxyOracle.setLogging(string2);
        } else {
            clusterIndexOracle.setLogging(string2);
        }
    }

    private void initLogging(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "NOLOGGING")) {
            bitmapJoinIndexOracle.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            bitmapJoinIndexOracle.setLogging("YES");
        } else {
            bitmapJoinIndexOracle.setLogging("");
        }
    }

    private void initOnline(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasToken(string, "ONLINE")) {
            if (indexProxyOracle != null) {
                indexProxyOracle.setOnline("YES");
            } else {
                clusterIndexOracle.setOnline("YES");
            }
        }
    }

    private void initOnline(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "ONLINE")) {
            bitmapJoinIndexOracle.setOnline("YES");
        }
    }

    private void initComputeStatistics(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasString(string, "COMPUTE STATISTICS")) {
            if (indexProxyOracle != null) {
                indexProxyOracle.setComputeStatistics("YES");
            } else {
                clusterIndexOracle.setComputeStatistics("YES");
            }
        }
    }

    private void initComputeStatistics(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasString(string, "COMPUTE STATISTICS")) {
            bitmapJoinIndexOracle.setComputeStatistics("YES");
        }
    }

    private void initCompress(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasToken(string, "COMPRESS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "COMPRESS").trim());
                if (indexProxyOracle != null) {
                    indexProxyOracle.setCompress(n);
                } else {
                    clusterIndexOracle.setCompress(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initCompress : " + numberFormatException.getMessage());
            }
        }
    }

    private void initCompress(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "COMPRESS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "COMPRESS").trim());
                bitmapJoinIndexOracle.setCompress(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initCompress : " + numberFormatException.getMessage());
            }
        }
    }

    private void initSortedRows(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasToken(string, "NOSORT")) {
            if (indexProxyOracle != null) {
                indexProxyOracle.setSortedRows("NO");
            }
        } else if (Token.hasToken(string, "REVERSE")) {
            if (indexProxyOracle != null) {
                indexProxyOracle.setSortedRows("REVERSE");
            } else {
                clusterIndexOracle.setReverse("YES");
            }
        } else if (Token.hasToken(string, "SORT") && indexProxyOracle != null) {
            indexProxyOracle.setSortedRows("SORTED");
        }
    }

    private void initSortedRows(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "NOSORT")) {
            bitmapJoinIndexOracle.setSortedRows("NO");
        } else if (Token.hasToken(string, "REVERSE")) {
            bitmapJoinIndexOracle.setSortedRows("REVERSE");
        } else if (Token.hasToken(string, "SORT")) {
            bitmapJoinIndexOracle.setSortedRows("SORTED");
        }
    }

    private void initParallel(IndexProxyOracle indexProxyOracle, ClusterIndexOracle clusterIndexOracle, String string) {
        if (Token.hasToken(string, "PARALLEL")) {
            String string2 = Token.getTokenAfter(string, "PARALLEL").trim();
            if (indexProxyOracle != null) {
                indexProxyOracle.setParallel("YES");
                try {
                    Integer.parseInt(string2);
                    indexProxyOracle.setDegree(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                clusterIndexOracle.setParallel("YES");
                try {
                    Integer.parseInt(string2);
                    clusterIndexOracle.setDegree(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void initParallel(BitmapJoinIndexOracle bitmapJoinIndexOracle, String string) {
        if (Token.hasToken(string, "PARALLEL")) {
            bitmapJoinIndexOracle.setParallel("YES");
            String string2 = Token.getTokenAfter(string, "PARALLEL").trim();
            try {
                Integer.parseInt(string2);
                bitmapJoinIndexOracle.setDegree(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private String initBitmapPartitioning() {
        String string;
        block11: {
            Object object;
            String string2;
            Object object2;
            String string3;
            TableProxyOracle tableProxyOracle;
            String string4;
            block12: {
                string = this.statement;
                if (!Token.hasToken(this.statement, "LOCAL")) break block11;
                this.bitmapIndex.setLocalPartitioning("YES");
                string4 = Token.getStringAfterToken(this.statement, "LOCAL");
                tableProxyOracle = this.bitmapIndex.getTable();
                if (tableProxyOracle == null || !tableProxyOracle.getPartitioned().equalsIgnoreCase("YES")) break block11;
                string3 = tableProxyOracle.getPartitionList().getPartitionType();
                String string5 = tableProxyOracle.getPartitionList().getSubpartitionType();
                if (Token.startsWithString(string4, "STORE IN")) {
                    if (string3.equalsIgnoreCase("HASH BY QUANTITY") || string3.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || string5.equalsIgnoreCase("HASH")) {
                        object2 = Token.getValBetweenBrackets(string4, 1);
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = Token.getName(stringTokenizer.nextToken());
                            object = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(string2);
                            if (object == null) continue;
                            this.bitmapIndex.setHashSubPartitionsTableSpaces(((ModelIDObject)object).getObjectID());
                        }
                    }
                    string = string4 = Token.getValAfterBrackets(string4, 1);
                }
                if (!string3.equalsIgnoreCase("RANGE") && !string3.equalsIgnoreCase("LIST") && !string3.equalsIgnoreCase("COMPOSITE BY HASH") && !string3.equalsIgnoreCase("COMPOSITE BY LIST")) break block12;
                if (!Token.hasToken(string4, "PARTITION")) break block11;
                string = Token.getValAfterBrackets(string4, 1);
                string4 = Token.getValBetweenBrackets(string4, 1);
                object2 = new StringTokenizer(string4, ",");
                int n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    StorageObjectCollection storageObjectCollection;
                    ++n;
                    string2 = ((StringTokenizer)object2).nextToken();
                    while (Token.hasOpenBracket(string2) && ((StringTokenizer)object2).hasMoreTokens()) {
                        string2 = string2 + ", " + ((StringTokenizer)object2).nextToken();
                    }
                    object = Token.getQuotedNameAfterToken(string2, "PARTITION").trim();
                    if ("".equalsIgnoreCase((String)object) || n > (storageObjectCollection = tableProxyOracle.getPartitions()).size()) continue;
                    AbstractStorageObjectOracle abstractStorageObjectOracle = (AbstractStorageObjectOracle)storageObjectCollection.getElement(n - 1);
                    this.initPartitionAttr(string2, this.bitmapIndex, abstractStorageObjectOracle, (String)object, string5);
                }
                break block11;
            }
            if (string3.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") && Token.hasToken(string4, "PARTITION")) {
                string = Token.getValAfterBrackets(string4, 1);
                string4 = Token.getValBetweenBrackets(string4, 1);
                object2 = new StringTokenizer(string4, ",");
                int n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    Object object3;
                    StorageObjectCollection storageObjectCollection;
                    ++n;
                    string2 = ((StringTokenizer)object2).nextToken();
                    while (Token.hasOpenBracket(string2) && ((StringTokenizer)object2).hasMoreTokens()) {
                        string2 = string2 + ", " + ((StringTokenizer)object2).nextToken();
                    }
                    object = Token.getQuotedNameAfterToken(string2, "PARTITION").trim();
                    if ("".equalsIgnoreCase((String)object) || n > (storageObjectCollection = tableProxyOracle.getPartitions()).size()) continue;
                    HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)storageObjectCollection.getElement(n - 1);
                    TableSpaceOracle tableSpaceOracle = null;
                    if (Token.hasToken(string2, "TABLESPACE")) {
                        object3 = Token.getQuotedNameAfterToken(string2, "TABLESPACE");
                        tableSpaceOracle = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName((String)object3);
                        if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase((String)object3)) {
                            tableSpaceOracle = this.stoDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName((String)object3);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                        }
                    }
                    if (tableSpaceOracle == null && ((String)object).equals(hashPartitionOracle.getName()) || (object3 = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(hashPartitionOracle, this.bitmapIndex)) == null) continue;
                    ((LocalIndexProperties)object3).setIndex(this.bitmapIndex);
                    if (!((String)object).equals("TABLESPACE")) {
                        ((LocalIndexProperties)object3).setPartitionName((String)object);
                    }
                    if (tableSpaceOracle == null) continue;
                    ((LocalIndexProperties)object3).setTableSpace(tableSpaceOracle);
                }
            }
        }
        return string;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }
}

