/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DirectoryOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateExternalTableOraclev9i
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateExternalTableOraclev9i.class);
    private String lineFormatted;

    public SHCreateExternalTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateExternalTableOraclev9i.clearCR(string);
        if ((Token.startsWithString(string2, "create table") || Token.startsWithString(string2, "create global temporary table")) && string2.toLowerCase().indexOf("organization external") > -1) {
            try {
                this.lineFormatted = SHCreateExternalTableOraclev9i.FormatCR(string, "\n");
                this.parseExternalTable(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle 9i failed!", exception);
                this.importLog.addFailedStatement(SHCreateExternalTableOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseExternalTable(String string) {
        ExternalTableOraclev9i externalTableOraclev9i;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOraclev9i != null && (externalTableOraclev9i = (ExternalTableOraclev9i)storageDesignOraclev9i.getExternalTableSet().createExternalTable()) != null) {
            this.initName(externalTableOraclev9i, storageDesignOraclev9i);
            this.initColumns(externalTableOraclev9i, storageDesignOraclev9i);
            this.initExternalTableClause(externalTableOraclev9i, storageDesignOraclev9i);
            this.initParallel(externalTableOraclev9i);
            this.initRejectLimit(externalTableOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(externalTableOraclev9i);
        }
    }

    private void initName(ExternalTableOraclev9i externalTableOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        String string = Token.getQuotedNameAfterToken(this.statement, "TABLE");
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            UserOraclev9i userOraclev9i = (UserOraclev9i)storageDesignOraclev9i.getUserSet().getByName(string2);
            if (userOraclev9i != null) {
                externalTableOraclev9i.setOwner(userOraclev9i);
            }
            string = string.substring(n + 1);
        }
        externalTableOraclev9i.setName(string);
    }

    private void initColumns(ExternalTableOraclev9i externalTableOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        String string = Token.getValBetweenBrackets(this.statement, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                string3 = string3 + ", " + stringTokenizer.nextToken();
            }
            String string4 = Token.getFirstToken(string3.trim());
            if ("".equalsIgnoreCase(string4)) continue;
            ExternalTableColumnOraclev9i externalTableColumnOraclev9i = (ExternalTableColumnOraclev9i)storageDesignOraclev9i.getExternalColumnSet().createExternalColumn();
            externalTableColumnOraclev9i.setName(string4);
            externalTableColumnOraclev9i.setExternalTable(externalTableOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(externalTableColumnOraclev9i);
            String string5 = Token.getStringAfterToken(string3, string4).toUpperCase();
            if (string5.startsWith("TIMESTAMP")) {
                String string6 = Token.getValBetweenBrackets(string5, 1).trim();
                if (string6.length() > 0) {
                    try {
                        externalTableColumnOraclev9i.setPrecision(Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Wrong precision format " + string6);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
                string5 = string5.indexOf("WITH") >= 0 && string5.indexOf("TIME") >= 0 && string5.indexOf("ZONE") >= 0 ? (string5.indexOf("LOCAL") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : "TIMESTAMP WITH TIME ZONE") : "TIMESTAMP";
            } else if (string5.startsWith("INTERVAL")) {
                String string7 = Token.cutTokenFromFront(string5, "INTERVAL");
                if (string7.startsWith("YEAR")) {
                    string5 = "INTERVAL YEAR TO MONTH";
                } else {
                    String string8;
                    String string9;
                    String string10;
                    string5 = "INTERVAL DAY TO SECOND";
                    string2 = Token.cutTokenFromFront(string7, "DAY");
                    if (string2.startsWith("(") && (string10 = Token.getValBetweenBrackets(string2, 1).trim()).length() > 0) {
                        try {
                            externalTableColumnOraclev9i.setPrecision(Integer.parseInt(string10));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Wrong precision format " + string10);
                            this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                        }
                    }
                    if ((string9 = Token.cutTokenFromFront(string10 = Token.getStringAfterToken(string7, "TO"), "SECOND")).startsWith("(") && (string8 = Token.getValBetweenBrackets(string9, 1).trim()).length() > 0) {
                        try {
                            externalTableColumnOraclev9i.setScale(Integer.parseInt(string8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Wrong precision format " + string8);
                            this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                        }
                    }
                }
            } else {
                string5 = this.getDatatype(string5);
            }
            if (string5 == null) continue;
            externalTableColumnOraclev9i.setDatatype(string5);
            boolean bl = Token.hasCloseAndOpenBrackets(string3);
            if (!bl) continue;
            string2 = Token.getValBetweenBrackets(string3, 1).trim();
            try {
                if (string5.indexOf("CHAR") > -1 || string5.equals("RAW") || string5.equals("UROWID")) {
                    if (string2.endsWith("BYTE") || string2.endsWith("CHAR")) {
                        externalTableColumnOraclev9i.setUnits(string2.substring(string2.length() - 4));
                        string2 = string2.substring(0, string2.length() - 4).trim();
                    }
                    externalTableColumnOraclev9i.setSize(Integer.parseInt(string2));
                    continue;
                }
                if (string5.startsWith("TIMESTAMP") || string5.equals("INTERVAL DAY TO SECOND")) continue;
                int n = string2.indexOf(",");
                if (n != -1) {
                    externalTableColumnOraclev9i.setPrecision(Integer.parseInt(string2.substring(0, n).trim()));
                    externalTableColumnOraclev9i.setScale(Integer.parseInt(string2.substring(n + 1).trim()));
                    continue;
                }
                externalTableColumnOraclev9i.setPrecision(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong size/precision format " + string2);
                this.importLog.addWarning("Wrong size/precision format in statement " + this.statement);
            }
        }
    }

    private String getDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("Oracle9i");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.startsWith(string2)) continue;
            return string2;
        }
        return null;
    }

    private void initExternalTableClause(ExternalTableOraclev9i externalTableOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        String string;
        if (Token.hasToken(this.statement, "TYPE")) {
            externalTableOraclev9i.setAccessDriverType(Token.getTokenAfter(this.statement, "TYPE"));
        }
        if (Token.hasToken(this.statement, "DIRECTORY")) {
            string = Token.getTokenAfter(this.statement, "DIRECTORY");
            DirectoryOraclev9i directoryOraclev9i = (DirectoryOraclev9i)storageDesignOraclev9i.getDirectorySet().getByName(string);
            if (directoryOraclev9i != null) {
                externalTableOraclev9i.setDefaultDir(directoryOraclev9i);
            }
        }
        if (this.statement.toUpperCase().indexOf("ACCESS PARAMETERS") > -1) {
            string = this.lineFormatted.substring(this.lineFormatted.toUpperCase().indexOf("PARAMETERS") + 10);
            if (Token.startsWithString(string = Token.getStringBefore(string, "LOCATION").trim(), "USING CLOB")) {
                externalTableOraclev9i.setAccessParametersType("CLOB Subquery");
                string = Token.getStringAfter(string, "CLOB");
                externalTableOraclev9i.setClobSubquery(string);
            } else {
                string = Token.getValBetweenBrackets(string, 1).trim();
                externalTableOraclev9i.setAccessParametersType("Opaque Format Spec");
                externalTableOraclev9i.setOpaqueFormatSpec(string);
            }
        }
        string = Token.getStringAfter(this.statement, "LOCATION");
        string = Token.getValBetweenBrackets(string, 1).trim();
        string = Token.getValBetweenQuotationMarks(string);
        externalTableOraclev9i.setLocation(string);
    }

    private void initParallel(ExternalTableOraclev9i externalTableOraclev9i) {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            externalTableOraclev9i.setParallel("PARALLEL");
            String string = Token.getTokenAfter(this.statement, "PARALLEL");
            try {
                externalTableOraclev9i.setParallelNum(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong syntax near " + string);
                this.importLog.addWarning("Wrong PARALLEL format in statement " + this.statement);
            }
        }
    }

    private void initRejectLimit(ExternalTableOraclev9i externalTableOraclev9i) {
        if (Token.hasString(this.statement, "REJECT LIMIT")) {
            String string = Token.getStringAfter(this.statement, "REJECT LIMIT");
            if ((string = Token.getFirstToken(string)) != null && string.trim().equalsIgnoreCase("UNLIMITED")) {
                externalTableOraclev9i.setRejectLimit("UNLIMITED");
            } else {
                try {
                    Integer.parseInt(string);
                    externalTableOraclev9i.setRejectLimit(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Wrong syntax near " + string);
                    this.importLog.addWarning("Wrong REJECT LIMIT format in statement " + this.statement);
                }
            }
        }
    }
}

