/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RedoLogGroupOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseOraclev9i
extends DDLStatementHandler {
    private DataBaseOraclev9i database;
    private StorageDesignOraclev9i stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseOraclev9i.class);

    public SHCreateDatabaseOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create database")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateDatabaseOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.database = (DataBaseOraclev9i)this.stoDesign.getDataBaseSet().createDataBase();
            if (this.database != null) {
                String string2 = this.initDatabaseName();
                this.database.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(this.database);
                this.initUserSysPass();
                this.initUserSystemPass();
                this.initControlFileReuse();
                this.initLogFiles();
                this.initMaxLogFiles();
                this.initMaxLogHistory();
                this.initMaxDataFiles();
                this.initMaxInstances();
                this.initArchiveLog();
                this.initForceLogging();
                this.initCharacterSet();
                this.initNationalCharacterSet();
                this.initDataFiles();
                this.initTempTablespace();
                this.initUndoTablespace();
                this.initTimeZone();
            }
        }
    }

    private void initUserSysPass() {
        if (this.statement.toUpperCase().indexOf("USER SYS IDENTIFIED BY") > -1) {
            this.database.setPassForSYS(Token.getTokenAfter(this.statement, "USER SYS IDENTIFIED BY"));
        }
    }

    private void initUserSystemPass() {
        if (this.statement.toUpperCase().indexOf("USER SYSTEM IDENTIFIED BY") > -1) {
            this.database.setPassForSYSTEM(Token.getTokenAfter(this.statement, "USER SYSTEM IDENTIFIED BY"));
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private void initControlFileReuse() {
        if (Token.hasToken(this.statement, "CONTROLFILE")) {
            this.database.setControlFileReuse("YES");
        }
    }

    private void initLogFiles() {
        if (Token.hasToken(this.statement, "LOGFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "LOGFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                RedoLogGroupOraclev9i redoLogGroupOraclev9i = this.initRedoLogGroup(string2);
                redoLogGroupOraclev9i.setDataBase(this.database);
            }
        }
    }

    private RedoLogGroupOraclev9i initRedoLogGroup(String string) {
        if (!"".equalsIgnoreCase(string)) {
            RedoLogGroupOraclev9i redoLogGroupOraclev9i = (RedoLogGroupOraclev9i)this.stoDesign.getRedoLogGroupSet().createRedoLogGroup();
            String string2 = Token.getValBetweenQuotes(string);
            redoLogGroupOraclev9i.setFileName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(redoLogGroupOraclev9i);
            if (Token.hasToken(string, "SIZE")) {
                String string3 = Token.getTokenAfter(string, "SIZE").trim();
                try {
                    int n = Integer.parseInt(this.getNumberOnly(string3));
                    redoLogGroupOraclev9i.setSize(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev9i.initRedoLogGroup!", numberFormatException);
                    this.importLog.addWarning("Wrong redo log group SIZE format in statement " + this.statement);
                }
                String string4 = this.getMeasureUnit(string3, string);
                redoLogGroupOraclev9i.setMeasureUnit(string4);
            }
            if (Token.hasToken(string, "REUSE")) {
                redoLogGroupOraclev9i.setReuse("YES");
            } else {
                redoLogGroupOraclev9i.setReuse("NO");
            }
            return redoLogGroupOraclev9i;
        }
        return null;
    }

    private String getMeasureUnit(String string, String string2) {
        if (string.toUpperCase().endsWith("K")) {
            return "K";
        }
        if (string.toUpperCase().endsWith("M")) {
            return "M";
        }
        if (Token.getTokenAfter(string2, string).equalsIgnoreCase("K")) {
            return "K";
        }
        if (Token.getTokenAfter(string2, string).equalsIgnoreCase("M")) {
            return "M";
        }
        return "";
    }

    private void initMaxLogFiles() {
        if (Token.hasToken(this.statement, "MAXLOGFILES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGFILES"));
                this.database.setMaxLogFiles(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXLOGFILES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxLogFiles : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxLogHistory() {
        if (Token.hasToken(this.statement, "MAXLOGHISTORY")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGHISTORY"));
                this.database.setMaxLogHistory(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXLOGHISTORY format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxLogHistory : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxDataFiles() {
        if (Token.hasToken(this.statement, "MAXDATAFILES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXDATAFILES"));
                this.database.setMaxDataFiles(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXDATAFILES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxDataFiles : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxInstances() {
        if (Token.hasToken(this.statement, "MAXINSTANCES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXINSTANCES"));
                this.database.setMaxInstances(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXINSTANCES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxInstances : " + numberFormatException.getMessage());
            }
        }
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                DataFileOraclev9i dataFileOraclev9i = this.initDataFile(string2);
                dataFileOraclev9i.setDataBase(this.database);
            }
        }
    }

    private void initArchiveLog() {
        if (Token.hasToken(this.statement, "ARCHIVELOG")) {
            this.database.setArchiveLog("YES");
        } else {
            this.database.setArchiveLog("NO");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase().indexOf("FORCE LOGGING") > -1) {
            this.database.setForceLogging("YES");
        }
    }

    private void initCharacterSet() {
        if (Token.hasToken(this.statement, "CHARACTER") && !"NATIONAL".equalsIgnoreCase(Token.getTokenBefore(this.statement, "CHARACTER"))) {
            String string = Token.getTokenAfter(this.statement, "SET").trim();
            this.database.setCharacterSet(string);
        }
    }

    private void initNationalCharacterSet() {
        if (Token.hasToken(this.statement, "NATIONAL")) {
            String string = Token.getStringAfter(this.statement, "NATIONAL");
            String string2 = Token.getTokenAfter(string, "SET").trim();
            this.database.setNationalCharacterSet(string2);
        }
    }

    private void initTempTablespace() {
        if (this.statement.toUpperCase().indexOf("DEFAULT TEMPORARY TABLESPACE") > -1) {
            String string = Token.getQuotedNameAfterToken(this.statement, "DEFAULT TEMPORARY TABLESPACE");
            if (this.stoDesign.getTemporaryTablespaceSet().getByName(string) != null) {
                String[] stringArray;
                TemporaryTablespaceOraclev9i temporaryTablespaceOraclev9i = (TemporaryTablespaceOraclev9i)this.stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
                temporaryTablespaceOraclev9i.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(temporaryTablespaceOraclev9i);
                this.database.setTempTablespace(temporaryTablespaceOraclev9i);
                if (Token.hasToken(this.statement, "TEMPFILE")) {
                    stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                    String string2 = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        DataFileOraclev9i dataFileOraclev9i = this.initDataFile(string3);
                        dataFileOraclev9i.setTemporaryTablespace(temporaryTablespaceOraclev9i);
                    }
                }
                if (Token.hasToken(this.statement, "UNIFORM")) {
                    stringArray = Token.getStringAfterToken(this.statement, "UNIFORM");
                    stringArray = this.getNumberOnly(Token.getTokenAfter((String)stringArray, "SIZE").trim());
                    try {
                        temporaryTablespaceOraclev9i.setUniformSize(Long.parseLong((String)stringArray));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.importLog.addWarning("Wrong UNIFORM format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateDatabaseOraclev9i.initExtManagement : " + numberFormatException.getMessage());
                    }
                }
            }
        }
    }

    private DataFileOraclev9i initDataFile(String string) {
        if (!"".equalsIgnoreCase(string)) {
            String string2;
            String string3;
            DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)this.stoDesign.getDataFileSet().createDataFile();
            String string4 = Token.getValBetweenQuotes(string);
            dataFileOraclev9i.setFileName(string4);
            this.design.getRelationalDesign().stampModelObjectDDL(dataFileOraclev9i);
            if (Token.hasToken(string, "SIZE")) {
                string3 = Token.getTokenAfter(string, "SIZE").trim();
                try {
                    long l = Long.parseLong(this.getNumberOnly(string3));
                    dataFileOraclev9i.setSize(l);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev9i.initDataFile!", numberFormatException);
                }
                string2 = this.getMeasureUnit(string3, string);
                dataFileOraclev9i.setMeasureUnit(string2);
            }
            if (Token.hasToken(string, "REUSE")) {
                dataFileOraclev9i.setReuse("YES");
            } else {
                dataFileOraclev9i.setReuse("NO");
            }
            if (Token.hasToken(string, "AUTOEXTEND")) {
                string3 = Token.getTokenAfter(string, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string2 = Token.getTokenAfter(string, "NEXT").trim();
                        try {
                            int n = Integer.parseInt(this.getNumberOnly(string2));
                            dataFileOraclev9i.setNextBlockSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        dataFileOraclev9i.setMaxSize(this.getNumberOnly(Token.getTokenAfter(string, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("OFF");
                }
            }
            return dataFileOraclev9i;
        }
        return null;
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K") || string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void initUndoTablespace() {
        if (this.statement.toUpperCase().indexOf("UNDO TABLESPACE") > -1) {
            String string = Token.getQuotedNameAfterToken(this.statement, "UNDO TABLESPACE");
            if (this.stoDesign.getUndoTablespaceSet().getByName(string) != null) {
                UndoTablespaceOraclev9i undoTablespaceOraclev9i = (UndoTablespaceOraclev9i)this.stoDesign.getUndoTablespaceSet().createTablespace();
                undoTablespaceOraclev9i.setName(string);
                this.database.setUndoTablespace(undoTablespaceOraclev9i);
                this.design.getRelationalDesign().stampModelObjectDDL(undoTablespaceOraclev9i);
                if (Token.hasToken(this.statement, "TEMPFILE")) {
                    String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                    String string2 = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        DataFileOraclev9i dataFileOraclev9i = this.initDataFile(string3);
                        dataFileOraclev9i.setUndoTablespace(undoTablespaceOraclev9i);
                    }
                }
            }
        }
    }

    private void initTimeZone() {
        if (Token.hasToken(this.statement, "TIME_ZONE")) {
            String string = Token.getStringAfterToken(this.statement, "TIME_ZONE");
            if ((string = Token.cutFirstToken(string)).startsWith("'")) {
                this.database.setTimeZone(Token.getValBetweenQuotationMarks(string));
            }
        }
    }
}

