/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateContextOraclev9i
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateContextOraclev9i.class);

    public SHCreateContextOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateContextOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create context") || Token.startsWithString(string2, "create or replace context")) {
            try {
                this.parseContext(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle 9i failed!", exception);
                this.importLog.addFailedStatement(SHCreateContextOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseContext(String string) {
        ContextOraclev9i contextOraclev9i;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (contextOraclev9i = (ContextOraclev9i)storageDesignOracle.getContextSet().createContext()) != null) {
            this.initNamespace(contextOraclev9i);
            this.initPackage(contextOraclev9i);
            this.initOptions(contextOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(contextOraclev9i);
        }
    }

    private void initNamespace(ContextOraclev9i contextOraclev9i) {
        String string = Token.getQuotedNameAfterToken(this.statement, "CONTEXT").trim();
        contextOraclev9i.setName(string);
        contextOraclev9i.setNamespace(string);
    }

    private void initPackage(ContextOraclev9i contextOraclev9i) {
        String string = Token.getQuotedNameAfterToken(this.statement, "USING").trim();
        contextOraclev9i.setPackage(string);
    }

    private void initOptions(ContextOraclev9i contextOraclev9i) {
        if (Token.hasToken(this.statement, "INITIALIZED")) {
            String string = Token.getTokenAfter(this.statement, "INITIALIZED");
            contextOraclev9i.setInitialized(string);
        } else if (this.statement.toUpperCase().indexOf("ACCESSED GLOBALLY") > -1) {
            contextOraclev9i.setAccessedGlobally("YES");
        }
    }
}

