/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableOraclev9i
extends DDLStatementHandler {
    private Table table;
    private RDBMSSite site = null;
    private StorageDesignOraclev9i storageDesign = null;
    private FKIndexAssociation fkass = null;
    private String name = "";
    private String line;
    private static final Logger LOGGER = new Logger(SHAlterTableOraclev9i.class);

    public SHAlterTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterTableOraclev9i.clearCR(string);
        this.line = string;
        this.statement = string2;
        if (Token.startsWithString(string2, "ALTER TABLE")) {
            this.parseAlterTable(string2);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseAlterTable(String string) {
        try {
            this.initTable();
            if (this.table != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
                String[] stringArray = string.split(" ADD ");
                if (stringArray.length == 1) {
                    stringArray = string.split(" add ");
                }
                Iterator<String> iterator = Arrays.asList(stringArray).iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next().trim();
                    int n = 0;
                    if (string2.startsWith("(")) {
                        n = 1;
                        int n2 = 0;
                        while (n2 > -1) {
                            n2 = string2.indexOf(44, n);
                            while (n2 > -1 && Token.hasOpenBracketNoClose(string2.substring(n, n2))) {
                                n2 = string2.indexOf(44, n2 + 1);
                            }
                            if (n2 <= -1) continue;
                            this.processClause(string2.substring(n, n2));
                            n = n2 + 1;
                        }
                    }
                    this.processClause(string2.substring(n));
                }
                this.importLog.incrementImportedStatements();
            }
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(SHAlterTableOraclev9i.FormatCR(this.line, "\n"));
        }
    }

    private void processClause(String string) {
        if (this.isPK(string)) {
            this.initPK(string);
        } else if (this.isUK(string)) {
            this.initUK(string);
        } else if (this.isFK(string)) {
            this.parseFK(string);
        } else if (this.isCheck(string)) {
            this.initCheck(string);
        } else if (this.modify(string)) {
            this.parseFK(string);
        }
    }

    public void parseFK(String string) {
        this.fkass = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        this.statement = string;
        int n = string.toUpperCase().indexOf("CONSTRAINT");
        if (n < 0) {
            n = string.toUpperCase().indexOf("FOREIGN");
        }
        if (n > -1) {
            String string2 = string.substring(n);
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                RelationalContainerProxy relationalContainerProxy;
                Object object;
                Table table;
                String string4;
                Object object2;
                string3 = stringTokenizer.nextToken().trim();
                while (Token.hasOpenBracketNoClose(string3) && stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + ", " + stringTokenizer.nextToken().trim();
                }
                if (this.table == null) continue;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
                if (this.isFK(string3)) {
                    this.initForeignKey(string3);
                    if (this.storageDesign == null || (object2 = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getByName(this.name)) == null) continue;
                    if (Token.hasToken(string3, "DEFERRABLE")) {
                        boolean bl = Token.getTokenBefore(string3, "DEFERRABLE").equalsIgnoreCase("NOT");
                        ((FKProxyOracle)object2).setDeferrable(bl ? "NO" : "YES");
                    }
                    if (Token.hasToken(string3, "INITIALLY")) {
                        String string5 = Token.getTokenAfter(string3, "INITIALLY").toUpperCase();
                        ((FKProxyOracle)object2).setInitially(string5);
                    }
                    if (Token.hasToken(string3, "DISABLE")) {
                        ((FKProxyOracle)object2).setEnable("NO");
                        ((FKProxyOracle)object2).setValidate(Token.hasToken(string3, "VALIDATE") ? "YES" : "NO");
                    } else {
                        ((FKProxyOracle)object2).setEnable("YES");
                        ((FKProxyOracle)object2).setValidate(Token.hasToken(string3, "NOVALIDATE") ? "NO" : "YES");
                    }
                    if (!Token.hasToken(string3, "INTO")) continue;
                    String string6 = Token.getQuotedNameAfterToken(string3, "INTO");
                    string4 = this.getNameOnly(string6);
                    table = null;
                    object = Token.getValBeforeCharacter(string6, '.');
                    string4 = Token.removeQuotes(string4);
                    if (object != null && !"".equals(object)) {
                        object = Token.removeQuotes((String)object);
                        table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName((String)object, string4);
                    }
                    if (table == null) {
                        table = this.getTableFor(string4);
                    }
                    if (table == null || (relationalContainerProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) == null) continue;
                    ((FKProxyOracle)object2).setExceptionsTable((TableProxyOracle)relationalContainerProxy);
                    continue;
                }
                if (!this.modify(string) || this.storageDesign == null) continue;
                object2 = Token.getQuotedNameAfterToken(string3, "CONSTRAINT");
                TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
                string4 = this.getNameOnly(Token.getQuotedNameAfterToken(string3, "INTO"));
                table = this.getTableFor(string4);
                object = null;
                if (table != null) {
                    object = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                }
                if ((relationalContainerProxy = (PKProxyOracle)this.storageDesign.getPKProxySet().getByName((String)object2)) != null) {
                    if (object == null) continue;
                    relationalContainerProxy.setExceptionsTable((TableProxyOracle)object);
                    continue;
                }
                UniqueOracle uniqueOracle = (UniqueOracle)this.storageDesign.getUniqueSet().getByName((String)object2);
                if (uniqueOracle != null) {
                    if (object == null) continue;
                    uniqueOracle.setExceptionsTable((TableProxyOracle)object);
                    continue;
                }
                ColumnProxyOracle columnProxyOracle = this.getColumnPrByNNCoinstraintName(tableProxy, (String)object2);
                if (columnProxyOracle == null) continue;
                columnProxyOracle.setNncExceptionsTable((TableProxyOracle)object);
            }
        }
    }

    private ColumnProxyOracle getColumnPrByNNCoinstraintName(TableProxy tableProxy, String string) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            String string2;
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            String string3 = string2 = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return (ColumnProxyOracle)columnProxyArray[i];
        }
        return null;
    }

    private boolean isFK(String string) {
        return Token.hasToken(string, "FOREIGN");
    }

    private boolean modify(String string) {
        return Token.hasString(string, "MODIFY CONSTRAINT");
    }

    private void initTable() throws ObjectDoesNotExistException {
        this.table = null;
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String string2 = this.getNameFor(string);
        String string3 = Token.getValBeforeCharacter(string, '.');
        if (string3 != null && !"".equals(string3)) {
            this.table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string3, string2);
        }
        if (this.table == null) {
            this.table = this.getTableFor(string2);
        }
        if (this.table == null) {
            this.importLog.addError("Table with name " + string + " does not exist.");
            throw new ObjectDoesNotExistException("Table with name " + string);
        }
    }

    private void initForeignKey(String string) {
        boolean bl = false;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        String string2 = string;
        bl = Token.hasToken(string2, "FOREIGN");
        while (bl) {
            String string3;
            int n = string2.toUpperCase().indexOf("FOREIGN");
            String string4 = string2.substring(n);
            String string5 = "FK_ASS";
            if (Token.hasToken(string2, "CONSTRAINT")) {
                string5 = Token.getQuotedNameAfterToken(string2, "CONSTRAINT");
            } else {
                String string6 = this.table.getName();
                if (string6.length() > 25) {
                    string6 = string6.substring(0, 25);
                }
                string5 = string6 + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = string5;
            int n2 = string4.indexOf(41);
            String string7 = string4.substring(0, n2 + 1).trim();
            String string8 = Token.getValBetweenBrackets(string7);
            List list = this.getColumnNames(string8);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column[] columnArray = (Column[])this.table.getElements();
            for (String string9 : list) {
                for (int i = 0; i < columnArray.length; ++i) {
                    string3 = columnArray[i].getName().trim();
                    if (!string9.equalsIgnoreCase(string3)) continue;
                    arrayList.add(columnArray[i]);
                }
            }
            int n3 = string4.toUpperCase().indexOf("REFERENCES");
            string4 = string4.substring(n3);
            String string10 = Token.getNameAfterToken(string4, "REFERENCES", '\"', '\"').trim();
            string3 = Token.getValBeforeCharacter(string10, '.');
            String string11 = this.getNameFor(string10);
            string11 = Token.removeQuotes(string11);
            Table table = null;
            if (string3 != null && !"".equals(string3)) {
                string3 = Token.removeQuotes(string3);
                table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string3, string11);
            }
            if (table == null) {
                table = this.getTableFor(string11);
            }
            if (table != null) {
                Object object;
                Object object2;
                Object object3;
                boolean bl2 = Token.hasString(string4, "(");
                if (bl2) {
                    object3 = Token.getValBetweenBrackets(string4, 1);
                    object2 = this.getColumnNames((String)object3);
                    FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object = this.getUniqueIndexForColumnNames(table, (List)object2);
                    if (object != null) {
                        this.fkass = this.table.addFK((KeyObject)object, null, fKIndexAssociationReference);
                        this.fkass.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                        this.fkass.getLocalFKIndex().setName(string5);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns(this.fkass, arrayList, (Index)object);
                        } else {
                            this.fixFKColumns(this.fkass, arrayList, (Index)object);
                        }
                        boolean bl3 = Token.hasToken(string4, "DELETE");
                        if (bl3) {
                            String string12 = Token.getTokenAfter(string4, "DELETE");
                            if (string12.equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").equalsIgnoreCase("ACTION")) {
                                    string12 = "NO ACTION";
                                }
                            } else if (string12.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").equalsIgnoreCase("NULL")) {
                                string12 = "SET NULL";
                            }
                            String[] stringArray = this.fkass.getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!string12.equalsIgnoreCase(stringArray[i])) continue;
                                this.fkass.setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                } else {
                    object3 = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object2 = (Index)table.getPK();
                    if (object2 != null) {
                        this.fkass = this.table.addFK((KeyObject)object2, null, (FKIndexAssociationReference)object3);
                        this.fkass.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                        this.fkass.getLocalFKIndex().setName(string5);
                        this.replaceAllColumns(this.fkass, arrayList, (Index)object2);
                        boolean bl4 = Token.hasToken(string4, "DELETE");
                        if (bl4) {
                            object = Token.getTokenAfter(string4, "DELETE");
                            if (((String)object).equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").equalsIgnoreCase("ACTION")) {
                                    object = "NO ACTION";
                                }
                            } else if (((String)object).equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").equalsIgnoreCase("NULL")) {
                                object = "SET NULL";
                            }
                            String[] stringArray = this.fkass.getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!((String)object).equalsIgnoreCase(stringArray[i])) continue;
                                this.fkass.setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                }
            } else {
                String string13 = "Referenced table " + string11 + " doesn't exist\n" + this.statement;
                this.importLog.addError(string13);
            }
            string2 = string4;
            bl = Token.hasToken(string2, "FOREIGN");
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.getName(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n;
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40)).trim();
        }
        if ((n = string.indexOf(46)) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        string = Token.getName(string);
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        string = Token.getName(string);
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String string) {
        Column column = null;
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column2 = columnArray[i];
            if (!column2.getName().equalsIgnoreCase(string)) continue;
            column = column2;
            break;
        }
        return column;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Column[] columnArray;
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Column[] columnArray2 = (Column[])index.getElements();
        if (columnArray2.length != list.size()) {
            columnArray = new StringBuffer();
            columnArray.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(columnArray.toString());
            this.importLog.addError(columnArray.toString());
        }
        columnArray = list.toArray(new Column[0]);
        fKIndexAssociation.swapFKColumnsWith(columnArray);
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isPK(String string) {
        return string.toUpperCase().indexOf("PRIMARY KEY") > -1;
    }

    private void initPK(String string) {
        Object object;
        String string2 = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string2 = Token.getQuotedNameAfterToken(string, "CONSTRAINT");
        } else {
            object = this.table.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_PK";
        }
        object = null;
        String string3 = Token.getValBetweenBrackets(Token.getStringAfter(string, "PRIMARY KEY"), 1).trim();
        List list = this.getColumnNames(string3);
        if (list.size() > 0) {
            Object object22;
            object = this.table.createIndex();
            for (Object object22 : list) {
                Column column = this.getColumnFor(this.table, (String)object22);
                if (column == null) continue;
                ((Index)object).add(column);
            }
            ((KeyObject)object).makePK();
            if (string2 != null) {
                ((DesignObject)object).setName(string2);
            }
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            object22 = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(((ModelIDObject)object).getObjectID());
            boolean bl = Token.hasString(string, "PRIMARY KEY");
            if (bl && object22 != null) {
                String string4;
                if (Token.hasToken(string, "DEFERRABLE")) {
                    ((PKProxyOracle)object22).setDeferrable("YES");
                }
                if (Token.hasToken(string, "INITIALLY")) {
                    string4 = Token.getTokenAfter(string, "INITIALLY");
                    ((PKProxyOracle)object22).setInitially(string4);
                }
                if (Token.hasToken(string, "DISABLE")) {
                    ((PKProxyOracle)object22).setEnable("NO");
                    ((PKProxyOracle)object22).setValidate(Token.hasToken(string, "VALIDATE") ? "YES" : "NO");
                }
                if (Token.hasToken(string, "NOVALIDATE")) {
                    ((PKProxyOracle)object22).setValidate("NO");
                }
                if (Token.hasString(string, "USING INDEX")) {
                    Object object3;
                    String string5;
                    String string6;
                    Object object4;
                    string4 = Token.getStringAfter(string, "USING INDEX");
                    String string7 = Token.getFirstToken(string4);
                    if (string7.equalsIgnoreCase("LOCAL")) {
                        ((PKProxyOraclev9i)object22).setUsingIndex("LOCAL PARTITIONED");
                    } else if (string7.equalsIgnoreCase("GLOBAL")) {
                        ((PKProxyOraclev9i)object22).setUsingIndex("GLOBAL PARTITIONED");
                        object4 = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                        ((PKProxyOraclev9i)object22).setIndexGlobalPL((IndexGlobalPartitionsListOracle)object4);
                        ((IndexGlobalPartitionsListOracle)object4).setIndex((IndexProxy)object22);
                        string6 = Token.getStringAfter(string, "GLOBAL PARTITION BY RANGE");
                        string5 = Token.getValBetweenBrackets(string6);
                        if (Token.hasToken(string5, ")")) {
                            string5 = Token.getStringBefore(string5, ")");
                        }
                        ((IndexGlobalPartitionsListOracle)object4).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)object4).columnNamesToColumnIDs(string5));
                    } else if (string7.equalsIgnoreCase("(")) {
                        ((PKProxyOraclev9i)object22).setUsingIndex("BY CREATE INDEX STATEMENT");
                        ((PKProxyOraclev9i)object22).setCreateIndexStatement(Token.getValBetweenBrackets(string4));
                    } else {
                        ((PKProxyOraclev9i)object22).setUsingIndex("BY INDEX NAME");
                        if (string7.equalsIgnoreCase("PCTFREE")) {
                            ((PKProxyOracle)object22).setExistingIndex(null);
                        } else {
                            object4 = Token.getFirstName(string4, '\"', '\"');
                            string6 = this.getNameFor((String)object4);
                            string5 = Token.getValBeforeCharacter((String)object4, '.');
                            object3 = this.table.getIndexByNameAndSchema(string5, string6);
                            if (object3 == null) {
                                this.table.getIndexByName(string6);
                            }
                            if (object3 != null) {
                                IndexProxyOracle indexProxyOracle = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object3).getObjectID());
                                ((PKProxyOracle)object22).setExistingIndex(indexProxyOracle);
                            }
                        }
                    }
                    if (((PKProxyOracle)object22).getExistingIndex() == null && !((PKProxyOraclev9i)object22).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        Object object5;
                        Object object6;
                        String string8;
                        boolean bl2;
                        String string9;
                        object4 = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                        string6 = Token.getTokenAfter(string4, "PCTFREE");
                        if (!"".equalsIgnoreCase(string6)) {
                            try {
                                int n = Integer.parseInt(string6);
                                ((SegmentOracle)object4).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string9 = Token.getTokenAfter(string4, "INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string9);
                                ((SegmentOracle)object4).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase((String)(object3 = Token.getTokenAfter(string4, "MAXTRANS")))) {
                            try {
                                int n = Integer.parseInt((String)object3);
                                ((SegmentOracle)object4).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl2 = Token.hasToken(string4, "STORAGE")) {
                            String string10;
                            String string11;
                            String string12;
                            String string13;
                            String string14;
                            string8 = Token.getStringAfter(string4, "STORAGE");
                            object6 = Token.getTokenAfter(string8, "INITIALLY");
                            if (!"".equalsIgnoreCase((String)object6)) {
                                try {
                                    long l = Long.parseLong((String)object6);
                                    ((SegmentOracle)object4).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object5 = Token.getTokenAfter(string8, "NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object5);
                                    ((SegmentOracle)object4).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string14 = Token.getTokenAfter(string8, "PCTINCREASE"))) {
                                try {
                                    int n = Integer.parseInt(string14);
                                    ((SegmentOracle)object4).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string13 = Token.getTokenAfter(string8, "MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string13);
                                    ((SegmentOracle)object4).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string12 = Token.getTokenAfter(string8, "MAXEXTENTS"))) {
                                ((SegmentOracle)object4).setSCMaxExtents(string12);
                            }
                            if (!"".equalsIgnoreCase(string11 = Token.getTokenAfter(string8, "FREELISTS"))) {
                                try {
                                    int n = Integer.parseInt(string11);
                                    ((SegmentOracle)object4).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string10 = Token.getTokenAfter(string8, "GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string10);
                                    ((SegmentOracle)object4).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string15 = Token.getQuotedNameAfterToken(string8, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string10)) {
                                ((SegmentOracle)object4).setSCBufferPool(string15);
                            }
                        }
                        if (!(string8 = Token.getQuotedNameAfterToken(string4, "TABLESPACE")).equalsIgnoreCase("")) {
                            object6 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string8);
                            if (object6 == null && !"SYSTEM".equalsIgnoreCase(string8)) {
                                object6 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object6).setName(string8);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                            }
                            if (object6 != null) {
                                ((PKProxyOracle)object22).setTableSpace((TableSpaceOracle)object6);
                            }
                        }
                        if (Token.hasToken(string4, "NOSORT")) {
                            ((PKProxyOraclev9i)object22).setIndexSort("NO");
                        } else if (Token.hasToken(string4, "REVERSE")) {
                            ((PKProxyOraclev9i)object22).setIndexSort("REVERSE");
                        } else {
                            ((PKProxyOraclev9i)object22).setIndexSort("SORTED");
                        }
                        if (Token.hasToken(string4, "NOLOGGING")) {
                            ((PKProxyOracle)object22).setLogging("NO");
                        } else if (Token.hasToken(string4, "LOGGING")) {
                            ((PKProxyOracle)object22).setLogging("YES");
                        } else {
                            ((PKProxyOracle)object22).setLogging("");
                        }
                        boolean bl3 = Token.hasString(string4, "COMPUTE STATISTICS");
                        if (bl3) {
                            ((PKProxyOraclev9i)object22).setComputeStatistics("YES");
                        } else {
                            ((PKProxyOraclev9i)object22).setComputeStatistics("NO");
                        }
                        object5 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)object4);
                        ((PKProxyOracle)object22).setIndexSegment((SegmentOracle)object5);
                    }
                }
            }
        }
    }

    private boolean isUK(String string) {
        return string.toUpperCase().indexOf("UNIQUE") > -1;
    }

    private void initUK(String string) {
        Object object;
        String string2 = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string2 = Token.getQuotedNameAfterToken(string, "CONSTRAINT");
        } else {
            object = this.table.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_UK" + this.table.getUKeys().size();
        }
        object = null;
        String string3 = Token.getValBetweenBrackets(Token.getStringAfter(string, "UNIQUE"), 1).trim();
        List list = this.getColumnNames(string3);
        if (list.size() > 0) {
            Object object2;
            Object object32;
            object = this.table.createIndex();
            for (Object object32 : list) {
                object2 = this.getColumnFor(this.table, (String)object32);
                if (object2 == null) continue;
                ((Index)object).add((ContainedObject)object2);
            }
            ((KeyObject)object).setUnique(true);
            if (string2 != null) {
                ((DesignObject)object).setName(string2);
            }
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            object32 = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(((ModelIDObject)object).getObjectID());
            if (object32 != null) {
                if (Token.hasToken(string, "DEFERRABLE")) {
                    ((UniqueOracle)object32).setDeferrable("YES");
                }
                if (Token.hasToken(string, "INITIALLY")) {
                    object2 = Token.getTokenAfter(string, "INITIALLY");
                    ((UniqueOracle)object32).setInitially((String)object2);
                }
                if (Token.hasToken(string, "DISABLE")) {
                    ((UniqueOracle)object32).setEnable("NO");
                    ((UniqueOracle)object32).setValidate(Token.hasToken(string, "VALIDATE") ? "YES" : "NO");
                }
                if (Token.hasToken(string, "NOVALIDATE")) {
                    ((UniqueOracle)object32).setValidate("NO");
                }
                if (Token.hasString(string, "USING INDEX")) {
                    Object object4;
                    String string4;
                    String string5;
                    Object object5;
                    object2 = Token.getStringAfter(string, "USING INDEX");
                    String string6 = Token.getFirstToken((String)object2);
                    if (string6.equalsIgnoreCase("LOCAL")) {
                        ((UniqueOraclev9i)object32).setUsingIndex("LOCAL PARTITIONED");
                    } else if (string6.equalsIgnoreCase("GLOBAL")) {
                        ((UniqueOraclev9i)object32).setUsingIndex("GLOBAL PARTITIONED");
                        object5 = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                        ((UniqueOracle)object32).setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)object5);
                        ((IndexGlobalPartitionsListOracle)object5).setIndex((IndexProxy)object32);
                        string5 = Token.getStringAfter(string, "GLOBAL PARTITION BY RANGE");
                        string4 = Token.getStringAfter(string5, "(");
                        if (Token.hasToken(string4, ")")) {
                            string4 = Token.getStringBefore(string4, ")");
                        }
                        ((IndexGlobalPartitionsListOracle)object5).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)object5).columnNamesToColumnIDs(string4));
                    } else if (string6.equalsIgnoreCase("(")) {
                        ((UniqueOraclev9i)object32).setUsingIndex("BY CREATE INDEX STATEMENT");
                        ((UniqueOraclev9i)object32).setCreateIndexStatement(Token.getValBetweenBrackets((String)object2));
                    } else {
                        ((UniqueOraclev9i)object32).setUsingIndex("BY INDEX NAME");
                        if (string6.equalsIgnoreCase("PCTFREE")) {
                            ((UniqueOracle)object32).setExistingIndex(null);
                        } else {
                            object5 = Token.getFirstName((String)object2, '\"', '\"');
                            string5 = this.getNameFor((String)object5);
                            string4 = Token.getValBeforeCharacter((String)object5, '.');
                            object4 = this.table.getIndexByNameAndSchema(string4, string5);
                            if (object4 == null) {
                                this.table.getIndexByName(string5);
                            }
                            if (object4 != null) {
                                IndexProxyOracle indexProxyOracle = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object4).getObjectID());
                                ((UniqueOracle)object32).setExistingIndex(indexProxyOracle);
                            }
                        }
                    }
                    if (((UniqueOracle)object32).getExistingIndex() == null && !((UniqueOraclev9i)object32).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        Object object6;
                        Object object7;
                        String string7;
                        boolean bl;
                        String string8;
                        object5 = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                        string5 = Token.getTokenAfter((String)object2, "PCTFREE");
                        if (!"".equalsIgnoreCase(string5)) {
                            try {
                                int n = Integer.parseInt(string5);
                                ((SegmentOracle)object5).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string8 = Token.getTokenAfter((String)object2, "INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string8);
                                ((SegmentOracle)object5).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase((String)(object4 = Token.getTokenAfter((String)object2, "MAXTRANS")))) {
                            try {
                                int n = Integer.parseInt((String)object4);
                                ((SegmentOracle)object5).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl = Token.hasToken((String)object2, "STORAGE")) {
                            String string9;
                            String string10;
                            String string11;
                            String string12;
                            String string13;
                            string7 = Token.getStringAfter((String)object2, "STORAGE");
                            object7 = Token.getTokenAfter(string7, "INITIALLY");
                            if (!"".equalsIgnoreCase((String)object7)) {
                                try {
                                    long l = Long.parseLong((String)object7);
                                    ((SegmentOracle)object5).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object6 = Token.getTokenAfter(string7, "NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object6);
                                    ((SegmentOracle)object5).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string13 = Token.getTokenAfter(string7, "PCTINCREASE"))) {
                                try {
                                    int n = Integer.parseInt(string13);
                                    ((SegmentOracle)object5).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string12 = Token.getTokenAfter(string7, "MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string12);
                                    ((SegmentOracle)object5).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string11 = Token.getTokenAfter(string7, "MAXEXTENTS"))) {
                                ((SegmentOracle)object5).setSCMaxExtents(string11);
                            }
                            if (!"".equalsIgnoreCase(string10 = Token.getTokenAfter(string7, "FREELISTS"))) {
                                try {
                                    int n = Integer.parseInt(string10);
                                    ((SegmentOracle)object5).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string9 = Token.getTokenAfter(string7, "GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string9);
                                    ((SegmentOracle)object5).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string14 = Token.getQuotedNameAfterToken(string7, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string9)) {
                                ((SegmentOracle)object5).setSCBufferPool(string14);
                            }
                        }
                        if (!(string7 = Token.getQuotedNameAfterToken((String)object2, "TABLESPACE")).equalsIgnoreCase("")) {
                            object7 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string7);
                            if (object7 == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                object7 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object7).setName(string7);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object7);
                            }
                            if (object7 != null) {
                                ((UniqueOracle)object32).setTableSpace((TableSpaceOracle)object7);
                            }
                        }
                        if (Token.hasToken((String)object2, "NOSORT")) {
                            ((UniqueOraclev9i)object32).setIndexSort("NO");
                        } else if (Token.hasToken((String)object2, "REVERSE")) {
                            ((UniqueOraclev9i)object32).setIndexSort("REVERSE");
                        } else {
                            ((UniqueOraclev9i)object32).setIndexSort("SORTED");
                        }
                        if (Token.hasToken((String)object2, "NOLOGGING")) {
                            ((UniqueOracle)object32).setLogging("NO");
                        } else if (Token.hasToken((String)object2, "LOGGING")) {
                            ((UniqueOracle)object32).setLogging("YES");
                        } else {
                            ((UniqueOracle)object32).setLogging("");
                        }
                        boolean bl2 = Token.hasString((String)object2, "COMPUTE STATISTICS");
                        if (bl2) {
                            ((UniqueOraclev9i)object32).setComputeStatistics("YES");
                        } else {
                            ((UniqueOraclev9i)object32).setComputeStatistics("NO");
                        }
                        object6 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)object5);
                        ((UniqueOracle)object32).setIndexSegment((SegmentOracle)object6);
                    }
                }
            }
        }
    }

    private boolean isCheck(String string) {
        return string.toUpperCase().indexOf("CHECK") > -1;
    }

    private Column getColumnForConstr(Table table, String string) {
        String string2 = string.toUpperCase();
        ContainedObject[] containedObjectArray = table.getElements();
        Column column = null;
        boolean bl = false;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            column = (Column)containedObjectArray[i];
            String string3 = column.getName().toUpperCase();
            if (string2.indexOf(string3) <= -1) continue;
            bl = true;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string4;
                Column column2 = (Column)containedObjectArray[j];
                if (column == column2 || string2.indexOf(string4 = column2.getName().toUpperCase()) <= -1) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return column;
        }
        return null;
    }

    private void initCheck(String string) {
        ModelObject modelObject;
        ModelIDObject modelIDObject;
        String string2;
        this.statement = string;
        String string3 = null;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            string3 = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT");
        } else {
            string2 = this.table.getName();
            if (string2.length() > 25) {
                string2 = string2.substring(0, 25);
            }
            string3 = string2 + "_CK" + this.table.getCheckConstraints().size();
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        try {
            modelIDObject = this.getColumnForConstr(this.table, string2);
            if (modelIDObject != null && (modelObject = ((Column)modelIDObject).getCheck()) == null) {
                CheckConstraint checkConstraint = new CheckConstraint();
                RDBMSTypeSet rDBMSTypeSet = this.table.getDesign().getRDBMSTypeSet();
                Iterator iterator = rDBMSTypeSet.iterator();
                while (iterator.hasNext()) {
                    RDBMSType rDBMSType = (RDBMSType)iterator.next();
                    if (rDBMSType != StorageDesignOraclev9i.RDBMS_TYPE) continue;
                    checkConstraint.add(rDBMSType, string2);
                }
                ((ContainedObjectWithDomain)modelIDObject).setUseDomainConstraints(false);
                ((Column)modelIDObject).setCheck(checkConstraint);
                ((ContainedObject)modelIDObject).setConstraintName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(checkConstraint);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        modelIDObject = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        modelObject = this.table.createCheckConstraint(string3, string2);
        this.table.addCheckConstraint((TableLevelConstraint)modelObject);
        this.design.getRelationalDesign().stampModelObjectDDL(modelObject);
        TableCheckConstraintOracle tableCheckConstraintOracle = ((TableProxyOracle)modelIDObject).getTableConstraint((TableLevelConstraint)modelObject);
        if (tableCheckConstraintOracle != null) {
            if (Token.hasToken(this.statement, "DEFERRABLE")) {
                boolean bl = Token.getTokenBefore(this.statement, "DEFERRABLE").equalsIgnoreCase("NOT");
                tableCheckConstraintOracle.setDeferrable(bl ? "NO" : "YES");
            }
            if (Token.hasToken(this.statement, "INITIALLY")) {
                String string4 = Token.getTokenAfter(this.statement, "INITIALLY").trim();
                tableCheckConstraintOracle.setInitially(string4);
            }
            if (Token.hasToken(this.statement, "DISABLE")) {
                tableCheckConstraintOracle.setEnable("NO");
                tableCheckConstraintOracle.setValidate(Token.hasToken(this.statement, "VALIDATE") ? "YES" : "NO");
            } else {
                tableCheckConstraintOracle.setEnable("YES");
                tableCheckConstraintOracle.setValidate(Token.hasToken(this.statement, "NOVALIDATE") ? "NO" : "YES");
            }
            if (Token.hasToken(this.statement, "INTO")) {
                TableProxyOracle tableProxyOracle;
                String string5 = Token.getQuotedNameAfterToken(this.statement, "INTO");
                String string6 = this.getNameOnly(string5);
                Table table = null;
                String string7 = Token.getValBeforeCharacter(string5, '.');
                string6 = Token.removeQuotes(string6);
                if (string7 != null && !"".equals(string7)) {
                    string7 = Token.removeQuotes(string7);
                    table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string6);
                }
                if (table == null) {
                    table = this.getTableFor(string6);
                }
                if (table != null && (tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
                    tableCheckConstraintOracle.setExceptionsTable(tableProxyOracle);
                }
            }
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }
}

