/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHColumnElementsOraclev9i;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;

public class DomainHandlerReadDDLOraclev9i
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;

    public DomainHandlerReadDDLOraclev9i(Design design) {
        this.design = design;
    }

    public void createDomains(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = DDLStatementHandler.clearCR((String)iterator.next());
            if (!Token.startsWithString(string, "create table") && !Token.startsWithString(string, "create global temporary table")) continue;
            ArrayList arrayList = this.getColumns(string);
            for (String string2 : arrayList) {
                this.createOneDomain(string2);
            }
        }
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracket(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString();
                }
            }
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        SHColumnElementsOraclev9i sHColumnElementsOraclev9i = new SHColumnElementsOraclev9i();
        Map map = sHColumnElementsOraclev9i.getElementsColumn(string);
        String string2 = (String)map.get("columnname");
        if (!"".equalsIgnoreCase(string2)) {
            String string3 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
            if (string3 != null) {
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                string4 = StandardDatatypeNames.getTransformedDatatypeName(string4, StorageDesignOraclev9i.RDBMS_TYPE);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignOraclev9i.RDBMS_TYPE, string4);
                this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
            }
        }
    }
}

