/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.MethodProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TypeElementProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTypeOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTypeOraclev10g.class);
    private StorageDesignOracle storageDesign;

    public SHCreateTypeOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        this.statement = SHCreateTypeOraclev10g.clearCR(string);
        if (Token.startsWithString(this.statement, "create type") || Token.startsWithString(this.statement, "create or replace type")) {
            try {
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
                if (Token.startsWithString(this.statement, "create type body") || Token.startsWithString(this.statement, "create or replace type body")) {
                    this.parseTypeBody();
                } else {
                    this.parseType();
                }
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + this.statement + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateTypeOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseType() {
        if (this.storageDesign != null) {
            StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g;
            StructuredType structuredType;
            String string = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            String string2 = null;
            String string3 = string;
            int n = string3.indexOf(46);
            if (n > 0) {
                string2 = Token.getValBeforeCharacter(string, '.');
                string3 = Token.getValAfterCharacter(string, '.');
            }
            if (this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string3) != null) {
                structuredType = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string3);
                this.storageDesign.getStructuredTypeProxySet().add(structuredType);
                structuredTypeProxyOraclev10g = (StructuredTypeProxyOraclev10g)this.storageDesign.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            } else {
                structuredType = this.design.getDataTypesDesign().createStructuredType();
                structuredType.setName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(structuredType);
                structuredTypeProxyOraclev10g = (StructuredTypeProxyOraclev10g)this.storageDesign.getProxy(structuredType);
                if (structuredTypeProxyOraclev10g != null && string2 != null) {
                    UserOraclev10g userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().getByName(string2);
                    if (userOraclev10g == null) {
                        userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                        userOraclev10g.setName(string2);
                        this.design.getRelationalDesign().stampModelObjectDDL(userOraclev10g);
                    }
                    structuredTypeProxyOraclev10g.setOwner(userOraclev10g);
                }
            }
            if (structuredTypeProxyOraclev10g != null) {
                this.initInvokerRights(structuredTypeProxyOraclev10g);
                this.initOid(structuredTypeProxyOraclev10g);
                this.initElementList(structuredType, structuredTypeProxyOraclev10g);
            }
        }
    }

    private void initInvokerRights(StructuredTypeProxyOracle structuredTypeProxyOracle) {
        String string;
        if (Token.hasToken(this.statement, "AUTHID") && !"".equalsIgnoreCase(string = Token.getTokenAfter(this.statement, "AUTHID"))) {
            if (string.equalsIgnoreCase("CURRENT_USER")) {
                structuredTypeProxyOracle.setInvokerRights("CURRENT_USER");
            } else if (string.equalsIgnoreCase("DEFINER")) {
                structuredTypeProxyOracle.setInvokerRights("DEFINER");
            }
        }
    }

    private void initOid(StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g) {
        if (Token.hasToken(this.statement, "OID")) {
            String string = Token.getStringAfterToken(this.statement, "OID");
            string = Token.getValBetweenQuotes(string);
            structuredTypeProxyOraclev10g.setGlobalOid(string);
        }
    }

    private String initMethod(StructuredType structuredType, String string, String[] stringArray) {
        CharSequence charSequence;
        Object object;
        Object object2;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = "NO";
        String string7 = "NO";
        String string8 = "YES";
        boolean bl = false;
        boolean bl2 = false;
        String string9 = "NO";
        StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g = (StructuredTypeProxyOraclev10g)this.storageDesign.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
        boolean bl3 = true;
        while (bl3) {
            string5 = "YES";
            if (string.toUpperCase().startsWith("NOT")) {
                string = Token.cutFirstToken2(string);
                string5 = "NO";
            }
            if ((string4 = string.toUpperCase()).startsWith("OVERRIDING")) {
                string = Token.cutFirstToken2(string);
                string6 = string5;
                continue;
            }
            if (string4.startsWith("FINAL")) {
                string = Token.cutFirstToken2(string);
                string7 = string5;
                continue;
            }
            if (string4.startsWith("INSTANTIABLE")) {
                string = Token.cutFirstToken2(string);
                string8 = string5;
                continue;
            }
            bl3 = false;
        }
        if (Token.startsWithString(string, "STATIC")) {
            string9 = "YES";
            string = Token.cutFirstToken2(string);
        } else {
            if (string.toUpperCase().startsWith("MAP")) {
                structuredTypeProxyOraclev10g.setMapOrderType("MAP");
                bl2 = true;
                string = Token.cutFirstToken2(string);
            } else if (string.toUpperCase().startsWith("ORDER")) {
                structuredTypeProxyOraclev10g.setMapOrderType("ORDER");
                bl2 = true;
                string = Token.cutFirstToken2(string);
            }
            if (Token.startsWithString(string, "MEMBER")) {
                string = Token.cutFirstToken2(string);
            }
        }
        if (Token.getFirstToken(string).equalsIgnoreCase("CONSTRUCTOR")) {
            bl = true;
            string = Token.cutFirstToken(string);
        }
        if (Token.getFirstToken(string).equalsIgnoreCase("PROCEDURE")) {
            string = Token.cutFirstToken(string);
        } else if (Token.getFirstToken(string).equalsIgnoreCase("FUNCTION")) {
            string = Token.cutFirstToken(string);
        }
        string5 = Token.getStringToFirstMatch(string, stringArray);
        string4 = Token.getStringAfter(string, string5);
        if (!string5.equals("")) {
            string = string5;
        }
        if (Token.hasString(string3 = Token.getFirstName(string, '\"', '\"'), "(")) {
            string3 = Token.getStringBefore(string3, "(");
        }
        Method method = new Method(structuredType.getDesignPart(), structuredType);
        method.setName(string3);
        method.setDesign(structuredType.getDesign());
        structuredType.addMethod(method);
        method.setConstructor(bl);
        MethodProxyOraclev10g methodProxyOraclev10g = (MethodProxyOraclev10g)this.storageDesign.getProxy(method);
        methodProxyOraclev10g.setIsStatic(string9);
        methodProxyOraclev10g.setOverriding(string6);
        methodProxyOraclev10g.setIsFinal(string7);
        methodProxyOraclev10g.setInstantiable(string8);
        if (bl2) {
            structuredTypeProxyOraclev10g.setMapOrderFunction(methodProxyOraclev10g);
        }
        String string10 = "";
        if ((string = Token.getStringAfter(string, string3)).startsWith("\"")) {
            string = string.substring(1).trim();
        }
        if (string.startsWith("(")) {
            string2 = Token.getValBetweenBrackets(string, 1).trim();
            string10 = Token.getValAfterBrackets(string, 1);
            object2 = new StringTokenizer(string2, ",");
            object = null;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
                charSequence = new StringBuffer((String)object);
                while (Token.tokenNumber((String)object, "(") > Token.tokenNumber((String)object, ")") && ((StringTokenizer)object2).hasMoreTokens()) {
                    ((StringBuffer)charSequence).append(",").append(((StringTokenizer)object2).nextToken().trim());
                    object = ((StringBuffer)charSequence).toString().trim();
                }
                String string11 = Token.getFirstName((String)object, '\"', '\"');
                if (string11.equalsIgnoreCase("SELF")) {
                    if (!Token.hasToken((String)object, "NOCOPY")) continue;
                    methodProxyOraclev10g.setCopySelf("NO");
                    continue;
                }
                String string12 = Token.getStringAfter((String)object, string11);
                if (string12.startsWith("\"")) {
                    string12 = string12.substring(1).trim();
                }
                String string13 = "IN";
                if (string12.toUpperCase().startsWith("IN OUT ")) {
                    string13 = "IN OUT";
                    string12 = Token.cutTokenFromFront(string12, string13);
                } else if (Token.getFirstToken(string12).equalsIgnoreCase("IN")) {
                    string13 = "IN";
                    string12 = Token.cutFirstToken(string12);
                } else if (Token.getFirstToken(string12).equalsIgnoreCase("OUT")) {
                    string13 = "OUT";
                    string12 = Token.cutFirstToken(string12);
                }
                String string14 = "YES";
                if (Token.getFirstToken(string12).equalsIgnoreCase("NOCOPY")) {
                    string14 = "NO";
                    string12 = Token.cutFirstToken(string12);
                }
                MethodParam methodParam = new MethodParam(method.getDesignPart());
                methodParam.setName(string11);
                methodParam.setDesign(method.getDesign());
                method.addParameter(methodParam);
                this.initDatatype(string12, methodParam);
                if (this.storageDesign.getProxy(methodParam) == null) continue;
                MethodParamProxyOracle methodParamProxyOracle = (MethodParamProxyOracle)this.storageDesign.getProxy(methodParam);
                methodParamProxyOracle.setDirectionType(string13);
                methodParamProxyOracle.setCopyArgument(string14);
            }
        } else {
            string10 = string;
        }
        if (string10.startsWith("RETURN")) {
            string2 = string10;
            if (Token.hasToken(string2, "IS")) {
                string2 = Token.getStringBeforeToken(string2, "IS");
                string10 = Token.getStringAfterToken(string10, "IS");
            } else if (Token.hasToken(string2, "AS")) {
                string2 = Token.getStringBeforeToken(string2, "AS");
                string10 = Token.getStringAfterToken(string10, "AS");
            }
            if (!"".equalsIgnoreCase(string2)) {
                object2 = Token.getFirstToken(string2);
                object = new MethodParam(method.getDesignPart());
                ((DesignObject)object).setName((String)object2);
                ((ModelObject)object).setDesign(method.getDesign());
                charSequence = Token.cutFirstToken(string2);
                this.initDatatype((String)charSequence, (DataTypeObject)object);
                method.setReturnValue((MethodParam)object);
            }
        }
        if (Token.hasToken(string, "PARALLEL_ENABLE")) {
            methodProxyOraclev10g.setParallel("YES");
            string2 = Token.getStringAfter(string, "PARALLEL_ENABLE");
            if (Token.hasToken(string2, "AGGREGATE")) {
                string2 = Token.getStringBeforeToken(string2, "AGGREGATE");
            } else if (Token.hasToken(string2, "PIPELINED")) {
                string2 = Token.getStringBeforeToken(string2, "PIPELINED");
            }
            methodProxyOraclev10g.setPartitioningAndStreaming(string2);
        }
        if (Token.hasToken(string, "DETERMINISTIC")) {
            methodProxyOraclev10g.setDeterministic("YES");
        }
        if (Token.hasString(string, "AGGREGATE USING")) {
            methodProxyOraclev10g.setPipeliningAndAggregation("Aggregate Using");
        } else if (Token.hasString(string, "PIPELINED USING")) {
            methodProxyOraclev10g.setPipeliningAndAggregation("Pipelined Using");
        } else if (Token.hasString(string, "PIPELINED")) {
            methodProxyOraclev10g.setPipeliningAndAggregation("Pipelined");
            string2 = Token.getStringAfter(string, "PIPELINED");
            string10 = Token.cutFirstToken(string2);
            string10 = Token.cutFirstToken(string10);
            string2 = Token.getStringBefore(string2, "AS");
            methodProxyOraclev10g.setPipeliningAndAggregationImpl(string2);
            if (!"".equalsIgnoreCase(string10) && string10.startsWith("LANGUAGE")) {
                if (Token.getFirstToken(string10 = Token.cutFirstToken(string10)).equalsIgnoreCase("JAVA")) {
                    methodProxyOraclev10g.setImplLanguage("Java");
                    string10 = Token.cutFirstToken(string10);
                    string10 = Token.getValBetweenQuotes(string10);
                    methodProxyOraclev10g.setJavaName(string10);
                } else if (Token.getFirstToken(string10).equalsIgnoreCase("C")) {
                    methodProxyOraclev10g.setImplLanguage("C");
                    string10 = Token.cutFirstToken(string10);
                    if (Token.getFirstToken(string10).equalsIgnoreCase("NAME")) {
                        string10 = Token.cutFirstToken(string10);
                        methodProxyOraclev10g.setCName(Token.getFirstToken(string10));
                        string10 = Token.cutFirstToken(string10);
                    }
                    if (!"".equalsIgnoreCase((String)(object2 = Token.getTokenAfter(string10, "LIBRARY")))) {
                        methodProxyOraclev10g.setCLibrary((String)object2);
                    }
                    if (Token.hasString(string10, "AGENT IN")) {
                        object = Token.getStringAfter(string10, "AGENT IN");
                        object = Token.getValBetweenBrackets((String)object, 1);
                        methodProxyOraclev10g.setAgentArguments((String)object);
                    }
                    if (Token.hasString(string10, "WITH CONTEXT")) {
                        methodProxyOraclev10g.setWithContext("YES");
                    }
                    if (Token.hasString(string10, "PARAMETERS")) {
                        string10 = Token.cutFirstToken(string10);
                        string10 = Token.getValBetweenBrackets(string10, 1);
                        methodProxyOraclev10g.setCPartemeters(string10);
                    }
                }
            }
        }
        string = this.initPragma(methodProxyOraclev10g, string);
        return string4;
    }

    private String initPragma(MethodProxyOracle methodProxyOracle, String string) {
        if (Token.hasString(string, "PRAGMA RESTRICT_REFERENCES") && Token.hasCloseAndOpenBrackets(string = Token.getStringAfter(string, "RESTRICT_REFERENCES").trim())) {
            StringBuffer stringBuffer = new StringBuffer("PRAGMA RESTRICT_REFERENCES (");
            stringBuffer.append(Token.getValBetweenBrackets(string));
            stringBuffer.append(")");
            methodProxyOracle.setPragmaClause(stringBuffer.toString());
            string = Token.getValAfterBrackets(string, 1);
        }
        return string;
    }

    private void initDatatype(String string, DataTypeObject dataTypeObject) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        boolean bl = Token.getFirstToken(string = string.toUpperCase()).equalsIgnoreCase("REF");
        if (bl) {
            string = Token.cutFirstToken(string);
        }
        int n = 0;
        int n2 = 0;
        String string3 = Token.getFirstToken(string);
        int n3 = string3.indexOf("(");
        if (n3 >= 0) {
            string3 = string3.substring(0, n3);
        }
        if (string3.equals("TIMESTAMP")) {
            if (string.indexOf("WITH") >= 0) {
                string3 = string.indexOf("LOCAL") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : "TIMESTAMP WITH TIME ZONE";
            }
            n = 6;
        } else if (string3.equals("INTERVAL")) {
            if (string.indexOf("YEAR") >= 0) {
                string3 = "INTERVAL YEAR TO MONTH";
                n = 2;
            } else if (string.indexOf("DAY") >= 0) {
                string3 = "INTERVAL DAY TO SECOND";
                n = 2;
                n2 = 6;
            }
        } else if (string3.equals("DOUBLE")) {
            string3 = "DOUBLE PRECISION";
        }
        if (Token.hasCloseAndOpenBrackets(string)) {
            if (string3.equals("INTERVAL DAY TO SECOND")) {
                string2 = Token.cutTokenFromFront(string, "INTERVAL");
                object3 = Token.cutTokenFromFront(string2, "DAY");
                if (((String)object3).startsWith("(")) {
                    object2 = Token.getValBetweenBrackets((String)object3, 1).trim();
                    try {
                        n = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Wrong precision format " + n);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
                if (((String)(object = Token.cutTokenFromFront((String)(object2 = Token.getStringAfterToken(string2, "TO")), "SECOND"))).startsWith("(")) {
                    String string4 = Token.getValBetweenBrackets((String)object, 1).trim();
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Wrong precision format " + string4);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
            } else {
                string2 = Token.getValBetweenBrackets(string, 1);
                int n4 = string2.indexOf(44);
                if (n4 > -1) {
                    try {
                        n = Integer.parseInt(string2.substring(0, n4).trim());
                        n2 = Integer.parseInt(string2.substring(n4 + 1).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTypeOracle.initDatatype : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong Precision/Scale value in statement " + this.statement);
                    }
                } else {
                    try {
                        n = Integer.parseInt(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTypeOracle.initDatatype : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong Size value in statement " + this.statement);
                    }
                }
            }
        }
        string2 = StandardDatatypeNames.getUsedDatatypeName(string3);
        string2 = StandardDatatypeNames.getTransformedDatatypeName(string2, this.getStorageDesign().getRDBMSType());
        object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string2);
        if (object3 != null && !string2.equalsIgnoreCase("UNKNOWN")) {
            dataTypeObject.setType((DesignObject)object3);
            if (n > 0) {
                if (string2.indexOf("CHAR") >= 0 || string2.equalsIgnoreCase("RAW")) {
                    dataTypeObject.setSize(Integer.toString(n));
                } else {
                    dataTypeObject.setPrecision(n);
                }
            }
            if (n2 != 0) {
                dataTypeObject.setScale(n2);
            }
        } else {
            object2 = (StructuredType)dataTypeObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string3);
            if (object2 != null) {
                dataTypeObject.setType((DesignObject)object2);
            } else {
                object = (CollectionType)dataTypeObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string3);
                if (object != null) {
                    dataTypeObject.setType((DesignObject)object);
                }
            }
        }
        if (bl) {
            dataTypeObject.setReference(true);
        }
    }

    private void parseTypeBody() {
        if (this.storageDesign != null) {
            Object object;
            StructuredTypeProxyOracle structuredTypeProxyOracle;
            StructuredType structuredType;
            String string;
            String string2 = string = Token.getNameAfterToken(this.statement, "BODY", '\"', '\"').trim();
            String string3 = null;
            int n = string2.indexOf(46);
            if (n > 0) {
                string3 = Token.getValBeforeCharacter(string, '.');
                string2 = Token.getValAfterCharacter(string, '.');
            }
            if (this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string2) != null) {
                structuredType = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                this.storageDesign.getStructuredTypeProxySet().add(structuredType);
                structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            } else {
                LOGGER.error("Type " + string2 + " does not exist!");
                structuredType = this.design.getDataTypesDesign().createStructuredType();
                structuredType.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(structuredType);
                structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getProxy(structuredType);
                if (structuredTypeProxyOracle != null && string3 != null) {
                    object = (UserOraclev10g)this.storageDesign.getUserSet().getByName(string3);
                    if (object == null) {
                        object = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                        ((UserOracle)object).setName(string3);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                    }
                    structuredTypeProxyOracle.setOwner((UserOracle)object);
                }
            }
            object = this.statement;
            while (((String)object).length() > 0) {
                String string4 = Token.getFirstToken((String)object);
                object = Token.cutTokenFromFront((String)object, string4);
                if (!string4.equalsIgnoreCase("IS") && !string4.equalsIgnoreCase("AS")) continue;
                this.initMethods((String)object, structuredTypeProxyOracle);
                break;
            }
        }
    }

    private void initMethods(String string, StructuredTypeProxyOracle structuredTypeProxyOracle) {
        if (string != null) {
            String string2 = "";
            String[] stringArray = new String[]{"OVERRIDING", "FINAL", "INSTANTIABLE", "MEMBER", "STATIC", "PROCEDURE", "CONSTRUCTOR", "FUNCTION"};
            if (Token.startsWithString(string.toUpperCase(), "IS") || Token.startsWithString(string.toUpperCase(), "AS")) {
                string = Token.cutFirstToken2(string);
            }
            block0: while (Token.hasToken(string, "MEMBER") || Token.hasToken(string, "STATIC") || Token.hasToken(string, "CONSTRUCTOR") || Token.hasToken(string, "PROCEDURE") || Token.hasToken(string, "FUNCTION")) {
                String string3;
                String string4 = string.trim();
                if (string4.startsWith("OVERRIDING")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (string4.startsWith("FINAL")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (string4.startsWith("INSTANTIABLE")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (string4.startsWith("MAP") || string4.startsWith("ORDER")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (string4.startsWith("STATIC") || string4.startsWith("MEMBER")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (string4.startsWith("CONSTRUCTOR")) {
                    string4 = Token.cutFirstToken2(string4);
                }
                if (Token.hasString(string3 = Token.getFirstName(string4 = Token.cutFirstToken2(string4), '\"', '\"'), "(")) {
                    string3 = Token.getStringBefore(string3, "(");
                }
                if ((string2 = Token.getStringToFirstMatch(string4, stringArray)).equals("")) {
                    string2 = string4;
                }
                if ((string = string4.substring(string2.length())).length() == 0) {
                    if ((string2 = Token.trimRight(string2)).endsWith(";")) {
                        string2 = string2.substring(0, string2.length() - 1).trim();
                    }
                    if (string2.toUpperCase().endsWith(" END")) {
                        string2 = string2.substring(0, string2.length() - 4);
                    }
                }
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                this.getMethodParams(string2, arrayList, arrayList2);
                MethodProxyOraclev10g methodProxyOraclev10g = (MethodProxyOraclev10g)this.storageDesign.getMethodProxySet().getMethodByNameAndParams(structuredTypeProxyOracle, string3, arrayList, arrayList2);
                if (methodProxyOraclev10g == null) continue;
                if (Token.hasString(string2.toUpperCase(), "RETURN SELF AS RESULT")) {
                    string2 = Token.getStringAfter(string2, "RETURN SELF AS RESULT");
                }
                while (string2.length() > 0) {
                    String string5 = Token.getFirstToken(string2);
                    string2 = Token.cutTokenFromFront(string2, string5);
                    if (!string5.equalsIgnoreCase("IS") && !string5.equalsIgnoreCase("AS")) continue;
                    methodProxyOraclev10g.getMethod().setBody(string2);
                    methodProxyOraclev10g.setPLSQLBody(string2);
                    continue block0;
                }
            }
        }
    }

    private void getMethodParams(String string, List list, List list2) {
        String string2;
        if (Token.hasCloseAndOpenBrackets(string) && !(string2 = Token.getValBetweenBrackets(string, 1)).trim().equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (Token.startsWithString(string3.toUpperCase(), "SELF IN OUT")) continue;
                String string4 = Token.getFirstName(string3, '\"', '\"');
                String string5 = Token.getStringAfter(string3, string4);
                if (string5.startsWith("\"")) {
                    string5 = string5.substring(1).trim();
                }
                if (Token.hasString(string5.toUpperCase(), "IN OUT ")) {
                    string5 = Token.getStringAfter(string5, "IN OUT");
                } else if (Token.hasToken(string5, "IN")) {
                    string5 = Token.getStringAfterToken(string5, "IN");
                } else if (Token.hasToken(string5, "OUT")) {
                    string5 = Token.getStringAfterToken(string5, "OUT");
                }
                if (Token.hasToken(string5, "NOCOPY")) {
                    string5 = Token.getStringAfterToken(string5, "NOCOPY");
                }
                list.add(string4);
                list2.add(string5);
            }
        }
    }

    private void initElementList(StructuredType structuredType, StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g) {
        Object object;
        String string;
        String string2 = "";
        if (Token.hasString(this.statement.toUpperCase(), "IS OBJECT")) {
            string2 = Token.getStringAfter(this.statement, "IS OBJECT");
        } else if (Token.hasString(this.statement.toUpperCase(), "AS OBJECT")) {
            string2 = Token.getStringAfter(this.statement, "AS OBJECT");
        } else if (Token.hasToken(this.statement, "UNDER")) {
            string2 = Token.getStringAfterToken(this.statement, "UNDER");
            string = Token.getFirstName(string2, '\"', '\"');
            int n = string.indexOf(46);
            if (n > 0) {
                string = Token.getValAfterCharacter(string, '.').trim();
            }
            string2 = Token.getStringAfter(string2, string);
            if (!"".equalsIgnoreCase(string) && this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string) != null) {
                object = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string);
                structuredType.setParentType((StructuredType)object, false);
            }
        }
        if (Token.hasString(string2, "LANGUAGE JAVA USING")) {
            string = Token.getStringAfter(string2, "EXTERNAL NAME");
            structuredTypeProxyOraclev10g.setJavaClass(Token.getFirstToken(string));
            structuredTypeProxyOraclev10g.setMapToJavaClass("YES");
            String string3 = Token.getStringAfter(string2, "LANGUAGE JAVA USING");
            string3 = Token.getFirstToken(string3);
            structuredTypeProxyOraclev10g.setJavaInstanceUsing(string3);
            string2 = Token.getStringAfterToken(this.statement, string3);
        }
        if (!string2.equals("")) {
            string = Token.getValAfterBrackets(string2, 1).toUpperCase();
            string2 = Token.getValBetweenBrackets(string2, 1);
            String[] stringArray = new String[]{"NOT OVERRIDING", "OVERRIDING", "NOT FINAL", "FINAL", "NOT INSTANTIABLE", "INSTANTIABLE", "MEMBER", "STATIC", "PROCEDURE", "CONSTRUCTOR", "FUNCTION", "MAP", "ORDER"};
            object = string2;
            String string4 = Token.getStringToFirstMatch(string2, stringArray).trim();
            if (!"".equalsIgnoreCase(string4)) {
                object = Token.getStringAfter(string2, string4);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                String string5 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    while (Token.hasOpenBracketNoClose(string6) && stringTokenizer.hasMoreTokens()) {
                        string6 = string6 + ", " + stringTokenizer.nextToken();
                    }
                    String string7 = Token.getFirstName(string6, '\"', '\"');
                    String string8 = Token.getStringAfter(string6, string7);
                    if (string8.startsWith("\"")) {
                        string8 = string8.substring(1).trim();
                    }
                    if (Token.hasString(string8, "EXTERNAL NAME")) {
                        string5 = Token.getStringAfter(string8, "EXTERNAL NAME");
                        string5 = Token.getValBetweenQuotes(string5);
                    }
                    TypeElement typeElement = null;
                    typeElement = structuredType.getElementByName(string7);
                    if (typeElement == null) {
                        typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
                        typeElement.setName(string7);
                        typeElement.setDesign(structuredType.getDesign());
                        structuredType.add(typeElement);
                    }
                    this.initDatatype(string8, typeElement);
                    TypeElementProxyOraclev10g typeElementProxyOraclev10g = (TypeElementProxyOraclev10g)this.storageDesign.getProxy(typeElement);
                    if (typeElementProxyOraclev10g == null) continue;
                    typeElementProxyOraclev10g.setSqlJAttr(string5);
                }
            }
            if (!((String)object).equals("")) {
                while (Token.hasToken((String)object, "MEMBER") || Token.hasToken((String)object, "STATIC") || Token.hasToken((String)object, "CONSTRUCTOR") || Token.hasToken((String)object, "PROCEDURE") || Token.hasToken((String)object, "FUNCTION")) {
                    object = this.initMethod(structuredType, ((String)object).trim(), stringArray);
                }
            }
            boolean bl = true;
            while (bl) {
                boolean bl2 = true;
                if (string.startsWith("NOT")) {
                    bl2 = false;
                    string = Token.cutFirstToken2(string);
                }
                if (string.startsWith("FINAL")) {
                    structuredType.setFinal(bl2);
                    string = Token.cutFirstToken2(string);
                    continue;
                }
                if (string.startsWith("INSTANTIABLE")) {
                    structuredType.setInstantiable(bl2);
                    string = Token.cutFirstToken2(string);
                    continue;
                }
                bl = false;
            }
        }
    }
}

