/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.AggregateFunctionsOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSnapshotOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSnapshotOraclev10g.class);
    private SnapshotOraclev10g snapshot;
    private StorageDesignOraclev10g storageDesign;
    private SHCreateTableOraclev10g shCreateTableOraclev10g = null;
    public static final String FAST = "FAST";
    public static final String COMPLETE = "COMPLETE";
    public static final String NEVER = "NEVER";

    public SHCreateSnapshotOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSnapshotOraclev10g.clearCR(string);
        if (Token.startsWithString(string2, "create snapshot") || Token.startsWithString(string2, "create materialized view")) {
            this.parseSnapshot(string2.replaceAll("\"", ""), string);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseSnapshot(String string, String string2) {
        try {
            this.statement = string;
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
            if (this.storageDesign != null) {
                this.snapshot = (SnapshotOraclev10g)this.storageDesign.getSnapshotSet().createSnapshot();
                if (this.snapshot != null) {
                    this.initSnapshotName();
                    this.snapshot.setNameHasQuotes(this.nameHasQuotes());
                    if (Token.hasToken(string, "CLUSTER")) {
                        this.initCluster();
                    } else {
                        this.initSegment();
                    }
                    this.initSnapshotTable();
                    this.initPartitioning();
                    this.initParallelClause();
                    this.initPrebuild();
                    this.initUsingIndex();
                    this.initRefreshClause();
                    this.initForUpdate();
                    this.initQueryRewrite();
                    this.initSubquery(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.snapshot);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(string2);
        }
    }

    private boolean nameHasQuotes() {
        String string = Token.getTokenAfter(this.statement, "CREATE").equalsIgnoreCase("SNAPSHOT") ? Token.getStringAfterToken(this.statement, "SNAPSHOT") : Token.getStringAfterToken(this.statement, "VIEW");
        return string.startsWith("\"");
    }

    private void initSnapshotName() {
        String string = Token.getTokenAfter(this.statement, "CREATE").equalsIgnoreCase("SNAPSHOT") ? Token.getQuotedNameAfterToken(this.statement, "SNAPSHOT") : Token.getQuotedNameAfterToken(this.statement, "VIEW");
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            UserOraclev10g userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().getByName(string2);
            if (userOraclev10g == null && !string2.trim().equalsIgnoreCase("")) {
                userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                userOraclev10g.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(userOraclev10g);
            }
            this.snapshot.setUser(userOraclev10g);
            string = string.substring(n + 1);
        }
        this.snapshot.setName(string);
    }

    private void initSegment() {
        SegmentOraclev10g segmentOraclev10g = null;
        if (Token.hasToken(this.statement, "PCTFREE") && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            this.initPhysicalAttributesClause(this.statement, segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            this.snapshot.setSegment(segmentOracle);
        }
        this.initTableSpace();
        this.initLobStorage();
        this.initLogging();
        this.initCache();
    }

    private void initPhysicalAttributesClause(String string, SegmentOraclev10g segmentOraclev10g) {
        this.initPctFree(string, segmentOraclev10g);
        this.initPctUsed(string, segmentOraclev10g);
        this.initInitrans(string, segmentOraclev10g);
        this.initMaxtrans(string, segmentOraclev10g);
        this.initStorage(string, segmentOraclev10g);
    }

    private void initPctFree(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "PCTFREE")) {
            String string2 = Token.getTokenAfter(string, "PCTFREE").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setPCTFree(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctFree : " + numberFormatException.getMessage());
            }
        }
    }

    private void initPctUsed(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "PCTUSED")) {
            String string2 = Token.getTokenAfter(string, "PCTUSED").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setPCTUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctUsed : " + numberFormatException.getMessage());
            }
        }
    }

    private void initInitrans(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "INITRANS")) {
            String string2 = Token.getTokenAfter(string, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxtrans(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "MAXTRANS")) {
            String string2 = Token.getTokenAfter(string, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMaxtrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initStorage(String string, SegmentOraclev10g segmentOraclev10g) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, segmentOraclev10g, null);
            this.initNext(string2, segmentOraclev10g, null);
            this.initPCtIncrease(string2, segmentOraclev10g, null);
            this.initMinExtents(string2, segmentOraclev10g, null);
            this.initMaxExtents(string2, segmentOraclev10g, null);
            this.initFreeLists(string2, segmentOraclev10g, null);
            this.initFreeListGroups(string2, segmentOraclev10g, null);
            this.initSegBufferPool(string2, segmentOraclev10g, null);
        }
    }

    private void initTableSpace() {
        if (Token.hasToken(this.statement, "TABLESPACE")) {
            String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE");
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string);
            if (tableSpaceOraclev10g != null) {
                this.snapshot.setTablespace(tableSpaceOraclev10g);
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.snapshot.setLogging("NO");
        } else if (Token.hasToken(this.statement, "LOGGING")) {
            this.snapshot.setLogging("YES");
        }
    }

    private void initCache() {
        if (Token.hasToken(this.statement, "NOCACHE")) {
            this.snapshot.setCache("NO");
        } else if (Token.hasToken(this.statement, "CACHE")) {
            this.snapshot.setCache("YES");
        }
    }

    private void initLobStorage() {
        if (Token.hasToken(this.statement, "LOB")) {
            LobStorageOraclev10g lobStorageOraclev10g = (LobStorageOraclev10g)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOraclev10g);
            this.snapshot.setLobStorage(lobStorageOraclev10g);
            lobStorageOraclev10g.setSnapshot(this.snapshot);
            String string = Token.getStringAfter(this.statement, "LOB");
            String string2 = Token.getValBetweenBrackets(string, 1).replaceAll("\"", "").trim();
            lobStorageOraclev10g.setColumn(string2);
            String string3 = "STORE AS";
            if (Token.getTokenAfter(string.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string3 = "SECUREFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("SECUREFILE");
                }
            } else if (Token.getTokenAfter(string.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string3 = "BASICFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("BASICFILE");
                }
            }
            string = Token.getStringAfter(string, string3);
            String string4 = Token.getFirstToken(string).trim();
            if (!(string4 = Token.getName(string4)).equalsIgnoreCase("(")) {
                lobStorageOraclev10g.setName(string4);
            }
            String string5 = Token.getValBetweenBrackets(string, 1).trim();
            String string6 = Token.getQuotedNameAfterToken(string5, "TABLESPACE");
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string6);
            if (tableSpaceOraclev10g != null) {
                lobStorageOraclev10g.setTableSpace(tableSpaceOraclev10g);
            }
            this.initLobStorageStorage(string5, lobStorageOraclev10g);
        }
    }

    private void initLobStorageStorage(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, lobStorageOraclev10g);
            this.initNext(string2, null, lobStorageOraclev10g);
            this.initPCtIncrease(string2, null, lobStorageOraclev10g);
            this.initMinExtents(string2, null, lobStorageOraclev10g);
            this.initMaxExtents(string2, null, lobStorageOraclev10g);
            this.initFreeLists(string2, null, lobStorageOraclev10g);
            this.initFreeListGroups(string2, null, lobStorageOraclev10g);
            this.initSegBufferPool(string2, null, lobStorageOraclev10g);
        }
        this.initChunk(string, lobStorageOraclev10g);
        this.initRetention(string, lobStorageOraclev10g);
        this.initPctVersion(string, lobStorageOraclev10g);
        this.initFreePools(string, lobStorageOraclev10g);
        this.initStorageInRow(string, lobStorageOraclev10g);
        this.initLSCache(string, lobStorageOraclev10g);
        this.initLogging(string, lobStorageOraclev10g);
    }

    private void initChunk(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                lobStorageOraclev10g.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initChunk : ", numberFormatException);
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                lobStorageOraclev10g.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctVersion : ", numberFormatException);
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "RETENTION")) {
            lobStorageOraclev10g.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                lobStorageOraclev10g.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreePools : ", numberFormatException);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasString(string, "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            lobStorageOraclev10g.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                lobStorageOraclev10g.setCache("CACHE READS");
            } else {
                lobStorageOraclev10g.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            lobStorageOraclev10g.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "NOLOGGING")) {
            lobStorageOraclev10g.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            lobStorageOraclev10g.setLogging("YES");
        } else if (Token.hasToken(string, "FILESYSTEM_LIKE_LOGGING")) {
            lobStorageOraclev10g.setLogging("FILESYSTEM_LIKE_LOGGING");
        }
    }

    private void initInitial(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCInitialExtent(l);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCInitialExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitial : ", numberFormatException);
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
            }
        }
    }

    private void initNext(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCNextExtent(l);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCNextExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initNext: ", numberFormatException);
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCPctIncrease(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCPctIncrease(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPCtIncrease: ", numberFormatException);
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
            }
        }
    }

    private void initMinExtents(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCMinExtents(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCMinExtents(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMinExtents: ", numberFormatException);
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
            }
        }
    }

    private void initMaxExtents(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            if (segmentOraclev10g != null) {
                segmentOraclev10g.setSCMaxExtents(string2);
            } else {
                lobStorageOraclev10g.setSCMaxExtents(string2);
            }
        }
    }

    private void initFreeLists(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCFreeLists(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCFreeLists(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeLists: ", numberFormatException);
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCFreelistGroups(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCFreelistGroups(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeListGroups: ", numberFormatException);
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL").trim();
            if (segmentOraclev10g != null) {
                segmentOraclev10g.setSCBufferPool(string2);
            } else if (lobStorageOraclev10g != null) {
                lobStorageOraclev10g.setSCBufferPool(string2);
            }
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateSnapshotOracle10g.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initCluster() {
        String string = Token.getQuotedNameAfterToken(this.statement, "CLUSTER");
        string = string.substring(string.lastIndexOf(46) + 1);
        ClusterOraclev10g clusterOraclev10g = (ClusterOraclev10g)this.storageDesign.getClusterSet().getByName(string);
        if (clusterOraclev10g != null) {
            this.snapshot.setCluster(clusterOraclev10g);
            String string2 = Token.getStringAfterToken(this.statement, "CLUSTER");
            string2 = Token.getValBetweenBrackets(string2, 1);
            this.snapshot.setClusterColumns(string2);
        }
    }

    private void initPartitioning() {
        int n = this.statement.toUpperCase().indexOf("PARTITION BY ");
        if (n > -1) {
            String string = this.statement.substring(n);
            if (Token.hasToken(string = Token.getStringBeforeToken(string, "AS"), "USING")) {
                string = Token.getStringBeforeToken(string, "USING");
            }
            if (this.shCreateTableOraclev10g == null) {
                this.shCreateTableOraclev10g = new SHCreateTableOraclev10g(this.design);
            }
            this.shCreateTableOraclev10g.initPartitionsForSnapshotTable(string, (TableProxyOraclev10g)this.snapshot.getImplementedTable());
        }
    }

    private void initParallelClause() {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            this.snapshot.setParalelClause("YES");
        }
    }

    private void initPrebuild() {
        if (Token.hasToken(this.statement, "BUILD")) {
            this.snapshot.setBuild(Token.getTokenAfter(this.statement, "BUILD"));
        } else if (Token.hasString(this.statement.toUpperCase(), "ON PREBUILT TABLE")) {
            TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)((TableProxySetOraclev10g)this.storageDesign.getTableProxySet()).getByName(this.snapshot.getName());
            this.snapshot.setOnPrebuildTable(tableProxyOraclev10g);
            if (Token.hasString(this.statement.toUpperCase(), "WITHOUT REDUCED PRECISION")) {
                this.snapshot.setReducedPrecision("NO");
            }
        }
    }

    private void initUsingIndex() {
        if (Token.hasString(this.statement.toUpperCase(), "USING INDEX")) {
            this.snapshot.setUseIndex("YES");
            int n = this.statement.toUpperCase().indexOf("USING INDEX TABLESPACE");
            if (n > -1) {
                TableSpaceOraclev10g tableSpaceOraclev10g;
                String string = this.statement.substring(n + 22).trim();
                string = Token.getFirstToken(string);
                if (!"".equalsIgnoreCase(string = Token.getName(string)) && (tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string)) != null) {
                    this.snapshot.setIndexTablespace(tableSpaceOraclev10g);
                }
            } else {
                SegmentOraclev10g segmentOraclev10g = null;
                if (Token.hasToken(this.statement, "PCTFREE") && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
                    String string = Token.getStringAfter(this.statement, "USING INDEX");
                    this.initPhysicalAttributesClause(string, segmentOraclev10g);
                    SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
                    this.snapshot.setSegment(segmentOracle);
                }
            }
        } else if (Token.hasString(this.statement.toUpperCase(), "USING NO INDEX")) {
            this.snapshot.setUseIndex("NO");
        }
    }

    private void initRefreshClause() {
        if (Token.hasToken(this.statement, "REFRESH")) {
            if (Token.getTokenBefore(this.statement, "REFRESH").equalsIgnoreCase(NEVER)) {
                this.snapshot.setRefresh(NEVER);
            } else {
                String string;
                this.snapshot.setRefresh("YES");
                String string2 = Token.getStringAfterToken(this.statement, "REFRESH");
                if (Token.hasToken(string2, FAST)) {
                    this.snapshot.setRefreshType(FAST);
                } else if (Token.hasToken(string2, COMPLETE)) {
                    this.snapshot.setRefreshType(COMPLETE);
                } else if (Token.hasToken(string2, "FORCE")) {
                    this.snapshot.setRefreshType("FORCE");
                }
                if (Token.hasString(string2.toUpperCase(), "ON COMMIT")) {
                    this.snapshot.setAction("ON COMMIT");
                } else if (Token.hasString(string2.toUpperCase(), "ON DEMAND")) {
                    this.snapshot.setAction("ON DEMAND");
                }
                if (Token.hasString(string2.toUpperCase(), "NEXT")) {
                    string = string2.substring(string2.toUpperCase().indexOf("NEXT") + 4).trim();
                    string = Token.getFirstToken(string);
                    this.snapshot.setNextDate(string);
                }
                if (Token.hasString(string2.toUpperCase(), "START")) {
                    string = string2.substring(string2.toUpperCase().indexOf("START") + 10).trim();
                    string = Token.getFirstToken(string);
                    this.snapshot.setStartDate(string);
                }
                if (Token.hasString(string2.toUpperCase(), "WITH ROWID")) {
                    this.snapshot.setWith("ROWID");
                }
                if (Token.hasString(string2.toUpperCase(), "USING")) {
                    if (Token.getTokenAfter(string2, "USING").equalsIgnoreCase("DEFAULT")) {
                        this.snapshot.setDefaultSegment("YES");
                    } else if (Token.getTokenAfter(string2, "USING").equalsIgnoreCase("ENFORCED")) {
                        string = Token.getTokenAfter(string2, "USING");
                        this.snapshot.setUsingConstraint(string);
                    } else if (Token.getTokenAfter(string2, "USING").equalsIgnoreCase("TRUSTED")) {
                        string = Token.getTokenAfter(string2, "USING");
                        this.snapshot.setUsingConstraint(string);
                    } else {
                        this.snapshot.setUsingConstraint("ENFORCED");
                        string = Token.getTokenAfter(string2, "SEGMENT");
                        RollbackSegmentOracle rollbackSegmentOracle = (RollbackSegmentOracle)this.storageDesign.getRollbackSegmentSet().getByName(string);
                        if (rollbackSegmentOracle != null) {
                            this.snapshot.setRollbackSegment(rollbackSegmentOracle);
                        }
                    }
                    if (Token.hasToken(string2, "LOCAL")) {
                        this.snapshot.setSegmentType("LOCAL");
                    }
                }
            }
        }
    }

    private void initForUpdate() {
        if (Token.hasString(this.statement.toUpperCase(), "FOR UPDATE")) {
            this.snapshot.setForUpdate("YES");
        }
    }

    private void initQueryRewrite() {
        if (Token.hasString(this.statement.toUpperCase(), "QUERY REWRITE")) {
            this.snapshot.setQueryRewrite(Token.getTokenBefore(this.statement.toUpperCase(), "QUERY"));
        }
    }

    private void initSubquery(String string) {
        String string2 = Token.getStringAfter(string, "AS");
        int n = Token.getStringAfter(string2, "SELECT").length();
        if (n == 0) {
            string2 = "";
        } else {
            String string3;
            while ((string3 = Token.getStringAfter(string2, "AS")).length() > n) {
                string2 = string3;
            }
        }
        if (!"".equalsIgnoreCase(string2)) {
            this.snapshot.setSubquery(string2);
        }
    }

    private void initSnapshotTable() {
        try {
            Table table = this.storageDesign.getPhysicalDesign().createTable();
            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.storageDesign.getProxy(table);
            UserOracle userOracle = this.snapshot.getUser();
            if (userOracle != null) {
                String string = userOracle.getName();
                SchemaObjectSet schemaObjectSet = ((RelationalDesign)table.getDesignPart()).getSchemaObjectSet();
                SchemaObject schemaObject = (SchemaObject)schemaObjectSet.getByName(string);
                if (schemaObject == null && !string.trim().equalsIgnoreCase("")) {
                    schemaObject = schemaObjectSet.createSchemaObject(null);
                    schemaObject.setName(string);
                    this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
                }
                if (userOracle.getSchemaObject() == null) {
                    userOracle.setSchemaObject(schemaObject);
                }
                if (userOracle.getSchemaObject() != schemaObject && tableProxyOracle != null) {
                    tableProxyOracle.setUser(userOracle);
                }
                table.setSchemaObject(schemaObject);
            }
            table.setName(this.snapshot.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(table);
            table.setTypeID(this.storageDesign.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
            this.initColumns(table);
            if (tableProxyOracle != null) {
                tableProxyOracle.setSnapshot(this.snapshot);
            }
        }
        catch (Exception exception) {
            LOGGER.error("wrong format in SHCreateSnapshotOracle10g.initSnapshotTable: ", exception);
            this.importLog.addWarning("Unable to import Snapshot " + this.statement);
        }
    }

    public void initColumns(Table table) {
        String string;
        Object object;
        String string2;
        ArrayList<String> arrayList = null;
        this.statement = this.removeBracketsAroundSubquery(this.statement);
        String string3 = Token.getStringBefore(this.statement, "AS SELECT ");
        if (!Token.hasToken(string3, "OF") && Token.hasCloseAndOpenBrackets(string3) && !"".equalsIgnoreCase(string2 = Token.getValBetweenBrackets(string3, 1))) {
            arrayList = new ArrayList<String>();
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                arrayList.add(Token.getFirstName(string, '\"', '\"'));
            }
        }
        if (!"".equalsIgnoreCase(string2 = Token.getStringAfter(this.statement, "SELECT"))) {
            String string4;
            String string5;
            Object object2;
            Object object3;
            object = string2;
            string = "";
            if (Token.hasToken((String)object, "FROM")) {
                int n = ((String)object).toUpperCase().indexOf(" FROM ");
                object3 = ((String)object).substring(0, n);
                string = ((String)object).substring(n + 6);
                while (Token.tokenNumber((String)object3, "(") > Token.tokenNumber((String)object3, ")") && (n = ((String)object).toUpperCase().indexOf(" FROM ", n + 1)) > -1) {
                    object3 = ((String)object).substring(0, n);
                    string = ((String)object).substring(n + 6);
                }
                object = object3;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            object3 = new HashMap();
            if (Token.hasToken(string, "WHERE")) {
                string = Token.getStringBeforeToken(string, "WHERE");
            }
            String[] stringArray = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            String string6 = Token.getStringToFirstMatch(string.toUpperCase(), stringArray);
            string = string.substring(0, string6.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = null;
                string5 = stringTokenizer.nextToken();
                string4 = Token.getFirstName(string5, '\"', '\"');
                String string7 = "";
                int n = string4.indexOf(46);
                if (n > -1) {
                    string7 = string4.substring(0, n);
                    string7 = Token.removeQuotes(string7);
                    string4 = string4.substring(n + 1);
                }
                string4 = Token.removeQuotes(string4);
                if (!"".equals(string7) && (object2 = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string4)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string7, string4);
                }
                if (object2 == null && (object2 = (Table)this.design.getRelationalDesign().getTableSet().getByName(string4)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string4);
                }
                if (object2 == null) continue;
                String string8 = "";
                int n2 = string5.indexOf(string4);
                if (n2 > -1) {
                    String string9 = string5.substring(n2 + string4.length());
                    if (string9.startsWith("\"")) {
                        string9 = string9.substring(1);
                    }
                    string8 = Token.getFirstName(string9, '\"', '\"');
                }
                if (string8.equals("")) {
                    string8 = string4;
                }
                arrayList2.add(string8);
                object3.put(string8, object2);
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("ALL")) {
                object = Token.getStringAfterToken((String)object, "ALL").trim();
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("DISTINCT")) {
                object = Token.getStringAfterToken((String)object, "DISTINCT").trim();
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("UNIQUE")) {
                object = Token.getStringAfterToken((String)object, "UNIQUE").trim();
            }
            object2 = new StringTokenizer((String)object, ",");
            string5 = null;
            string4 = null;
            int n = 0;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Object object4;
                ContainerObject containerObject;
                int n3;
                string5 = ((StringTokenizer)object2).nextToken().trim();
                string4 = null;
                StringBuffer stringBuffer = new StringBuffer(string5);
                while (Token.tokenNumber(string5, "(") > Token.tokenNumber(string5, ")") && ((StringTokenizer)object2).hasMoreTokens()) {
                    stringBuffer.append(",").append(((StringTokenizer)object2).nextToken().trim());
                    string5 = stringBuffer.toString().trim();
                }
                boolean bl = false;
                if (!string5.endsWith("*") && (Token.hasCloseAndOpenBrackets(string5) || string5.indexOf(43) > -1 || string5.indexOf(45) > -1 || string5.indexOf(42) > -1 || string5.indexOf(47) > -1 || string5.indexOf("||") > -1 || Token.hasToken(string5, "PRIOR"))) {
                    bl = true;
                }
                if (Token.hasToken(string5, "AS")) {
                    string4 = Token.getNameAfterToken(string5, "AS", '\"', '\"');
                    string5 = Token.getStringBeforeToken(string5, "AS");
                    string5 = Token.encodeQuotedString(string5);
                } else if (!((string5 = Token.encodeQuotedString(string5)).indexOf(32) <= -1 || arrayList != null && bl)) {
                    if (string5.charAt(string5.length() - 1) == '\"') {
                        string4 = string5.substring(0, string5.length() - 1);
                        int n4 = string4.lastIndexOf(34);
                        string4 = string4.substring(n4) + "\"";
                        string5 = string5.substring(0, n4 - 1);
                    } else {
                        String string10 = Token.getLastToken(string5);
                        if (string10.indexOf(41) == -1 && !string10.equalsIgnoreCase("END")) {
                            string4 = string10;
                            string5 = string5.substring(0, string5.indexOf(string10)).trim();
                        }
                    }
                }
                String string11 = "";
                if (!bl && (n3 = string5.lastIndexOf(46)) > -1) {
                    string11 = string5.substring(0, n3);
                    int n5 = string11.lastIndexOf(46);
                    if (n5 > -1) {
                        string11 = string11.substring(n5 + 1);
                    }
                    string11 = Token.removeQuotes(Token.decodeQuotedString(string11)).trim();
                    string5 = string5.substring(n3 + 1);
                }
                if ((string5 = Token.removeQuotes(Token.decodeQuotedString(string5))).equalsIgnoreCase("*")) {
                    for (String string12 : arrayList2) {
                        Column column;
                        if (!string11.equals("") && !string11.equalsIgnoreCase(string12)) continue;
                        containerObject = (ContainerObject)object3.get(string12);
                        if (containerObject instanceof Table) {
                            object4 = (ContainedObject[])containerObject;
                            for (ContainedObject containedObject : object4.getElementsCollection()) {
                                String string13 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : containedObject.getName();
                                column = table.createColumn(string13);
                                this.design.getRelationalDesign().stampModelObjectDDL(column);
                                this.copyColumnDef((Column)containedObject, column);
                                ++n;
                            }
                            continue;
                        }
                        if (!(containerObject instanceof TableView)) continue;
                        object4 = ((TableView)containerObject).getColumns();
                        for (int i = 0; i < ((ContainedObject[])object4).length; ++i) {
                            ContainedObject containedObject;
                            containedObject = (ColumnView)object4[i];
                            String string14 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : containedObject.getName();
                            column = table.createColumn(string14);
                            this.design.getRelationalDesign().stampModelObjectDDL(column);
                            ++n;
                        }
                    }
                    continue;
                }
                if (string5.equalsIgnoreCase("")) continue;
                string4 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : (string4 != null && !string4.equals("") ? Token.removeQuotes(Token.decodeQuotedString(string4)) : string5);
                Column column = table.createColumn(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(column);
                if (bl) {
                    if (this.isAggregateFunction(string5)) {
                        column.setSourceType("Aggregate");
                    } else {
                        column.setSourceType("Derived");
                    }
                    column.setFormulaDesc(string5);
                } else {
                    for (String string12 : arrayList2) {
                        if (!string11.equals("") && !string11.equalsIgnoreCase(string12)) continue;
                        containerObject = (ContainerObject)object3.get(string12);
                        object4 = containerObject.getElementByName(string5);
                        if (!(object4 instanceof Column)) break;
                        this.copyColumnDef((Column)object4, column);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private void copyColumnDef(Column column, Column column2) {
        short s = column.getUse();
        column2.setUse(s);
        if (s == 0) {
            column2.setDomain(column.getDomain());
        } else if (s == 1) {
            column2.setLogicalDatatype(column.getLogicalDatatype());
            column2.setDataTypeSize(column.getSize());
            column2.setDataTypePrecision(column.getPrecision());
            column2.setDataTypeScale(column.getScale());
        } else if (s == 3) {
            column2.setStructuredType(column.getStructuredType());
        } else if (s == 4) {
            column2.setCollectionType(column.getCollectionType());
        } else if (s == 2) {
            column2.setDistinctType(column.getDistinctType());
        }
        column2.setReference(column.isReference());
        column2.setNullsAllowed(column.getNullsAllowed());
    }

    private String removeBracketsAroundSubquery(String string) {
        int n = string.toUpperCase().indexOf(" AS ");
        String string2 = string;
        if (n > -1) {
            String string3 = string.substring(0, n + 4);
            String string4 = string.substring(n + 4).trim();
            if (string4.charAt(0) == '(') {
                string4 = Token.getValBetweenBrackets(string4);
            }
            string2 = string3 + string4;
        }
        return string2;
    }

    private boolean isAggregateFunction(String string) {
        String[] stringArray = AggregateFunctionsOracle.FUNCTIONS_V10;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.toUpperCase().startsWith(string2.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

