/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DirectoryOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableColumnOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateExternalTableOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateExternalTableOraclev10g.class);
    private String lineFormatted;

    public SHCreateExternalTableOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateExternalTableOraclev10g.clearCR(string);
        if ((Token.startsWithString(string2, "create table") || Token.startsWithString(string2, "create global temporary table")) && string2.toLowerCase().indexOf("organization external") > -1) {
            try {
                this.lineFormatted = SHCreateExternalTableOraclev10g.FormatCR(string, "\n");
                this.parseExternalTable(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oraclev10g failed!", exception);
                this.importLog.addFailedStatement(SHCreateExternalTableOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseExternalTable(String string) {
        ExternalTableOraclev10g externalTableOraclev10g;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOraclev10g != null && (externalTableOraclev10g = (ExternalTableOraclev10g)storageDesignOraclev10g.getExternalTableSet().createExternalTable()) != null) {
            this.initName(externalTableOraclev10g, storageDesignOraclev10g);
            this.initColumns(externalTableOraclev10g, storageDesignOraclev10g);
            this.initExternalTableClause(externalTableOraclev10g, storageDesignOraclev10g);
            this.initParallel(externalTableOraclev10g);
            this.initRejectLimit(externalTableOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(externalTableOraclev10g);
        }
    }

    private void initName(ExternalTableOraclev10g externalTableOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string = Token.getQuotedNameAfterToken(this.statement, "TABLE");
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            UserOraclev10g userOraclev10g = (UserOraclev10g)storageDesignOraclev10g.getUserSet().getByName(string2);
            if (userOraclev10g != null) {
                externalTableOraclev10g.setOwner(userOraclev10g);
            }
            string = string.substring(n + 1);
        }
        externalTableOraclev10g.setName(string);
    }

    private void initColumns(ExternalTableOraclev10g externalTableOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string = Token.getValBetweenBrackets(this.statement, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                string3 = string3 + ", " + stringTokenizer.nextToken();
            }
            String string4 = Token.getFirstToken(string3.trim());
            if ("".equalsIgnoreCase(string4)) continue;
            ExternalTableColumnOraclev10g externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)storageDesignOraclev10g.getExternalColumnSet().createExternalColumn();
            externalTableColumnOraclev10g.setName(string4);
            this.design.getRelationalDesign().stampModelObjectDDL(externalTableColumnOraclev10g);
            externalTableColumnOraclev10g.setExternalTable(externalTableOraclev10g);
            String string5 = Token.getStringAfterToken(string3, string4).toUpperCase();
            if (string5.startsWith("TIMESTAMP")) {
                String string6 = Token.getValBetweenBrackets(string5, 1).trim();
                if (string6.length() > 0) {
                    try {
                        externalTableColumnOraclev10g.setPrecision(Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Wrong precision format " + string6);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
                string5 = string5.indexOf("WITH") >= 0 && string5.indexOf("TIME") >= 0 && string5.indexOf("ZONE") >= 0 ? (string5.indexOf("LOCAL") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : "TIMESTAMP WITH TIME ZONE") : "TIMESTAMP";
            } else if (string5.startsWith("INTERVAL")) {
                String string7 = Token.cutTokenFromFront(string5, "INTERVAL");
                if (string7.startsWith("YEAR")) {
                    string5 = "INTERVAL YEAR TO MONTH";
                } else {
                    String string8;
                    String string9;
                    String string10;
                    string5 = "INTERVAL DAY TO SECOND";
                    string2 = Token.cutTokenFromFront(string7, "DAY");
                    if (string2.startsWith("(") && (string10 = Token.getValBetweenBrackets(string2, 1).trim()).length() > 0) {
                        try {
                            externalTableColumnOraclev10g.setPrecision(Integer.parseInt(string10));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Wrong precision format " + string10);
                            this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                        }
                    }
                    if ((string9 = Token.cutTokenFromFront(string10 = Token.getStringAfterToken(string7, "TO"), "SECOND")).startsWith("(") && (string8 = Token.getValBetweenBrackets(string9, 1).trim()).length() > 0) {
                        try {
                            externalTableColumnOraclev10g.setScale(Integer.parseInt(string8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Wrong precision format " + string8);
                            this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                        }
                    }
                }
            } else {
                string5 = this.getDatatype(string5, storageDesignOraclev10g);
            }
            if (string5 == null) continue;
            externalTableColumnOraclev10g.setDatatype(string5);
            boolean bl = Token.hasCloseAndOpenBrackets(string3);
            if (!bl) continue;
            string2 = Token.getValBetweenBrackets(string3, 1).trim();
            try {
                if (string5.indexOf("CHAR") > -1 || string5.equals("RAW") || string5.equals("UROWID")) {
                    if (string2.endsWith("BYTE") || string2.endsWith("CHAR")) {
                        externalTableColumnOraclev10g.setUnits(string2.substring(string2.length() - 4));
                        string2 = string2.substring(0, string2.length() - 4).trim();
                    }
                    externalTableColumnOraclev10g.setSize(Integer.parseInt(string2));
                    continue;
                }
                if (string5.startsWith("TIMESTAMP") || string5.equals("INTERVAL DAY TO SECOND")) continue;
                int n = string2.indexOf(",");
                if (n != -1) {
                    externalTableColumnOraclev10g.setPrecision(Integer.parseInt(string2.substring(0, n).trim()));
                    externalTableColumnOraclev10g.setScale(Integer.parseInt(string2.substring(n + 1).trim()));
                    continue;
                }
                externalTableColumnOraclev10g.setPrecision(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong size/precision format " + string2);
                this.importLog.addWarning("Wrong size/precision format in statement " + this.statement);
            }
        }
    }

    private String getDatatype(String string, StorageDesign storageDesign) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes(storageDesign.getRDBMSType().getName());
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.startsWith(string2)) continue;
            return string2;
        }
        return null;
    }

    private void initExternalTableClause(ExternalTableOraclev10g externalTableOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string;
        if (Token.hasToken(this.statement, "TYPE")) {
            externalTableOraclev10g.setAccessDriverType(Token.getTokenAfter(this.statement, "TYPE"));
        }
        if (Token.hasToken(this.statement, "DIRECTORY")) {
            string = Token.getTokenAfter(this.statement, "DIRECTORY");
            DirectoryOraclev10g directoryOraclev10g = (DirectoryOraclev10g)storageDesignOraclev10g.getDirectorySet().getByName(string);
            if (directoryOraclev10g != null) {
                externalTableOraclev10g.setDefaultDir(directoryOraclev10g);
            }
        }
        if (this.statement.toUpperCase().indexOf("ACCESS PARAMETERS") > -1) {
            string = this.lineFormatted.substring(this.lineFormatted.toUpperCase().indexOf("PARAMETERS") + 10);
            if (Token.startsWithString(string = Token.getStringBefore(string, "LOCATION").trim(), "USING CLOB")) {
                externalTableOraclev10g.setAccessParametersType("CLOB Subquery");
                string = Token.getStringAfter(string, "CLOB");
                externalTableOraclev10g.setClobSubquery(string);
            } else {
                string = Token.getValBetweenBrackets(string, 1).trim();
                externalTableOraclev10g.setAccessParametersType("Opaque Format Spec");
                externalTableOraclev10g.setOpaqueFormatSpec(string);
            }
        }
        string = Token.getStringAfter(this.statement, "LOCATION");
        string = Token.getValBetweenBrackets(string, 1).trim();
        string = Token.getValBetweenQuotationMarks(string);
        externalTableOraclev10g.setLocation(string);
    }

    private void initParallel(ExternalTableOraclev10g externalTableOraclev10g) {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            externalTableOraclev10g.setParallel("PARALLEL");
            String string = Token.getTokenAfter(this.statement, "PARALLEL");
            try {
                externalTableOraclev10g.setParallelNum(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong syntax near " + string);
                this.importLog.addWarning("Wrong PARALLEL format in statement " + this.statement);
            }
        }
    }

    private void initRejectLimit(ExternalTableOraclev10g externalTableOraclev10g) {
        if (Token.hasString(this.statement, "REJECT LIMIT")) {
            String string = Token.getStringAfter(this.statement, "REJECT LIMIT");
            if ((string = Token.getFirstToken(string)) != null && string.trim().equalsIgnoreCase("UNLIMITED")) {
                externalTableOraclev10g.setRejectLimit("UNLIMITED");
            } else {
                try {
                    Integer.parseInt(string);
                    externalTableOraclev10g.setRejectLimit(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Wrong syntax near " + string);
                    this.importLog.addWarning("Wrong REJECT LIMIT format in statement " + this.statement);
                }
            }
        }
    }
}

