/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDiskGroupOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDiskGroupOraclev10g.class);
    private StorageDesignOraclev10g storageDesign;
    private DiskGroupOraclev10g diskGroup;
    private FailGroupOraclev10g failGroup;
    private ASMDiskOraclev10g asmDisk;
    private String line;

    public SHCreateDiskGroupOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDiskGroupOraclev10g.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create diskgroup")) {
            this.parseDiskGroup(string2.replaceAll("\"", ""));
        } else {
            this.nextHandler(string);
        }
    }

    private void parseDiskGroup(String string) {
        try {
            this.statement = string;
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
            if (this.storageDesign != null) {
                this.diskGroup = this.storageDesign.getDiskGroupSet().createDiskGroup();
                if (this.diskGroup != null) {
                    this.initName();
                    this.initRedundancy();
                    this.initFailGroups();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.diskGroup);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(SHCreateDiskGroupOraclev10g.FormatCR(this.line, "\n"));
        }
    }

    private void initFailGroups() {
        String string = Token.getStringAfter(this.statement, "DISKGROUP");
        while (Token.hasToken(string, "FAILGROUP")) {
            this.failGroup = this.storageDesign.getFailGroupSet().createFailGroup();
            if (this.failGroup != null) {
                String string2 = Token.getQuotedNameAfterToken(string, "FAILGROUP");
                this.failGroup.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(this.failGroup);
                this.failGroup.setDiskGroup(this.diskGroup);
                if (!Token.getStringAfterToken(string, "DISK").equalsIgnoreCase("")) {
                    this.initASMDisks(string);
                }
            }
            string = Token.getStringAfter(string, "DISK");
        }
    }

    private void initASMDisks(String string) {
        this.asmDisk = this.storageDesign.getASMDiskSet().createASMDisk();
        if (this.asmDisk != null) {
            String string2;
            this.design.getRelationalDesign().stampModelObjectDDL(this.asmDisk);
            String string3 = Token.getTokenAfter(string, "DISK");
            String string4 = null;
            string3 = Token.getValBetweenQuotationMarks(string3);
            this.asmDisk.setSearchString(string3);
            string = !"".equalsIgnoreCase(string3) ? Token.getStringAfter(string, string3) : Token.getStringAfter(string, "FAILGROUP");
            if (Token.hasToken(string, "NAME")) {
                string2 = Token.getQuotedNameAfterToken(string, "NAME");
                this.asmDisk.setName(string2);
                this.asmDisk.setFailGroup(this.failGroup);
            }
            if (Token.hasToken(string, "SIZE")) {
                string2 = this.getNumberOnly(Token.getTokenAfter(string, "SIZE").trim());
                try {
                    int n = Integer.parseInt(string2);
                    this.asmDisk.setSize(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateDiskGroupOraclev10g.initSize() : " + numberFormatException.getMessage());
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                string4 = Token.getTokenAfter(string, string2);
                this.asmDisk.setSizeMeasurementUnit(string4);
                string = Token.getStringAfter(string, "SIZE");
            }
            if ((string2 = Token.getTokenAfter(string, string4)).equalsIgnoreCase("FORCE")) {
                this.asmDisk.setForce("YES");
            } else if (string2.equalsIgnoreCase("NOFORCE")) {
                this.asmDisk.setForce("NO");
            }
        }
    }

    private void initRedundancy() {
        if (Token.hasToken(this.statement, "REDUNDANCY")) {
            String string = Token.getTokenBefore(this.statement, "REDUNDANCY");
            this.diskGroup.setRedundancy(string.toUpperCase());
        }
    }

    private void initName() {
        String string = Token.getQuotedNameAfterToken(this.statement, "DISKGROUP").trim();
        this.diskGroup.setName(string);
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            this.asmDisk.setSizeMeasurementUnit("K");
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            this.asmDisk.setSizeMeasurementUnit("M");
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("G")) {
            this.asmDisk.setSizeMeasurementUnit("G");
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("T")) {
            this.asmDisk.setSizeMeasurementUnit("T");
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

