/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDimensionOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDimensionOraclev10g.class);
    private DimensionOracle dimension;
    private StorageDesignOracle storageDesign;
    private String line;

    public SHCreateDimensionOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDimensionOraclev10g.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create dimension")) {
            this.parseDimension(string2);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseDimension(String string) {
        try {
            this.statement = string;
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
            if (this.storageDesign != null) {
                this.dimension = this.storageDesign.getDimensionSet().createDimension();
                if (this.dimension != null) {
                    this.initName();
                    this.initLevels();
                    this.initHierarchies();
                    this.initAttributes();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.dimension);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(SHCreateDimensionOraclev10g.FormatCR(this.line, "\n"));
        }
    }

    private void initName() {
        String string = Token.getQuotedNameAfterToken(this.statement, "DIMENSION").trim();
        if (string.indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            UserOracle userOracle = (UserOracle)this.storageDesign.getUserSet().getByName(string2);
            if (userOracle != null) {
                this.dimension.setUser(userOracle);
            }
            string = string.substring(string.indexOf(46) + 1);
        }
        this.dimension.setName(string);
    }

    private void initLevels() {
        int n = this.statement.toUpperCase().indexOf("LEVEL ");
        if (n > -1) {
            String string = this.statement.substring(n);
            if (Token.hasToken(string, "HIERARCHY")) {
                string = Token.getStringBeforeToken(string, "HIERARCHY");
            }
            if (Token.hasToken(string, "ATTRIBUTE")) {
                string = Token.getStringBeforeToken(string, "ATTRIBUTE");
            }
            while (Token.hasToken(string, "LEVEL")) {
                String string2;
                if (string.toUpperCase().indexOf("LEVEL ", 5) > -1) {
                    string2 = string.substring(0, string.toUpperCase().indexOf("LEVEL ", 5));
                    string = string.substring(string.toUpperCase().indexOf("LEVEL ", 5));
                } else {
                    string2 = string;
                    string = "";
                }
                string2 = Token.cutFirstToken(string2);
                String string3 = Token.getFirstName(string2, '\"', '\"');
                LevelOracle levelOracle = this.storageDesign.getLevelSet().createLevel();
                levelOracle.setName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(levelOracle);
                levelOracle.setDimension(this.dimension);
                String string4 = Token.getStringAfterToken(string2, "IS");
                if (Token.hasToken(string4, "HIERARCHY")) {
                    string4 = Token.getStringBeforeToken(string4, "HIERARCHY");
                }
                if (Token.hasToken(string4, "ATTRIBUTES")) {
                    string4 = Token.getStringBeforeToken(string4, "ATTRIBUTES");
                }
                if ("".equalsIgnoreCase(string4)) continue;
                if (string4.charAt(0) == '(' && Token.hasCloseAndOpenBrackets(string4)) {
                    String string5 = Token.getValBetweenBrackets(string4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        this.addLevelColumn(levelOracle, stringTokenizer.nextToken());
                    }
                    continue;
                }
                this.addLevelColumn(levelOracle, string4);
            }
        }
    }

    private void addLevelColumn(LevelOracle levelOracle, String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            ColumnProxy columnProxy;
            TableProxyOracle tableProxyOracle;
            String string2 = null;
            String string3 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            int n2 = string3.lastIndexOf(46);
            if (n2 > -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
            if ((tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByLongName(string3, string2)) != null && (columnProxy = tableProxyOracle.getColumnProxyByName(string = Token.getName(string))) != null) {
                levelOracle.setColumns(columnProxy.getObjectID());
                levelOracle.setLevelTable(tableProxyOracle);
            }
        }
    }

    private void initHierarchies() {
        int n = this.statement.indexOf("HIERARCHY ");
        if (n > -1) {
            String string = this.statement.substring(n);
            while (Token.hasToken(string, "HIERARCHY")) {
                Object object;
                String string2;
                String string3;
                if (string.indexOf("HIERARCHY ", 9) > -1) {
                    string3 = string.substring(0, string.indexOf("HIERARCHY ", 9));
                    string = string.substring(string.indexOf("HIERARCHY ", 9));
                } else {
                    string3 = string;
                    string = "";
                }
                string3 = Token.cutFirstToken(string3);
                String string4 = Token.getFirstName(string3, '\"', '\"');
                HierarchyOracle hierarchyOracle = this.storageDesign.getHierarchySet().createHierarchy();
                hierarchyOracle.setName(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(hierarchyOracle);
                hierarchyOracle.setDimension(this.dimension);
                if (Token.hasToken(string3, "ATTRIBUTE")) {
                    string3 = Token.getStringBeforeToken(string3, "ATTRIBUTE");
                }
                string3 = Token.getValBetweenBrackets(string3, 1);
                String string5 = "";
                int n2 = string3.toUpperCase().indexOf("JOIN KEY ");
                if (n2 > -1) {
                    string2 = Token.getStringBeforeToken(string3, "JOIN");
                    string5 = string3.substring(n2);
                } else {
                    string2 = string3;
                }
                while (!string2.equalsIgnoreCase("")) {
                    String string6;
                    if (string2.indexOf("CHILD OF") > -1) {
                        string6 = string2.substring(0, string2.toUpperCase().indexOf("CHILD OF")).trim();
                        string2 = Token.getStringAfter(string2, "CHILD OF");
                    } else {
                        string6 = string2;
                        string2 = "";
                    }
                    if ((object = this.dimension.getLevelByName(string6 = Token.getFirstName(string6, '\"', '\"'))) == null) continue;
                    hierarchyOracle.setLevels(((ModelIDObject)object).getObjectID());
                }
                if (string5.equalsIgnoreCase("")) continue;
                while (!string5.equalsIgnoreCase("")) {
                    if (string5.indexOf("JOIN KEY", 7) > -1) {
                        object = string5.substring(0, string5.indexOf("JOIN KEY", 7)).trim();
                        string5 = string5.substring(string5.indexOf("JOIN KEY", 7));
                    } else {
                        object = string5.trim();
                        string5 = "";
                    }
                    hierarchyOracle.setJoins((String)object);
                }
            }
        }
    }

    private void initAttributes() {
        int n = this.statement.indexOf("ATTRIBUTE ");
        if (n > -1) {
            String string = this.statement.substring(n);
            while (Token.hasToken(string, "ATTRIBUTE")) {
                String string2;
                LevelOracle levelOracle;
                String string3;
                String string4;
                if (string.indexOf("ATTRIBUTE ", 9) > -1) {
                    string4 = string.substring(0, string.indexOf("ATTRIBUTE ", 9));
                    string = string.substring(string.indexOf("ATTRIBUTE ", 9));
                } else {
                    string4 = string;
                    string = "";
                }
                string4 = Token.cutFirstToken(string4);
                DimensionAttributeOracle dimensionAttributeOracle = this.storageDesign.getDimensionAttributeSet().createDimensionAttribute();
                this.design.getRelationalDesign().stampModelObjectDDL(dimensionAttributeOracle);
                dimensionAttributeOracle.setDimension(this.dimension);
                if (Token.hasToken(string4, "LEVEL")) {
                    string3 = Token.getFirstName(string4, '\"', '\"');
                    dimensionAttributeOracle.setName(string3);
                    string4 = Token.getStringAfterToken(string4, "LEVEL");
                }
                if ((levelOracle = this.dimension.getLevelByName(string3 = Token.getFirstName(string4, '\"', '\"'))) != null) {
                    dimensionAttributeOracle.setLevel(levelOracle);
                }
                if ((string2 = Token.getStringAfterToken(string4, "DETERMINES")).charAt(0) == '(' && Token.hasCloseAndOpenBrackets(string2)) {
                    string2 = Token.getValBetweenBrackets(string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        this.addAttributeColumn(dimensionAttributeOracle, levelOracle, stringTokenizer.nextToken().trim());
                    }
                    continue;
                }
                this.addAttributeColumn(dimensionAttributeOracle, levelOracle, string2);
            }
        }
    }

    private void addAttributeColumn(DimensionAttributeOracle dimensionAttributeOracle, LevelOracle levelOracle, String string) {
        Object object;
        TableProxy tableProxy = null;
        int n = string.lastIndexOf(46);
        if (n > -1) {
            object = null;
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            int n2 = string2.lastIndexOf(46);
            if (n2 > -1) {
                object = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
            tableProxy = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByLongName(string2, (String)object);
        }
        if (tableProxy == null && levelOracle != null) {
            tableProxy = levelOracle.getLevelTable();
        }
        if (tableProxy != null && (object = tableProxy.getColumnProxyByName(string = Token.getName(string))) != null) {
            dimensionAttributeOracle.setColumns(((RelationalObjectProxy)object).getObjectID());
        }
    }
}

