/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsOraclev10g
implements StatementsConstants {
    private Map mapElementsColumn;
    private String statement;
    private static final Logger LOGGER = new Logger(SHColumnElementsOraclev10g.class);

    public void parseColumns(String string, RDBMSType rDBMSType) {
        this.statement = string;
        this.mapElementsColumn = new HashMap();
        try {
            if (!this.initColumnName(rDBMSType)) {
                this.initPrimaryKeyOrUnique();
                this.initUsingIndex();
                this.initConstraintCheck();
            }
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + this.statement + " for Oracle failed!", exception);
        }
    }

    private boolean initColumnName(RDBMSType rDBMSType) {
        boolean bl;
        String string = this.statement.trim().toUpperCase();
        boolean bl2 = bl = string.startsWith("CONSTRAINT ") && (Token.hasString(string, "PRIMARY KEY ") || Token.hasToken(string, "UNIQUE") || Token.hasString(string, "FOREIGN KEY ") || Token.hasToken(string, "CHECK")) || string.startsWith("PRIMARY KEY ") || string.startsWith("UNIQUE ") || string.startsWith("FOREIGN KEY ") || string.startsWith("CHECK ") || string.startsWith("SCOPE FOR ") || string.startsWith("REF (");
        if (!bl) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
            String string2 = "";
            if (this.statement.startsWith("\"")) {
                string2 = Token.getValBetweenDoubleQuotes(this.statement);
                this.statement = Token.getStringAfter(this.statement, string2);
                this.statement = Token.cutFirstToken(this.statement);
            } else {
                string2 = Token.getFirstToken(this.statement).trim();
                this.statement = Token.getStringAfter(this.statement, string2);
            }
            this.mapElementsColumn.put("columnname", string2);
            this.initDatatype(rDBMSType);
            this.initVirtualCol();
            this.initWithDefault();
            this.initNotNull();
            this.initPrimaryOrUnique();
            this.initReferences();
            this.initConstraintCheck();
            this.initWithRowid();
            return true;
        }
        this.mapElementsColumn.put("columnname", "");
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
        return false;
    }

    private void initVirtualCol() {
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("GENERATED")) {
            this.statement = Token.cutTokenFromFront(this.statement, "GENERATED");
            if (Token.getFirstToken(this.statement).equalsIgnoreCase("ALWAYS")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ALWAYS");
            }
        }
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("AS")) {
            this.statement = Token.cutTokenFromFront(this.statement, "AS");
            this.mapElementsColumn.put("COMPUTED", Boolean.TRUE);
            this.mapElementsColumn.put("FORMULA", Token.getValBetweenBrackets(this.statement, 1).trim());
            this.statement = Token.getValAfterBrackets(this.statement, 1);
            if (Token.getFirstToken(this.statement).equalsIgnoreCase("VIRTUAL")) {
                this.statement = Token.cutTokenFromFront(this.statement, "VIRTUAL");
            }
        } else {
            this.mapElementsColumn.put("COMPUTED", Boolean.FALSE);
        }
    }

    private void initDatatype(RDBMSType rDBMSType) {
        String string = this.statement;
        String string2 = this.searchWhichDatatype(this.statement, rDBMSType);
        if (string2 != null) {
            String string3 = StandardDatatypeNames.getUsedDatatypeName(string2);
            if ((string3 = StandardDatatypeNames.getTransformedDatatypeName(string3, rDBMSType)) != null) {
                this.mapElementsColumn.put("datatype", string3);
                if (string2.startsWith("TIMESTAMP")) {
                    String string4 = "6";
                    this.statement = Token.cutTokenFromFront(this.statement, "TIMESTAMP");
                    if (this.statement.startsWith("(")) {
                        string4 = Token.getValBetweenBrackets(this.statement, 1).trim();
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                    if (string2.endsWith("ZONE")) {
                        this.statement = Token.getStringAfter(this.statement, "ZONE");
                    }
                    this.mapElementsColumn.put("precision", string4);
                } else if (string2.equals("INTERVAL YEAR TO MONTH")) {
                    String string5 = "2";
                    this.statement = Token.getStringAfter(this.statement, "YEAR");
                    if (this.statement.startsWith("(")) {
                        string5 = Token.getValBetweenBrackets(this.statement, 1).trim();
                    }
                    this.statement = Token.getStringAfter(this.statement, "MONTH");
                    this.mapElementsColumn.put("precision", string5);
                } else if (string2.equals("INTERVAL DAY TO SECOND")) {
                    String string6 = "2";
                    String string7 = "6";
                    this.statement = Token.getStringAfter(this.statement, "DAY");
                    if (this.statement.startsWith("(")) {
                        string6 = Token.getValBetweenBrackets(this.statement, 1).trim();
                    }
                    this.statement = Token.getStringAfter(this.statement, "SECOND");
                    if (this.statement.startsWith("(")) {
                        string7 = Token.getValBetweenBrackets(this.statement, 1).trim();
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                    this.mapElementsColumn.put("precision", string6);
                    this.mapElementsColumn.put("scale", string7);
                } else {
                    this.statement = Token.cutTokenFromFront(this.statement, string2);
                    if (this.statement.startsWith("(")) {
                        String string8 = Token.getValBetweenBrackets(this.statement, 1);
                        int n = string8.indexOf(",");
                        if (n != -1) {
                            this.mapElementsColumn.put("size", "0");
                            this.mapElementsColumn.put("precision", string8.substring(0, n).trim());
                            this.mapElementsColumn.put("scale", string8.substring(n + 1).trim());
                        } else if (StandardDatatypeNames.isPackedSized(string3)) {
                            this.mapElementsColumn.put("size", "0");
                            this.mapElementsColumn.put("precision", string8.trim());
                            this.mapElementsColumn.put("scale", "0");
                        } else {
                            this.mapElementsColumn.put("size", string8.trim());
                            this.mapElementsColumn.put("precision", "0");
                            this.mapElementsColumn.put("scale", "0");
                        }
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                }
            }
        } else {
            this.mapElementsColumn.put(NameElements.COL_STRUCTURED_TYPE, string);
        }
    }

    protected String searchWhichDatatype(String string, RDBMSType rDBMSType) {
        String string2 = string.toUpperCase();
        if (Token.getFirstToken(string2).equals("INTERVAL")) {
            if (Token.cutTokenFromFront(string2, "INTERVAL").startsWith("YEAR")) {
                return "INTERVAL YEAR TO MONTH";
            }
            return "INTERVAL DAY TO SECOND";
        }
        if (string2.startsWith("SYS.XMLTYPE")) {
            return "XMLTYPE";
        }
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes(rDBMSType.getName());
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            boolean bl = string2.startsWith(string3.toUpperCase());
            if (!bl) continue;
            try {
                char c = string.charAt(string3.length());
                bl = c == '(' || c == ' ' || c == '\n' || c == '\t';
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = true;
            }
            if (!bl) continue;
            if (string3.equals("TIMESTAMP") && Token.hasToken(string2, "TIME") && Token.hasToken(string2, "ZONE")) {
                if (Token.hasToken(string2, "LOCAL")) {
                    return "TIMESTAMP WITH LOCAL TIME ZONE";
                }
                return "TIMESTAMP WITH TIME ZONE";
            }
            return string3;
        }
        return null;
    }

    private void initNotNull() {
        boolean bl = this.statement.toUpperCase().indexOf("NOT NULL") > -1;
        this.mapElementsColumn.put("NOT NULL", bl ? Boolean.TRUE : Boolean.FALSE);
        if (bl) {
            String string;
            String string2;
            String string3 = Token.getStringBeforeToken(this.statement, "NOT NULL");
            if ((string3 = Token.getStringAfterToken(string3, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(string3, "CONSTRAINT")) {
                    string3 = Token.getStringAfterToken(string3, "CONSTRAINT");
                }
                if (string3.indexOf(32) == -1 || string3.startsWith("\"") && string3.indexOf("\"", 1) == string3.length() - 1) {
                    this.mapElementsColumn.put("NN_CONSTRAINT_NAME", Token.getName(string3));
                }
            }
            if (Token.hasToken(string2 = Token.getStringAfter(this.statement, "NOT NULL"), "CONSTRAINT")) {
                string2 = Token.getStringBeforeToken(string2, "CONSTRAINT");
            }
            if (Token.hasToken(string2, "DEFERRABLE")) {
                string = Token.getTokenBefore(string2, "DEFERRABLE");
                boolean bl2 = !string.equalsIgnoreCase("NOT");
                this.mapElementsColumn.put("NN_DEFERRABLE", bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((string = Token.getStringAfter(string2, "INITIALLY")).length() > 0) {
                String string4 = Token.getFirstToken(string);
                this.mapElementsColumn.put("NN_INITIALLY", string4);
            }
            if (Token.hasToken(string2, "RELY")) {
                this.mapElementsColumn.put("NN_RELY", Boolean.TRUE);
            } else if (Token.hasToken(string2, "NORELY")) {
                this.mapElementsColumn.put("NN_RELY", Boolean.FALSE);
            }
            if (Token.hasToken(string2, "DISABLE")) {
                this.mapElementsColumn.put("NN_DISABLE", Boolean.TRUE);
            } else if (Token.hasToken(string2, "ENABLE")) {
                this.mapElementsColumn.put("NN_DISABLE", Boolean.FALSE);
            }
            if (Token.hasToken(string2, "NOVALIDATE")) {
                this.mapElementsColumn.put("NN_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(string2, "VALIDATE")) {
                this.mapElementsColumn.put("NN_NOVALIDATE", Boolean.FALSE);
            }
            string = Token.getStringAfter(string2, "EXCEPTIONS");
            if (!"".equals(string)) {
                String string5 = Token.getNameAfterToken(string, "INTO", '\"', '\"');
                this.mapElementsColumn.put("NN_EXCEPTIONS", string5);
            }
        }
    }

    private void initPrimaryOrUnique() {
        boolean bl = Token.hasToken(this.statement, "PRIMARY");
        boolean bl2 = Token.hasToken(this.statement, "KEY");
        if (bl && bl2) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "PRIMARY KEY");
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            boolean bl3 = Token.isTokenEqualTo(this.statement, 1, "UNIQUE");
            if (bl3) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "UNIQUE");
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean bl;
        String string;
        String string2;
        boolean bl2 = this.statement.toUpperCase().indexOf("PRIMARY KEY") > -1;
        boolean bl3 = false;
        if (bl2) {
            String string3 = Token.getStringBeforeToken(this.statement, "PRIMARY");
            if ((string3 = Token.getStringAfterToken(string3, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(string3, "CONSTRAINT")) {
                    string3 = Token.getStringAfterToken(string3, "CONSTRAINT");
                }
                string3 = string3.indexOf(32) == -1 || string3.startsWith("\"") && string3.indexOf("\"", 1) == string3.length() - 1 ? Token.getName(string3) : "";
            }
            this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME", string3);
            string2 = Token.getStringAfter(this.statement, "PRIMARY KEY");
            if (string2.startsWith("(")) {
                string = Token.getValBetweenBrackets(string2, 1).trim();
                this.mapElementsColumn.put("VALUES", string);
                string2 = Token.getValAfterBrackets(string2, 1).trim();
            } else {
                this.mapElementsColumn.put("VALUES", "");
            }
            if (Token.hasToken(string2, "CONSTRAINT")) {
                string2 = Token.getStringBeforeToken(string2, "CONSTRAINT");
            }
            if (!"".equalsIgnoreCase(string2)) {
                bl3 = true;
                if (Token.hasToken(string2, "DEFERRABLE")) {
                    string = Token.getTokenBefore(string2, "DEFERRABLE");
                    boolean bl4 = !string.equalsIgnoreCase("NOT");
                    this.mapElementsColumn.put("PKUK_DEFERRABLE", bl4 ? Boolean.TRUE : Boolean.FALSE);
                }
                if ((string = Token.getStringAfter(string2, "INITIALLY")).length() > 0) {
                    String string4 = Token.getFirstToken(string);
                    this.mapElementsColumn.put("PKUK_INITIALLY", string4);
                }
                if (Token.hasToken(string2, "DISABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.TRUE);
                } else if (Token.hasToken(string2, "ENABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.FALSE);
                }
                if (Token.hasToken(string2, "NOVALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                } else if (Token.hasToken(string2, "VALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.FALSE);
                }
                string = Token.getStringAfter(string2, "EXCEPTIONS");
                if (!"".equals(string)) {
                    String string5 = Token.getNameAfterToken(string, "INTO", '\"', '\"');
                    this.mapElementsColumn.put("PKUK_EXCEPTIONS", string5);
                }
            }
        }
        this.mapElementsColumn.put("PRIMARY KEY", bl2 ? Boolean.TRUE : Boolean.FALSE);
        this.mapElementsColumn.put("IS_PK_CONSTRAINT", bl3 ? Boolean.TRUE : Boolean.FALSE);
        boolean bl5 = bl = this.statement.toUpperCase().indexOf("UNIQUE") > -1;
        if (bl) {
            string2 = Token.getStringBeforeToken(this.statement, "UNIQUE");
            if ((string2 = Token.getStringAfterToken(string2, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(string2, "CONSTRAINT")) {
                    string2 = Token.getStringAfterToken(string2, "CONSTRAINT");
                }
                string2 = string2.indexOf(32) == -1 || string2.startsWith("\"") && string2.indexOf("\"", 1) == string2.length() - 1 ? Token.getName(string2) : "";
            }
            this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME", string2);
            string = Token.getStringAfter(this.statement, "UNIQUE");
            if (string.startsWith("(")) {
                String string6 = Token.removeQuotes(Token.getValBetweenBrackets(string, 1).trim());
                this.mapElementsColumn.put("VALUES", string6);
                string = Token.getValAfterBrackets(string, 1).trim();
            } else {
                this.mapElementsColumn.put("VALUES", "");
            }
            if (Token.hasToken(string, "CONSTRAINT")) {
                string = Token.getStringBeforeToken(string, "CONSTRAINT");
            }
            if (!"".equalsIgnoreCase(string)) {
                String string7;
                if (Token.hasToken(string, "DEFERRABLE")) {
                    String string8 = Token.getTokenBefore(string, "DEFERRABLE");
                    boolean bl6 = !string8.equalsIgnoreCase("NOT");
                    this.mapElementsColumn.put("PKUK_DEFERRABLE", bl6 ? Boolean.TRUE : Boolean.FALSE);
                }
                if ((string7 = Token.getStringAfter(string, "INITIALLY")).length() > 0) {
                    String string9 = Token.getFirstToken(string7);
                    this.mapElementsColumn.put("PKUK_INITIALLY", string9);
                }
                if (Token.hasToken(string, "DISABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.TRUE);
                } else if (Token.hasToken(string, "ENABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.FALSE);
                }
                if (Token.hasToken(string, "NOVALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                } else if (Token.hasToken(string, "VALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.FALSE);
                }
                string7 = Token.getStringAfter(string, "EXCEPTIONS");
                if (!"".equals(string7)) {
                    String string10 = Token.getNameAfterToken(string7, "INTO", '\"', '\"');
                    this.mapElementsColumn.put("PKUK_EXCEPTIONS", string10);
                }
            }
        }
        this.mapElementsColumn.put("UNIQUE", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private void initWithDefault() {
        boolean bl = Token.hasToken(this.statement, "DEFAULT");
        if (bl) {
            String string = Token.getStringAfter(this.statement, "DEFAULT");
            String string2 = Token.getFirstTextLiteral(string);
            if (string2.equals("")) {
                if (string.startsWith("(")) {
                    string2 = "(" + Token.getValBetweenBrackets(string, 1) + ")";
                } else {
                    string2 = string.startsWith("\"") ? "\"" + Token.getFirstName(string, '\"', '\"') + "\"" : Token.getFirstToken(string);
                    String string3 = Token.getStringAfter(string, string2);
                    if (string3.startsWith("(")) {
                        string2 = string2 + "(" + Token.getValBetweenBrackets(string3, 1) + ")";
                    }
                }
            }
            this.statement = Token.getStringAfter(this.statement, "DEFAULT");
            this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
            if (!(string2.equalsIgnoreCase("REFERENCES") || string2.equalsIgnoreCase("CONSTRAINT") || string2.equalsIgnoreCase("FIELDPROC"))) {
                this.mapElementsColumn.put("DEFAULT", string2);
            }
        } else {
            this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
        }
    }

    private void initConstraintCheck() {
        boolean bl = Token.hasToken(this.statement, "CHECK");
        if (bl) {
            String string;
            String string2 = Token.getStringBeforeToken(this.statement, "CHECK");
            if ((string2 = Token.getStringAfterToken(string2, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(string2, "CONSTRAINT")) {
                    string2 = Token.getStringAfterToken(string2, "CONSTRAINT");
                }
                string2 = string2.indexOf(32) == -1 || string2.startsWith("\"") && string2.indexOf("\"", 1) == string2.length() - 1 ? Token.getName(string2) : "";
            }
            this.mapElementsColumn.put("CHECK_CONSTRAINT", string2);
            String string3 = Token.getStringAfter(this.statement, "CHECK");
            String string4 = Token.getValBetweenBrackets(string3, 1).trim();
            this.mapElementsColumn.put("CHECK", string4);
            string3 = Token.getValAfterBrackets(string3, 1);
            if (Token.hasToken(string3, "CONSTRAINT")) {
                string3 = Token.getStringBeforeToken(string3, "CONSTRAINT");
            }
            if (Token.hasToken(string3, "DEFERRABLE")) {
                string = Token.getTokenBefore(string3, "DEFERRABLE");
                boolean bl2 = !string.equalsIgnoreCase("NOT");
                this.mapElementsColumn.put("CHK_DEFERRABLE", bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((string = Token.getStringAfter(string3, "INITIALLY")).length() > 0) {
                String string5 = Token.getFirstToken(string);
                this.mapElementsColumn.put("CHK_INITIALLY", string5);
            }
            if (Token.hasToken(string3, "DISABLE")) {
                this.mapElementsColumn.put("CHK_DISABLE", Boolean.TRUE);
            } else if (Token.hasToken(string3, "ENABLE")) {
                this.mapElementsColumn.put("CHK_DISABLE", Boolean.FALSE);
            }
            if (Token.hasToken(string3, "NOVALIDATE")) {
                this.mapElementsColumn.put("CHK_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(string3, "VALIDATE")) {
                this.mapElementsColumn.put("CHK_NOVALIDATE", Boolean.FALSE);
            }
            string = Token.getStringAfter(string3, "EXCEPTIONS");
            if (!"".equals(string)) {
                String string6 = Token.getNameAfterToken(string, "INTO", '\"', '\"');
                this.mapElementsColumn.put("CHK_EXCEPTIONS", string6);
            }
        }
        this.mapElementsColumn.put("HAS_CHECK_CONSTRAINT", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private void initUsingIndex() {
        if (Token.hasString(this.statement.toUpperCase(), "USING INDEX")) {
            String string;
            String string2;
            this.mapElementsColumn.put("USING INDEX", Boolean.TRUE);
            this.statement = Token.getStringAfter(this.statement, "USING INDEX");
            if (this.statement.startsWith("(")) {
                this.mapElementsColumn.put("BY CREATE INDEX STATEMENT", Token.getValBetweenBrackets(this.statement, 1).trim());
            }
            if ("GLOBAL".equalsIgnoreCase(Token.getFirstToken(this.statement))) {
                this.mapElementsColumn.put("GLOBAL", Boolean.TRUE);
                if (Token.hasToken(this.statement, "HASH")) {
                    this.statement = Token.getStringAfter(this.statement, "HASH");
                    string2 = Token.getValBetweenBrackets(this.statement, 1).trim();
                    this.mapElementsColumn.put("COLUMN_LIST", string2);
                    this.statement = Token.getValAfterBrackets(this.statement, 1);
                    if (Token.getFirstToken(this.statement).equalsIgnoreCase("PARTITIONS")) {
                        this.mapElementsColumn.put("GLOBAL HASH PARTITION BY QUANTITY", Boolean.TRUE);
                        this.mapElementsColumn.put("QUANTITY", Token.getTokenAfter(this.statement, "PARTITIONS"));
                        string = Token.getStringAfter(this.statement, "OVERFLOW STORE IN");
                        String string3 = Token.getValBetweenBrackets(string, 1).trim();
                        this.mapElementsColumn.put("OVERFLOW TABLESPACES", string3);
                        string = Token.getStringAfter(this.statement, "STORE IN", "OVERFLOW");
                        string3 = Token.getValBetweenBrackets(string, 1).trim();
                        this.mapElementsColumn.put("HASH TABLESPACES", string3);
                    } else {
                        this.mapElementsColumn.put("GLOBAL HASH PARTITION BY LIST", Boolean.TRUE);
                        string = Token.getValBetweenBrackets(this.statement, 1).trim();
                        this.mapElementsColumn.put("PARTITIONS", string);
                    }
                } else {
                    this.mapElementsColumn.put("GLOBAL BY RANGE", Boolean.TRUE);
                    this.statement = Token.getStringAfter(this.statement, "RANGE");
                    string2 = Token.getValBetweenBrackets(this.statement, 1).trim();
                    this.mapElementsColumn.put("COLUMN_LIST", string2);
                    this.statement = Token.getValAfterBrackets(this.statement, 1);
                    string = Token.getValBetweenBrackets(this.statement, 1).trim();
                    this.mapElementsColumn.put("PARTITIONS", string);
                }
            } else {
                this.mapElementsColumn.put("GLOBAL", Boolean.FALSE);
            }
            if ("LOCAL".equalsIgnoreCase(Token.getFirstToken(this.statement))) {
                this.mapElementsColumn.put("LOCAL", Boolean.TRUE);
            }
            if (Token.hasToken(this.statement, "PCTFREE")) {
                string2 = Token.getTokenAfter(this.statement, "PCTFREE").trim();
                this.mapElementsColumn.put("PCTFREE", string2);
            } else {
                this.mapElementsColumn.put("PCTFREE", "");
            }
            if (Token.hasToken(this.statement, "INITRANS")) {
                string2 = Token.getTokenAfter(this.statement, "INITRANS").trim();
                this.mapElementsColumn.put("INITRANS", string2);
            } else {
                this.mapElementsColumn.put("INITRANS", "");
            }
            if (Token.hasToken(this.statement, "MAXTRANS")) {
                string2 = Token.getTokenAfter(this.statement, "MAXTRANS").trim();
                this.mapElementsColumn.put("MAXTRANS", string2);
            } else {
                this.mapElementsColumn.put("MAXTRANS", "");
            }
            if (Token.hasToken(this.statement, "TABLESPACE")) {
                string2 = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
                this.mapElementsColumn.put("TABLESPACE", string2);
            } else {
                this.mapElementsColumn.put("TABLESPACE", "");
            }
            if (Token.hasToken(this.statement, "STORAGE")) {
                this.statement = Token.getStringAfter(this.statement, "STORAGE");
                string2 = Token.getValBetweenBrackets(this.statement, 1).trim();
                this.mapElementsColumn.put("STORAGE", Boolean.TRUE);
                if (Token.hasToken(string2, "INITIAL")) {
                    string = Token.getTokenAfter(string2, "INITIAL").trim();
                    this.mapElementsColumn.put("INITIAL", string);
                } else {
                    this.mapElementsColumn.put("INITIAL", "");
                }
                if (Token.hasToken(string2, "NEXT")) {
                    string = Token.getTokenAfter(string2, "NEXT").trim();
                    this.mapElementsColumn.put("NEXT", string);
                } else {
                    this.mapElementsColumn.put("NEXT", "");
                }
                if (Token.hasToken(string2, "PCTINCREASE")) {
                    string = Token.getTokenAfter(string2, "PCTINCREASE").trim();
                    this.mapElementsColumn.put("PCTINCREASE", string);
                } else {
                    this.mapElementsColumn.put("PCTINCREASE", "");
                }
                if (Token.hasToken(string2, "MINEXTENTS")) {
                    string = Token.getTokenAfter(string2, "MINEXTENTS").trim();
                    this.mapElementsColumn.put("MINEXTENTS", string);
                } else {
                    this.mapElementsColumn.put("MINEXTENTS", "");
                }
                if (Token.hasToken(string2, "MAXEXTENTS")) {
                    string = Token.getTokenAfter(string2, "MAXEXTENTS").trim();
                    this.mapElementsColumn.put("MAXEXTENTS", string);
                } else {
                    this.mapElementsColumn.put("MAXEXTENTS", "");
                }
                if (Token.hasToken(string2, "FREELISTS")) {
                    string = Token.getTokenAfter(string2, "FREELISTS").trim();
                    this.mapElementsColumn.put("FREELISTS", string);
                } else {
                    this.mapElementsColumn.put("FREELISTS", "");
                }
                if (Token.hasToken(string2, "GROUPS")) {
                    string = Token.getTokenAfter(string2, "GROUPS").trim();
                    this.mapElementsColumn.put("GROUPS", string);
                } else {
                    this.mapElementsColumn.put("GROUPS", "");
                }
                if (Token.hasToken(string2, "BUFFER_POOL")) {
                    string = Token.getTokenAfter(string2, "BUFFER_POOL").trim();
                    this.mapElementsColumn.put("BUFFER_POOL", string);
                } else {
                    this.mapElementsColumn.put("BUFFER_POOL", "");
                }
            } else {
                this.mapElementsColumn.put("STORAGE", Boolean.FALSE);
            }
            if (Token.hasToken(this.statement, "NOLOGGING")) {
                this.mapElementsColumn.put("LOGGING", "NO");
            } else if (Token.hasToken(this.statement, "LOGGING")) {
                this.mapElementsColumn.put("LOGGING", "YES");
            }
        } else {
            this.mapElementsColumn.put("USING INDEX", Boolean.FALSE);
        }
    }

    private void initReferences() {
        boolean bl = Token.hasToken(this.statement, "REFERENCES");
        if (bl) {
            boolean bl2;
            String string = Token.getStringBeforeToken(this.statement, "REFERENCES");
            String string2 = Token.getLastToken(string);
            String string3 = string.substring(0, string.length() - string2.length()).trim().toUpperCase();
            if (string3.endsWith("CONSTRAINT")) {
                this.mapElementsColumn.put("CONSTRAINT_NAME", string2);
            }
            this.statement = Token.getStringAfterToken(this.statement, "REFERENCES");
            String string4 = Token.getFirstToken(this.statement);
            int n = string4.indexOf("(");
            if (n > 0) {
                string4 = string4.substring(0, n);
            }
            this.mapElementsColumn.put("REFERENCES", string4);
            this.statement = Token.cutTokenFromFront(this.statement, string4);
            boolean bl3 = Token.hasString(this.statement, "(");
            if (bl3) {
                String string5 = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", string5);
            }
            if (bl2 = Token.isTokenEqualTo(this.statement, 1, "ON")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ON DELETE");
                String string6 = Token.getFirstToken(this.statement);
                if (string6.equalsIgnoreCase("NO")) {
                    if (Token.getTokenAfter(this.statement, "NO").equalsIgnoreCase("ACTION")) {
                        string6 = "NO ACTION";
                    }
                } else if (string6.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").equalsIgnoreCase("NULL")) {
                    string6 = "SET NULL";
                }
                this.mapElementsColumn.put("ON DELETE", string6);
                this.statement = Token.cutTokenFromFront(this.statement, string6);
            }
        }
    }

    private void initWithRowid() {
        boolean bl = Token.hasString(this.statement.toUpperCase(), "WITH ROWID");
        if (bl) {
            this.mapElementsColumn.put("WITH ROWID", Boolean.TRUE);
        }
    }

    public Map getElementsColumn(String string, RDBMSType rDBMSType) {
        this.parseColumns(string, rDBMSType);
        return this.mapElementsColumn;
    }
}

