/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableOraclev10g
extends DDLStatementHandler
implements AlterTableHandler {
    private Table table;
    private RDBMSSite site = null;
    private StorageDesignOraclev10g storageDesign = null;
    private FKIndexAssociation fkass = null;
    private String name = "";
    private String line;
    private static final Logger LOGGER = new Logger(SHAlterTableOraclev10g.class);
    protected List statemensList = new ArrayList();

    public SHAlterTableOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterTableOraclev10g.clearCR(string);
        this.line = string;
        this.statement = string2;
        if (Token.startsWithString(string2, "ALTER TABLE")) {
            this.parseAlterTable(string2);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseAlterTable(String string) {
        try {
            this.initTable();
            if (this.table == null) {
                return;
            }
            this.site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
            String[] stringArray = string.split(" ADD ");
            if (stringArray.length == 1) {
                stringArray = string.split(" add ");
            }
            boolean bl = false;
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().trim();
                int n = 0;
                if (string2.startsWith("(")) {
                    n = 1;
                    int n2 = 0;
                    while (n2 > -1) {
                        n2 = string2.indexOf(44, n);
                        while (n2 > -1 && Token.hasOpenBracketNoClose(string2.substring(n, n2))) {
                            n2 = string2.indexOf(44, n2 + 1);
                        }
                        if (n2 <= -1) continue;
                        bl = this.processClause(string2.substring(n, n2), bl);
                        n = n2 + 1;
                    }
                }
                bl = this.processClause(string2.substring(n), bl);
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(SHAlterTableOraclev10g.FormatCR(this.line, "\n"));
        }
    }

    private boolean processClause(String string, boolean bl) {
        if (this.isPK(string)) {
            this.initPK(string);
        } else if (this.isUK(string)) {
            this.initUK(string);
        } else if (this.isFK(string)) {
            if (!bl) {
                this.statemensList.add(this.statement);
                bl = true;
            }
        } else if (this.isCheck(string)) {
            this.initCheck(string);
        }
        return bl;
    }

    public void parseFK(String string) {
        int n;
        this.fkass = null;
        this.statement = string;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if ((n = string.toUpperCase().indexOf("CONSTRAINT")) < 0) {
            n = string.toUpperCase().indexOf("FOREIGN");
        }
        if (n > -1) {
            String string2 = string.substring(n);
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                RelationalContainerProxy relationalContainerProxy;
                Object object;
                Table table;
                String string4;
                Object object2;
                string3 = stringTokenizer.nextToken().trim();
                while (Token.hasOpenBracketNoClose(string3) && stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + ", " + stringTokenizer.nextToken().trim();
                }
                if (this.table != null) {
                    this.site = this.design.getSelectedRDBMSSite();
                    this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
                    if (!this.isFK(string3)) continue;
                    this.initForeignKey(string3);
                    if (this.storageDesign == null || (object2 = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getByName(this.name)) == null) continue;
                    if (Token.hasToken(string3, "DEFERRABLE")) {
                        boolean bl = Token.getTokenBefore(string3, "DEFERRABLE").equalsIgnoreCase("NOT");
                        ((FKProxyOracle)object2).setDeferrable(bl ? "NO" : "YES");
                    }
                    if (Token.hasToken(string3, "INITIALLY")) {
                        String string5 = Token.getTokenAfter(string3, "INITIALLY").toUpperCase();
                        ((FKProxyOracle)object2).setInitially(string5);
                    }
                    if (Token.hasToken(string3, "DISABLE")) {
                        ((FKProxyOracle)object2).setEnable("NO");
                        ((FKProxyOracle)object2).setValidate(Token.hasToken(string3, "VALIDATE") ? "YES" : "NO");
                    } else {
                        ((FKProxyOracle)object2).setEnable("YES");
                        ((FKProxyOracle)object2).setValidate(Token.hasToken(string3, "NOVALIDATE") ? "NO" : "YES");
                    }
                    if (!Token.hasToken(string3, "INTO")) continue;
                    String string6 = Token.getQuotedNameAfterToken(string3, "INTO");
                    string4 = this.getNameOnly(string6);
                    table = null;
                    object = Token.getValBeforeCharacter(string6, '.');
                    string4 = Token.removeQuotes(string4);
                    if (object != null && !"".equals(object)) {
                        object = Token.removeQuotes((String)object);
                        table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName((String)object, string4);
                    }
                    if (table == null) {
                        table = this.getTableFor(string4);
                    }
                    if (table == null || (relationalContainerProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) == null) continue;
                    ((FKProxyOracle)object2).setExceptionsTable((TableProxyOracle)relationalContainerProxy);
                    continue;
                }
                if (!this.modify(string) || this.storageDesign == null) continue;
                object2 = Token.getQuotedNameAfterToken(string3, "CONSTRAINT");
                TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
                string4 = this.getNameOnly(Token.getQuotedNameAfterToken(string3, "INTO"));
                table = this.getTableFor(string4);
                object = null;
                if (table != null) {
                    object = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                }
                if ((relationalContainerProxy = (PKProxyOracle)this.storageDesign.getPKProxySet().getByName((String)object2)) != null) {
                    if (object == null) continue;
                    relationalContainerProxy.setExceptionsTable((TableProxyOracle)object);
                    continue;
                }
                UniqueOracle uniqueOracle = (UniqueOracle)this.storageDesign.getUniqueSet().getByName((String)object2);
                if (uniqueOracle != null) {
                    if (object == null) continue;
                    uniqueOracle.setExceptionsTable((TableProxyOracle)object);
                    continue;
                }
                ColumnProxyOracle columnProxyOracle = this.getColumnPrByNNCoinstraintName(tableProxy, (String)object2);
                if (columnProxyOracle == null) continue;
                columnProxyOracle.setNncExceptionsTable((TableProxyOracle)object);
            }
        }
    }

    private ColumnProxyOracle getColumnPrByNNCoinstraintName(TableProxy tableProxy, String string) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            String string2;
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            String string3 = string2 = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return columnProxyOracle;
        }
        return null;
    }

    private boolean isFK(String string) {
        return Token.hasToken(string, "FOREIGN");
    }

    private boolean modify(String string) {
        return Token.hasString(string, "MODIFY CONSTRAINT");
    }

    private void initTable() throws ObjectDoesNotExistException {
        this.table = null;
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String string2 = this.getNameFor(string);
        String string3 = Token.getValBeforeCharacter(string, '.');
        if (string3 != null && !"".equals(string3)) {
            this.table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string3, string2);
        }
        if (this.table == null) {
            this.table = this.getTableFor(string2);
        }
        if (this.table == null) {
            this.importLog.addError("Table with name " + string + " does not exist.");
            throw new ObjectDoesNotExistException("Table with name " + string);
        }
    }

    private void initForeignKey(String string) {
        boolean bl = false;
        String string2 = string;
        if (string2.trim().startsWith("(")) {
            string2 = Token.getValBetweenBrackets(string2);
        }
        bl = Token.hasToken(string2, "FOREIGN");
        while (bl) {
            String string3;
            int n = string2.toUpperCase().indexOf("FOREIGN");
            String string4 = string2.substring(n);
            String string5 = "FK_ASS";
            if (Token.hasToken(string2, "CONSTRAINT")) {
                string5 = Token.getQuotedNameAfterToken(string2, "CONSTRAINT");
            } else {
                String string6 = this.table.getName();
                if (string6.length() > 25) {
                    string6 = string6.substring(0, 25);
                }
                string5 = string6 + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = string5;
            int n2 = string4.indexOf(41);
            String string7 = string4.substring(0, n2 + 1).trim();
            String string8 = Token.getValBetweenBrackets(string7);
            List list = this.getColumnNames(string8);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column[] columnArray = (Column[])this.table.getElements();
            block1: for (String string9 : list) {
                for (int i = 0; i < columnArray.length; ++i) {
                    string3 = columnArray[i].getName().trim();
                    if (!string9.equalsIgnoreCase(string3)) continue;
                    arrayList.add(columnArray[i]);
                    continue block1;
                }
            }
            int n3 = string4.toUpperCase().indexOf("REFERENCES");
            string4 = string4.substring(n3);
            String string10 = Token.getNameAfterToken(string4, "REFERENCES", '\"', '\"').trim();
            string3 = Token.getValBeforeCharacter(string10, '.');
            String string11 = this.getNameFor(string10);
            string11 = Token.removeQuotes(string11);
            Table table = null;
            if (string3 != null && !"".equals(string3)) {
                string3 = Token.removeQuotes(string3);
                table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string3, string11);
            }
            if (table == null) {
                table = this.getTableFor(string11);
            }
            if (table != null) {
                Object object;
                Object object2;
                Object object3;
                boolean bl2 = Token.hasString(string4, "(");
                if (bl2) {
                    object3 = Token.getValBetweenBrackets(string4, 1);
                    object2 = this.getColumnNames((String)object3);
                    FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object = SHAlterTableOraclev10g.getUniqueIndexForColumnNames(table, (List)object2);
                    if (object != null) {
                        this.fkass = this.table.addFK((KeyObject)object, null, fKIndexAssociationReference);
                        this.fkass.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                        this.fkass.getLocalFKIndex().setName(string5);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns(this.fkass, arrayList, (Index)object);
                        } else {
                            this.fixFKColumns(this.fkass, arrayList, (Index)object);
                        }
                        boolean bl3 = Token.hasToken(string4, "DELETE");
                        if (bl3) {
                            String string12 = Token.getTokenAfter(string4, "DELETE");
                            if (string12.equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").equalsIgnoreCase("ACTION")) {
                                    string12 = "NO ACTION";
                                }
                            } else if (string12.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").equalsIgnoreCase("NULL")) {
                                string12 = "SET NULL";
                            }
                            String[] stringArray = this.fkass.getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!string12.equalsIgnoreCase(stringArray[i])) continue;
                                this.fkass.setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                } else {
                    object3 = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object2 = (Index)table.getPK();
                    if (object2 != null) {
                        this.fkass = this.table.addFK((KeyObject)object2, null, (FKIndexAssociationReference)object3);
                        this.fkass.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                        this.fkass.getLocalFKIndex().setName(string5);
                        this.replaceAllColumns(this.fkass, arrayList, (Index)object2);
                        boolean bl4 = Token.hasToken(string4, "DELETE");
                        if (bl4) {
                            object = Token.getTokenAfter(string4, "DELETE");
                            if (((String)object).equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").equalsIgnoreCase("ACTION")) {
                                    object = "NO ACTION";
                                }
                            } else if (((String)object).equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").equalsIgnoreCase("NULL")) {
                                object = "SET NULL";
                            }
                            String[] stringArray = this.fkass.getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!((String)object).equalsIgnoreCase(stringArray[i])) continue;
                                this.fkass.setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                }
            } else {
                String string13 = "Referenced table " + string11 + " doesn't exist\n" + this.statement;
                this.importLog.addError(string13);
            }
            string2 = string4;
            bl = Token.hasToken(string2, "FOREIGN");
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.getName(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n;
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40)).trim();
        }
        if ((n = string.indexOf(46)) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        string = Token.getName(string);
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String string) {
        Column column = null;
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column2 = columnArray[i];
            if (!column2.getName().equalsIgnoreCase(string)) continue;
            column = column2;
            break;
        }
        return column;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Column[] columnArray;
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Column[] columnArray2 = (Column[])index.getElements();
        if (columnArray2.length != list.size()) {
            columnArray = new StringBuffer();
            columnArray.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(columnArray.toString());
            this.importLog.addError(columnArray.toString());
        }
        columnArray = list.toArray(new Column[0]);
        fKIndexAssociation.swapFKColumnsWith(columnArray);
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isPK(String string) {
        return string.toUpperCase().indexOf("PRIMARY KEY") > -1;
    }

    private void initPK(String string) {
        Object object;
        String string2 = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string2 = Token.getQuotedNameAfterToken(string, "CONSTRAINT");
        } else {
            object = this.table.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_PK";
        }
        object = null;
        String string3 = Token.getValBetweenBrackets(Token.getStringAfter(string, "PRIMARY KEY"), 1).trim();
        List list = this.getColumnNames(string3);
        if (list.size() > 0) {
            Object object22;
            object = this.table.createIndex();
            for (Object object22 : list) {
                Column column = this.getColumnFor(this.table, (String)object22);
                if (column == null) continue;
                ((Index)object).add(column);
            }
            ((KeyObject)object).makePK();
            if (string2 != null) {
                ((DesignObject)object).setName(string2);
            }
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            object22 = (PKProxyOraclev10g)this.storageDesign.getPKProxySet().getProxy(((ModelIDObject)object).getObjectID());
            boolean bl = Token.hasString(string, "PRIMARY KEY");
            if (bl && object22 != null) {
                String string4;
                if (Token.hasToken(string, "DEFERRABLE")) {
                    ((PKProxyOracle)object22).setDeferrable("YES");
                }
                if (Token.hasToken(string, "INITIALLY")) {
                    string4 = Token.getTokenAfter(string, "INITIALLY");
                    ((PKProxyOracle)object22).setInitially(string4);
                }
                if (Token.hasToken(string, "DISABLE")) {
                    ((PKProxyOracle)object22).setEnable("NO");
                    ((PKProxyOracle)object22).setValidate(Token.hasToken(string, "VALIDATE") ? "YES" : "NO");
                }
                if (Token.hasToken(string, "NOVALIDATE")) {
                    ((PKProxyOracle)object22).setValidate("NO");
                }
                if (Token.hasString(string, "USING INDEX")) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    String string5;
                    String string6;
                    Object object8;
                    string4 = Token.getStringAfter(string, "USING INDEX");
                    String string7 = Token.getFirstToken(string4);
                    if (string7.equalsIgnoreCase("LOCAL")) {
                        ((PKProxyOraclev10g)object22).setUsingIndex("LOCAL");
                    } else if (string7.equalsIgnoreCase("GLOBAL")) {
                        object8 = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                        ((PKProxyOraclev10g)object22).setIndexGlobalPL((IndexGlobalPartitionsListOracle)object8);
                        ((IndexGlobalPartitionsListOracle)object8).setIndex((IndexProxy)object22);
                        string6 = Token.getStringAfter(string4, "PARTITION BY");
                        if (Token.getFirstToken(string6).equalsIgnoreCase("RANGE")) {
                            ((PKProxyOraclev10g)object22).setUsingIndex("GLOBAL BY RANGE");
                        } else if (Token.getFirstToken(string6).equalsIgnoreCase("HASH") && Token.hasToken(string6, "PARTITIONS")) {
                            StringTokenizer stringTokenizer;
                            ((PKProxyOraclev10g)object22).setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                            try {
                                int n = Integer.parseInt(Token.getTokenAfter(string6, "PARTITIONS"));
                                ((IndexGlobalPartitionsListOraclev10g)object8).setHashPQuantity(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHAlterTableOraclev10g.initPK : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong QUANTITY format in statement " + string);
                            }
                            string5 = Token.getStringAfter(string6, "STORE IN (");
                            string5 = Token.getTokenBefore(string5, ")");
                            if (string5 != null && !string5.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string5, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    object7 = Token.getName(stringTokenizer.nextToken().trim());
                                    object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object7);
                                    if (((String)object7).equalsIgnoreCase("")) continue;
                                    if (object6 == null && !"SYSTEM".equalsIgnoreCase((String)object7)) {
                                        object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object6).setName((String)object7);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                                    }
                                    if (object6 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)object8).setHashPTableSpaces(((ModelIDObject)object6).getObjectID());
                                }
                            }
                            string5 = Token.getStringAfter(string6, "OVERFLOW");
                            string5 = Token.getStringAfter(string5, "STORE IN");
                            if ((string5 = Token.getValBetweenBrackets(string5, 1)) != null && !string5.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string5, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    object7 = Token.getName(stringTokenizer.nextToken().trim());
                                    object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object7);
                                    if (object6 == null && !"SYSTEM".equalsIgnoreCase((String)object7)) {
                                        object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object6).setName((String)object7);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                                    }
                                    if (object6 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)object8).setIOTOverflowHashPTSSet(((ModelIDObject)object6).getObjectID());
                                }
                            }
                        } else {
                            ((PKProxyOraclev10g)object22).setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                            string5 = Token.getStringAfter(string6, "PARTITION");
                            int n = string5.toUpperCase().indexOf("PARTITION ");
                            if (n > -1) {
                                object7 = string5.substring(n);
                                while (((String)object7).toUpperCase().indexOf("PARTITION ") > -1) {
                                    TableSpaceOraclev10g tableSpaceOraclev10g;
                                    String string8;
                                    if (((String)object7).toUpperCase().indexOf("PARTITION ", 9) > -1) {
                                        object6 = ((String)object7).substring(0, ((String)object7).toUpperCase().indexOf("PARTITION ", 9));
                                        object7 = ((String)object7).substring(((String)object7).toUpperCase().indexOf("PARTITION ", 9));
                                    } else {
                                        object6 = object7;
                                        object7 = "";
                                    }
                                    object6 = Token.cutFirstToken((String)object6);
                                    object5 = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                    object4 = Token.getFirstToken((String)object6).trim();
                                    ((StorageObject)object5).setName((String)object4);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                                    ((IndexHashPartitionOracle)object5).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)object8);
                                    Object object9 = object6;
                                    if (Token.hasToken((String)object6, "LOB")) {
                                        object9 = Token.getStringBefore((String)object9, "LOB");
                                    }
                                    if (Token.hasString((String)object9, "OVERFLOW TABLESPACE")) {
                                        string8 = Token.getStringAfterToken((String)object9, "OVERFLOW");
                                        string8 = Token.getQuotedNameAfterToken(string8, "TABLESPACE");
                                        object9 = Token.getStringBefore((String)object9, "OVERFLOW TABLESPACE");
                                        tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string8);
                                        if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string8)) {
                                            tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            tableSpaceOraclev10g.setName(string8);
                                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                        }
                                        if (tableSpaceOraclev10g != null) {
                                            ((IndexHashPartitionOracle)object5).setOverflowTableSpace(tableSpaceOraclev10g);
                                        }
                                    }
                                    if (!Token.hasToken((String)object9, "TABLESPACE") || (string8 = Token.getQuotedNameAfterToken((String)object9, "TABLESPACE")).equalsIgnoreCase("")) continue;
                                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string8);
                                    if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string8)) {
                                        tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpaceOraclev10g.setName(string8);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                    }
                                    if (tableSpaceOraclev10g == null) continue;
                                    ((IndexHashPartitionOracle)object5).setTableSpace(tableSpaceOraclev10g);
                                }
                            }
                        }
                        string5 = Token.getStringAfter(string, "GLOBAL PARTITION");
                        object3 = Token.getStringAfter(string5, "(");
                        if (Token.hasToken((String)object3, ")")) {
                            object3 = Token.getStringBefore((String)object3, ")");
                        }
                        ((IndexGlobalPartitionsListOracle)object8).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)object8).columnNamesToColumnIDs((String)object3));
                    } else if (string7.equalsIgnoreCase("(")) {
                        ((PKProxyOraclev10g)object22).setUsingIndex("BY CREATE INDEX STATEMENT");
                        ((PKProxyOraclev10g)object22).setCreateIndexStatement(Token.getValBetweenBrackets(string4));
                    } else {
                        ((PKProxyOraclev10g)object22).setUsingIndex("BY INDEX NAME");
                        if (string7.equalsIgnoreCase("PCTFREE")) {
                            ((PKProxyOracle)object22).setExistingIndex(null);
                        } else {
                            object8 = Token.getFirstName(string4, '\"', '\"');
                            string6 = this.getNameFor((String)object8);
                            string5 = Token.getValBeforeCharacter((String)object8, '.');
                            object3 = this.table.getIndexByNameAndSchema(string5, string6);
                            if (object3 == null) {
                                object3 = this.table.getIndexByName(string6);
                            }
                            if (object3 != null) {
                                object7 = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object3).getObjectID());
                                ((PKProxyOracle)object22).setExistingIndex((IndexProxyOracle)object7);
                            }
                        }
                    }
                    if (((PKProxyOracle)object22).getExistingIndex() == null && !((PKProxyOraclev10g)object22).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        boolean bl2;
                        String string9;
                        String string10;
                        object8 = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                        string6 = Token.getTokenAfter(string4, "PCTFREE");
                        if (!"".equalsIgnoreCase(string6)) {
                            try {
                                int n = Integer.parseInt(string6);
                                ((SegmentOracle)object8).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string10 = Token.getTokenAfter(string4, "INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string10);
                                ((SegmentOracle)object8).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string9 = Token.getTokenAfter(string4, "MAXTRANS"))) {
                            try {
                                int n = Integer.parseInt(string9);
                                ((SegmentOracle)object8).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl2 = Token.hasToken(string4, "STORAGE")) {
                            String string11;
                            String string12;
                            String string13;
                            String string14;
                            String string15;
                            object6 = Token.getStringAfter(string4, "STORAGE");
                            object5 = Token.getTokenAfter((String)object6, "INITIALLY");
                            if (!"".equalsIgnoreCase((String)object5)) {
                                try {
                                    long l = Long.parseLong((String)object5);
                                    ((SegmentOracle)object8).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object4 = Token.getTokenAfter((String)object6, "NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object4);
                                    ((SegmentOracle)object8).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string15 = Token.getTokenAfter((String)object6, "PCTINCREASE"))) {
                                try {
                                    int n = Integer.parseInt(string15);
                                    ((SegmentOracle)object8).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string14 = Token.getTokenAfter((String)object6, "MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string14);
                                    ((SegmentOracle)object8).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string13 = Token.getTokenAfter((String)object6, "MAXEXTENTS"))) {
                                ((SegmentOracle)object8).setSCMaxExtents(string13);
                            }
                            if (!"".equalsIgnoreCase(string12 = Token.getTokenAfter((String)object6, "FREELISTS"))) {
                                try {
                                    int n = Integer.parseInt(string12);
                                    ((SegmentOracle)object8).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string11 = Token.getTokenAfter((String)object6, "GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string11);
                                    ((SegmentOracle)object8).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string16 = Token.getQuotedNameAfterToken((String)object6, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string11)) {
                                ((SegmentOracle)object8).setSCBufferPool(string16);
                            }
                        }
                        if (!(((String)(object6 = Token.getQuotedNameAfterToken(string4, "TABLESPACE"))).equalsIgnoreCase("LOGGING") || ((String)object6).equalsIgnoreCase(((PKProxyOraclev10g)object22).getIndexSort()) || ((String)object6).equalsIgnoreCase(""))) {
                            object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object6);
                            if (object5 == null && !"SYSTEM".equalsIgnoreCase((String)object6)) {
                                object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object5).setName((String)object6);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                            }
                            if (object5 != null) {
                                ((PKProxyOracle)object22).setTableSpace((TableSpaceOracle)object5);
                            }
                        }
                        if (Token.hasToken(string4, "NOSORT")) {
                            ((PKProxyOraclev10g)object22).setIndexSort("NO");
                        } else if (Token.hasToken(string4, "REVERSE")) {
                            ((PKProxyOraclev10g)object22).setIndexSort("REVERSE");
                        } else {
                            ((PKProxyOraclev10g)object22).setIndexSort("SORTED");
                        }
                        if (Token.hasToken(string4, "NOLOGGING")) {
                            ((PKProxyOracle)object22).setLogging("NO");
                        } else if (Token.hasToken(string4, "LOGGING")) {
                            ((PKProxyOracle)object22).setLogging("YES");
                        } else {
                            ((PKProxyOracle)object22).setLogging("");
                        }
                        boolean bl3 = Token.hasString(string4, "COMPUTE STATISTICS");
                        if (bl3) {
                            ((PKProxyOraclev10g)object22).setComputeStatistics("YES");
                        } else {
                            ((PKProxyOraclev10g)object22).setComputeStatistics("NO");
                        }
                        object4 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)object8);
                        ((PKProxyOracle)object22).setIndexSegment((SegmentOracle)object4);
                    }
                }
            }
        }
    }

    private boolean isUK(String string) {
        return string.toUpperCase().indexOf("UNIQUE") > -1;
    }

    private void initUK(String string) {
        Object object;
        String string2 = null;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if (Token.hasToken(string, "CONSTRAINT")) {
            string2 = Token.getQuotedNameAfterToken(string, "CONSTRAINT");
        } else {
            object = this.table.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_UK" + this.table.getUKeys().size();
        }
        object = null;
        String string3 = Token.getValBetweenBrackets(Token.getStringAfter(string, "UNIQUE"), 1).trim();
        List list = this.getColumnNames(string3);
        if (list.size() > 0) {
            Object object2;
            Object object32;
            object = this.table.createIndex();
            for (Object object32 : list) {
                object2 = this.getColumnFor(this.table, (String)object32);
                if (object2 == null) continue;
                ((Index)object).add((ContainedObject)object2);
            }
            ((KeyObject)object).setUnique(true);
            if (string2 != null) {
                ((DesignObject)object).setName(string2);
            }
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            object32 = (UniqueOraclev10g)this.storageDesign.getUniqueSet().getProxy(((ModelIDObject)object).getObjectID());
            if (object32 != null) {
                if (Token.hasToken(string, "DEFERRABLE")) {
                    ((UniqueOracle)object32).setDeferrable("YES");
                }
                if (Token.hasToken(string, "INITIALLY")) {
                    object2 = Token.getTokenAfter(string, "INITIALLY");
                    ((UniqueOracle)object32).setInitially((String)object2);
                }
                if (Token.hasToken(string, "DISABLE")) {
                    ((UniqueOracle)object32).setEnable("NO");
                    ((UniqueOracle)object32).setValidate(Token.hasToken(string, "VALIDATE") ? "YES" : "NO");
                }
                if (Token.hasToken(string, "NOVALIDATE")) {
                    ((UniqueOracle)object32).setValidate("NO");
                }
                if (Token.hasString(string, "USING INDEX")) {
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    String string4;
                    String string5;
                    Object object10;
                    object2 = Token.getStringAfter(string, "USING INDEX");
                    String string6 = Token.getFirstToken((String)object2);
                    if (string6.equalsIgnoreCase("LOCAL")) {
                        ((UniqueOraclev10g)object32).setUsingIndex("LOCAL");
                    } else if (string6.equalsIgnoreCase("GLOBAL")) {
                        object10 = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object10);
                        ((UniqueOraclev10g)object32).setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)object10);
                        ((IndexGlobalPartitionsListOracle)object10).setIndex((IndexProxy)object32);
                        string5 = Token.getStringAfter((String)object2, "PARTITION BY");
                        if (Token.getFirstToken(string5).equalsIgnoreCase("RANGE")) {
                            ((UniqueOraclev10g)object32).setUsingIndex("GLOBAL BY RANGE");
                        } else if (Token.getFirstToken(string5).equalsIgnoreCase("HASH") && Token.hasToken(string5, "PARTITIONS")) {
                            StringTokenizer stringTokenizer;
                            ((UniqueOraclev10g)object32).setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                            try {
                                int n = Integer.parseInt(Token.getTokenAfter(string5, "PARTITIONS"));
                                ((IndexGlobalPartitionsListOraclev10g)object10).setHashPQuantity(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHAlterTableOraclev10g.initPK : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong QUANTITY format in statement " + string);
                            }
                            string4 = Token.getStringAfter(string5, "STORE IN (");
                            string4 = Token.getTokenBefore(string4, ")");
                            if (string4 != null && !string4.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string4, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    object9 = Token.getName(stringTokenizer.nextToken().trim());
                                    object8 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object9);
                                    if (!((String)object9).equalsIgnoreCase("") && object8 == null && !"SYSTEM".equalsIgnoreCase((String)object9)) {
                                        object8 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object8).setName((String)object9);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                                    }
                                    if (object8 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)object10).setHashPTableSpaces(((ModelIDObject)object8).getObjectID());
                                }
                            }
                            string4 = Token.getStringAfter(string5, "OVERFLOW");
                            string4 = Token.getStringAfter(string4, "STORE IN");
                            if ((string4 = Token.getValBetweenBrackets(string4, 1)) != null && !string4.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string4, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    object9 = Token.getName(stringTokenizer.nextToken().trim());
                                    object8 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object9);
                                    if (object8 == null && !"SYSTEM".equalsIgnoreCase((String)object9)) {
                                        object8 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object8).setName((String)object9);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                                    }
                                    if (object8 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)object10).setIOTOverflowHashPTSSet(((ModelIDObject)object8).getObjectID());
                                }
                            }
                        } else {
                            ((UniqueOraclev10g)object32).setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                            string4 = Token.getStringAfter(string5, "PARTITION");
                            int n = string4.toUpperCase().indexOf("PARTITION ");
                            if (n > -1) {
                                object9 = string4.substring(n);
                                while (((String)object9).toUpperCase().indexOf("PARTITION ") > -1) {
                                    Object object11;
                                    Object object12;
                                    if (((String)object9).toUpperCase().indexOf("PARTITION ", 9) > -1) {
                                        object8 = ((String)object9).substring(0, ((String)object9).toUpperCase().indexOf("PARTITION ", 9));
                                        object9 = ((String)object9).substring(((String)object9).toUpperCase().indexOf("PARTITION ", 9));
                                    } else {
                                        object8 = object9;
                                        object9 = "";
                                    }
                                    object8 = Token.cutFirstToken((String)object8);
                                    object7 = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                    object6 = Token.getFirstToken((String)object8).trim();
                                    ((StorageObject)object7).setName((String)object6);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object7);
                                    ((IndexHashPartitionOracle)object7).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)object10);
                                    Object object13 = object8;
                                    if (Token.hasToken((String)object8, "LOB")) {
                                        object13 = Token.getStringBefore((String)object13, "LOB");
                                    }
                                    if (Token.hasToken((String)object13, "TABLESPACE") && !((String)(object12 = Token.getQuotedNameAfterToken((String)object13, "TABLESPACE"))).equalsIgnoreCase("")) {
                                        object11 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object12);
                                        if (object11 == null && !"SYSTEM".equalsIgnoreCase((String)object12)) {
                                            object11 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object11).setName((String)object12);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object11);
                                        }
                                        if (object11 != null) {
                                            ((IndexHashPartitionOracle)object7).setTableSpace((TableSpaceOracle)object11);
                                        }
                                    }
                                    object13 = Token.getStringAfter(string5, "OVERFLOW");
                                    object13 = Token.getStringAfter((String)object13, "STORE IN");
                                    if ((object13 = Token.getValBetweenBrackets((String)object13, 1)) == null || ((String)object13).trim().equalsIgnoreCase("")) continue;
                                    object12 = new StringTokenizer((String)object13, ",");
                                    while (((StringTokenizer)object12).hasMoreTokens()) {
                                        object11 = Token.getName(((StringTokenizer)object12).nextToken().trim());
                                        object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object11);
                                        if (object5 == null && !"SYSTEM".equalsIgnoreCase((String)object11)) {
                                            object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object5).setName((String)object11);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                                        }
                                        if (object5 == null) continue;
                                        ((IndexGlobalPartitionsListOraclev10g)object10).setIOTOverflowHashPTSSet(((ModelIDObject)object5).getObjectID());
                                    }
                                }
                            }
                        }
                        string4 = Token.getStringAfter(string, "GLOBAL PARTITION");
                        object4 = Token.getStringAfter(string4, "(");
                        if (Token.hasToken((String)object4, ")")) {
                            object4 = Token.getStringBefore((String)object4, ")");
                        }
                        ((IndexGlobalPartitionsListOracle)object10).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)object10).columnNamesToColumnIDs((String)object4));
                    } else if (string6.equalsIgnoreCase("(")) {
                        ((UniqueOraclev10g)object32).setUsingIndex("BY CREATE INDEX STATEMENT");
                        ((UniqueOraclev10g)object32).setCreateIndexStatement(Token.getValBetweenBrackets((String)object2));
                    } else {
                        ((UniqueOraclev10g)object32).setUsingIndex("BY INDEX NAME");
                        if (string6.equalsIgnoreCase("PCTFREE")) {
                            ((UniqueOracle)object32).setExistingIndex(null);
                        } else {
                            object10 = Token.getFirstName((String)object2, '\"', '\"');
                            string5 = this.getNameFor((String)object10);
                            string4 = Token.getValBeforeCharacter((String)object10, '.');
                            object4 = this.table.getIndexByNameAndSchema(string4, string5);
                            if (object4 == null) {
                                this.table.getIndexByName(string5);
                            }
                            if (object4 != null) {
                                object9 = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object4).getObjectID());
                                ((UniqueOracle)object32).setExistingIndex((IndexProxyOracle)object9);
                            }
                        }
                    }
                    if (((UniqueOracle)object32).getExistingIndex() == null && !((UniqueOraclev10g)object32).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        boolean bl;
                        String string7;
                        String string8;
                        object10 = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object10);
                        string5 = Token.getTokenAfter((String)object2, "PCTFREE");
                        if (!"".equalsIgnoreCase(string5)) {
                            try {
                                int n = Integer.parseInt(string5);
                                ((SegmentOracle)object10).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string8 = Token.getTokenAfter((String)object2, "INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string8);
                                ((SegmentOracle)object10).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string7 = Token.getTokenAfter((String)object2, "MAXTRANS"))) {
                            try {
                                int n = Integer.parseInt(string7);
                                ((SegmentOracle)object10).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl = Token.hasToken((String)object2, "STORAGE")) {
                            String string9;
                            String string10;
                            String string11;
                            String string12;
                            object8 = Token.getStringAfter((String)object2, "STORAGE");
                            object7 = Token.getTokenAfter((String)object8, "INITIALLY");
                            if (!"".equalsIgnoreCase((String)object7)) {
                                try {
                                    long l = Long.parseLong((String)object7);
                                    ((SegmentOracle)object10).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object6 = Token.getTokenAfter((String)object8, "NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object6);
                                    ((SegmentOracle)object10).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string12 = Token.getTokenAfter((String)object8, "PCTINCREASE"))) {
                                try {
                                    int n = Integer.parseInt(string12);
                                    ((SegmentOracle)object10).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string11 = Token.getTokenAfter((String)object8, "MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string11);
                                    ((SegmentOracle)object10).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string10 = Token.getTokenAfter((String)object8, "MAXEXTENTS"))) {
                                ((SegmentOracle)object10).setSCMaxExtents(string10);
                            }
                            if (!"".equalsIgnoreCase((String)(object5 = Token.getTokenAfter((String)object8, "FREELISTS")))) {
                                try {
                                    int n = Integer.parseInt((String)object5);
                                    ((SegmentOracle)object10).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string9 = Token.getTokenAfter((String)object8, "GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string9);
                                    ((SegmentOracle)object10).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string13 = Token.getQuotedNameAfterToken((String)object8, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string9)) {
                                ((SegmentOracle)object10).setSCBufferPool(string13);
                            }
                        }
                        if (!((String)(object8 = Token.getQuotedNameAfterToken((String)object2, "TABLESPACE"))).equalsIgnoreCase("")) {
                            object7 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object8);
                            if (object7 == null && !"SYSTEM".equalsIgnoreCase((String)object8)) {
                                object7 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object7).setName((String)object8);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object7);
                            }
                            if (object7 != null) {
                                ((UniqueOracle)object32).setTableSpace((TableSpaceOracle)object7);
                            }
                        }
                        if (Token.hasToken((String)object2, "NOSORT")) {
                            ((UniqueOraclev10g)object32).setIndexSort("NO");
                        } else if (Token.hasToken((String)object2, "REVERSE")) {
                            ((UniqueOraclev10g)object32).setIndexSort("REVERSE");
                        } else {
                            ((UniqueOraclev10g)object32).setIndexSort("SORTED");
                        }
                        if (Token.hasToken((String)object2, "NOLOGGING")) {
                            ((UniqueOracle)object32).setLogging("NO");
                        } else if (Token.hasToken((String)object2, "LOGGING")) {
                            ((UniqueOracle)object32).setLogging("YES");
                        } else {
                            ((UniqueOracle)object32).setLogging("");
                        }
                        boolean bl2 = Token.hasString((String)object2, "COMPUTE STATISTICS");
                        if (bl2) {
                            ((UniqueOraclev10g)object32).setComputeStatistics("YES");
                        } else {
                            ((UniqueOraclev10g)object32).setComputeStatistics("NO");
                        }
                        object6 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)object10);
                        ((UniqueOracle)object32).setIndexSegment((SegmentOracle)object6);
                    }
                }
            }
        }
    }

    private Column getColumnForConstr(Table table, String string) {
        String string2 = string.toUpperCase();
        ContainedObject[] containedObjectArray = table.getElements();
        Column column = null;
        boolean bl = false;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            column = (Column)containedObjectArray[i];
            String string3 = column.getName().toUpperCase();
            if (string2.indexOf(string3) <= -1) continue;
            bl = true;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string4;
                Column column2 = (Column)containedObjectArray[j];
                if (column == column2 || string2.indexOf(string4 = column2.getName().toUpperCase()) <= -1) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return column;
        }
        return null;
    }

    private boolean isCheck(String string) {
        return string.toUpperCase().indexOf("CHECK") > -1;
    }

    private void initCheck(String string) {
        ModelObject modelObject;
        ModelIDObject modelIDObject;
        String string2;
        this.statement = string;
        String string3 = null;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            string3 = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT");
        } else {
            string2 = this.table.getName();
            if (string2.length() > 25) {
                string2 = string2.substring(0, 25);
            }
            string3 = string2 + "_CK" + this.table.getCheckConstraints().size();
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        try {
            modelIDObject = this.getColumnForConstr(this.table, string2);
            if (modelIDObject != null && (modelObject = ((Column)modelIDObject).getCheck()) == null) {
                CheckConstraint checkConstraint = new CheckConstraint();
                RDBMSTypeSet rDBMSTypeSet = this.table.getDesign().getRDBMSTypeSet();
                Iterator iterator = rDBMSTypeSet.iterator();
                while (iterator.hasNext()) {
                    RDBMSType rDBMSType = (RDBMSType)iterator.next();
                    if (rDBMSType != StorageDesignOraclev10g.RDBMS_TYPE) continue;
                    checkConstraint.add(rDBMSType, string2);
                }
                ((ContainedObjectWithDomain)modelIDObject).setUseDomainConstraints(false);
                ((Column)modelIDObject).setCheck(checkConstraint);
                ((ContainedObject)modelIDObject).setConstraintName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(checkConstraint);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        modelIDObject = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        modelObject = this.table.createCheckConstraint(string3, string2);
        this.table.addCheckConstraint((TableLevelConstraint)modelObject);
        this.design.getRelationalDesign().stampModelObjectDDL(modelObject);
        TableCheckConstraintOracle tableCheckConstraintOracle = ((TableProxyOracle)modelIDObject).getTableConstraint((TableLevelConstraint)modelObject);
        if (tableCheckConstraintOracle != null) {
            if (Token.hasToken(this.statement, "DEFERRABLE")) {
                boolean bl = Token.getTokenBefore(this.statement, "DEFERRABLE").equalsIgnoreCase("NOT");
                tableCheckConstraintOracle.setDeferrable(bl ? "NO" : "YES");
            }
            if (Token.hasToken(this.statement, "INITIALLY")) {
                String string4 = Token.getTokenAfter(this.statement, "INITIALLY").trim();
                tableCheckConstraintOracle.setInitially(string4);
            }
            if (Token.hasToken(this.statement, "DISABLE")) {
                tableCheckConstraintOracle.setEnable("NO");
                tableCheckConstraintOracle.setValidate(Token.hasToken(this.statement, "VALIDATE") ? "YES" : "NO");
            } else {
                tableCheckConstraintOracle.setEnable("YES");
                tableCheckConstraintOracle.setValidate(Token.hasToken(this.statement, "NOVALIDATE") ? "NO" : "YES");
            }
            if (Token.hasToken(this.statement, "INTO")) {
                TableProxyOracle tableProxyOracle;
                String string5 = Token.getQuotedNameAfterToken(this.statement, "INTO");
                String string6 = this.getNameOnly(string5);
                Table table = null;
                String string7 = Token.getValBeforeCharacter(string5, '.');
                string6 = Token.removeQuotes(string6);
                if (string7 != null && !"".equals(string7)) {
                    string7 = Token.removeQuotes(string7);
                    table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string6);
                }
                if (table == null) {
                    table = this.getTableFor(string6);
                }
                if (table != null && (tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
                    tableCheckConstraintOracle.setExceptionsTable(tableProxyOracle);
                }
            }
        }
    }

    private static boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && SHAlterTableOraclev10g.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !SHAlterTableOraclev10g.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        Iterator iterator = this.statemensList.iterator();
        while (iterator.hasNext()) {
            String string;
            this.statement = string = (String)iterator.next();
            this.fkass = null;
            try {
                this.initTable();
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                // empty catch block
            }
            if (this.table == null) continue;
            String[] stringArray = string.split(" ADD ");
            if (stringArray.length == 1) {
                stringArray = string.split(" add ");
            }
            Iterator<String> iterator2 = Arrays.asList(stringArray).iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3 = iterator2.next().trim();
                int n = 0;
                if (string3.startsWith("(")) {
                    n = 1;
                    int n2 = 0;
                    while (n2 > -1) {
                        n2 = string3.indexOf(44, n);
                        while (n2 > -1 && Token.hasOpenBracketNoClose(string3.substring(n, n2))) {
                            n2 = string3.indexOf(44, n2 + 1);
                        }
                        if (n2 <= -1) continue;
                        String string4 = string3.substring(n, n2);
                        if (this.isFK(string4)) {
                            this.parseFK(string4);
                        }
                        n = n2 + 1;
                    }
                }
                if (!this.isFK(string2 = string3.substring(n))) continue;
                this.parseFK(string2);
            }
        }
    }
}

