/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTemporaryTablespaceOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTemporaryTablespaceOracle.class);

    public SHCreateTemporaryTablespaceOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTemporaryTablespaceOracle.clearCR(string);
        if (Token.startsWithString(string2, "create temporary tablespace") || Token.startsWithString(string2, "create smallfile temporary tablespace") || Token.startsWithString(string2, "create bigfile temporary tablespace")) {
            try {
                this.parseTemporaryTablespace(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateTemporaryTablespaceOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseTemporaryTablespace(String string) {
        TemporaryTablespaceOracle temporaryTablespaceOracle;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (temporaryTablespaceOracle = storageDesignOracle.getTemporaryTablespaceSet().createTemporaryTablespace()) != null) {
            this.initName(temporaryTablespaceOracle);
            this.initTempFile(temporaryTablespaceOracle);
            this.initExtent(temporaryTablespaceOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(temporaryTablespaceOracle);
        }
    }

    private void initName(TemporaryTablespaceOracle temporaryTablespaceOracle) {
        String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        temporaryTablespaceOracle.setName(string);
    }

    private void initTempFile(TemporaryTablespaceOracle temporaryTablespaceOracle) {
        if (Token.hasToken(this.statement, "TEMPFILE")) {
            String string;
            String string2 = Token.getStringAfterToken(this.statement, "TEMPFILE");
            if (string2.startsWith("'")) {
                string = Token.getValBetweenQuotes(string2);
                temporaryTablespaceOracle.setFilename(string);
            }
            if (Token.hasToken(string2, "SIZE")) {
                string = Token.getTokenAfter(string2, "SIZE");
                try {
                    temporaryTablespaceOracle.setSize(Long.parseLong(this.getNumberOnly(string)));
                    temporaryTablespaceOracle.setMeasureUnitSize(this.getMeasureUnit(string, string2));
                }
                catch (Exception exception) {
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                    LOGGER.error(" Wrong syntax near " + string + "!");
                }
            }
            if (Token.hasToken(string2, "REUSE")) {
                temporaryTablespaceOracle.setReuse("YES");
            } else {
                temporaryTablespaceOracle.setReuse("NO");
            }
            if (Token.hasToken(string2, "AUTOEXTEND")) {
                string = Token.getStringAfterToken(string2, "AUTOEXTEND");
                if (Token.hasToken(string, "OFF")) {
                    temporaryTablespaceOracle.setAutoextend("OFF");
                } else if (Token.hasToken(string, "ON")) {
                    String string3;
                    temporaryTablespaceOracle.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string3 = Token.getTokenAfter(string2, "NEXT");
                        try {
                            temporaryTablespaceOracle.setNextBlockSize(Integer.parseInt(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.importLog.addWarning("Wrong AUTOEXTEND format in statement " + this.statement);
                            LOGGER.error(" Wrong syntax near " + string3 + "!");
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        string3 = Token.getStringAfterToken(string2, "MAXSIZE");
                        if (Token.hasToken(string3, "UNLIMITED")) {
                            temporaryTablespaceOracle.setMaxSize("UNLIMITED");
                        } else {
                            String string4 = Token.getTokenAfter(string2, "MAXSIZE");
                            temporaryTablespaceOracle.setMaxSize(string4);
                        }
                    }
                }
            }
        }
    }

    private String getNumberOnly(String string) {
        String string2 = string.toUpperCase();
        if (string2.endsWith("K") || string2.endsWith("M")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getMeasureUnit(String string, String string2) {
        String string3 = string.toUpperCase();
        if (string3.endsWith("K") || string3.endsWith("M")) {
            return string3.substring(string3.length() - 1);
        }
        string3 = Token.getTokenAfter(string2, string).toUpperCase();
        if (string3.equals("K") || string3.equals("M")) {
            return string3;
        }
        return "";
    }

    private void initExtent(TemporaryTablespaceOracle temporaryTablespaceOracle) {
        if (Token.hasToken(this.statement, "UNIFORM")) {
            String string = Token.getStringAfterToken(this.statement, "UNIFORM");
            String string2 = Token.getTokenAfter(string, "SIZE");
            try {
                temporaryTablespaceOracle.setUniformSize(Long.parseLong(this.getNumberOnly(string2)));
                temporaryTablespaceOracle.setMeasureUnitUniformSize(this.getMeasureUnit(string2, string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error(" Wrong syntax near " + string2 + "!");
                this.importLog.addWarning("Wrong UNIFORM format in statement " + this.statement);
            }
        }
    }
}

