/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSynonymOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSynonymOracle.class);
    private String userName;

    public SHCreateSynonymOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSynonymOracle.clearCR(string);
        if (Token.startsWithString(string2, "create synonym") || Token.startsWithString(string2, "create or replace synonym") || Token.startsWithString(string2, "create public synonym") || Token.startsWithString(string2, "create or replace public synonym")) {
            try {
                this.parseSynonym(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateSynonymOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSynonym(String string) {
        SynonymOracle synonymOracle;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (synonymOracle = storageDesignOracle.getSynonymSet().createSynonym()) != null) {
            this.initName(synonymOracle);
            this.initUser(synonymOracle, storageDesignOracle);
            this.initPublic(synonymOracle);
            this.initFor(synonymOracle, storageDesignOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(synonymOracle);
        }
    }

    private void initName(SynonymOracle synonymOracle) {
        String string = Token.getNameAfterToken(this.statement, "SYNONYM", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        synonymOracle.setName(string);
    }

    private void initUser(SynonymOracle synonymOracle, StorageDesignOracle storageDesignOracle) {
        if (this.userName != null) {
            UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(this.userName);
            if (userOracle == null) {
                userOracle = storageDesignOracle.getUserSet().createUser();
                userOracle.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            synonymOracle.setUser(userOracle);
        }
    }

    private void initPublic(SynonymOracle synonymOracle) {
        if ("PUBLIC".equalsIgnoreCase(Token.getTokenAfter(this.statement, "CREATE").trim())) {
            synonymOracle.setPublic("YES");
        }
    }

    private void initFor(SynonymOracle synonymOracle, StorageDesignOracle storageDesignOracle) {
        if (Token.hasToken(this.statement, "FOR")) {
            int n;
            int n2;
            String string = Token.getStringAfterToken(this.statement, "FOR");
            String string2 = Token.getQuotedNameAfterToken(this.statement, "FOR").trim();
            int n3 = string2.indexOf(46);
            if (n3 > 0) {
                String string3 = Token.getValBeforeCharacter(string2, '.');
                string2 = Token.getValAfterCharacter(string2, '.');
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string3);
                if (userOracle == null) {
                    userOracle = storageDesignOracle.getUserSet().createUser();
                    userOracle.setName(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
                }
                synonymOracle.setObjectUser(userOracle);
            }
            if ((n2 = string2.indexOf(64)) > -1) {
                string2 = Token.getValBeforeCharacter(string2, '@');
            }
            if ((n = string.indexOf(64)) > -1) {
                String string4 = string.substring(n + 1).trim();
                synonymOracle.setDBLink(string4);
            }
            synonymOracle.setObject(string2);
        }
    }
}

