/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceOracle
extends DDLStatementHandler {
    private String userName;
    private static final Logger LOGGER = new Logger(SHCreateSequenceOracle.class);

    public SHCreateSequenceOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSequenceOracle.clearCR(string);
        if (Token.startsWithString(string2, "create sequence")) {
            try {
                this.parseSequence(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateSequenceOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSequence(String string) {
        SequenceOracle sequenceOracle;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (sequenceOracle = storageDesignOracle.getSequenceSet().createSequence()) != null) {
            this.initName(sequenceOracle);
            sequenceOracle.setNameHasQuotes(this.nameHasQuotes());
            this.initUser(sequenceOracle, storageDesignOracle);
            this.initStartWith(sequenceOracle);
            this.initIncrementBy(sequenceOracle);
            this.initMaxValue(sequenceOracle);
            this.initMinValue(sequenceOracle);
            this.initCycle(sequenceOracle);
            this.initCache(sequenceOracle);
            this.initOrder(sequenceOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(sequenceOracle);
        }
    }

    private boolean nameHasQuotes() {
        String string = Token.getStringAfterToken(this.statement, "SEQUENCE");
        return string.startsWith("\"");
    }

    private void initName(SequenceOracle sequenceOracle) {
        String string = Token.getQuotedNameAfterToken(this.statement, "SEQUENCE").trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
            string = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
        }
        sequenceOracle.setName(string);
    }

    private void initUser(SequenceOracle sequenceOracle, StorageDesignOracle storageDesignOracle) {
        if (this.userName != null) {
            UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(this.userName);
            if (userOracle == null) {
                userOracle = storageDesignOracle.getUserSet().createUser();
                userOracle.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            sequenceOracle.setUser(userOracle);
        }
    }

    private void initStartWith(SequenceOracle sequenceOracle) {
        if (Token.hasString(this.statement, "START")) {
            String string = Token.getTokenAfter(this.statement, "WITH").trim();
            sequenceOracle.setStartWith(string);
        }
    }

    private void initIncrementBy(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "BY")) {
            String string = Token.getTokenAfter(this.statement, "BY").trim();
            sequenceOracle.setIncrementBy(string);
        }
    }

    private void initMaxValue(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            String string = Token.getTokenAfter(this.statement, "MAXVALUE").trim();
            sequenceOracle.setMaxValue(string);
        }
    }

    private void initMinValue(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            String string = Token.getTokenAfter(this.statement, "MINVALUE").trim();
            sequenceOracle.setMinValue(string);
        }
    }

    private void initCycle(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            sequenceOracle.setCycle("YES");
        }
    }

    private void initCache(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "NOCACHE")) {
            sequenceOracle.setNoCache("YES");
        } else if (Token.hasToken(this.statement, "CACHE")) {
            String string = Token.getTokenAfter(this.statement, "CACHE").trim();
            sequenceOracle.setCache(string);
        }
    }

    private void initOrder(SequenceOracle sequenceOracle) {
        if (Token.hasToken(this.statement, "ORDER")) {
            sequenceOracle.setOrder("YES");
        }
    }
}

