/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class SHCreateObjectOracle
extends DDLStatementHandler {
    protected static final Logger LOGGER = new Logger(SHCreateObjectOracle.class);
    public static final String CREATE_PREFIX = "CREATE ";
    public static final String CREATE_OR_REPLACE_PREFIX = "CREATE OR REPLACE ";

    public SHCreateObjectOracle(Design design) {
        super(design);
    }

    protected boolean canHandle(String string) {
        return Token.startsWithString(string, CREATE_PREFIX + this.getTypeName()) || Token.startsWithString(string, CREATE_OR_REPLACE_PREFIX + this.getTypeName());
    }

    protected abstract String getTypeName();

    @Override
    public void handle(String string) {
        String string2 = SHCreateObjectOracle.clearCR(string);
        if (this.canHandle(string2)) {
            try {
                this.parse(string2.replaceAll("\"", ""), string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateObjectOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
            return;
        }
    }

    protected void parse(String string, String string2) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null) {
            String string3;
            PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle = this.createElement(storageDesignOracle);
            String string4 = string3 = this.extractOwnerAndName(string);
            int n = string3.indexOf(46);
            if (n > -1) {
                String string5 = string4.substring(0, n);
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string5);
                if (userOracle != null) {
                    plSqlSourceStorageObjectOracle.setOwner(userOracle);
                }
                string4 = string4.substring(n + 1);
            }
            plSqlSourceStorageObjectOracle.setName(string4);
            plSqlSourceStorageObjectOracle.setSource(this.extractSource(string2));
        }
    }

    protected abstract PlSqlSourceStorageObjectOracle createElement(StorageDesignOracle var1);

    protected String extractOwnerAndName(String string) {
        String string2 = this.getTypeName();
        String string3 = Token.getStringAfter(string, string2);
        return Token.getFirstName(string3, '\"', '\"');
    }

    protected String extractSource(String string) {
        String string2 = string.toUpperCase();
        int n = string2.indexOf(";", string2.lastIndexOf("END"));
        if (n > -1) {
            return string.substring(0, n + 1);
        }
        return string;
    }
}

