/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDirectoryOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDirectoryOracle.class);

    public SHCreateDirectoryOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDirectoryOracle.clearCR(string);
        if (Token.startsWithString(string2, "create directory") || Token.startsWithString(string2, "create or replace directory")) {
            try {
                this.parseDirectory(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateDirectoryOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDirectory(String string) {
        DirectoryOracle directoryOracle;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (directoryOracle = storageDesignOracle.getDirectorySet().createDirectory()) != null) {
            this.initName(directoryOracle);
            this.initDirPath(directoryOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(directoryOracle);
        }
    }

    private void initName(DirectoryOracle directoryOracle) {
        String string = Token.getTokenAfter(this.statement, "DIRECTORY").trim();
        string = Token.getName(string);
        directoryOracle.setName(string);
    }

    private void initDirPath(DirectoryOracle directoryOracle) {
        String string = Token.getStringAfterToken(this.statement, "AS").trim();
        if (string.startsWith("'")) {
            string = Token.getValBetweenQuotationMarks(string);
        }
        directoryOracle.setDirPath(string);
    }
}

