/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class SHCommentOnOracle
extends DDLStatementHandler {
    public SHCommentOnOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCommentOnOracle.clearCR(string);
        if (Token.startsWithString(string2, "comment on")) {
            try {
                this.parseCommentOn(string2.replaceAll("\"", ""), string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCommentOnOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseCommentOn(String string, String string2) throws ObjectDoesNotExistException {
        String string3 = Token.getTokenAfter(string, "ON");
        String string4 = Token.getStringAfter(string2, "IS");
        if ((string4 = Token.getFirstTextLiteral(string4)).startsWith("'")) {
            string4 = string4.substring(1, string4.length() - 1);
            string4 = string4.replaceAll("''", "'");
        }
        if (string3.equalsIgnoreCase("COLUMN")) {
            string3 = Token.getNameAfterToken(string, "COLUMN", '\"', '\"');
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            String string5 = null;
            String string6 = null;
            if (stringTokenizer.countTokens() == 3) {
                string6 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            } else if (stringTokenizer.countTokens() == 2) {
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            DesignObject designObject = null;
            if (string5 != null) {
                ContainerObject containerObject = null;
                ContainerObject containerObject2 = null;
                if (string6 != null && !"".equals(string6) && (containerObject = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string6, string5)) == null) {
                    containerObject2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string6, string5);
                }
                if (containerObject2 == null && containerObject == null && (containerObject = (Table)this.design.getRelationalDesign().getTableSet().getByName(string5)) == null) {
                    containerObject2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string5);
                }
                designObject = containerObject != null ? containerObject.getElementByName(string3) : (containerObject2 != null ? containerObject2.getElementByName(string3) : this.design.getRelationalDesign().getColumnSet().getByName(string3));
            } else {
                designObject = this.design.getRelationalDesign().getColumnSet().getByName(string3);
            }
            if (designObject != null) {
                designObject.setCommentInRDBMS(string4);
                return;
            }
            this.importLog.addError("Trying to set comment to a non-existent object: " + string3);
            throw new ObjectDoesNotExistException();
        }
        if (!string3.equalsIgnoreCase("TABLE")) {
            if (!string3.equalsIgnoreCase("MATERIALIZED")) return;
        }
        if ((string3 = Token.getNameAfterToken(string, "TABLE", '\"', '\"')).equals("")) {
            string3 = Token.getNameAfterToken(string, "VIEW", '\"', '\"');
        }
        String string7 = null;
        int n = string3.indexOf(46);
        if (n > -1) {
            string7 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        ModelIDObject modelIDObject = null;
        if (string7 != null && (modelIDObject = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string3)) == null) {
            modelIDObject = this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string7, string3);
        }
        if (modelIDObject == null && (modelIDObject = this.design.getRelationalDesign().getTableSet().getByName(string3)) == null && (modelIDObject = this.design.getRelationalDesign().getTableViewSet().getByName(string3)) == null) {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
            modelIDObject = (SnapshotOracle)storageDesignOracle.getSnapshotSet().getByName(string3);
        }
        if (modelIDObject != null) {
            modelIDObject.setCommentInRDBMS(string4);
            return;
        }
        this.importLog.addError("Trying to set comment to a non-existent object: " + string3);
        throw new ObjectDoesNotExistException();
    }
}

