/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpacePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpacePartitionSetDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceDB2v80
extends DDLStatementHandler {
    private static final String LARGE = "LARGE";
    private TableSpaceDB2 tableSpace;
    private RDBMSSite site;
    private AbstractStorageDesignDB2 stoDesign;
    private String statementUC;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceDB2v80.class);

    public SHCreateTablespaceDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTablespaceDB2v80.clearCR(string);
        if (Token.startsWithString(string2, "create tablespace") || Token.startsWithString(string2, "create large tablespace") || Token.startsWithString(string2, "create lob tablespace")) {
            try {
                this.parseTablespace(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateTablespaceDB2v80.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseTablespace(String string) {
        this.statement = string;
        this.statementUC = string.toUpperCase();
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            Object object;
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initName();
            this.initLob();
            this.initNameDatabase();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
            this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
            this.tableSpace.setStorageTemplate(storageTemplateDB2);
            boolean bl = this.initNumParts();
            if (bl) {
                this.tableSpace.setType("PARTITIONED");
                object = Token.getValBetweenBrackets(this.statement);
                TableSpacePartitionSetDB2v80 tableSpacePartitionSetDB2v80 = (TableSpacePartitionSetDB2v80)this.tableSpace.getPartitionSet();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    TableSpacePartitionDB2v80 tableSpacePartitionDB2v80 = (TableSpacePartitionDB2v80)tableSpacePartitionSetDB2v80.createPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpacePartitionDB2v80);
                    this.initPartPosition(string2, tableSpacePartitionDB2v80);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB22);
                    tableSpacePartitionDB2v80.setStorageTemplate(storageTemplateDB22);
                    tableSpacePartitionDB2v80.setTableSpace(this.tableSpace);
                    this.initUsingBlockPart(string2, tableSpacePartitionDB2v80);
                    this.initFreeBlockPart(string2, tableSpacePartitionDB2v80);
                    this.initGbpcacheBlockPart(string2, tableSpacePartitionDB2v80);
                    this.initTrackmodeBlockPart(string2, tableSpacePartitionDB2v80);
                    this.initCompressPart(string2, tableSpacePartitionDB2v80);
                    StorageTemplateDB2 storageTemplateDB23 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(tableSpacePartitionDB2v80.getStorageTemplate());
                    if (storageTemplateDB23 == tableSpacePartitionDB2v80.getStorageTemplate()) continue;
                    tableSpacePartitionDB2v80.setStorageTemplate(storageTemplateDB23);
                }
            }
            this.initUsingBlock();
            this.initFreeBlock();
            this.initGbpcacheBlock();
            this.initTrackmodeBlock();
            this.initLog();
            this.initDefine();
            this.initDSSize();
            this.initMemberCluster(bl);
            this.initSegsize();
            this.initBufferpool();
            this.initLocksize();
            this.initLockmax();
            this.initClose();
            this.initCompress();
            this.initCCsid();
            this.initLockpart();
            this.initMaxrows();
            object = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(this.tableSpace.getStorageTemplate());
            if (object != this.tableSpace.getStorageTemplate()) {
                this.tableSpace.setStorageTemplate((StorageTemplateDB2)object);
            }
        }
    }

    private void initName() {
        String string = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(string);
    }

    private void initNameDatabase() {
        if (Token.hasToken(this.statement, "IN")) {
            String string = Token.getNameAfterToken(this.statement, "IN", '\"', '\"').trim();
            if (!string.equals("")) {
                DataBaseSetDB2 dataBaseSetDB2 = this.stoDesign.getDataBaseSet();
                Iterator iterator = dataBaseSetDB2.iterator();
                while (iterator.hasNext()) {
                    DataBaseDB2 dataBaseDB2 = (DataBaseDB2)iterator.next();
                    if (!dataBaseDB2.getName().equalsIgnoreCase(string)) continue;
                    this.tableSpace.setDataBase(dataBaseDB2);
                    break;
                }
            } else {
                DataBaseDB2 dataBaseDB2 = null;
                if (this.stoDesign != null) {
                    Iterator iterator = this.stoDesign.getDataBaseSet().iterator();
                    while (iterator.hasNext() && !(dataBaseDB2 = (DataBaseDB2)iterator.next()).isSystemDatabase()) {
                    }
                    if (dataBaseDB2 != null) {
                        this.tableSpace.setDataBase(dataBaseDB2);
                    }
                }
            }
        } else {
            DataBaseDB2 dataBaseDB2 = (DataBaseDB2)this.stoDesign.getDataBaseSet().getByName("DSNDB04");
            this.tableSpace.setDataBase(dataBaseDB2);
        }
    }

    private void initLog() {
        String string = Token.getTokenAfter(this.statement, "LOG").trim();
        if (string.equalsIgnoreCase("NO")) {
            this.tableSpace.setLobLogging(false);
        }
    }

    private void initDefine() {
        String string = Token.getTokenAfter(this.statement, "DEFINE").trim();
        if (string.equalsIgnoreCase("YES")) {
            this.tableSpace.getStorageTemplate().setDefine(true);
        }
    }

    private void initDSSize() {
        String string = Token.getTokenAfter(this.statement, "DSSIZE");
        String string2 = this.initNumParts() ? Token.getTokenBefore(this.statement, "NUMPARTS") : (this.statement.indexOf("SEGSIZE") > -1 ? Token.getTokenBefore(this.statement, "SEGSIZE") : (this.statement.indexOf("MEMBER") > -1 ? Token.getTokenBefore(this.statement, "MEMBER") : (this.statement.indexOf("BUFFER_POOL") > -1 ? Token.getTokenBefore(this.statement, "BUFFER_POOL") : (this.statement.indexOf("LOCKSIZE") > -1 ? Token.getTokenBefore(this.statement, "LOCKSIZE") : Token.getTokenBefore(this.statement, "LOCKMAX")))));
        String string3 = string + " " + string2;
        if (!string3.equals("")) {
            this.tableSpace.setDsSize(string3);
        } else if (this.statementUC.indexOf(LARGE) > 0) {
            this.tableSpace.setDsSize("4 G");
        }
    }

    private void initMemberCluster(boolean bl) {
        String string;
        boolean bl2 = Token.hasToken(this.statement, "MEMBER");
        if (bl2 && (string = Token.getTokenAfter(this.statement, "MEMBER")).equalsIgnoreCase("CLUSTER")) {
            this.tableSpace.setClustered(TableSpaceDB2.YES_NO_STATES[0]);
        }
    }

    private boolean initNumParts() {
        boolean bl = Token.hasToken(this.statement, "NUMPARTS");
        if (bl) {
            try {
                String string = Token.getTokenAfter(this.statement, "NUMPARTS").trim();
                if (!string.equals("")) {
                    int n = Integer.parseInt(string);
                    this.tableSpace.setNumParts(n);
                    bl = n > 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initNumParts: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
            }
        }
        return bl;
    }

    private void initSegsize() {
        String string = Token.getTokenAfter(this.statement, "SEGSIZE").trim();
        if (!string.equals("")) {
            this.tableSpace.setSegSize(string);
        }
    }

    private void initBufferpool() {
        String string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        if (!string.equals("")) {
            BufferPoolSetDB2 bufferPoolSetDB2 = this.stoDesign.getBufferPoolSet();
            Iterator iterator = bufferPoolSetDB2.iterator();
            while (iterator.hasNext()) {
                BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
                if (!bufferPoolDB2.getName().equalsIgnoreCase(string)) continue;
                this.tableSpace.setBufferPool(bufferPoolDB2);
                break;
            }
        }
    }

    private void initLocksize() {
        String string = Token.getTokenAfter(this.statement, "LOCKSIZE").trim();
        if (!string.equals("")) {
            String[] stringArray = TableSpaceDB2.getLockSizeValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                this.tableSpace.setLockSize(stringArray[i]);
                break;
            }
        }
    }

    private void initLockmax() {
        try {
            String string = Token.getTokenAfter(this.statement, "LOCKMAX").trim();
            if (!"".equalsIgnoreCase(string)) {
                if ("SYSTEM".equalsIgnoreCase(string)) {
                    this.tableSpace.setLockMax(-1);
                } else {
                    int n = Integer.parseInt(string);
                    this.tableSpace.setLockMax(n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initLockmax: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong LOCKMAX format in statement " + this.statement);
        }
    }

    private void initClose() {
        String string = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (string.equalsIgnoreCase("NO")) {
            this.tableSpace.setClose(false);
        }
    }

    private void initCompress() {
        String string = Token.getTokenAfter(this.statement, "COMPRESS").trim();
        if (string.equalsIgnoreCase("YES")) {
            this.tableSpace.setCompress(true);
        }
    }

    private void initCompressPart(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "COMPRESS").trim();
        if (string2.equalsIgnoreCase("YES")) {
            tableSpacePartitionDB2v80.setCompress(true);
        }
    }

    private void initCCsid() {
        String string = Token.getTokenAfter(this.statement, "CCSID").trim();
        if (!string.equals("")) {
            String[] stringArray = TableSpaceDB2.getCCSIDValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.tableSpace.setCcsid(stringArray[i]);
                break;
            }
        }
    }

    private void initLockpart() {
        String string = Token.getTokenAfter(this.statement, "LOCKPART").trim();
        if (string.equalsIgnoreCase("YES")) {
            this.tableSpace.setLockPart(true);
        }
    }

    private void initMaxrows() {
        try {
            String string = Token.getTokenAfter(this.statement, "MAXROWS").trim();
            if (!string.equals("")) {
                int n = Integer.parseInt(string);
                this.tableSpace.setMaxRows(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initMaxrows: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong MAXROWS format in statement " + this.statement);
        }
    }

    private void initUsingBlock() {
        String string = Token.getTokenAfter(this.statement, "USING").trim();
        if (string.equalsIgnoreCase("VCAT")) {
            String string2 = Token.getTokenAfter(this.statement, "VCAT").trim();
            Iterator iterator = this.stoDesign.getVCatSet().iterator();
            while (iterator.hasNext()) {
                VCatDB2 vCatDB2 = (VCatDB2)iterator.next();
                if (!vCatDB2.getName().equalsIgnoreCase(string2)) continue;
                this.tableSpace.getStorageTemplate().setVCat(vCatDB2);
                break;
            }
        } else if (string.equalsIgnoreCase("STOGROUP")) {
            int n;
            String string3;
            String string4 = Token.getTokenAfter(this.statement, "STOGROUP").trim();
            StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
            this.tableSpace.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string4));
            try {
                string3 = Token.getTokenAfter(this.statement, "PRIQTY").trim();
                if (!string3.equals("")) {
                    n = Integer.parseInt(string3);
                    this.tableSpace.getStorageTemplate().setSgPriqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlock: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong PRIQTY format in statement " + this.statement);
            }
            try {
                string3 = Token.getTokenAfter(this.statement, "SECQTY").trim();
                if (!string3.equals("")) {
                    n = Integer.parseInt(string3);
                    this.tableSpace.getStorageTemplate().setSgSeqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlock: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong SECQTY format in statement " + this.statement);
            }
            string3 = Token.getTokenAfter(this.statement, "ERASE").trim();
            if (string3.equalsIgnoreCase("YES")) {
                this.tableSpace.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initPartPosition(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        try {
            String string2 = Token.getTokenAfter(string, "PART").trim();
            if (!string2.equals("")) {
                int n = Integer.parseInt(string2);
                tableSpacePartitionDB2v80.setPartNumber(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initPartPosition: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PART format in statement " + this.statement);
        }
    }

    private void initUsingBlockPart(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "USING").trim();
        if (string2.equalsIgnoreCase("VCAT")) {
            String string3 = Token.getTokenAfter(string, "VCAT").trim();
            VCatDB2 vCatDB2 = this.stoDesign.getVCatSet().getOrCreateVCat(string3);
            tableSpacePartitionDB2v80.getStorageTemplate().setVCat(vCatDB2);
        } else if (string2.equalsIgnoreCase("STOGROUP")) {
            int n;
            String string4;
            String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
            StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
            tableSpacePartitionDB2v80.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
            try {
                string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                if (!string4.equals("")) {
                    n = Integer.parseInt(string4);
                    tableSpacePartitionDB2v80.getStorageTemplate().setSgPriqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong PRIQTY format in statement " + this.statement);
            }
            try {
                string4 = Token.getTokenAfter(string, "SECQTY").trim();
                if (!string4.equals("")) {
                    n = Integer.parseInt(string4);
                    tableSpacePartitionDB2v80.getStorageTemplate().setSgSeqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong SECQTY format in statement " + this.statement);
            }
            string4 = Token.getTokenAfter(string, "ERASE").trim();
            if (string4.equalsIgnoreCase("YES")) {
                tableSpacePartitionDB2v80.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initFreeBlock() {
        int n;
        String string;
        try {
            string = Token.getTokenAfter(this.statement, "FREEPAGE").trim();
            if (!string.equals("")) {
                n = Integer.parseInt(string);
                this.tableSpace.getStorageTemplate().setFreePage(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlock: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FREEPAGE format in statement " + this.statement);
        }
        try {
            string = Token.getTokenAfter(this.statement, "PCTFREE").trim();
            if (!string.equals("")) {
                n = Integer.parseInt(string);
                this.tableSpace.getStorageTemplate().setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlock: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
        }
    }

    private void initFreeBlockPart(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        int n;
        String string2;
        try {
            string2 = Token.getTokenAfter(string, "FREEPAGE").trim();
            if (!string2.equals("")) {
                n = Integer.parseInt(string2);
                tableSpacePartitionDB2v80.getStorageTemplate().setFreePage(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FREEPAGE format in statement " + this.statement);
        }
        try {
            string2 = Token.getTokenAfter(string, "PCTFREE").trim();
            if (!string2.equals("")) {
                n = Integer.parseInt(string2);
                tableSpacePartitionDB2v80.getStorageTemplate().setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlock() {
        String string = Token.getTokenAfter(this.statement, "GBPCACHE").trim().toUpperCase();
        if (!string.equals("")) {
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                this.tableSpace.getStorageTemplate().setGbCache(stringArray[i]);
                break;
            }
        }
    }

    private void initGbpcacheBlockPart(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
        if (!string2.equals("")) {
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                tableSpacePartitionDB2v80.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initTrackmodeBlockPart(String string, TableSpacePartitionDB2v80 tableSpacePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "TRACKMOD").trim();
        if (string2.equalsIgnoreCase("YES")) {
            tableSpacePartitionDB2v80.getStorageTemplate().setTrackMode(true);
        }
    }

    private void initTrackmodeBlock() {
        String string = Token.getTokenAfter(this.statement, "TRACKMOD").trim();
        if (!string.equals("") && string.equalsIgnoreCase("NO")) {
            this.tableSpace.getStorageTemplate().setTrackMode(false);
        }
    }

    public TableSpaceDB2 getTablespace() {
        return this.tableSpace;
    }

    private void initLob() {
        if (Token.getTokenAfter(this.statement, "CREATE").trim().equalsIgnoreCase("LOB")) {
            this.tableSpace.setType("LOB");
        }
    }
}

