/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.db2.AggregateFunctionsDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTable;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHColumnElementsDB2v80;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceSetDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableDB2v80
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    protected LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    protected Table table = null;
    protected RDBMSSite site = null;
    protected StorageDesignDB2v80 storageDesign = null;
    protected TableProxyDB2v80 tableProxy = null;
    private boolean createDomainsDuringImport;
    protected String tableName;
    protected String ownerName = null;
    protected ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    protected String inTablespace;
    private String inDatabase;
    protected String editproc;
    protected String validproc;
    protected String audit;
    protected String obid;
    protected boolean dataCapture;
    protected boolean restrict;
    protected String ccsid;
    protected String outSideBrackets;
    protected String inSideBrackets;
    protected String afterColumns;
    private boolean failed = false;
    protected static final Logger LOGGER = new Logger(SHCreateTableDB2v80.class);

    public SHCreateTableDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block7: {
            String string2 = SHCreateTableDB2v80.clearCR(string);
            if (!Token.startsWithString(string2, "create aux")) {
                if (Token.startsWithString(string2, "create table")) {
                    try {
                        this.fkList = new ArrayList();
                        this.refAtColumnList = new ArrayList();
                        this.parseTable(string2);
                        FKRefNode fKRefNode = new FKRefNode();
                        fKRefNode.processedTable = this.table;
                        fKRefNode.fkStatements = this.fkList;
                        fKRefNode.refAtColumns = this.refAtColumnList;
                        this.tableNodeList.add(fKRefNode);
                        if (this.failed) {
                            this.importLog.addFailedStatement(SHCreateTableDB2v80.FormatCR(string, "\n"));
                            break block7;
                        }
                        this.importLog.incrementImportedStatements();
                    }
                    catch (Exception exception) {
                        LOGGER.error(" Parsing " + string2 + " for DB2 8.0 failed!", exception);
                        this.importLog.addFailedStatement(SHCreateTableDB2v80.FormatCR(string, "\n"));
                    }
                } else {
                    this.nextHandler(string);
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    protected void parseTable(String string) {
        String string2;
        Object object;
        int n;
        this.setStatement(string);
        this.outSideBrackets = SHCreateTableDB2v80.getValOutsideFirstBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1);
        this.afterColumns = string.substring(string.indexOf(41) + 1).trim();
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignDB2v80)this.design.getStorageDesign(this.site);
        if (this.storageDesign.importStorageObjectsOnly()) {
            this.table = this.ownerName != null && !"".equals(this.ownerName) ? this.design.getRelationalDesign().getTableSet().getBySchemaAndName(this.ownerName, this.tableName) : (Table)this.design.getRelationalDesign().getTableSet().getByName(this.tableName);
        } else {
            this.table = this.design.getRelationalDesign().createTable();
            this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        }
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.tableProxy = (TableProxyDB2v80)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
        if (string.toUpperCase().indexOf("AS (SELECT") > -1 || string.toUpperCase().indexOf("AS ( SELECT") > -1) {
            if (string.toUpperCase().indexOf("AS (SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(string, "AS (SELECT");
            } else if (string.toUpperCase().indexOf("AS ( SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(string, "AS ( SELECT");
            }
            this.inSideBrackets = Token.getValBetweenBrackets(this.inSideBrackets);
            if (!this.storageDesign.importStorageObjectsOnly() && !this.initCols()) {
                this.initCol();
            }
            this.processMaterializedQuery();
        } else {
            this.columns = this.initColumns();
            for (n = 0; n < this.columns.size(); ++n) {
                CharSequence charSequence;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                object = (Map)this.columns.get(n);
                boolean bl = (Boolean)object.get("IS_CONSTRAINT");
                if (!bl) {
                    Object object6;
                    ModelIDObject modelIDObject;
                    Object object7;
                    String string3;
                    String string4 = (String)object.get("columnname");
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        object5 = (Column)this.table.getElementByName(string4);
                    } else {
                        Object object8;
                        object5 = this.table.createColumn(string4);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                        string3 = (String)object.get("datatype");
                        object7 = (String)object.get("scale");
                        object4 = (String)object.get("size");
                        object3 = (String[])object.get("precision");
                        object2 = new String[]{object3, object7, object4};
                        charSequence = StandardDatatypeNames.getUsedDatatypeName(string3);
                        modelIDObject = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)charSequence);
                        if (this.createDomainsDuringImport) {
                            Domain domain = null;
                            String string5 = (String)object.get("typename");
                            if (string5 != null) {
                                object8 = this.design.getDomainSet();
                                domain = (Domain)((DesignObjectSet)object8).getByName(string5);
                            }
                            object8 = "";
                            if (domain == null) {
                                object8 = DomainFactory.createDomainName((LogicalDatatype)modelIDObject, (String[])object2);
                                domain = this.getCorrespondingDomain((String)object8);
                            }
                            if (domain != null) {
                                ((Column)object5).setDomain(domain);
                            } else {
                                object6 = new StringBuffer("domain is null in SHCreateTableDB2v80.parseTable : ");
                                ((StringBuffer)object6).append((String)object8);
                                LOGGER.error(((StringBuffer)object6).toString());
                                this.importLog.addError("Null domain occurred while creating " + this.tableName);
                            }
                        } else {
                            ((ContainedObjectWithDomain)object5).setLogicalDatatype((LogicalDatatype)modelIDObject);
                            ((ContainedObjectWithDomain)object5).setUse((short)1);
                            ((ContainedObjectWithDomain)object5).setDataTypeParameter("scale", (String)object7);
                            ((ContainedObjectWithDomain)object5).setDataTypeParameter("precision", (String)object3);
                            ((ContainedObjectWithDomain)object5).setDataTypeParameter("size", (String)object4);
                        }
                        boolean bl2 = (Boolean)object.get("NOT NULL");
                        ((ContainedObject)object5).setNullsAllowed(!bl2);
                        boolean bl3 = (Boolean)object.get("PRIMARY KEY");
                        if (bl3) {
                            object8 = this.table.createIndex();
                            ((Index)object8).add((ContainedObject)object5);
                            ((KeyObject)object8).makePK();
                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                        } else {
                            boolean bl4 = (Boolean)object.get("UNIQUE");
                            if (bl4) {
                                object6 = this.table.createIndex();
                                ((Index)object6).add((ContainedObject)object5);
                                ((Index)object6).setIndexState("Unique Constraint");
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                            }
                        }
                    }
                    if (this.storageDesign != null) {
                        string3 = (String)object.get("FOR");
                        object7 = (String)object.get("DEFAULT");
                        object4 = (ColumnProxyDB2v80)this.storageDesign.getColumnProxySet().getProxy(((ModelIDObject)object5).getObjectID());
                        ((ColumnProxyDB2)object4).setBitData(string3);
                        object3 = ColumnProxyDB2.getDefaultValueChoices();
                        if (object7 != null) {
                            boolean bl5 = (Boolean)object.get("IS DEFAULT");
                            ((ColumnProxyDB2)object4).setDefault(bl5);
                            if (((String)object7).equalsIgnoreCase(object3[2]) || ((String)object7).equalsIgnoreCase((String)object3[3])) {
                                ((ColumnProxyDB2)object4).setDefaultValue((String)object7);
                            } else if (Token.hasCloseAndOpenBrackets((String)object7)) {
                                ((ColumnProxyDB2)object4).setDefaultValue((String)object3[4]);
                                ((ColumnProxyDB2)object4).setDefaultValueConstant((String)object7);
                            } else {
                                ((ColumnProxyDB2)object4).setDefaultValue((String)object3[1]);
                                ((ColumnProxyDB2)object4).setDefaultValueConstant((String)object7);
                                ((ContainedObjectWithDomain)object5).setDefaultValue((String)object7);
                            }
                        }
                        if ((object2 = (String)object.get("FIELDPROC")) != null) {
                            if (Token.hasCloseAndOpenBrackets((String)object2)) {
                                charSequence = Token.getValBetweenBrackets((String)object2).trim();
                                ((ColumnProxyDB2)object4).setConstant((String)charSequence);
                                object2 = Token.getValBeforeBrackets((String)object2).trim();
                            }
                            ((ColumnProxyDB2)object4).setProgram((String)object2);
                        }
                        if ((charSequence = (String)object.get("GENERATED")) != null) {
                            String string6;
                            CharSequence charSequence2;
                            String string7;
                            String string8;
                            String string9;
                            modelIDObject = (ColumnIdentityDB2v80)this.storageDesign.getColumnIdentitySet().createColumnIdentity();
                            this.design.getRelationalDesign().stampModelObjectDDL(modelIDObject);
                            ((ColumnIdentityDB2)modelIDObject).setColumn((ColumnProxyDB2)object4);
                            for (int i = 0; i < ColumnIdentityDB2.getGenerateValues().length; ++i) {
                                String string10 = ColumnIdentityDB2.getGenerateValues()[i];
                                if (!((String)charSequence).equalsIgnoreCase(string10)) continue;
                                ((ColumnIdentityDB2)modelIDObject).setGenerate(string10);
                                break;
                            }
                            if ((string9 = (String)object.get("START")) != null) {
                                ((ColumnIdentityDB2)modelIDObject).setStartWith(string9);
                            }
                            if ((string8 = (String)object.get("INCREMENT")) != null) {
                                try {
                                    int n2 = Integer.parseInt(string8);
                                    ((ColumnIdentityDB2)modelIDObject).setIncrementBy(n2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    object6 = new StringBuffer("wrong Format for Increment value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(((StringBuffer)object6).toString(), numberFormatException);
                                    this.importLog.addWarning("Wrong INCREMENT format in statement " + string);
                                }
                            }
                            if ((string7 = (String)object.get("CACHE")) != null) {
                                try {
                                    int n3 = Integer.parseInt(string7);
                                    ((ColumnIdentityDB2)modelIDObject).setCache(n3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    charSequence2 = new StringBuffer("wrong Format for Cache value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(charSequence2.toString(), numberFormatException);
                                    this.importLog.addWarning("Wrong CACHE format in statement " + string);
                                }
                            }
                            if ((object6 = object.get("CYCLE")) != null) {
                                boolean bl6 = (Boolean)object.get("CYCLE");
                                ((ColumnIdentityDB2)modelIDObject).setCycle(bl6);
                            }
                            if ((object6 = object.get("ORDER")) != null) {
                                charSequence2 = (String)object.get("ORDER");
                                ((ColumnIdentityDB2v80)modelIDObject).setOrder((String)charSequence2);
                            }
                            if ((charSequence2 = (String)object.get("MAXVALUE")) != null) {
                                try {
                                    Integer.parseInt((String)charSequence2);
                                    ((ColumnIdentityDB2)modelIDObject).setMaxValue((String)charSequence2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    StringBuffer stringBuffer = new StringBuffer("wrong Format for MAXVALUE value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(stringBuffer.toString(), numberFormatException);
                                    this.importLog.addWarning("Wrong MAXVALUE format in statement " + string);
                                }
                            }
                            if ((string6 = (String)object.get("MINVALUE")) != null) {
                                try {
                                    Integer.parseInt(string6);
                                    ((ColumnIdentityDB2)modelIDObject).setMinValue(string6);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    StringBuffer stringBuffer = new StringBuffer("wrong Format for MINVALUE value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(stringBuffer.toString(), numberFormatException);
                                    this.importLog.addWarning("Wrong MINVALUE format in statement " + string);
                                }
                            }
                            ((ColumnProxyDB2)object4).setColumnIdentity((ColumnIdentityDB2)modelIDObject);
                        }
                    }
                    if ((string3 = (String)object.get("REFERENCES")) != null) {
                        object7 = new RefAtColNode();
                        int n4 = string3.indexOf(46);
                        if (n4 > 0) {
                            string3 = Token.getValAfterCharacter(string3, '.');
                        }
                        ((RefAtColNode)object7).onDelete = (String)object.get("ON DELETE");
                        ((RefAtColNode)object7).columnName = (String)object.get("columnname");
                        ((RefAtColNode)object7).refColumn = (String)object.get("REFERENCED_COLUMN");
                        ((RefAtColNode)object7).referencedTable = string3;
                        this.refAtColumnList.add(object7);
                    }
                    object7 = (String)object.get("CONSTRAINT");
                    object4 = (String)object.get("CHECK");
                    if (object4 == null) continue;
                    this.initCheckConstraint((String)object4, (String)object7, (Column)object5);
                    continue;
                }
                object5 = (String)object.get("CONSTRAINT_NAME");
                boolean bl7 = (Boolean)object.get("PRIMARY KEY");
                if (bl7) {
                    Index index;
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        index = (Index)this.table.getPK();
                    } else {
                        index = this.table.createIndex();
                        this.design.getRelationalDesign().stampModelObjectDDL(index);
                    }
                    String string11 = null;
                    if (!"".equalsIgnoreCase((String)object5)) {
                        int n5 = ((String)object5).indexOf(46);
                        if (n5 > 0) {
                            string11 = Token.getValBeforeCharacter((String)object5, '.');
                            object5 = Token.getValAfterCharacter((String)object5, '.');
                        }
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            index.setName((String)object5);
                        }
                    } else {
                        if (this.tableName.length() > 125) {
                            this.tableName = this.tableName.substring(0, 125);
                        }
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            index.setName(this.tableName + "_PK");
                        }
                    }
                    object4 = (String)object.get("CONSTRAINT_VALUE");
                    try {
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            SHCreateTable.setColumnsForIndexPK(index, (String)object4, this.importLog);
                            index.makePK();
                        }
                        if ((object3 = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
                        ((RelationalObjectProxy)object3).setName(index.getName());
                        if (string11 == null) continue;
                        object2 = (Owner)this.storageDesign.getOwnerSet().getByName(string11);
                        if (object2 == null) {
                            object2 = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                            ((StorageObject)object2).setName(string11);
                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                        }
                        ((IndexProxyDB2)object3).setOwner((Owner)object2);
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                        object2 = new StringBuffer(objectDoesNotExistException.getMessage());
                        ((StringBuffer)object2).append(" in SHCreateTable.parseTable:PRIMARY KEY");
                        LOGGER.error(((StringBuffer)object2).toString(), objectDoesNotExistException);
                        this.importLog.addError("Columns for primary key " + index.getName() + " don't exist.");
                        this.failed = true;
                    }
                    continue;
                }
                boolean bl8 = (Boolean)object.get("UNIQUE");
                if (bl8) {
                    String string12 = null;
                    if (!"".equalsIgnoreCase((String)object5)) {
                        int n6 = ((String)object5).indexOf(46);
                        if (n6 > 0) {
                            string12 = Token.getValBeforeCharacter((String)object5, '.');
                            object5 = Token.getValAfterCharacter((String)object5, '.');
                        }
                    } else {
                        if (this.tableName.length() > 123) {
                            this.tableName = this.tableName.substring(0, 123);
                        }
                        object5 = this.tableName + "_UK" + this.table.getUKeys().size();
                    }
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        object4 = this.table.getIndexByName((String)object5);
                    } else {
                        object4 = this.table.createIndex();
                        ((DesignObject)object4).setName((String)object5);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        object3 = (String)object.get("CONSTRAINT_VALUE");
                        try {
                            SHCreateTable.setColumnsForIndexPK((Index)object4, (String)object3, this.importLog);
                            ((Index)object4).setIndexState("Unique Constraint");
                        }
                        catch (ObjectDoesNotExistException objectDoesNotExistException) {
                            charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                            ((StringBuffer)charSequence).append(" in SHCreateTable.parseTable:UNIQUE");
                            LOGGER.error(((StringBuffer)charSequence).toString(), objectDoesNotExistException);
                            this.importLog.addError("Columns for unique key " + ((DesignObject)object4).getName() + " don't exist.");
                            this.failed = true;
                        }
                        ((Index)object4).setIndexState("Unique Constraint");
                    }
                    if ((object3 = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object4).getObjectID())) == null) continue;
                    ((RelationalObjectProxy)object3).setName(((DesignObject)object4).getName());
                    if (string12 == null) continue;
                    object2 = (Owner)this.storageDesign.getOwnerSet().getByName(string12);
                    if (object2 == null) {
                        object2 = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                        ((StorageObject)object2).setName(string12);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                    }
                    ((IndexProxyDB2)object3).setOwner((Owner)object2);
                    continue;
                }
                boolean bl9 = (Boolean)object.get("CHECK");
                if (!bl9) continue;
                object4 = (String)object.get("CONSTRAINT_VALUE");
                if (this.tableName.length() > 123) {
                    this.tableName = this.tableName.substring(0, 123);
                }
                object3 = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), (String)object4);
                if (!"".equalsIgnoreCase((String)object5)) {
                    ((DesignObject)object3).setName((String)object5);
                }
                this.table.addCheckConstraint((TableLevelConstraint)object3);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
            }
        }
        this.initDatabaseTablespace();
        this.processPartitioningClause();
        if (this.tableProxy != null) {
            TableSpaceSetDB2v80 tableSpaceSetDB2v80 = (TableSpaceSetDB2v80)this.storageDesign.getTableSpaceSet();
            object = tableSpaceSetDB2v80.getOrCreateTablespace(this.inDatabase, this.inTablespace);
            this.tableProxy.setTableSpace((TableSpaceDB2)object);
            if (this.ownerName != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (owner == null) {
                    owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                this.tableProxy.setOwner(owner);
            } else if (this.getOwner() != null) {
                this.tableProxy.setOwner(this.getOwner());
            } else {
                this.tableProxy.setOwner(((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getDefaultOwner());
            }
        }
        this.editproc = this.initEditProc();
        if (this.tableProxy != null && !this.editproc.equals(" ") && this.editproc != null && !this.editproc.equals("")) {
            this.tableProxy.setEditProc(this.editproc);
        }
        this.validproc = this.initValidProc();
        if (this.tableProxy != null && !this.validproc.equals(" ") && this.validproc != null && !this.validproc.equals("")) {
            this.tableProxy.setValidProc(this.validproc);
        }
        this.audit = this.initAudit();
        if (this.tableProxy != null && !this.audit.equals(" ") && this.audit != null && !this.audit.equals("")) {
            this.tableProxy.setAudit(this.audit);
        }
        this.obid = this.initObid();
        if (this.tableProxy != null) {
            try {
                if (!this.obid.equals(" ") && this.obid != null && !this.obid.equals("")) {
                    this.tableProxy.setObid(Integer.parseInt(this.obid));
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new StringBuffer("wrong Format for Obid in SHCreateTable.parseTable : ");
                LOGGER.error(((StringBuffer)object).toString(), numberFormatException);
                this.importLog.addWarning("Wrong OBID format in statement " + string);
            }
        }
        this.dataCapture = this.initDataCapture();
        if (this.tableProxy != null) {
            this.tableProxy.setDataCapture(this.dataCapture);
        }
        this.restrict = this.initWithRestrictOnDrop();
        if (this.tableProxy != null) {
            this.tableProxy.setDropRestrict(this.restrict);
        }
        this.ccsid = this.initCcsid();
        if (this.tableProxy != null) {
            for (n = 0; n < TableProxyDB2.getCcsidValues().length; ++n) {
                object = TableProxyDB2.getCcsidValues()[n];
                if (!this.ccsid.equalsIgnoreCase((String)object)) continue;
                this.tableProxy.setCcsid((String)object);
                break;
            }
        }
        if ((string2 = this.initVolatile()) != null) {
            this.tableProxy.setTableAccess(string2);
        }
    }

    private void processPartitioningClause() {
        if (Token.hasToken(this.outSideBrackets, "PARTITION")) {
            this.tableProxy.setPartitioned("YES");
            String string = Token.getStringAfter(this.outSideBrackets, "PARTITION").trim();
            string = Token.getStringAfter(string, "BY");
            if (Token.getFirstToken(string).equalsIgnoreCase("RANGE")) {
                Token.cutFirstToken(string);
            }
            String string2 = Token.getValBetweenBrackets(string, 1).trim();
            this.processPartitionExpr(string2);
            int n = string.indexOf(41);
            String string3 = string.substring(n + 1).trim();
            string3 = Token.getValBetweenBrackets(string3);
            this.processPartitionElement(string3);
        }
    }

    private void processPartitionElement(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (!string2.startsWith("PARTITION")) continue;
            TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)((StorageDesignDB2v80)this.tableProxy.getStorageDesign()).getTablePartitionSet().createElement(null);
            tablePartitionDB2v80.setTable(this.tableProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(tablePartitionDB2v80);
            string2 = Token.cutFirstToken(string2);
            try {
                n = new Integer(Token.getFirstToken(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            tablePartitionDB2v80.setPartNumber(n);
            if (!Token.hasCloseAndOpenBrackets(string2)) continue;
            tablePartitionDB2v80.setPartConstants(Token.getValBetweenBrackets(string2));
        }
    }

    private void processPartitionExpr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            this.tableProxy.setPartitioningKey(Token.getFirstToken(string2));
            this.tableProxy.setPartitioningKey(Token.getLastToken(string2));
        }
    }

    private void processMaterializedQuery() {
        String string = Token.getStringAfter(this.afterColumns, "AS ( SELECT");
        if (string.equalsIgnoreCase("")) {
            string = Token.getStringAfter(this.afterColumns, "AS (SELECT");
        }
        if (!string.equalsIgnoreCase("")) {
            this.tableProxy.setMaterializedQuery("YES");
            string = Token.getStringAfterToken(this.afterColumns, "AS");
            String string2 = Token.getValBetweenBrackets(string, 1);
            this.tableProxy.setMqQueryDefinition(string2);
            string = Token.getStringAfter(string, string2).trim();
            string = Token.cutFirstToken(string);
            if (string.toUpperCase().startsWith("WITH NO DATA")) {
                this.processCopyOption(string.substring(12).trim());
            } else {
                this.processRefreshableOptions(string);
            }
        }
    }

    private void processRefreshableOptions(String string) {
        if (string.toUpperCase().startsWith("DATA INITIALLY DEFERRED")) {
            if (Token.hasString(string, "BY USER")) {
                this.tableProxy.setMqMaintenance("BY USER");
            } else {
                this.tableProxy.setMqMaintenance("BY SYSTEM");
            }
            if (Token.hasString(string, "ENABLE")) {
                this.tableProxy.setMqQueryOptimization("ENABLE");
            } else {
                this.tableProxy.setMqQueryOptimization("DISABLE");
            }
        }
    }

    private void processCopyOption(String string) {
        if (string.toUpperCase().startsWith("INCLUDING IDENTITY")) {
            this.tableProxy.setMqIdentityColumnAttr("INCLUDE");
        } else {
            this.tableProxy.setMqIdentityColumnAttr("EXCLUDE");
        }
        if (Token.hasString(string, "INCLUDING COLUMN DEFAULTS") || Token.hasString(string, "INCLUDING DEFAULTS")) {
            this.tableProxy.setMqColumnDefaults("INCLUDING");
        } else if (Token.hasString(string, "USING TYPE DEFAULTS")) {
            this.tableProxy.setMqColumnDefaults("USING TYPE DEFAULTS");
        } else {
            this.tableProxy.setMqColumnDefaults("EXCLUDING");
        }
    }

    private String initTableName() {
        String string = Token.getNameAfterToken(this.outSideBrackets, "TABLE", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.ownerName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initDatabaseTablespace() {
        String string = Token.getTokenAfter(this.outSideBrackets, "IN");
        if (string.equalsIgnoreCase("DATABASE")) {
            this.inTablespace = "";
            this.inDatabase = "";
        } else if (string.indexOf(46) > 0) {
            this.inTablespace = Token.getValAfterCharacter(string, '.');
            this.inDatabase = Token.getValBeforeCharacter(string, '.');
        } else {
            this.inTablespace = string;
            this.inDatabase = "";
        }
    }

    private boolean initCols() {
        String string = this.inSideBrackets;
        string = Token.getNamesOnly(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            if (this.storageDesign.importStorageObjectsOnly()) continue;
            object = this.table.createColumn(string2);
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
        }
        return false;
    }

    public void initCol() {
        if (Token.hasToken(this.statement, "AS")) {
            String string;
            this.table.setTypeID(this.storageDesign.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
            String string2 = Token.getStringAfter(this.statement, "SELECT").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string2.indexOf("FROM");
                string = string2.substring(0, n);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")")) {
                    n = string2.indexOf("FROM", n + 1);
                    string = string2.substring(0, n);
                }
                string2 = string;
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("ALL")) {
                string2 = Token.getStringAfterToken(string2, "ALL").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("DISTINCT")) {
                string2 = Token.getStringAfterToken(string2, "DISTINCT").trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            string = null;
            String string3 = null;
            block1: while (stringTokenizer.hasMoreTokens()) {
                Column column;
                Table table;
                String string4;
                StringTokenizer stringTokenizer2;
                int n;
                Column column2;
                int n2;
                string = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string, "AS")) {
                    n2 = string.lastIndexOf(" AS ");
                    string3 = string.substring(n2);
                    string3 = Token.cutFirstToken(string3);
                    string3 = Token.removeQuotes(string3);
                    string = string.substring(0, n2);
                    Token.removeQuotes(string);
                }
                if ((string = Token.encodeQuotedString(string)).indexOf(" ") > -1) {
                    if (string.charAt(string.length() - 1) == '\"') {
                        string3 = string.substring(0, string.length() - 1);
                        n2 = string3.lastIndexOf(34);
                        string3 = string3.substring(n2) + "\"";
                        string = string.substring(0, n2 - 1);
                    } else if (string.charAt(string.length() - 1) == '\'') {
                        string3 = string.substring(0, string.length() - 1);
                        n2 = string3.lastIndexOf(39);
                        string3 = string3.substring(n2) + "'";
                        string = string.substring(0, n2 - 1);
                    } else {
                        String string5 = Token.getLastToken(string);
                        if (string5.indexOf(41) == -1 && !string5.equalsIgnoreCase("END")) {
                            string3 = string5;
                            string = string.substring(0, string.lastIndexOf(string5)).trim();
                        }
                    }
                }
                string = Token.removeQuotes(Token.decodeQuotedString(string));
                String string6 = null;
                String string7 = null;
                if (!Token.hasCloseAndOpenBrackets(string) && string.indexOf(43) == -1 && string.indexOf(45) == -1 && string.indexOf(42) == -1 && string.indexOf(47) == -1 && string.indexOf(58) == -1 && string.indexOf("||") == -1 && !Token.hasToken(string, "CONCAT") && string.indexOf(46) > -1) {
                    if (string.indexOf(46) > -1) {
                        string7 = string.substring(0, string.indexOf(46));
                        string = string.substring(string.lastIndexOf(46) + 1);
                        if (string7.indexOf(46) > -1) {
                            string7 = string7.substring(string7.lastIndexOf(46) + 1);
                        }
                    }
                } else {
                    string6 = string;
                }
                if (string3 != null && !string3.equalsIgnoreCase("")) {
                    column2 = this.table.createColumn(Token.getNamesOnly(string3));
                    this.design.getRelationalDesign().stampModelObjectDDL(column2);
                    if (string6 != null) {
                        if (this.isAggregateFunction(string6)) {
                            column2.setSourceType("Aggregate");
                        } else {
                            column2.setSourceType("Derived");
                        }
                        column2.setFormulaDesc(string6);
                        continue;
                    }
                    if (!Token.hasToken(this.statement, "FROM")) continue;
                    string2 = Token.getStringAfter(this.statement, "FROM").trim();
                    n = -1;
                    if (Token.hasToken(string2, "WHERE")) {
                        n = string2.indexOf("WHERE");
                    } else if (Token.hasToken(string2, "GROUP")) {
                        n = string2.indexOf("GROUP");
                    }
                    if (n > -1) {
                        string2 = string2.substring(0, n);
                    }
                    stringTokenizer2 = new StringTokenizer(string2, ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken().trim();
                        if (string4.indexOf(46) > -1) {
                            string4 = string4.substring(string4.lastIndexOf(46) + 1);
                        }
                        if (!Token.hasToken(string4, string7)) continue;
                        string4 = string4.startsWith("\"") ? Token.getValBetweenDoubleQuotes(string4).trim() : Token.getFirstToken(string4);
                        table = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(string4);
                        if (table == null || (column = (Column)table.getElementByName(string)) == null) continue;
                        column2.setDomain(column.getDomain());
                        continue block1;
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("") || string.equalsIgnoreCase("*")) continue;
                column2 = this.table.createColumn(string);
                this.design.getRelationalDesign().stampModelObjectDDL(column2);
                if (!Token.hasToken(this.statement, "FROM")) continue;
                string2 = Token.getStringAfter(this.statement, "FROM").trim();
                n = -1;
                if (Token.hasToken(string2, "WHERE")) {
                    n = string2.indexOf("WHERE");
                } else if (Token.hasToken(string2, "GROUP")) {
                    n = string2.indexOf("GROUP");
                }
                if (n > -1) {
                    string2 = string2.substring(0, n);
                }
                stringTokenizer2 = new StringTokenizer(string2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    if (string4.indexOf(46) > -1) {
                        string4 = string4.substring(string4.lastIndexOf(46) + 1);
                    }
                    if (!Token.hasToken(string4, string7)) continue;
                    string4 = string4.startsWith("\"") ? Token.getValBetweenDoubleQuotes(string4).trim() : Token.getFirstToken(string4);
                    table = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(string4);
                    if (table == null || (column = (Column)table.getElementByName(string)) == null) continue;
                    column2.setDomain(column.getDomain());
                    continue block1;
                }
            }
        }
    }

    private boolean isAggregateFunction(String string) {
        String[] stringArray = AggregateFunctionsDB2.FUNCTIONS_V8;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.toUpperCase().startsWith(string2.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private ArrayList initColumns() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.inSideBrackets;
        SHColumnElementsDB2v80 sHColumnElementsDB2v80 = new SHColumnElementsDB2v80();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            if (Boolean.TRUE.equals((object = sHColumnElementsDB2v80.getElementsColumn(string2.trim(), Token.hasToken(this.statement, "AS") && Token.hasToken(this.statement, "SELECT"))).get("IS_CONSTRAINT")) && string2.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string2);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private String initEditProc() {
        return Token.getTokenAfter(this.outSideBrackets, "EDITPROC").trim();
    }

    private String initValidProc() {
        return Token.getTokenAfter(this.outSideBrackets, "VALIDPROC").trim();
    }

    private String initAudit() {
        return Token.getTokenAfter(this.outSideBrackets, "AUDIT").trim();
    }

    private String initObid() {
        return Token.getTokenAfter(this.outSideBrackets, "OBID").trim();
    }

    private boolean initDataCapture() {
        String string = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return string.equalsIgnoreCase("CHANGES");
    }

    private boolean initWithRestrictOnDrop() {
        return Token.hasToken(this.outSideBrackets, "RESTRICT");
    }

    private String initCcsid() {
        return Token.getTokenAfter(this.outSideBrackets, "CCSID").trim();
    }

    private String initVolatile() {
        return Token.getTokenAfter(this.outSideBrackets, "VOLATILE").trim();
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        Object object;
        CheckConstraint checkConstraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(checkConstraint);
        RDBMSTypeSet rDBMSTypeSet = this.design.getRDBMSTypeSet();
        Iterator iterator = rDBMSTypeSet.iterator();
        while (iterator.hasNext()) {
            object = (RDBMSType)iterator.next();
            if (object != StorageDesignDB2v80.RDBMS_TYPE) continue;
            checkConstraint.add((ConstraintType)object, string);
        }
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            object = column.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        }
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private void addForeignKey(String string, Table table) {
        block17: {
            Table table2;
            ArrayList<Column> arrayList;
            String string2;
            block18: {
                String string3;
                int n;
                string2 = null;
                if (Token.hasToken(string, "CONSTRAINT")) {
                    string2 = Token.getTokenAfter(string, "CONSTRAINT");
                } else {
                    string2 = Token.getTokenAfter(string, "KEY");
                    n = string2.indexOf("(");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    } else if (n == 0) {
                        string2 = null;
                    }
                }
                n = string.indexOf(41);
                String string4 = string.substring(0, n + 1).trim();
                String string5 = Token.getValBetweenBrackets(string4);
                List list = this.getColumnNames(string5);
                arrayList = new ArrayList<Column>();
                Column[] columnArray = (Column[])table.getElements();
                for (String string6 : list) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        string3 = columnArray[i].getName().trim();
                        if (!string6.equalsIgnoreCase(string3)) continue;
                        arrayList.add(columnArray[i]);
                    }
                }
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string7 = Token.getTokenAfter(string, "REFERENCES");
                string3 = this.getNameFor(string7);
                table2 = this.getTableFor(string3 = Token.removeQuotes(string3));
                if (table2 == null) break block17;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block18;
                String string8 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string8);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index == null) break block17;
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (!bl2) break block17;
                String string9 = Token.getTokenAfter(string, "DELETE").trim();
                String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string9.equalsIgnoreCase(stringArray[i])) continue;
                    fKIndexAssociation.setDeleteRule(stringArray[i]);
                    break block17;
                }
                break block17;
            }
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)table2.getPK();
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string10 = Token.getTokenAfter(string, "DELETE").trim();
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string10.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = this.getNameFor(refAtColNode.referencedTable);
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
        if (table2 != null) {
            Index index;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (refAtColNode.refColumn != null) {
                arrayList.add(refAtColNode.refColumn);
                index = this.getUniqueIndexForColumnNames(table2, arrayList);
            } else {
                index = (Index)table2.getPK();
            }
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
        }
    }

    public static String getValOutsideFirstBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = string.indexOf(40);
                int n2 = string.indexOf(41);
                if (n != -1 && n2 != -1) {
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(' ');
                    stringBuffer.append(string.substring(n2 + 1, string.length()));
                }
                return stringBuffer.toString();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValOutsideBrackets:", exception);
            return "";
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

