/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateView
extends DDLStatementHandler {
    private boolean allColumnsAreMade;
    private AbstractView view;
    private String userDefined;
    private static final Logger LOGGER = new Logger(SHCreateView.class);

    public SHCreateView(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateView.clearCR(string);
        if (Token.startsWithString(string2, "create view")) {
            try {
                this.userDefined = SHCreateView.FormatCR(string, "\n");
                this.parseView(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for DB2 failed!", exception);
                this.importLog.addFailedStatement(SHCreateView.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseView(String string) {
        this.statement = string;
        this.allColumnsAreMade = true;
        if (this.allColumnsAreMade) {
            TableViewProxyDB2 tableViewProxyDB2;
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            String string2 = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
            String string3 = this.getNameOnly(string2);
            String string4 = Token.getValBeforeCharacter(string2, '.');
            if (abstractStorageDesignDB2.importStorageObjectsOnly()) {
                this.view = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(string3);
            } else {
                this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
                if (string4 != null && !"".equals(string4)) {
                    this.view.setSchema(string4);
                }
                this.view.setName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(this.view);
                if (!this.initCols()) {
                    this.initCol();
                }
                this.initUserDefinedSql();
            }
            if (abstractStorageDesignDB2 != null && (tableViewProxyDB2 = (TableViewProxyDB2)abstractStorageDesignDB2.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                tableViewProxyDB2.setDefinition(this.userDefined);
                this.initCheckOption(tableViewProxyDB2);
                this.initOwner(tableViewProxyDB2);
            }
        }
    }

    public boolean initCols() {
        String string = Token.getStringBefore(this.statement, " as select ");
        if (Token.hasCloseAndOpenBrackets(string)) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            if (!"".equalsIgnoreCase(string2)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = Token.removeQuotes(stringTokenizer.nextToken());
                    AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    abstractViewElement.setName(string3);
                    abstractViewElement.setAlias(string3);
                    abstractViewElement.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                    this.view.add(abstractViewElement);
                }
            }
            return true;
        }
        return false;
    }

    private void initCheckOption(TableViewProxyDB2 tableViewProxyDB2) {
        String string = Token.getTokenAfter(this.statement, "WITH");
        if (string.equalsIgnoreCase("LOCAL")) {
            tableViewProxyDB2.setCheckOptionScope("LOCAL");
        } else {
            tableViewProxyDB2.setCheckOptionScope("CASCADED");
        }
        if (!string.equalsIgnoreCase("")) {
            tableViewProxyDB2.setCheckOption(true);
        } else {
            tableViewProxyDB2.setCheckOption(false);
        }
    }

    public void initCol() {
        String string = Token.getStringAfter(this.statement, "AS SELECT").trim();
        if (string.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            string = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!string.equalsIgnoreCase("")) {
            String string2;
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string.toUpperCase().indexOf("FROM");
                string2 = string.substring(0, n);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")")) {
                    n = string.toUpperCase().indexOf("FROM", n + 1);
                    string2 = string.substring(0, n);
                }
                string = string2;
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("ALL")) {
                string = Token.getStringAfterToken(string, "ALL").trim();
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("DISTINCT")) {
                string = Token.getStringAfterToken(string, "DISTINCT").trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string2);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string2 = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string2, "AS")) {
                    string3 = Token.getNameAfterToken(string2, "AS", '\"', '\"');
                    string2 = Token.getStringBeforeToken(string2, "AS");
                }
                if ((string2 = Token.encodeQuotedString(string2)).indexOf(" ") > -1) {
                    if (string2.charAt(string2.length() - 1) == '\"') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(34);
                        string3 = string3.substring(n) + "\"";
                        string2 = string2.substring(0, n - 1);
                    } else if (string2.charAt(string2.length() - 1) == '\'') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(39);
                        string3 = string3.substring(n) + "'";
                        string2 = string2.substring(0, n - 1);
                    } else {
                        String string4 = Token.getLastToken(string2);
                        if (string4.indexOf(41) == -1 && !string4.equalsIgnoreCase("END")) {
                            string3 = string4;
                            string2 = string2.substring(0, string2.lastIndexOf(string4)).trim();
                        }
                    }
                }
                if (!Token.hasCloseAndOpenBrackets(string2) && string2.indexOf(43) == -1 && string2.indexOf(45) == -1 && string2.indexOf(42) == -1 && string2.indexOf(47) == -1 && string2.indexOf("||") == -1 && string2.indexOf(58) == -1 && !Token.hasToken(string2, "CONCAT") && string2.indexOf(46) > -1 && (string2 = string2.substring(string2.indexOf(46) + 1)).indexOf(46) > -1) {
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                if ((string2 = Token.removeQuotes(Token.decodeQuotedString(string2))).equalsIgnoreCase("") || string2.equalsIgnoreCase("*")) continue;
                AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                if (string3 != null) {
                    abstractViewElement.setName(string3);
                } else {
                    abstractViewElement.setName(string2);
                }
                abstractViewElement.setExpression(string2);
                abstractViewElement.setAlias(string2);
                abstractViewElement.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                this.view.add(abstractViewElement);
                if (string3 != null) {
                    string3 = Token.removeQuotes(Token.decodeQuotedString(string3));
                    abstractViewElement.setAlias(string3);
                    continue;
                }
                abstractViewElement.setAlias(abstractViewElement.getName());
            }
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("DB2");
    }

    private void initOwner(TableViewProxyDB2 tableViewProxyDB2) {
        String string = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "VIEW").trim(), '.');
        if (!"".equalsIgnoreCase(string)) {
            Owner owner = (Owner)((AbstractStorageDesignDB2)tableViewProxyDB2.getStorageDesign()).getOwnerSet().getByName(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)tableViewProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            tableViewProxyDB2.setOwner(owner);
        } else if (this.getOwner() != null) {
            tableViewProxyDB2.setOwner(this.getOwner());
        } else {
            tableViewProxyDB2.setOwner(((AbstractStorageDesignDB2)tableViewProxyDB2.getStorageDesign()).getOwnerSet().getDefaultOwner());
        }
    }

    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }
}

