/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;

public class SHCreateStoragegroup
extends DDLStatementHandler {
    private StorageGroupDB2 stoGroup;
    private AbstractStorageDesignDB2 stoDesign = null;

    public SHCreateStoragegroup(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateStoragegroup.clearCR(string);
        if (Token.startsWithString(string2, "create stogroup")) {
            try {
                this.parseStorageGroup(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addError("Parsing " + string2 + " for DB2 failed");
                this.importLog.addFailedStatement(SHCreateStoragegroup.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseStorageGroup(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            String string2;
            this.stoGroup = this.stoDesign.getStorageGroupSet().createStorageGroup();
            String string3 = this.initName();
            this.stoGroup.setName(string3);
            String string4 = this.initVolumes();
            if (!string4.equalsIgnoreCase("")) {
                this.stoGroup.recreateVolumeSet(string4);
            }
            if (!(string2 = this.initVCat()).equalsIgnoreCase("")) {
                VCatDB2 vCatDB2 = this.stoDesign.getVCatSet().getOrCreateVCat(string2);
                this.stoGroup.setVCat(vCatDB2);
            }
        }
    }

    private String initName() {
        return Token.getNameAfterToken(this.statement, "STOGROUP", '\"', '\"').trim();
    }

    private String initVolumes() {
        String string = Token.getValBetweenBrackets(this.statement);
        string = Token.getValBetweenDoubleQuotes(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equalsIgnoreCase("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                VolumesDB2 volumesDB2 = this.stoDesign.getVolumesSet().getOrCreateVolumes(string2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(volumesDB2.getName());
            }
        }
        return stringBuffer.toString();
    }

    private String initVCat() {
        return Token.getTokenAfter(this.statement, "VCAT").trim();
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.stoGroup;
    }
}

