/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndex
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private AbstractStorageDesignDB2 stoDesign;
    private boolean unique;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndex.class);
    boolean hasIntegrIndex = false;

    public SHCreateIndex(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndex.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index") || Token.startsWithString(string2, "create unique where not null index") || Token.startsWithString(string2, "create type 2 index") || Token.startsWithString(string2, "create type 2 unique index") || Token.startsWithString(string2, "create type 2 unique where not null index") || Token.startsWithString(string2, "create type 1 index") || Token.startsWithString(string2, "create type 1 unique index") || Token.startsWithString(string2, "create type 1 unique where not null index")) {
            this.statement = string2;
            if (this.isTableIndex()) {
                try {
                    this.createIndex();
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateIndex.FormatCR(string, "\n"));
                    } else {
                        this.importLog.incrementImportedStatements();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Parsing " + string2 + " for DB2 7.0 failed!", exception);
                    this.importLog.addFailedStatement(SHCreateIndex.FormatCR(string, "\n"));
                }
                this.index = null;
                this.table = null;
                this.indexName = "";
                this.stoDesign = null;
                this.unique = false;
                this.failed = false;
            } else {
                this.nextHandler(string);
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createIndex() {
        try {
            this.indexName = this.initIndexName();
            this.unique = Token.hasToken(this.statement, "UNIQUE");
            this.hasIntegrIndex = false;
            List list = this.getColumnsName();
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            if (this.table != null) {
                if (this.stoDesign != null && this.stoDesign.importStorageObjectsOnly()) {
                    this.index = this.table.getIndexByName(this.indexName);
                } else {
                    this.constructIndex(this.makeNames(list));
                }
            }
            if (this.index != null) {
                IndexProxyDB2v70 indexProxyDB2v70;
                if (!this.stoDesign.importStorageObjectsOnly()) {
                    if (this.unique && !this.index.isPK() && !this.index.isUnique()) {
                        this.index.setIndexState("Unique Plain Index");
                    }
                    this.setColumnForIndex(list);
                }
                if (this.stoDesign != null && (indexProxyDB2v70 = (IndexProxyDB2v70)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    indexProxyDB2v70.setProcessedInDDLImport(true);
                    StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    indexProxyDB2v70.setName(this.indexName);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
                    indexProxyDB2v70.setStorageTemplate(storageTemplateDB2);
                    this.initNotNull(indexProxyDB2v70);
                    int n = this.statement.indexOf(41);
                    String string = this.statement.substring(n + 1).trim();
                    int n2 = string.indexOf(40);
                    if (n2 > 0) {
                        string = string.substring(0, n2);
                    }
                    this.initUsingBlock(indexProxyDB2v70, string);
                    this.initFreeBlock(indexProxyDB2v70, string);
                    this.initGbpcacheBlock(indexProxyDB2v70, string);
                    this.initDefine(indexProxyDB2v70, string);
                    this.initCluster(indexProxyDB2v70);
                    this.initBufferpool(indexProxyDB2v70);
                    this.initClose(indexProxyDB2v70);
                    this.initDefer(indexProxyDB2v70);
                    this.initCopy(indexProxyDB2v70);
                    this.initPieceSize(indexProxyDB2v70);
                    this.initOwner(indexProxyDB2v70);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(indexProxyDB2v70.getStorageTemplate());
                    if (storageTemplateDB22 != indexProxyDB2v70.getStorageTemplate()) {
                        indexProxyDB2v70.setStorageTemplate(storageTemplateDB22);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            StringBuffer stringBuffer = new StringBuffer(runtimeException.getMessage());
            stringBuffer.append(" in SHCreateIndex.createIndex");
            LOGGER.error(stringBuffer.toString(), runtimeException);
            this.importLog.addError("Creating index for statement " + this.statement + " for DB2 failed");
            this.failed = true;
        }
    }

    public boolean columnsBelongToIndex(Object[] objectArray, Index index) {
        if (index != null) {
            ContainedObject[] containedObjectArray = index.getElements();
            if (containedObjectArray.length != objectArray.length) {
                return false;
            }
            for (int i = 0; i < containedObjectArray.length; ++i) {
                if (containedObjectArray[i].getName().equalsIgnoreCase((String)objectArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    private void constructIndex(Object[] objectArray) {
        Object object;
        int n;
        Object object2;
        if (this.unique && this.table.hasPK() && !this.hasIntegrIndex && ((DesignObject)(object2 = (Index)this.table.getPK())).getName().equalsIgnoreCase(this.indexName)) {
            this.index = object2;
            return;
        }
        object2 = (Index[])this.table.getKeys();
        if (this.unique && !this.hasIntegrIndex) {
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                if (!((KeyObject)object).isUnique() || !((DesignObject)object).getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = object;
                return;
            }
        }
        for (n = 0; n < ((Object)object2).length; ++n) {
            object = object2[n];
            if (!((DesignObject)object).getName().equalsIgnoreCase(this.indexName) || !this.columnsBelongToIndex(objectArray, (Index)object)) continue;
            this.index = object;
            break;
        }
        if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
            this.index = this.table.createIndex();
            this.index.setName(this.indexName);
            this.design.getRelationalDesign().stampModelObjectDDL(this.index);
        }
    }

    private void initNotNull(IndexProxyDB2 indexProxyDB2) {
        boolean bl;
        if (!this.index.isPK() && (bl = Token.hasToken(this.statement, "WHERE"))) {
            indexProxyDB2.setWhereNotNull(true);
        }
    }

    private String initIndexName() {
        String string = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        if (string.indexOf(46) > -1) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void setColumnForIndex(List list) {
        for (ColNameSortOrder colNameSortOrder : list) {
            Column column = (Column)this.table.getElementByName(colNameSortOrder.cname);
            this.index.add(column);
            this.index.setColumnSortOrder(column, colNameSortOrder.sortOrder);
        }
    }

    private List getColumnsName() {
        int n = 0;
        ArrayList<ColNameSortOrder> arrayList = new ArrayList<ColNameSortOrder>();
        if (this.table != null) {
            n = this.table.getElements().length;
        }
        if (n > 0) {
            String string = Token.getValBetweenBrackets(this.statement, 1);
            boolean bl = Token.hasCloseAndOpenBrackets(string);
            if (bl) {
                this.index.setIndexExpression(string);
                return arrayList;
            }
            string = Token.getNamesOnly(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = "ASC";
                int n2 = string2.indexOf(" ");
                if (n2 > 0) {
                    try {
                        if (string2.substring(n2 + 1).trim().equalsIgnoreCase("DESC")) {
                            string3 = "DESC";
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    string2 = string2.substring(0, n2);
                }
                arrayList.add(new ColNameSortOrder(string2, string3));
            }
        }
        return arrayList;
    }

    private String getTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "ON", '\"', '\"');
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        if ((n = string.indexOf(46)) > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initUsingBlock(IndexProxyDB2 indexProxyDB2, String string) {
        boolean bl = Token.hasToken(string, "USING");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "USING").trim();
            if (string2.equalsIgnoreCase("VCAT")) {
                String string3 = Token.getTokenAfter(string, "VCAT").trim();
                Iterator iterator = this.stoDesign.getVCatSet().iterator();
                while (iterator.hasNext()) {
                    VCatDB2 vCatDB2 = (VCatDB2)iterator.next();
                    if (!vCatDB2.getName().equalsIgnoreCase(string3)) continue;
                    indexProxyDB2.getStorageTemplate().setVCat(vCatDB2);
                    break;
                }
            } else if (string2.equalsIgnoreCase("STOGROUP")) {
                String string4;
                String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
                StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
                indexProxyDB2.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
                try {
                    String string6;
                    string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                    if (!string4.equals("")) {
                        int n = Integer.parseInt(string4);
                        indexProxyDB2.getStorageTemplate().setSgPriqty(n);
                    }
                    if (!(string6 = Token.getTokenAfter(string, "SECQTY").trim()).equals("")) {
                        int n = Integer.parseInt(string6);
                        indexProxyDB2.getStorageTemplate().setSgSeqty(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Wrong format in SHCreateIndex.initUsingBlock():", numberFormatException);
                    this.importLog.addWarning("Wrong using block format in statement " + this.statement);
                }
                string4 = Token.getTokenAfter(this.statement, "ERASE").trim();
                if (string4.equalsIgnoreCase("YES")) {
                    indexProxyDB2.getStorageTemplate().setSgErase(true);
                }
            }
        }
    }

    private void initFreeBlock(IndexProxyDB2 indexProxyDB2, String string) {
        try {
            String string2;
            String string3 = Token.getTokenAfter(string, "FREEPAGE").trim();
            if (!string3.equals("")) {
                int n = Integer.parseInt(string3);
                indexProxyDB2.getStorageTemplate().setFreePage(n);
            }
            if (!(string2 = Token.getTokenAfter(string, "PCTFREE").trim()).equals("")) {
                int n = Integer.parseInt(string2);
                indexProxyDB2.getStorageTemplate().setPctFree(n);
            } else {
                indexProxyDB2.getStorageTemplate().setPctFree(10);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("Wrong format in SHCreateIndex.initFreeBlock:", numberFormatException);
            this.importLog.addWarning("Wrong free block format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlock(IndexProxyDB2 indexProxyDB2, String string) {
        boolean bl = Token.hasToken(string, "GBPCACHE");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                indexProxyDB2.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initDefine(IndexProxyDB2 indexProxyDB2, String string) {
        boolean bl = Token.hasToken(string, "DEFINE");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "DEFINE").trim();
            if (string2.equalsIgnoreCase("YES")) {
                indexProxyDB2.getStorageTemplate().setDefine(true);
            } else if (string2.equalsIgnoreCase("NO")) {
                indexProxyDB2.getStorageTemplate().setDefine(false);
            }
        }
    }

    private void initCluster(IndexProxyDB2v70 indexProxyDB2v70) {
        boolean bl = Token.hasToken(this.statement, "CLUSTER");
        if (bl) {
            int n = this.statement.indexOf("CLUSTER");
            String string = this.statement.substring(n);
            if (!(string = Token.getValBetweenBrackets(string).trim()).equalsIgnoreCase("")) {
                indexProxyDB2v70.setClusterType(IndexProxyDB2.CLUSTER_TYPES[2]);
                if (((TableProxyDB2)indexProxyDB2v70.getTableProxy()).getTableSpace() != null) {
                    ((TableProxyDB2)indexProxyDB2v70.getTableProxy()).getTableSpace().setPartIndex(indexProxyDB2v70);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    IndexPartitionDB2 indexPartitionDB2 = this.stoDesign.getIndexPartitionSet().createIndexPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(indexPartitionDB2);
                    indexPartitionDB2.setPartNumber(++n2);
                    StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
                    indexPartitionDB2.setStorageTemplate(storageTemplateDB2);
                    indexPartitionDB2.setIndex(indexProxyDB2v70);
                    this.initUsingBlockPart(string2, indexPartitionDB2);
                    this.initFreeBlockPart(string2, indexPartitionDB2);
                    this.initGbpcacheBlockPart(string2, indexPartitionDB2);
                    this.initConstantsBlockPart(string2, indexPartitionDB2);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(indexPartitionDB2.getStorageTemplate());
                    if (storageTemplateDB22 == indexProxyDB2v70.getStorageTemplate()) continue;
                    indexPartitionDB2.setStorageTemplate(storageTemplateDB22);
                }
            } else {
                indexProxyDB2v70.setClusterType(IndexProxyDB2.CLUSTER_TYPES[1]);
                indexProxyDB2v70.setClustered(true);
            }
        }
    }

    private void initUsingBlockPart(String string, IndexPartitionDB2 indexPartitionDB2) {
        String string2 = Token.getTokenAfter(string, "USING").trim();
        if (string2.equalsIgnoreCase("VCAT")) {
            String string3 = Token.getTokenAfter(string, "VCAT").trim();
            VCatDB2 vCatDB2 = this.stoDesign.getVCatSet().getOrCreateVCat(string3);
            indexPartitionDB2.getStorageTemplate().setVCat(vCatDB2);
        } else if (string2.equalsIgnoreCase("STOGROUP")) {
            String string4;
            String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
            StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
            indexPartitionDB2.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
            try {
                String string6;
                string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                if (!string4.equals("")) {
                    int n = Integer.parseInt(string4);
                    indexPartitionDB2.getStorageTemplate().setSgPriqty(n);
                }
                if (!(string6 = Token.getTokenAfter(string, "SECQTY").trim()).equals("")) {
                    int n = Integer.parseInt(string6);
                    indexPartitionDB2.getStorageTemplate().setSgSeqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart: ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong using block part format in statement " + this.statement);
            }
            string4 = Token.getTokenAfter(string, "ERASE").trim();
            if (string4.equalsIgnoreCase("YES")) {
                indexPartitionDB2.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initFreeBlockPart(String string, IndexPartitionDB2 indexPartitionDB2) {
        try {
            String string2;
            String string3 = Token.getTokenAfter(string, "FREEPAGE").trim();
            if (!string3.equals("")) {
                int n = Integer.parseInt(string3);
                indexPartitionDB2.getStorageTemplate().setFreePage(n);
            }
            if (!(string2 = Token.getTokenAfter(string, "PCTFREE").trim()).equals("")) {
                int n = Integer.parseInt(string2);
                indexPartitionDB2.getStorageTemplate().setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart: ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong using free block part format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlockPart(String string, IndexPartitionDB2 indexPartitionDB2) {
        String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
        if (!string2.equals("")) {
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                indexPartitionDB2.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initConstantsBlockPart(String string, IndexPartitionDB2 indexPartitionDB2) {
        String string2 = Token.getValBetweenBrackets(string).trim();
        if (!string2.equals("")) {
            indexPartitionDB2.setPartConstants(string2);
        }
    }

    private void initBufferpool(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        BufferPoolSetDB2 bufferPoolSetDB2 = this.stoDesign.getBufferPoolSet();
        Iterator iterator = bufferPoolSetDB2.iterator();
        while (iterator.hasNext()) {
            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
            if (!bufferPoolDB2.getName().equalsIgnoreCase(string)) continue;
            indexProxyDB2.setBufferPool(bufferPoolDB2);
        }
    }

    private void initClose(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (string.equalsIgnoreCase("NO")) {
            indexProxyDB2.setClose(false);
        }
    }

    private void initDefer(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getTokenAfter(this.statement, "DEFER").trim();
        if (string.equalsIgnoreCase("YES")) {
            indexProxyDB2.setDefer(true);
        }
    }

    private void initCopy(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getTokenAfter(this.statement, "COPY").trim();
        if (string.equalsIgnoreCase("YES")) {
            indexProxyDB2.setCopy(true);
        }
    }

    private void initPieceSize(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getStringAfter(this.statement, "PIECESIZE").trim();
        if (!string.equals("")) {
            if (!string.endsWith("K") && string.endsWith("M") && string.endsWith("G")) {
                string = Token.getStringAfterToken(this.statement, "PIECESIZE");
                string = Token.getTokens(string, 1, 2);
            }
            if (string.endsWith("M")) {
                try {
                    int n = Integer.parseInt(string.substring(0, string.length() - 2));
                    string = String.valueOf(n *= 1024) + " K";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "2097152 K";
                }
            } else if (string.endsWith("G")) {
                try {
                    int n = Integer.parseInt(string.substring(0, string.length() - 1).trim());
                    string = String.valueOf(n *= 0x100000) + " K";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "2097152 K";
                }
            }
            indexProxyDB2.setPieceSize(string);
        }
    }

    private void initOwner(IndexProxyDB2 indexProxyDB2) {
        String string = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "INDEX").trim(), '.');
        if (!string.equalsIgnoreCase("")) {
            Owner owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2.getStorageDesign()).getOwnerSet().getByName(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            indexProxyDB2.setOwner(owner);
        } else if (this.getOwner() != null) {
            indexProxyDB2.setOwner(this.getOwner());
        }
    }

    private boolean isTableIndex() {
        String string = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        return this.table != null;
    }

    private Object[] makeNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColNameSortOrder colNameSortOrder : list) {
            arrayList.add(colNameSortOrder.cname);
        }
        return arrayList.toArray();
    }

    private class ColNameSortOrder {
        String cname;
        String sortOrder;

        ColNameSortOrder(String string, String string2) {
            this.sortOrder = string2;
            this.cname = string;
        }
    }
}

