/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;

public class SHCreateDatabase
extends DDLStatementHandler {
    private DataBaseDB2 database;
    private static final String SYSDEFLT = "SYSDEFLT";

    public SHCreateDatabase(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabase.clearCR(string);
        if (Token.startsWithString(string2, "create database")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateDatabase.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (abstractStorageDesignDB2 != null) {
            Object object;
            boolean bl;
            String string2;
            Object object2;
            Object object3;
            boolean bl2;
            this.database = abstractStorageDesignDB2.getDataBaseSet().createDataBase();
            String string3 = this.initDatabaseName();
            this.database.setName(string3);
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
            this.initType();
            BufferPoolSetDB2 bufferPoolSetDB2 = abstractStorageDesignDB2.getBufferPoolSet();
            String string4 = this.initBufferPool();
            if (string4 != null && (bl2 = bufferPoolSetDB2.containsName(string4))) {
                object3 = bufferPoolSetDB2.iterator();
                while (object3.hasNext()) {
                    object2 = (BufferPoolDB2)object3.next();
                    if (!((StorageObject)object2).getName().equalsIgnoreCase(string4)) continue;
                    this.database.setBufferPool((BufferPoolDB2)object2);
                    break;
                }
            }
            if ((string2 = this.initIndexBP()) != null && (bl = bufferPoolSetDB2.containsName(string2))) {
                object2 = bufferPoolSetDB2.iterator();
                while (object2.hasNext()) {
                    object = (BufferPoolDB2)object2.next();
                    if (!((StorageObject)object).getName().equalsIgnoreCase(string2)) continue;
                    this.database.setIndexBufferPool((BufferPoolDB2)object);
                    break;
                }
            }
            if ((object3 = this.initStogroup()) != null) {
                object2 = abstractStorageDesignDB2.getStorageGroupSet();
                boolean bl3 = ((ModelObjectSet)object2).containsName((String)object3);
                if (!bl3) {
                    object3 = SYSDEFLT;
                }
                this.database.setStorageGroup(((StorageGroupSetDB2)object2).getOrCreateStorageGroup((String)object3));
            }
            if ((object2 = this.initCCsid()) != null) {
                object = DataBaseDB2.getCcsidChoices();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (!((String)object2).equalsIgnoreCase((String)object[i])) continue;
                    this.database.setCcsid((String)object[i]);
                    break;
                }
            }
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private String initBufferPool() {
        String string = null;
        boolean bl = Token.hasToken(this.statement, "BUFFERPOOL");
        if (bl) {
            string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        }
        return string;
    }

    private String initIndexBP() {
        String string = null;
        boolean bl = Token.hasToken(this.statement, "INDEXBP");
        if (bl) {
            string = Token.getTokenAfter(this.statement, "INDEXBP").trim();
        }
        return string;
    }

    private String initStogroup() {
        String string = null;
        boolean bl = Token.hasToken(this.statement, "STOGROUP");
        if (bl) {
            string = Token.getTokenAfter(this.statement, "STOGROUP").trim();
        }
        return string;
    }

    private String initCCsid() {
        String string = null;
        boolean bl = Token.hasToken(this.statement, "CCSID");
        if (bl) {
            string = Token.getTokenAfter(this.statement, "CCSID").trim();
        }
        return string;
    }

    public DataBaseDB2 getDatabase() {
        return this.database;
    }

    private void initType() {
        String string = null;
        String string2 = null;
        boolean bl = Token.hasToken(this.statement, "AS");
        boolean bl2 = Token.hasToken(this.statement, "FOR");
        if (bl && bl2) {
            string = Token.getTokenAfter(this.statement, "AS").trim();
            string2 = Token.getTokenAfter(this.statement, "FOR").trim();
            if (string.equalsIgnoreCase("WORKFILE") || string.equalsIgnoreCase("TEMP")) {
                this.database.setType(string);
            }
            this.database.setMember(string2);
        }
    }
}

