/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;

public class SHCommentOn
extends DDLStatementHandler {
    public SHCommentOn(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCommentOn.clearCR(string);
        if (Token.startsWithString(string2, "comment on")) {
            try {
                this.parseCommentOn(string2.replaceAll("\"", ""), string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCommentOn.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseCommentOn(String string, String string2) {
        String string3 = this.getNameOnly(Token.getTokenAfter(string, "ON").trim());
        String string4 = Token.getStringAfter(string2, "IS");
        string4 = Token.getValBetweenQuotationMarks(string4);
        if (string3.trim().equalsIgnoreCase("ALIAS")) {
            string3 = this.getNameOnly(Token.getTokenAfter(string, "ALIAS").trim());
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            AliasDB2 aliasDB2 = (AliasDB2)abstractStorageDesignDB2.getAliasSet().getByName(string3);
            if (aliasDB2 != null) {
                aliasDB2.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("COLUMN")) {
            string3 = Token.getTokenAfter(string, "COLUMN").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            String string5 = null;
            if (stringTokenizer.countTokens() == 3) {
                stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            } else if (stringTokenizer.countTokens() == 2) {
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            DesignObject designObject = null;
            if (string5 != null) {
                Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string5);
                if (table != null) {
                    designObject = table.getElementByName(string3);
                } else {
                    TableView tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string5);
                    if (tableView != null) {
                        designObject = tableView.getElementByName(string3);
                    }
                }
                if (designObject == null) {
                    designObject = this.design.getRelationalDesign().getColumnSet().getByName(string3);
                }
            } else {
                designObject = this.design.getRelationalDesign().getColumnSet().getByName(string3);
            }
            if (designObject != null) {
                designObject.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("PROCEDURE")) {
            string3 = this.getNameOnly(Token.getTokenAfter(string, "PROCEDURE").trim());
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            StoredProcedureDB2 storedProcedureDB2 = (StoredProcedureDB2)abstractStorageDesignDB2.getStoredProcedureSet().getByName(string3);
            if (storedProcedureDB2 != null) {
                storedProcedureDB2.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("TABLE")) {
            string3 = this.getNameOnly(Token.getTokenAfter(string, "TABLE").trim());
            Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string3);
            TableView tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string3);
            if (table != null) {
                table.setCommentInRDBMS(string4);
            } else if (tableView != null) {
                tableView.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("TRIGGER")) {
            string3 = this.getNameOnly(Token.getTokenAfter(string, "TRIGGER").trim());
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            TriggerDB2 triggerDB2 = (TriggerDB2)abstractStorageDesignDB2.getTriggerSet().getByName(string3);
            if (triggerDB2 != null) {
                triggerDB2.setCommentInRDBMS(string4);
            }
        }
    }
}

