/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElements
implements StatementsConstants {
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private static final String ZERO = "0";
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElements.class);
    private String tstatement = "";
    private String pstatement = "";

    public void parseColumns(String string) {
        this.statement = string;
        this.mapElementsColumn = new HashMap();
        this.tstatement = this.statement.toUpperCase();
        if (this.initColumnName()) {
            this.initDatatype();
            this.initNotNull();
            this.initIdentity();
            this.initFor();
            this.initWithDefault();
            this.initPrimaryKeyOrUnique();
            this.initReferences();
            this.initConstraintCheck();
            this.initFieldProc();
        } else {
            this.initConstraints();
        }
    }

    private boolean initColumnName() {
        String string = Token.getFirstToken(this.statement);
        if (this.constraints.contains(string.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", string);
        this.statement = Token.cutTokenFromFront(this.statement, string);
        return true;
    }

    private void initDatatype() {
        if (!this.statement.startsWith("FOREIGN")) {
            int n;
            String string = this.searchWhichDatatype(this.statement);
            String string2 = null;
            String string3 = null;
            if (string != null) {
                string2 = string;
                string3 = Token.getStringAfter(this.statement, string).trim();
                if (string3.startsWith("(") && (n = string3.indexOf(")")) > -1) {
                    string2 = string + string3.substring(0, n + 1);
                }
            }
            if (string == null && (string = this.searchNotStandartDatatypes(this.statement)) != null) {
                string2 = string;
                string3 = Token.getStringAfter(this.statement, string).trim();
                if (string3.startsWith("(") && (n = string3.indexOf(")")) > -1) {
                    string2 = string + string3.substring(0, n + 1);
                }
                this.mapElementsColumn.put("typename", string2);
            }
            if (string != null) {
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string);
                if (Token.hasCloseAndOpenBrackets(string4)) {
                    string2 = string4;
                    string = string4 = Token.getValBeforeBrackets(string4).trim();
                }
                if (string4 != null) {
                    string2 = Token.cutTokenFromFront(string2, string);
                    this.mapElementsColumn.put("datatype", string4);
                    if (!string2.equalsIgnoreCase("")) {
                        boolean bl = Token.hasCloseAndOpenBrackets(string2);
                        if (bl) {
                            String string5 = Token.getValBetweenBrackets(string2, 1);
                            int n2 = string5.indexOf(",");
                            if (n2 != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", string5.substring(0, n2).trim());
                                this.mapElementsColumn.put("scale", string5.substring(n2 + 1).trim());
                            } else if (string4.equals("DECIMAL")) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", string5.trim());
                            } else if (string4.equalsIgnoreCase("NUMERIC")) {
                                if (n2 != -1) {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", string5.substring(0, n2).trim());
                                    this.mapElementsColumn.put("scale", string5.substring(n2 + 1).trim());
                                } else {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", string5.trim());
                                    this.mapElementsColumn.put("scale", ZERO);
                                }
                            } else {
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", ZERO);
                                this.mapElementsColumn.put("size", string5.trim());
                            }
                            this.statement = Token.cutFirstToken(this.statement);
                        }
                    } else {
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer("datatype is unknown in SHColumnElements.initDatatype: ");
                    LOGGER.error(stringBuffer.toString());
                }
            } else {
                this.statement = Token.cutFirstToken(this.statement);
            }
        }
    }

    protected String searchWhichDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("DB2/390 7");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.toUpperCase().startsWith(string2);
            if (!bl) continue;
            try {
                char c = string.charAt(string2.length());
                bl = c == '(' || c == ' ' || c == '\n' || c == '\t';
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = true;
            }
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    private void initNotNull() {
        String string;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValAfterBrackets(this.statement.trim(), 1);
        }
        if ((string = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("NOT")) {
            if ("NULL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "NOT"))) {
                this.mapElementsColumn.put("NOT NULL", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "NOT NULL");
            } else {
                this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
        }
    }

    private void initIdentity() {
        int n = this.tstatement.indexOf("GENERATED");
        if (n > -1) {
            this.pstatement = this.tstatement.substring(n);
            String string = Token.getFirstToken(this.pstatement).trim();
            if (string.equalsIgnoreCase("GENERATED")) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "GENERATED");
                String string2 = Token.getFirstToken(this.pstatement).trim();
                if (string2.equalsIgnoreCase("ALWAYS")) {
                    this.mapElementsColumn.put("GENERATED", "ALWAYS");
                } else if (string2.equalsIgnoreCase("BY")) {
                    this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
                }
                if (Token.hasCloseAndOpenBrackets(this.pstatement)) {
                    int n2 = this.pstatement.indexOf(40);
                    this.pstatement = this.pstatement.substring(n2).trim();
                    String string3 = Token.getValBetweenBrackets(this.pstatement);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken().trim();
                        if (Token.hasToken(string4, "START")) {
                            string4 = Token.cutTokenFromFront(string4, "START");
                            string4 = Token.cutTokenFromFront(string4, "WITH");
                            this.mapElementsColumn.put("START", string4);
                            continue;
                        }
                        if (Token.hasToken(string4, "INCREMENT")) {
                            string4 = Token.cutTokenFromFront(string4, "INCREMENT");
                            string4 = Token.cutTokenFromFront(string4, "BY");
                            this.mapElementsColumn.put("INCREMENT", string4);
                            continue;
                        }
                        if (Token.hasToken(string4, "CACHE")) {
                            if (Token.hasToken(string4, "NO")) {
                                this.mapElementsColumn.put("CACHE", ZERO);
                                continue;
                            }
                            string4 = Token.cutTokenFromFront(string4, "CACHE");
                            this.mapElementsColumn.put("CACHE", string4);
                            continue;
                        }
                        if (Token.hasToken(string4, "CYCLE")) {
                            if (Token.hasToken(string4, "NO")) {
                                this.mapElementsColumn.put("CYCLE", Boolean.FALSE);
                                continue;
                            }
                            this.mapElementsColumn.put("CYCLE", Boolean.TRUE);
                            continue;
                        }
                        if (Token.hasToken(string4, "MAXVALUE")) {
                            string4 = Token.cutTokenFromFront(string4, "MAXVALUE");
                            this.mapElementsColumn.put("MAXVALUE", string4);
                            continue;
                        }
                        if (!Token.hasToken(string4, "MINVALUE")) continue;
                        string4 = Token.cutTokenFromFront(string4, "MINVALUE");
                        this.mapElementsColumn.put("MINVALUE", string4);
                    }
                    n2 = this.pstatement.indexOf(41);
                }
            }
        }
    }

    private void initPrimaryKeyOrUnique() {
        int n = this.tstatement.indexOf("PRIMARY");
        if (n > -1) {
            this.pstatement = this.tstatement.substring(n);
            boolean bl = Token.isTokenEqualTo(this.pstatement, 1, "PRIMARY");
            boolean bl2 = Token.isTokenEqualTo(this.pstatement, 2, "KEY");
            if (!bl2) {
                bl2 = Token.isTokenEqualTo(this.pstatement, 2, "KEY(");
            }
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            if (bl && bl2) {
                this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "PRIMARY KEY");
            } else {
                this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            n = this.tstatement.indexOf("UNIQUE");
            if (n > -1) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initFor() {
        int n = this.tstatement.indexOf("FOR");
        if (n > -1) {
            this.pstatement = this.tstatement.substring(n);
            boolean bl = Token.isTokenEqualTo(this.statement, 1, "FOR");
            if (bl) {
                this.statement = Token.cutTokenFromFront(this.statement, "FOR");
                String string = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("FOR", string);
                this.statement = Token.cutTokenFromFront(this.statement, string);
            }
        }
    }

    private void initWithDefault() {
        int n = this.tstatement.indexOf("WITH");
        if (n > -1) {
            boolean bl;
            this.pstatement = this.tstatement.substring(n);
            boolean bl2 = Token.isTokenEqualTo(this.pstatement, 1, "WITH");
            if (bl2) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "WITH");
            }
            if (bl = Token.isTokenEqualTo(this.pstatement, 1, "DEFAULT")) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "DEFAULT");
                String string = Token.getValBetweenQuotationMarks2(this.pstatement).trim();
                if ("".equalsIgnoreCase(string)) {
                    string = this.getDefaultPartOnly(this.pstatement).trim();
                }
                this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
                this.mapElementsColumn.put("DEFAULT", string);
            } else {
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            }
        }
    }

    private String getDefaultPartOnly(String string) {
        int n = string.indexOf("CONSTRAINT");
        if (n > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("CHECK")) > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("PRIMARY")) > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("UNIQUE")) > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("REFERENCES")) > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("FIELDPROC")) > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("GENERATED")) > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void initReferences() {
        int n = this.tstatement.indexOf("REFERENCES");
        if (n > -1) {
            this.pstatement = this.tstatement.substring(n);
            boolean bl = Token.isTokenEqualTo(this.pstatement, 1, "REFERENCES");
            if (bl) {
                boolean bl2;
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "REFERENCES");
                String string = Token.getFirstToken(this.pstatement);
                int n2 = string.indexOf("(");
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                this.mapElementsColumn.put("REFERENCES", string);
                this.pstatement = Token.cutTokenFromFront(this.pstatement, string);
                boolean bl3 = Token.hasString(this.pstatement, "(");
                if (bl3) {
                    String string2 = Token.getValBetweenBrackets(this.pstatement);
                    this.mapElementsColumn.put("REFERENCED_COLUMN", string2);
                }
                if (bl2 = Token.isTokenEqualTo(this.pstatement, 1, "ON")) {
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, "ON DELETE");
                    String string3 = Token.getFirstToken(this.pstatement).trim();
                    this.mapElementsColumn.put("ON DELETE", string3);
                }
            }
        }
    }

    private void initConstraintCheck() {
        int n = this.tstatement.indexOf("CONSTRAINT");
        if (n > -1) {
            boolean bl;
            this.pstatement = this.tstatement.substring(n);
            boolean bl2 = Token.isTokenEqualTo(this.pstatement, 1, "CONSTRAINT");
            String string = "";
            if (bl2) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "CONSTRAINT");
                string = Token.getFirstToken(this.pstatement).trim();
                this.pstatement = Token.cutTokenFromFront(this.pstatement, string);
            }
            if (bl = Token.isTokenEqualTo(this.pstatement, 1, "CHECK")) {
                this.mapElementsColumn.put("CONSTRAINT", string);
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "CHECK");
                String string2 = Token.getFirstToken(this.pstatement).trim();
                this.pstatement = Token.cutTokenFromFront(this.pstatement, string2);
                if (Token.hasOpenBracketNoClose(string2)) {
                    String string3;
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    while (!Token.hasCloseBracket(Token.getFirstToken(this.pstatement)) && !(string3 = Token.getFirstToken(this.pstatement)).equals("")) {
                        stringBuffer.append(" ").append(string3);
                        this.pstatement = Token.cutTokenFromFront(this.pstatement, string3);
                    }
                    stringBuffer.append(" )");
                    stringBuffer.append(" )");
                    string2 = stringBuffer.toString();
                }
                string2 = Token.getValBetweenBrackets(string2);
                this.mapElementsColumn.put("CHECK", string2);
            }
        } else {
            n = this.tstatement.indexOf("CHECK");
            if (n > -1) {
                this.pstatement = this.tstatement.substring(n);
                boolean bl = Token.isTokenEqualTo(this.pstatement, 1, "CHECK");
                if (bl) {
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, "CHECK");
                    String string = Token.getFirstToken(this.pstatement).trim();
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, string);
                    if (Token.hasOpenBracketNoClose(string)) {
                        String string4;
                        StringBuffer stringBuffer = new StringBuffer(string);
                        while (!Token.hasCloseBracket(Token.getFirstToken(this.pstatement)) && !(string4 = Token.getFirstToken(this.pstatement)).equals("")) {
                            stringBuffer.append(" ").append(string4);
                            this.pstatement = Token.cutTokenFromFront(this.pstatement, string4);
                        }
                        stringBuffer.append(" )");
                        stringBuffer.append(" )");
                        string = stringBuffer.toString();
                    }
                    string = Token.getValBetweenBrackets(string);
                    this.mapElementsColumn.put("CHECK", string);
                }
            }
        }
    }

    private String searchNotStandartDatatypes(String string) {
        String[] stringArray = NotStandartDataTypeNames.getAllNewTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.equalsIgnoreCase(string2);
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    private void initFieldProc() {
        int n = this.tstatement.indexOf("FIELDPROC");
        if (n > -1) {
            this.pstatement = this.tstatement.substring(n);
            boolean bl = Token.isTokenEqualTo(this.pstatement, 1, "FIELDPROC");
            if (bl) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "FIELDPROC");
                this.mapElementsColumn.put("FIELDPROC", this.pstatement);
            }
        }
    }

    public Map getElementsColumn(String string) {
        this.parseColumns(string.replaceAll("\"", ""));
        return this.mapElementsColumn;
    }

    private void initConstraints() {
        String string = Token.getFirstToken(this.statement);
        if (string.equalsIgnoreCase("CONSTRAINT")) {
            String string2 = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.statement = Token.getStringAfterToken(this.statement, string2);
            this.mapElementsColumn.put("CONSTRAINT_NAME", string2);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initTableConstraints() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (bl) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String string = Token.getValBetweenBrackets(this.statement);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", string);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }
}

